/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.gui2D;

import com.quincala.core.QClipBoardBridge;
import com.quincala.core.QGamePanel;
import com.quincala.core.QGameSpace;
import com.quincala.core.QGameStatus;
import com.quincala.core.QGraphics;
import com.quincala.core.QRules;
import com.quincala.core.QSFUtils;
import com.quincala.core.QSessionManager;
import com.quincala.gamequincala.QuiDrawingPanel;
import com.quincala.gamequincala.QuiRules;
import com.quincala.gamequincala.QuincalaBirth;
import com.quincala.gamequincala.QuincalaBoardPanel;
import com.quincala.gloife.GloifeGame;
import com.quincala.gui2D.QApplication;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;

public class QGameLabsGUI
extends QApplication {
    String testQString = "";
    private boolean maximus = false;
    public String[] textSizeChoices = new String[]{"22", "20", "18", "16", "14", "13", "12", "11", "10"};
    public int textSizeIndexOnLoad = 4;
    public int guiTextSize = 0;
    public boolean enableImmunity = true;
    public boolean enableIR = false;
    public boolean showRulesOptions = false;
    public boolean showControlPanel = true;
    public boolean showTextInputField = false;
    private boolean showTextInputFieldDefault = false;
    private boolean showSessionBackupCheckBox = false;
    public boolean showBrowserWindow = false;
    private boolean showLegalText = false;
    private boolean doSessionBackup = false;
    public boolean showOptions = false;
    private boolean showToolTips = true;
    private boolean showArrows = true;
    private boolean showRelHandles = true;
    public String[] speedChoices = new String[]{"30", "60", "120", "180", "240"};
    public int speedIndexOnLoad = 2;
    private boolean tooLateStrings = false;
    private String errorFlag = "";
    QGraphics boardGraphics = new QGraphics();
    int turnNumberTest = 0;
    public boolean clickableBoard = true;
    private int functionBarMode = 1;
    private String copyMode;
    public boolean stateOutMode = false;
    public boolean wrapMode;
    private String currentGameHead = "qui";
    public String currentGameLoaded = "Quincala 3.5";
    public String gameName = "Quincala";
    public int gameVersion = 1;
    public int gameVariant = 5;
    public String headTitleString;
    public int passFlag = -1;
    public String mainTitleText;
    public String inputFieldDefaultText = "Input Box";
    public int boardX = 13;
    public int boardY = 13;
    double boardProportion = 1.0;
    int infoPanelMinimumX = 200;
    private int playerDelay = 500;
    public boolean forwardAvailable = false;
    public boolean backwardAvailable = false;
    public boolean doPlay = false;
    public int currentTurnNo = 1;
    public int playerNo = 0;
    Font functionBarFont;
    Font textBoxFont;
    Font legalTextFont;
    Font copyModeFont;
    JMenuBar browserMenuBar;
    JMenu browserPortalMenu;
    JMenuItem localPortalAction;
    JMenuBar topMenuBar;
    JMenu gameMenu;
    JMenuItem sameGameAction;
    JMenu quincalaPosEditSubmenu;
    JMenuItem qPosEditWith5Sizes;
    JMenuItem qPosEditWith4Sizes;
    JMenuItem qPosEditWith3Sizes;
    JMenu miniQuincalaSubmenu;
    JMenuItem miniQuincalaKnocking;
    JMenuItem miniQuincalaMixing;
    JMenu quincalaStandardSubmenu;
    JMenuItem qReleaseWith5Sizes;
    JMenuItem qReleaseWith4Sizes;
    JMenuItem qReleaseWith3Sizes;
    JMenu quincalaKnockingSubmenu;
    JMenuItem qKnockingWith5Sizes;
    JMenuItem qKnockingWith4Sizes;
    JMenuItem qKnockingWith3Sizes;
    JMenuItem quincalaFootballNew;
    JMenu quincalaMixingSubmenu;
    JMenuItem qMixingWith5Sizes;
    JMenuItem qMixingWith4Sizes;
    JMenuItem qMixingWith3Sizes;
    JMenuItem quincalaBouncingNew;
    JMenuItem quincalaUnlimitedNew;
    JMenu viewMenu;
    JCheckBoxMenuItem viewRulesOptions;
    JCheckBoxMenuItem viewControlPanel;
    JMenuItem textSizesMenuItem;
    JCheckBoxMenuItem viewTextInputField;
    JMenuItem zoomTextEntry;
    JMenuItem resetZoomItem;
    JMenu actionMenu;
    JMenuItem resignActionItem;
    JMenuItem agreeDrawActionItem;
    JMenuItem PassActionItem;
    JMenu helpMenu;
    JMenuItem homePageItem;
    JMenuItem onlineHelpItem;
    JMenuItem ruleSheetItem;
    JMenuItem onlineScoresItem;
    JMenuItem onlineTutorialsItem;
    JMenuItem legalItem;
    JSplitPane mainPane;
    QGamePanel currentBoard;
    JPanel drawPanel;
    JPanel infoPanel = new JPanel();
    JPanel checkPanel0;
    JPanel checkPanel1;
    JPanel checkPanel2;
    JPanel checkPanel3;
    JPanel checkPanel4;
    JPanel functionBar = new JPanel();
    JScrollPane wholeLineDataScrollPane;
    JEditorPane wholeLineDataPane = new JEditorPane();
    JTextArea matchBox;
    JTextArea legalTextBox;
    JScrollPane legalTextScrollPane;
    JEditorPane quincalaBrowser = new JEditorPane();
    JCheckBox ImmunityRuleBn;
    JCheckBox IRBn;
    JCheckBox sessionBackupCheckBox;
    JCheckBox toggleShowOptionsButton;
    JCheckBox showArrowsBn;
    JCheckBox showRelHandlesBn;
    JCheckBox rightClickZoomChBox;
    JButton historyOutBn;
    JCheckBox showToolTipBn;
    JButton testNewGenerationBn;
    JButton functionButton;
    JButton previousMarkerButton;
    JButton backwardButton;
    JButton playButton;
    JButton forwardButton;
    JButton nextMarkerButton;
    JButton rotateBoardButton;
    JLabel turnLabel;
    JTextField turnNumberField;
    JLabel maxTurnLabel;
    JButton addXButton;
    JButton addZButton;
    JButton pZButton;
    JButton rPZButton;
    JButton titleButton;
    JButton copyButton = new JButton();
    JRadioButton scoreOutModeBn;
    JRadioButton correspondenceOutModeBn;
    JRadioButton posNoFutureOutModeBn;
    JRadioButton posWithFutureOutModeBn;
    JRadioButton purePositionOutModeBn;
    JRadioButton gifOutModeBn;
    ButtonGroup copyModes;
    JCheckBox stateOutModeBn;
    JCheckBox wrapModeBn;
    JButton pasteButton;
    JTextField inputField;
    JLabel setSpeedLabel;
    JComboBox speedChoser;
    JLabel setTextSizeLabel;
    JComboBox textSizeChoser;
    JLabel statusLabel;
    JButton helpButton;
    JButton legalButton;

    public static void main(String[] args) {
        QGameLabsGUI gui = new QGameLabsGUI();
        gui.initialise();
        gui.go();
        gui.rightClickZoomChBox.setEnabled(!QGraphics.isMiniBoard);
        gui.zoomTextEntry.setEnabled(!QGraphics.isMiniBoard);
        gui.resetZoomItem.setEnabled(!QGraphics.isMiniBoard);
        gui.writeSessionBackup();
    }

    public void initialise() {
        System.out.println("QSessionManager.sessionName is " + QSessionManager.sessionName);
        this.headTitleString = "Quincala Game Viewer";
        this.guiTextSize = Integer.parseInt(this.textSizeChoices[this.textSizeIndexOnLoad]);
        QGraphics.initQGraphics(this.guiTextSize);
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        UIManager.put("JRadioButton.defaultButtonFollowsFocus", Boolean.TRUE);
    }

    public void go() {
        this.legalTextScrollPane = new JScrollPane(this.quincalaBrowser);
        this.wholeLineDataScrollPane = new JScrollPane(this.wholeLineDataPane);
        this.manageWindowManagers();
        this.setCloseOperation();
        this.switchBoard();
        this.initInfoPanel();
        this.mainPane = new JSplitPane(1, true, this.currentBoard, this.infoPanel);
        this.mainPane.setOneTouchExpandable(true);
        this.mainPane.addComponentListener(new SplitPaneListener());
        this.mainPane.addMouseListener(new DividerSnapBackListener());
        Dimension infoMinSize = new Dimension(this.infoPanelMinimumX, 400);
        this.infoPanel.setMinimumSize(infoMinSize);
        Dimension boardMinSize = new Dimension(500, 500);
        this.currentBoard.setMinimumSize(boardMinSize);
        this.mainPane.setPreferredSize(new Dimension(930, 510));
        this.mainPane.setBackground(new Color(230, 230, 230));
        this.initMenuBar();
        this.initFunctionBar();
        this.getGameStatus();
        this.setToolTips();
        this.setShowOptions();
        this.setTextSizes();
        this.setJMenuBar(this.topMenuBar);
        this.getContentPane().add("South", this.functionBar);
        this.getContentPane().add("Center", this.mainPane);
        this.packApplication();
        if (this.maximus) {
            this.setMaximized();
        }
        this.inputField.requestFocusInWindow();
        this.setVisible(true);
        int ht = this.currentBoard.getHeight();
        int wd = this.currentBoard.getWidth();
        this.mainPane.setDividerLocation(ht);
        this.refreshInfoText();
        this.focusFunctionBar();
    }

    public void initMenuBar() {
        this.topMenuBar = new JMenuBar();
        this.topMenuBar.removeAll();
        this.topMenuBar.revalidate();
        this.gameMenu = new JMenu("Game");
        this.gameMenu.setMnemonic(71);
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic(87);
        this.actionMenu = new JMenu("Action");
        this.actionMenu.setMnemonic(65);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.sameGameAction = new JMenuItem("Same Game Again", 83);
        this.sameGameAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Same Game!");
                String restartString = QGameLabsGUI.this.getQuString("restart", false)[0];
                System.out.println("restartString is " + restartString);
                QGameLabsGUI.this.setValidQSFString(restartString);
            }
        });
        this.quincalaPosEditSubmenu = new JMenu("Quincala Position Editor");
        this.quincalaPosEditSubmenu.setMnemonic(69);
        this.quincalaPosEditSubmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala quincalaPosEditSubmenu!");
            }
        });
        this.qPosEditWith5Sizes = new JMenuItem("5 sizes", 53);
        this.qPosEditWith5Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qPosEditWith5Sizes with 5 sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;05;");
            }
        });
        this.qPosEditWith4Sizes = new JMenuItem("4 sizes", 52);
        this.qPosEditWith4Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qPosEditWith4Sizes with 4 sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;04;");
            }
        });
        this.qPosEditWith3Sizes = new JMenuItem("3 sizes", 51);
        this.qPosEditWith3Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qPosEditWith3Sizes with 3 sizes!");
                QGameLabsGUI.this.setValidQSFString("qui03");
            }
        });
        this.miniQuincalaSubmenu = new JMenu("Mini Quincala");
        this.miniQuincalaSubmenu.setMnemonic(77);
        this.miniQuincalaSubmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Mini Quincala submenu!");
            }
        });
        this.miniQuincalaKnocking = new JMenuItem("Mini Quincala Knocking", 75);
        this.miniQuincalaKnocking.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Mini Quincala Knocking!");
                QGameLabsGUI.this.setValidQSFString("Quincala;KM;");
            }
        });
        this.miniQuincalaMixing = new JMenuItem("Mixing", 77);
        this.miniQuincalaMixing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Mini Quincala Mixing!");
                QGameLabsGUI.this.setValidQSFString("Quincala;MM;");
            }
        });
        this.quincalaStandardSubmenu = new JMenu("Quincala Standard");
        this.quincalaStandardSubmenu.setMnemonic(81);
        this.quincalaStandardSubmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala Standard submenu!");
            }
        });
        this.qReleaseWith5Sizes = new JMenuItem("5 sizes", 53);
        this.qReleaseWith5Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala Standard with 5 sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;35;");
            }
        });
        this.qReleaseWith4Sizes = new JMenuItem("(4 sizes)", 52);
        this.qReleaseWith4Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala Standard with 4 sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;34;");
            }
        });
        this.qReleaseWith3Sizes = new JMenuItem("3 sizes", 51);
        this.qReleaseWith3Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala Standard with 3 sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;33;");
            }
        });
        this.quincalaKnockingSubmenu = new JMenu("(Quincala Knocking)");
        this.quincalaKnockingSubmenu.setMnemonic(75);
        this.quincalaKnockingSubmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala Knocking Submenu!");
            }
        });
        this.qKnockingWith5Sizes = new JMenuItem("(5 sizes)", 53);
        this.qKnockingWith5Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qKnockingWith5Sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;25;");
            }
        });
        this.qKnockingWith4Sizes = new JMenuItem("(4 sizes)", 52);
        this.qKnockingWith4Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qKnockingWith4Sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;24;");
            }
        });
        this.qKnockingWith3Sizes = new JMenuItem("(3 sizes)", 51);
        this.qKnockingWith3Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qDisplacingWith3Sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;23;");
            }
        });
        this.quincalaMixingSubmenu = new JMenu("Quincala Mixing");
        this.quincalaMixingSubmenu.setMnemonic(88);
        this.quincalaMixingSubmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala quincalaMixingSubmenu!");
            }
        });
        this.qMixingWith5Sizes = new JMenuItem("5 sizes", 53);
        this.qMixingWith5Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qMixingWith5Sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;15;");
            }
        });
        this.qMixingWith4Sizes = new JMenuItem("(4 sizes)", 52);
        this.qMixingWith4Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qMixingWith4Sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;14;");
            }
        });
        this.qMixingWith3Sizes = new JMenuItem("3 sizes", 51);
        this.qMixingWith3Sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Quincala qMixingWith3Sizes!");
                QGameLabsGUI.this.setValidQSFString("Quincala;13;");
            }
        });
        this.quincalaFootballNew = new JMenuItem("(Quincala Football)", 70);
        this.quincalaFootballNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("quincalaFootballNew!");
                QGameLabsGUI.this.setValidQSFString("Quincala;73;");
            }
        });
        this.quincalaBouncingNew = new JMenuItem("(Quincala Bouncing)", 66);
        this.quincalaBouncingNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("quincalaBouncingNew!");
                QGameLabsGUI.this.setValidQSFString("Quincala;45;");
            }
        });
        this.quincalaUnlimitedNew = new JMenuItem("<html>(Quincala <u>U</u>nlimited)</html>", 85);
        this.quincalaUnlimitedNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("quincalaUnlimitedNew!");
                QGameLabsGUI.this.setValidQSFString("Quincala;53;");
            }
        });
        this.viewControlPanel = new JCheckBoxMenuItem("Control Panel");
        this.viewControlPanel.setMnemonic(67);
        this.viewControlPanel.setSelected(this.showControlPanel);
        this.viewControlPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("viewControlPanel menuitem");
                QGameLabsGUI.this.showControlPanel = !QGameLabsGUI.this.showControlPanel;
                System.out.println("showControlPanel is " + QGameLabsGUI.this.showControlPanel);
                QGameLabsGUI.this.refreshInfoPanel();
            }
        });
        this.viewRulesOptions = new JCheckBoxMenuItem("Rules Options ...");
        this.viewRulesOptions.setMnemonic(82);
        this.viewRulesOptions.setSelected(this.showRulesOptions);
        this.viewRulesOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("viewRulesOptions menuitem");
                QGameLabsGUI.this.showRulesOptions = !QGameLabsGUI.this.showRulesOptions;
                System.out.println("showRulesOptions is " + QGameLabsGUI.this.showRulesOptions);
                QGameLabsGUI.this.refreshInfoPanel();
            }
        });
        this.viewTextInputField = new JCheckBoxMenuItem("Text Input");
        this.viewTextInputField.setMnemonic(84);
        this.viewTextInputField.setSelected(this.showTextInputField);
        this.viewTextInputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("viewTextInputField menuitem");
                QGameLabsGUI.this.showTextInputField = !QGameLabsGUI.this.showTextInputField;
                System.out.println("showTextInputField is " + QGameLabsGUI.this.showTextInputField);
                QGameLabsGUI.this.functionBarMode = 1;
                QGameLabsGUI.this.refreshFunctionBar();
            }
        });
        this.textSizesMenuItem = new JMenuItem("Text Sizes ...", 84);
        this.textSizesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("textSizesMenuItem menu item!");
                Object[] possibilities = new Object[]{"22", "20", "18", "16", "14", "13", "12", "11", "10"};
                String s = (String)JOptionPane.showInputDialog(QGameLabsGUI.this.mainPane, "Please choose a font size and press Enter", "Text Size Input", -1, null, possibilities, possibilities[QGameLabsGUI.this.textSizeIndexOnLoad]);
                if (s != null && s.length() > 0) {
                    QGameLabsGUI.this.guiTextSize = Integer.parseInt(s);
                    QGameLabsGUI.this.setTextSizes();
                    return;
                }
                QGameLabsGUI.this.refreshFunctionBar();
            }
        });
        this.zoomTextEntry = new JMenuItem("Zoom:", 90);
        this.zoomTextEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ZoomTextEntry menu item!");
                String currentZoomString = "Zoom: " + QGameLabsGUI.this.getQuString("zoom", false)[0];
                System.out.println("%currentZoomString is " + currentZoomString);
                String s = (String)JOptionPane.showInputDialog(QGameLabsGUI.this.mainPane, "Edit centre coordinate and radius after the prefix: \"Zoom:\"", "QGV input", -1, null, null, currentZoomString);
                String quString = QSFUtils.convertUserInputString(s);
                QGameLabsGUI.this.setValidQSFString(quString);
                QGameLabsGUI.this.refreshFunctionBar();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.resetZoomItem = new JMenuItem("Reset Zoom", 79);
        this.resetZoomItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("resetZoomItem!");
                QGameLabsGUI.this.setValidQSFString("zoom=66;7");
                QGameLabsGUI.this.refreshFunctionBar();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.resignActionItem = new JMenuItem("Resign now", 82);
        this.resignActionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("quincalaUnlimitedNew!");
                QGameLabsGUI.this.setValidQSFString("ply=r" + QGameLabsGUI.this.playerNo);
                QGameLabsGUI.this.functionBarMode = 0;
                QGameLabsGUI.this.refreshFunctionBar();
            }
        });
        this.agreeDrawActionItem = new JMenuItem("Agree Draw now", 87);
        this.agreeDrawActionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("agreeDrawMenuItem!");
                QGameLabsGUI.this.setValidQSFString("ply=rg");
                QGameLabsGUI.this.functionBarMode = 0;
                QGameLabsGUI.this.refreshFunctionBar();
            }
        });
        this.PassActionItem = new JMenuItem("Pass", 80);
        this.PassActionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("PassActionItem!");
                QGameLabsGUI.this.setValidQSFString("ply=rt");
                QGameLabsGUI.this.functionBarMode = 0;
                QGameLabsGUI.this.refreshFunctionBar();
            }
        });
        this.homePageItem = new JMenuItem("Quincala Home Page", 81);
        this.homePageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("homePageItem!");
                QGameLabsGUI.this.openExternalResource("http://www.quincala.com/");
            }
        });
        this.onlineHelpItem = new JMenuItem("Online Help (PDF)", 72);
        this.onlineHelpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("onlineHelpItem!");
                QGameLabsGUI.this.openExternalResource("http://www.quincala.com/0.9/Quincala%20Game%20Viewer%20Help.pdf");
            }
        });
        this.ruleSheetItem = new JMenuItem("Online Rules (PDF)", 82);
        this.ruleSheetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ruleSheetItem!");
                String ruleVersionFileName = QRules.getRuleSheetName();
                QGameLabsGUI.this.openExternalResource("http://www.quincala.com/0.9/" + ruleVersionFileName);
            }
        });
        this.onlineScoresItem = new JMenuItem("Online Scores etc", 83);
        this.onlineScoresItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("onlineScoresItem!");
                QGameLabsGUI.this.openExternalResource("http://www.quincala.com/material.html");
            }
        });
        this.onlineTutorialsItem = new JMenuItem("Online Tutorials", 84);
        this.onlineTutorialsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("onlineTutorialsItem!");
                QGameLabsGUI.this.openExternalResource("http://www.quincala.com/tutorials.html");
            }
        });
        this.legalItem = new JMenuItem("Legal Information", 76);
        this.legalItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("legalItem!");
                QGameLabsGUI.this.legalButton.doClick();
            }
        });
        this.refreshMenuBar();
    }

    private void openExternalResource(String resourceURLString) {
        String message = "This will try to open the selected resource in your default browser.";
        this.showConfirmationMessage(message);
        this.openExternalUrlString(resourceURLString);
    }

    public void refreshMenuBar() {
        this.topMenuBar.add(this.gameMenu);
        this.gameMenu.add(this.sameGameAction);
        this.gameMenu.addSeparator();
        this.gameMenu.add(this.miniQuincalaKnocking);
        this.gameMenu.addSeparator();
        this.gameMenu.add(this.quincalaMixingSubmenu);
        this.quincalaMixingSubmenu.add(this.qMixingWith5Sizes);
        this.quincalaMixingSubmenu.add(this.qMixingWith4Sizes);
        this.quincalaMixingSubmenu.add(this.qMixingWith3Sizes);
        this.gameMenu.add(this.quincalaStandardSubmenu);
        this.quincalaStandardSubmenu.add(this.qReleaseWith5Sizes);
        this.quincalaStandardSubmenu.add(this.qReleaseWith4Sizes);
        this.quincalaStandardSubmenu.add(this.qReleaseWith3Sizes);
        this.topMenuBar.add(this.actionMenu);
        this.actionMenu.add(this.PassActionItem);
        this.actionMenu.add(this.resignActionItem);
        this.actionMenu.add(this.agreeDrawActionItem);
        this.topMenuBar.add(this.viewMenu);
        this.viewMenu.add(this.viewControlPanel);
        this.viewMenu.add(this.textSizesMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.zoomTextEntry);
        this.viewMenu.add(this.resetZoomItem);
        this.topMenuBar.add(this.helpMenu);
        this.helpMenu.add(this.homePageItem);
        this.helpMenu.add(this.onlineHelpItem);
        this.helpMenu.add(this.ruleSheetItem);
        this.helpMenu.add(this.onlineScoresItem);
        this.helpMenu.add(this.onlineTutorialsItem);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.legalItem);
    }

    public void initInfoPanel() {
        this.infoPanel.removeAll();
        JLabel showText = new JLabel(" View: ");
        showText.setOpaque(true);
        this.ImmunityRuleBn = new JCheckBox("Immunity Rule");
        this.ImmunityRuleBn.setSelected(this.enableImmunity);
        this.ImmunityRuleBn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QGameLabsGUI.this.enableImmunity = !QGameLabsGUI.this.enableImmunity;
                System.out.println("ImmunityRuleBn is set " + QGameLabsGUI.this.enableImmunity);
                QGameLabsGUI.this.setUserRules();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.IRBn = new JCheckBox("Old Irreversibility Rule");
        this.IRBn.setSelected(this.enableIR);
        this.IRBn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QGameLabsGUI.this.enableIR = !QGameLabsGUI.this.enableIR;
                System.out.println("IRBn is set " + QGameLabsGUI.this.enableIR);
                QGameLabsGUI.this.setUserRules();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.showToolTipBn = new JCheckBox("ToolTips");
        this.showToolTipBn.setMnemonic(84);
        this.showToolTipBn.setSelected(this.showToolTips);
        this.showToolTipBn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QGameLabsGUI.this.showToolTips = !QGameLabsGUI.this.showToolTips;
                System.out.println("showToolTips is " + QGameLabsGUI.this.showToolTips);
                QGameLabsGUI.this.setToolTips();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.showArrowsBn = new JCheckBox("Arrows");
        this.showArrowsBn.setMnemonic(87);
        this.showArrowsBn.setSelected(true);
        this.showArrowsBn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QGameLabsGUI.this.showArrows = !QGameLabsGUI.this.showArrows;
                System.out.println("showArrows is " + QGameLabsGUI.this.showArrows);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.showRelHandlesBn = new JCheckBox("ReleasingHandles");
        this.showRelHandlesBn.setMnemonic(69);
        this.showRelHandlesBn.setSelected(true);
        this.showRelHandlesBn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QGameLabsGUI.this.currentBoard.toggleShowReleasingHandles();
                System.out.println("showRelHandlesBn is " + QGameLabsGUI.this.showRelHandlesBn);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.sessionBackupCheckBox = new JCheckBox("Session Back Up");
        this.sessionBackupCheckBox.setSelected(this.doSessionBackup);
        this.sessionBackupCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("sessionBackupCheckBox!");
                QGameLabsGUI.this.doSessionBackup = !QGameLabsGUI.this.doSessionBackup;
                if (QGameLabsGUI.this.doSessionBackup) {
                    QGameLabsGUI.this.showLegalText = false;
                    QGameLabsGUI.this.outputSessionStateStrings();
                    QGameLabsGUI.this.showBrowserWindow = true;
                } else if (QGameLabsGUI.this.showLegalText) {
                    QGameLabsGUI.this.setLegalText();
                    QGameLabsGUI.this.showBrowserWindow = true;
                } else {
                    QGameLabsGUI.this.showBrowserWindow = false;
                }
                QGameLabsGUI.this.refreshInfoPanel();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.toggleShowOptionsButton = new JCheckBox("Options");
        this.toggleShowOptionsButton.setMnemonic(79);
        this.toggleShowOptionsButton.setSelected(this.showOptions);
        this.toggleShowOptionsButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("Toggle ShowOptions!");
                QGameLabsGUI.this.showOptions = !QGameLabsGUI.this.showOptions;
                QGameLabsGUI.this.setShowOptions();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.rightClickZoomChBox = new JCheckBox("Right Click Zoom");
        this.rightClickZoomChBox.setMnemonic(75);
        this.rightClickZoomChBox.setSelected(QGraphics.canZoomByRClick);
        this.rightClickZoomChBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("rightClickZoomChBox!");
                QGraphics.toggleZoomByRClick();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.setTextSizeLabel = new JLabel("Text size: ");
        this.textSizeChoser = new JComboBox<String>(this.textSizeChoices);
        this.textSizeChoser.setSelectedIndex(this.textSizeIndexOnLoad);
        this.textSizeChoser.setMaximumSize(new Dimension(50, 150));
        this.textSizeChoser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                System.out.println(cb);
                String choiceString = (String)cb.getSelectedItem();
                QGameLabsGUI.this.guiTextSize = Integer.parseInt(choiceString);
                System.out.println("guiTextSize is " + QGameLabsGUI.this.guiTextSize);
                QGameLabsGUI.this.setTextSizes();
            }
        });
        this.historyOutBn = new JButton("HistoryOut");
        this.historyOutBn.setMnemonic(89);
        this.historyOutBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("historyOutBn");
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.testNewGenerationBn = new JButton("Test New Gen");
        this.testNewGenerationBn.setMnemonic(84);
        this.testNewGenerationBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("testNewGenerationBn");
                QGameLabsGUI.this.currentBoard.testNewG((byte)8, 16);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.wholeLineDataPane.setEditable(false);
        this.wholeLineDataPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        Dimension preferredWholeLinePaneSize = new Dimension(200, 400);
        this.wholeLineDataPane.setPreferredSize(preferredWholeLinePaneSize);
        this.quincalaBrowser.setEditable(false);
        this.quincalaBrowser.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.quincalaBrowser.addHyperlinkListener(new QuStringHyperlinkListener());
        Dimension preferredLegalPaneSize = new Dimension(200, 400);
        this.quincalaBrowser.setPreferredSize(preferredLegalPaneSize);
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.refreshInfoPanel();
    }

    public void initFunctionBar() {
        this.functionBar = new JPanel();
        this.functionBar.setBackground(Color.LIGHT_GRAY);
        this.functionBar.setLayout(new BoxLayout(this.functionBar, 0));
        this.functionBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.functionBar.setFocusable(true);
        this.functionButton = new JButton("Fn:");
        this.functionButton.setFont(this.functionBarFont);
        this.functionButton.setMnemonic(70);
        this.functionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("functionButton!");
                QGameLabsGUI.this.toggleFunctionBar();
            }
        });
        this.previousMarkerButton = new JButton();
        this.previousMarkerButton.setMnemonic(34);
        this.previousMarkerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("previousMarkerButton!");
                QGameLabsGUI.this.sendButtonPresses(2);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.backwardButton = new JButton();
        this.backwardButton.setMnemonic(37);
        this.backwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("backwardButton!");
                QGameLabsGUI.this.sendButtonPresses(3);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.playButton = new JButton(">>");
        this.playButton.setMnemonic(80);
        this.playButton.setFont(this.functionBarFont);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("playButton!");
                QGameLabsGUI.this.doPlay = true;
                QGameLabsGUI.this.setButtonsAbility(false);
                QGameLabsGUI.this.currentBoard.stepPlayer(QGameLabsGUI.this.playerDelay);
                QGameLabsGUI.this.doPlay = false;
                QGameLabsGUI.this.getGameStatus();
                QGameLabsGUI.this.refreshFunctionBar();
            }
        });
        this.forwardButton = new JButton();
        this.forwardButton.setMnemonic(39);
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("forwardButton!");
                QGameLabsGUI.this.sendButtonPresses(6);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.nextMarkerButton = new JButton();
        this.nextMarkerButton.setMnemonic(33);
        this.nextMarkerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("nextMarkerButton!");
                QGameLabsGUI.this.sendButtonPresses(7);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.rotateBoardButton = new JButton("R");
        this.rotateBoardButton.setMnemonic(82);
        this.rotateBoardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("rotateBoardButton!");
                QGameLabsGUI.this.currentBoard.rotateBoard(1);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.addXButton = new JButton("+Y");
        this.addXButton.setMnemonic(89);
        this.addXButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("addBranchButton!");
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.addZButton = new JButton("+Z");
        this.addZButton.setMnemonic(90);
        this.addZButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("addZButton!");
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.pZButton = new JButton("Pz");
        this.pZButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("pZButton!");
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.rPZButton = new JButton("rPz");
        this.rPZButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("rPZButton!");
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.turnLabel = new JLabel("Turn ");
        this.maxTurnLabel = new JLabel("/1");
        this.turnNumberField = new JTextField("1", 1);
        this.turnNumberField.setHorizontalAlignment(11);
        this.adjustTurnNumberFieldSize();
        this.turnNumberField.setFocusable(true);
        this.turnNumberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("turnNumberField!");
                String turnString = QGameLabsGUI.this.turnNumberField.getText();
                boolean isValidTurnString = QSFUtils.isValidTurnString(turnString, QGameLabsGUI.this.maxTurnLabel.getText());
                if (isValidTurnString) {
                    QGameLabsGUI.this.setValidQSFString("goto=" + turnString);
                } else {
                    QGameLabsGUI.this.getGameStatus();
                }
                QGameLabsGUI.this.turnNumberField.requestFocusInWindow();
                QGameLabsGUI.this.turnNumberField.selectAll();
            }
        });
        this.statusLabel = new JLabel();
        this.scoreOutModeBn = new JRadioButton("score");
        this.scoreOutModeBn.setSelected(true);
        this.copyMode = "score";
        this.scoreOutModeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("scoreOutMode!");
                QGameLabsGUI.this.copyMode = "score";
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.correspondenceOutModeBn = new JRadioButton("@");
        this.correspondenceOutModeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("correspondenceOutMode!");
                QGameLabsGUI.this.copyMode = "@";
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.posNoFutureOutModeBn = new JRadioButton("~pos|");
        this.posNoFutureOutModeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("posNoFutureOutMode!");
                QGameLabsGUI.this.copyMode = "posNo";
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.posWithFutureOutModeBn = new JRadioButton("~pos~");
        this.posWithFutureOutModeBn.setMnemonic(88);
        this.posWithFutureOutModeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("posWithFutureOutMode!");
                QGameLabsGUI.this.copyMode = "posYes";
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.purePositionOutModeBn = new JRadioButton("|pos|");
        this.purePositionOutModeBn.setMnemonic(88);
        this.purePositionOutModeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("purePositionOutMode!");
                QGameLabsGUI.this.copyMode = "purePos";
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.gifOutModeBn = new JRadioButton("gif");
        this.gifOutModeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("gifOutMode!");
                QGameLabsGUI.this.copyMode = "gif";
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        ButtonGroup copyModes = new ButtonGroup();
        copyModes.add(this.scoreOutModeBn);
        copyModes.add(this.correspondenceOutModeBn);
        copyModes.add(this.posNoFutureOutModeBn);
        copyModes.add(this.posWithFutureOutModeBn);
        copyModes.add(this.purePositionOutModeBn);
        copyModes.add(this.gifOutModeBn);
        this.stateOutModeBn = new JCheckBox("info");
        this.stateOutModeBn.setSelected(this.stateOutMode);
        this.stateOutModeBn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QGameLabsGUI.this.stateOutMode = !QGameLabsGUI.this.stateOutMode;
                System.out.println("stateOutMode is " + QGameLabsGUI.this.stateOutMode);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.wrapModeBn = new JCheckBox("wrap");
        this.wrapModeBn.setSelected(true);
        this.wrapMode = true;
        this.wrapModeBn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QGameLabsGUI.this.wrapMode = !QGameLabsGUI.this.wrapMode;
                System.out.println("wrapMode is " + QGameLabsGUI.this.wrapMode);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.copyButton = new JButton("Copy:");
        this.copyButton.setMnemonic(67);
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("CopyButton!");
                String[] quStringToCopy = QGameLabsGUI.this.getQuStringDressed(QGameLabsGUI.this.copyMode, QGameLabsGUI.this.stateOutMode);
                System.out.println("JNLPService is not used!!!");
                QClipBoardBridge.putStringOnClipboard(quStringToCopy[0]);
                QGameLabsGUI.this.showConfirmationMessage(quStringToCopy[1]);
            }
        });
        this.pasteButton = new JButton("Paste");
        this.pasteButton.setMnemonic(86);
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("pasteClipboardButton!");
                Object[] options = new Object[]{"OK", "Cancel Pasting"};
                int n = JOptionPane.showOptionDialog(QGameLabsGUI.this.mainPane, "Warning - clicking OK will attempt to load the contents of the clipboard\n- erasing the current game line!", "QGV Message", 2, 2, null, options, options[0]);
                System.out.println("integer returned is " + n);
                if (n != 0) {
                    return;
                }
                String stringOnClipBoard = "";
                QClipBoardBridge clipBoardBridge = new QClipBoardBridge();
                stringOnClipBoard = clipBoardBridge.getStringOnClipBoard();
                if (stringOnClipBoard.length() > 0) {
                    QGameLabsGUI.this.setWildQSFString(stringOnClipBoard);
                    QGameLabsGUI.this.refreshFunctionBar();
                    QGameLabsGUI.this.focusFunctionBar();
                } else {
                    QGameLabsGUI.this.showErrorMessage("No string on clipboard!");
                }
            }
        });
        this.titleButton = new JButton("Title:");
        this.titleButton.setMnemonic(73);
        this.titleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean titleEntered;
                System.out.println("titleButton!");
                String currentInfoString = "Title: " + QGameLabsGUI.this.getQuString("title", false)[0];
                String today = QSFUtils.getIdentityDateString();
                if (currentInfoString.length() < 8) {
                    currentInfoString = String.valueOf(currentInfoString) + today + " ";
                }
                boolean addTournamentTemplate = today.equals("2010-09-17");
                boolean bl = titleEntered = currentInfoString.length() > 19;
                if (addTournamentTemplate && !titleEntered) {
                    currentInfoString = String.valueOf(currentInfoString) + "Rnd ? Brd ? ";
                }
                System.out.println("%currentInfoString is " + currentInfoString);
                String s = (String)JOptionPane.showInputDialog(QGameLabsGUI.this.mainPane, "Add or edit the title after the prefix: \"Title:\"", "QGV input", -1, null, null, currentInfoString);
                String quString = QSFUtils.convertUserInputString(s);
                QGameLabsGUI.this.setValidQSFString(quString);
                QGameLabsGUI.this.refreshFunctionBar();
                QGameLabsGUI.this.focusFunctionBar();
                System.out.println("InputString is: " + s);
            }
        });
        this.inputField = new JTextField(5);
        this.inputField.setFocusable(true);
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("stringField!");
                String userInputString = QGameLabsGUI.this.inputField.getText();
                QGameLabsGUI.this.inputField.setText("");
                String quString = QSFUtils.convertUserInputString(userInputString);
                QGameLabsGUI.this.setValidQSFString(quString);
                QGameLabsGUI.this.showTextInputField = QGameLabsGUI.this.showTextInputFieldDefault;
                QGameLabsGUI.this.refreshFunctionBar();
                if (QGameLabsGUI.this.showTextInputField) {
                    QGameLabsGUI.this.inputField.setText(QGameLabsGUI.this.inputFieldDefaultText);
                }
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.setSpeedLabel = new JLabel("Animation speed (steps/minute): ");
        this.speedChoser = new JComboBox<String>(this.speedChoices);
        this.speedChoser.setSelectedIndex(this.speedIndexOnLoad);
        this.speedChoser.setMaximumSize(new Dimension(50, 150));
        this.speedChoser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                System.out.println(cb);
                String choiceString = (String)cb.getSelectedItem();
                int chosenSpeed = Integer.parseInt(choiceString);
                System.out.println("chosenSpeed is " + chosenSpeed);
                QGameLabsGUI.this.playerDelay = 60000 / chosenSpeed;
                System.out.println("playerDelay is " + QGameLabsGUI.this.playerDelay);
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.helpButton = new JButton("??");
        this.helpButton.setMnemonic(112);
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("helpButton!");
                QGameLabsGUI.this.showBrowserWindow = !QGameLabsGUI.this.showBrowserWindow;
            }
        });
        this.legalButton = new JButton("\u00a7\u00a9!");
        this.legalButton.setMnemonic(81);
        this.legalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("legalButton!");
                if (QGameLabsGUI.this.showLegalText) {
                    QGameLabsGUI.this.showLegalText = false;
                    if (QGameLabsGUI.this.doSessionBackup) {
                        QGameLabsGUI.this.outputSessionStateStrings();
                        QGameLabsGUI.this.showBrowserWindow = true;
                    } else {
                        QGameLabsGUI.this.showBrowserWindow = false;
                    }
                } else {
                    QGameLabsGUI.this.showLegalText = true;
                    QGameLabsGUI.this.showBrowserWindow = true;
                }
                if (QGameLabsGUI.this.showLegalText) {
                    QGameLabsGUI.this.setLegalText();
                } else if (QGameLabsGUI.this.doSessionBackup) {
                    QGameLabsGUI.this.outputSessionStateStrings();
                } else {
                    QGameLabsGUI.this.showBrowserWindow = false;
                }
                QGameLabsGUI.this.refreshInfoPanel();
                QGameLabsGUI.this.focusFunctionBar();
            }
        });
        this.refreshFunctionBar();
    }

    public void toggleFunctionBar() {
        this.functionBarMode = (this.functionBarMode + 1) % 2;
        this.refreshFunctionBar();
    }

    public void setUserRules() {
        boolean[] userRules = new boolean[]{this.enableIR, this.enableImmunity};
        this.currentBoard.passThruRuleModification(userRules);
    }

    public void setGameVersion(String body) {
        if (body.length() == 0 || body.charAt(0) > ':' || body.charAt(0) < '/') {
            this.gameVersion = -1;
            System.out.println("No game version is set");
        } else {
            this.gameVersion = Integer.parseInt(body.substring(0, 1));
            System.out.println("gameVersion is " + this.gameVersion);
        }
    }

    public void setLegalText() {
        try {
            this.quincalaBrowser.setPage(QSFUtils.getCoreURLString("docs/ABGamesLegalCore.html"));
        }
        catch (IOException evt) {
            this.quincalaBrowser.setContentType("text/html");
            this.quincalaBrowser.setText("<html>missing document</html>");
        }
    }

    public void refreshInfoPanel() {
        this.infoPanel.removeAll();
        this.infoPanel.revalidate();
        if (this.showRulesOptions) {
            this.checkPanel0 = new JPanel();
            this.checkPanel0.setLayout(new BoxLayout(this.checkPanel0, 0));
            if (this.currentGameHead.equals("qui") && this.gameVersion > 0) {
                this.checkPanel0.add(Box.createHorizontalGlue());
                this.checkPanel0.add(this.ImmunityRuleBn);
                this.checkPanel0.add(this.IRBn);
            }
            this.infoPanel.add(this.checkPanel0);
        }
        if (this.showControlPanel) {
            this.checkPanel1 = new JPanel();
            this.checkPanel1.setLayout(new BoxLayout(this.checkPanel1, 0));
            this.checkPanel2 = new JPanel();
            this.checkPanel2.setLayout(new BoxLayout(this.checkPanel2, 0));
            this.checkPanel3 = new JPanel();
            this.checkPanel3.setLayout(new BoxLayout(this.checkPanel3, 1));
            this.checkPanel4 = new JPanel();
            this.checkPanel4.setLayout(new BoxLayout(this.checkPanel4, 1));
            if (this.showSessionBackupCheckBox) {
                this.checkPanel1.add(this.sessionBackupCheckBox);
            }
            this.checkPanel1.add(Box.createHorizontalGlue());
            if (QuiRules.releasing) {
                this.checkPanel1.add(this.showRelHandlesBn);
            }
            this.checkPanel1.add(this.toggleShowOptionsButton);
            this.checkPanel2.add(this.rightClickZoomChBox);
            this.checkPanel2.add(Box.createHorizontalGlue());
            this.checkPanel2.add(this.showToolTipBn);
            this.infoPanel.add(this.checkPanel1);
            this.infoPanel.add(this.checkPanel2);
        }
        this.infoPanel.add(this.wholeLineDataScrollPane);
        if (this.showBrowserWindow) {
            this.infoPanel.add(this.legalTextScrollPane);
        }
        this.infoPanel.repaint();
    }

    public void refreshFunctionBar() {
        this.getGameStatus();
        this.functionBar.removeAll();
        this.functionBar.add(this.functionButton);
        this.functionBar.add(Box.createRigidArea(new Dimension(7, 0)));
        switch (this.functionBarMode) {
            case 0: {
                this.functionBar.add(this.previousMarkerButton);
                this.functionBar.add(this.backwardButton);
                this.functionBar.add(this.forwardButton);
                this.functionBar.add(this.nextMarkerButton);
                this.functionBar.add(Box.createRigidArea(new Dimension(5, 0)));
                this.functionBar.add(this.rotateBoardButton);
                this.functionBar.add(Box.createRigidArea(new Dimension(5, 0)));
                this.functionBar.add(this.turnLabel);
                this.functionBar.add(this.turnNumberField);
                this.functionBar.add(this.maxTurnLabel);
                this.functionBar.add(this.statusLabel);
                this.turnNumberField.selectAll();
                break;
            }
            case 1: {
                this.functionBar.add(this.copyButton);
                this.functionBar.add(this.scoreOutModeBn);
                this.functionBar.add(this.posWithFutureOutModeBn);
                this.functionBar.add(this.posNoFutureOutModeBn);
                this.functionBar.add(this.wrapModeBn);
                this.functionBar.add(Box.createRigidArea(new Dimension(7, 0)));
                this.functionBar.add(this.pasteButton);
                this.functionBar.add(Box.createRigidArea(new Dimension(5, 0)));
                this.functionBar.add(this.titleButton);
                if (!this.showTextInputField) break;
                this.functionBar.add(Box.createRigidArea(new Dimension(2, 0)));
                this.functionBar.add(this.inputField);
                this.inputField.setText(this.inputFieldDefaultText);
                break;
            }
        }
        this.functionBar.add(Box.createHorizontalGlue());
        this.functionBar.add(Box.createRigidArea(new Dimension(7, 0)));
        this.functionBar.add(this.legalButton);
        this.functionBar.revalidate();
        this.focusFunctionBar();
    }

    public void focusFunctionBar() {
        if (this.functionBarMode == 0) {
            this.turnNumberField.selectAll();
            this.turnNumberField.requestFocusInWindow();
        }
        if (this.functionBarMode == 1) {
            System.out.println("backwardAvailable is " + this.backwardAvailable);
            if (this.backwardAvailable || this.forwardAvailable) {
                this.functionButton.requestFocusInWindow();
            } else {
                this.pasteButton.requestFocusInWindow();
            }
        }
        this.functionBar.repaint();
    }

    public void sendButtonPresses(int cdNo) {
        this.setQSFString("nav=" + cdNo, true);
        this.currentBoard.repaint();
        this.getGameStatus();
        if (this.doSessionBackup) {
            this.writeSessionBackup();
        }
    }

    public String getBuildName() {
        String name = "Quincala Game";
        name = String.valueOf(name) + " Viewer";
        name = String.valueOf(name) + " 0.9 F2";
        return name;
    }

    public synchronized void getGameStatus() {
        QGameStatus currentStatus = this.currentBoard.getGameStatus();
        this.forwardAvailable = currentStatus.forwardAvailable;
        this.backwardAvailable = currentStatus.backwardAvailable;
        boolean fComparison = currentStatus.forwardAvailable;
        boolean bcomparison = currentStatus.backwardAvailable;
        if (fComparison != this.forwardAvailable || bcomparison != this.backwardAvailable) {
            this.errorFlag = String.valueOf(this.errorFlag) + "forward/backward is not equal!!";
            System.out.println("!!!forward/backward is not equal!!");
        }
        this.passFlag = currentStatus.passFlag;
        this.currentTurnNo = currentStatus.currentTurnNo;
        this.playerNo = currentStatus.playerInt;
        this.PassActionItem.setEnabled(currentStatus.mayPass);
        this.gameVersion = currentStatus.GameVersion;
        this.gameVariant = currentStatus.GameVariant;
        this.refreshInfoText();
        this.ImmunityRuleBn.setEnabled(!this.backwardAvailable && !this.forwardAvailable);
        this.IRBn.setEnabled(!this.backwardAvailable && !this.forwardAvailable);
        this.previousMarkerButton.setEnabled(this.backwardAvailable);
        this.backwardButton.setEnabled(this.backwardAvailable);
        this.playButton.setEnabled(this.forwardAvailable);
        this.forwardButton.setEnabled(this.forwardAvailable);
        this.nextMarkerButton.setEnabled(this.forwardAvailable);
        this.turnNumberField.setText("" + currentStatus.currentTurnNo);
        this.statusLabel.setText(currentStatus.getStatusBarText());
    }

    public void setButtonsAbility(boolean buttonsAbility) {
        this.forwardButton.setEnabled(buttonsAbility);
        this.functionBar.revalidate();
        this.functionBar.repaint();
    }

    public void setShowOptions() {
        this.currentBoard.setShowOptions(this.showOptions);
    }

    public void updateGUIIcons() {
    }

    public void setTextSizes() {
        QGraphics.initQGraphics(this.guiTextSize);
        this.forwardButton.setIcon(QGraphics.navArrows[1]);
        this.backwardButton.setIcon(QGraphics.navArrows[3]);
        this.nextMarkerButton.setIcon(QGraphics.navArrows[5]);
        this.previousMarkerButton.setIcon(QGraphics.navArrows[7]);
        UIManager.put("ToolTip.font", new FontUIResource("SansSerif", 0, this.guiTextSize));
        this.functionBarFont = new Font("Serif", 1, this.guiTextSize);
        this.copyModeFont = new Font("Serif", 2, (int)((double)this.guiTextSize * 0.85));
        this.textBoxFont = new Font("Serif", 0, this.guiTextSize + 1);
        this.legalTextFont = new Font("Serif", 0, this.guiTextSize + 1);
        UIManager.put("OptionPane.messageFont", new FontUIResource(this.functionBarFont));
        UIManager.put("TextField.textFont", new FontUIResource(this.functionBarFont));
        UIManager.put("OptionPane.buttonFont", new FontUIResource(this.functionBarFont));
        this.functionButton.setFont(this.functionBarFont);
        this.ImmunityRuleBn.setFont(this.functionBarFont);
        this.IRBn.setFont(this.functionBarFont);
        this.sessionBackupCheckBox.setFont(this.functionBarFont);
        this.showToolTipBn.setFont(this.functionBarFont);
        this.showArrowsBn.setFont(this.functionBarFont);
        this.showRelHandlesBn.setFont(this.functionBarFont);
        this.toggleShowOptionsButton.setFont(this.functionBarFont);
        this.rightClickZoomChBox.setFont(this.functionBarFont);
        this.historyOutBn.setFont(this.functionBarFont);
        this.testNewGenerationBn.setFont(this.functionBarFont);
        this.wholeLineDataPane.setFont(this.textBoxFont);
        this.quincalaBrowser.setFont(this.legalTextFont);
        this.infoPanel.revalidate();
        this.infoPanel.repaint();
        this.rotateBoardButton.setFont(this.functionBarFont);
        this.addXButton.setFont(this.functionBarFont);
        this.addZButton.setFont(this.functionBarFont);
        this.pZButton.setFont(this.functionBarFont);
        this.rPZButton.setFont(this.functionBarFont);
        this.turnLabel.setFont(this.functionBarFont);
        this.maxTurnLabel.setFont(this.functionBarFont);
        this.turnNumberField.setFont(this.functionBarFont);
        this.statusLabel.setFont(this.functionBarFont);
        this.titleButton.setFont(this.functionBarFont);
        this.copyButton.setFont(this.functionBarFont);
        this.scoreOutModeBn.setFont(this.copyModeFont);
        this.correspondenceOutModeBn.setFont(this.copyModeFont);
        this.posNoFutureOutModeBn.setFont(this.copyModeFont);
        this.posWithFutureOutModeBn.setFont(this.copyModeFont);
        this.purePositionOutModeBn.setFont(this.copyModeFont);
        this.gifOutModeBn.setFont(this.copyModeFont);
        this.stateOutModeBn.setFont(this.copyModeFont);
        this.wrapModeBn.setFont(this.copyModeFont);
        this.pasteButton.setFont(this.functionBarFont);
        this.inputField.setFont(this.functionBarFont);
        this.setSpeedLabel.setFont(this.functionBarFont);
        this.speedChoser.setFont(this.functionBarFont);
        this.setTextSizeLabel.setFont(this.functionBarFont);
        this.textSizeChoser.setFont(this.functionBarFont);
        this.helpButton.setFont(this.functionBarFont);
        this.legalButton.setFont(this.functionBarFont);
        this.gameMenu.setFont(this.functionBarFont);
        this.sameGameAction.setFont(this.functionBarFont);
        this.quincalaPosEditSubmenu.setFont(this.functionBarFont);
        this.qPosEditWith5Sizes.setFont(this.functionBarFont);
        this.qPosEditWith4Sizes.setFont(this.functionBarFont);
        this.qPosEditWith3Sizes.setFont(this.functionBarFont);
        this.miniQuincalaSubmenu.setFont(this.functionBarFont);
        this.miniQuincalaKnocking.setFont(this.functionBarFont);
        this.miniQuincalaMixing.setFont(this.functionBarFont);
        this.quincalaStandardSubmenu.setFont(this.functionBarFont);
        this.qReleaseWith5Sizes.setFont(this.functionBarFont);
        this.qReleaseWith4Sizes.setFont(this.functionBarFont);
        this.qReleaseWith3Sizes.setFont(this.functionBarFont);
        this.quincalaKnockingSubmenu.setFont(this.functionBarFont);
        this.qKnockingWith5Sizes.setFont(this.functionBarFont);
        this.qKnockingWith4Sizes.setFont(this.functionBarFont);
        this.qKnockingWith3Sizes.setFont(this.functionBarFont);
        this.quincalaFootballNew.setFont(this.functionBarFont);
        this.quincalaMixingSubmenu.setFont(this.functionBarFont);
        this.qMixingWith5Sizes.setFont(this.functionBarFont);
        this.qMixingWith4Sizes.setFont(this.functionBarFont);
        this.qMixingWith3Sizes.setFont(this.functionBarFont);
        this.quincalaBouncingNew.setFont(this.functionBarFont);
        this.quincalaUnlimitedNew.setFont(this.functionBarFont);
        this.viewMenu.setFont(this.functionBarFont);
        this.viewControlPanel.setFont(this.functionBarFont);
        this.viewRulesOptions.setFont(this.functionBarFont);
        this.viewTextInputField.setFont(this.functionBarFont);
        this.textSizesMenuItem.setFont(this.functionBarFont);
        this.zoomTextEntry.setFont(this.functionBarFont);
        this.resetZoomItem.setFont(this.functionBarFont);
        this.actionMenu.setFont(this.functionBarFont);
        this.PassActionItem.setFont(this.functionBarFont);
        this.resignActionItem.setFont(this.functionBarFont);
        this.agreeDrawActionItem.setFont(this.functionBarFont);
        this.helpMenu.setFont(this.functionBarFont);
        this.homePageItem.setFont(this.functionBarFont);
        this.onlineHelpItem.setFont(this.functionBarFont);
        this.ruleSheetItem.setFont(this.functionBarFont);
        this.onlineScoresItem.setFont(this.functionBarFont);
        this.onlineTutorialsItem.setFont(this.functionBarFont);
        this.legalItem.setFont(this.functionBarFont);
        this.adjustTurnNumberFieldSize();
        this.functionBar.revalidate();
        this.functionBar.repaint();
    }

    public void setToolTips() {
        if (this.showToolTips) {
            this.gameMenu.setToolTipText("(Alt + G) Start a new Game or switch to another one");
            this.ImmunityRuleBn.setToolTipText("(Alt + M) Enable the new rule about knocking that might replace the irreversibility rule");
            this.IRBn.setToolTipText("(Alt + U) Keep the old rule about not repeating previous positions");
            this.sessionBackupCheckBox.setToolTipText("Saves a text file in your home directory with the current or end state of each session");
            this.showToolTipBn.setToolTipText("(Alt + T) Toggle these informative/annoying pop-ups");
            this.rightClickZoomChBox.setToolTipText("(Alt + K) Enable zooming in on the board by right clicking");
            this.showRelHandlesBn.setToolTipText("(Alt + E) Show the green releasing indicator lines");
            this.toggleShowOptionsButton.setToolTipText("(Alt + O) Show all legal options");
            this.historyOutBn.setToolTipText("(Alt + Y) Open a log file of QSF Strings from previous sessions in a separate window");
            this.wholeLineDataPane.setToolTipText("<html>Shows Game variant, match information (if present) and calculated data concerning the whole line;<br>the text is <b>bold</b> if the line is <i>sealed.</i></html>");
            this.quincalaBrowser.setToolTipText("Shows the legal terms of use and licence as well as copyright messages etc.");
            this.functionButton.setToolTipText("<html>(Alt + F) Toggle the bar to the right between <i>navigation</i> and <i>input/output</i> mode</html>");
            this.previousMarkerButton.setToolTipText("(Alt + PageDown) Back to the previous marker or to the beginning");
            this.backwardButton.setToolTipText("(Alt + Left Arrow) Back one step");
            this.forwardButton.setToolTipText("(Alt + Right Arrow) Forward one step");
            this.nextMarkerButton.setToolTipText("(Alt + PageUp) Forward to the next marker or to the end");
            this.addXButton.setToolTipText("<html>(Alt + X) Create an <i>example</i> (new tab) starting from this position</html>");
            this.rotateBoardButton.setToolTipText("(Alt + R) Rotate the game board 90\u00b0 clockwise");
            this.turnLabel.setToolTipText(null);
            this.maxTurnLabel.setToolTipText("Shows the number of turns the line contains");
            this.turnNumberField.setToolTipText("Type a turn number and press Enter to navigate to the beginning of that turn");
            this.statusLabel.setToolTipText("Shows current status of displayed game");
            this.copyButton.setToolTipText("(Alt + C) Copy a QSF String to the clipboard in the format defined to the right");
            this.scoreOutModeBn.setToolTipText("<html>Simple Match Mode:<br>The copied QSF String will load from the beginning - <br>suitable for complete game scores</html>");
            this.correspondenceOutModeBn.setToolTipText("<html>Correspondence Game Mode:<br>The copied QSF String will load from the beginning of the last move - <br>suitable for correspondence games by email or chat clients including Skype.</html>");
            this.posNoFutureOutModeBn.setToolTipText("<html>Position Mode:<br>The copied QSF String will load to the current position WITHOUT future moves -<br>suitable for showing a real world or legal position</html>");
            this.posWithFutureOutModeBn.setToolTipText("<html>Variation or Example Mode:<br>The copied QSF String will load to the current position WITH future moves - <br>suitable for a game variation or example move</html>");
            this.purePositionOutModeBn.setToolTipText("<html>Pure Position Mode:<br>The copied QSF  String will load to the current position with NO past NOR future -<br>suitable for custom starting positions or 'flat' examples</html>");
            this.gifOutModeBn.setToolTipText("Put the graphic image of the board on the clipboard as a .gif file");
            this.wrapModeBn.setToolTipText("Copied long QSF Strings will be wrapped to more than one line");
            this.pasteButton.setToolTipText("<html>(Alt + V) Load a QSF String from the clipboard<br>- can cope with line breaks and email reply/forwarding characters!</html>");
            this.titleButton.setToolTipText("<html>(Alt + i) Enter or edit the line title:<br>after clicking this, please type after the prefix 'Title:', then click OK</html>");
            this.inputField.setToolTipText("Combined Input and Message Box; used for editing the line title, etc");
            this.setTextSizeLabel.setToolTipText("Set the size of all text (including tooltips)");
            this.setSpeedLabel.setToolTipText("Set the speed of animation");
            this.helpButton.setToolTipText("<html>(Alt + F1) Open help files and rules (when implemented) - <br> for now please refer to the separate file 'Quincala Game Viewer Help'</html>");
            this.legalButton.setToolTipText("(Alt + Q) Toggle the legal and copyright message in the info area");
        } else {
            this.gameMenu.setToolTipText(null);
            this.ImmunityRuleBn.setToolTipText(null);
            this.IRBn.setToolTipText(null);
            this.showToolTipBn.setToolTipText(null);
            this.showRelHandlesBn.setToolTipText(null);
            this.rightClickZoomChBox.setToolTipText(null);
            this.toggleShowOptionsButton.setToolTipText(null);
            this.historyOutBn.setToolTipText(null);
            this.wholeLineDataPane.setToolTipText(null);
            this.quincalaBrowser.setToolTipText(null);
            this.functionButton.setToolTipText(null);
            this.previousMarkerButton.setToolTipText(null);
            this.backwardButton.setToolTipText(null);
            this.forwardButton.setToolTipText(null);
            this.nextMarkerButton.setToolTipText(null);
            this.addXButton.setToolTipText(null);
            this.rotateBoardButton.setToolTipText(null);
            this.turnLabel.setToolTipText(null);
            this.maxTurnLabel.setToolTipText(null);
            this.turnNumberField.setToolTipText(null);
            this.statusLabel.setToolTipText(null);
            this.titleButton.setToolTipText(null);
            this.copyButton.setToolTipText(null);
            this.scoreOutModeBn.setToolTipText(null);
            this.correspondenceOutModeBn.setToolTipText(null);
            this.posNoFutureOutModeBn.setToolTipText(null);
            this.posWithFutureOutModeBn.setToolTipText(null);
            this.purePositionOutModeBn.setToolTipText(null);
            this.gifOutModeBn.setToolTipText(null);
            this.stateOutModeBn.setToolTipText(null);
            this.pasteButton.setToolTipText(null);
            this.inputField.setToolTipText(null);
            this.setTextSizeLabel.setToolTipText(null);
            this.setSpeedLabel.setToolTipText(null);
            this.helpButton.setToolTipText(null);
            this.legalButton.setToolTipText(null);
        }
    }

    public String[] getQuStringDressed(String quStringFormat, boolean stateOut) {
        String[] qStringReturn = this.getQuString(quStringFormat, stateOut);
        qStringReturn[0] = String.valueOf(QSFUtils.getQSFVersion()) + "&" + qStringReturn[0];
        qStringReturn[0] = String.valueOf(QSFUtils.qsfFrame[0]) + qStringReturn[0] + QSFUtils.qsfFrame[1];
        if (this.wrapMode) {
            qStringReturn[0] = QSFUtils.wrap(qStringReturn[0]);
        }
        return qStringReturn;
    }

    public synchronized String[] getQuString(String quStringFormat, boolean stateOut) {
        String[] qStringReturn = this.currentBoard.getQuString(quStringFormat, stateOut);
        return qStringReturn;
    }

    public boolean setQSFVersion(String versionString) {
        if ((versionString = versionString.trim()).length() == 0) {
            return QSFUtils.setQSFVersion("");
        }
        char first = versionString.charAt(0);
        if (first == '=' && versionString.length() > 7) {
            String[] v = versionString.substring(1).split(";");
            if (v.length < 2 || !v[0].equalsIgnoreCase("qsf")) {
                return QSFUtils.setQSFVersion("");
            }
            return QSFUtils.setQSFVersion(v[1]);
        }
        return QSFUtils.setQSFVersion("");
    }

    public boolean setGDV(String qsfString) {
        String[] s = qsfString.split(";");
        if (s[0].equalsIgnoreCase("Quincala")) {
            if (s.length > 3) {
                System.out.println("s[3] is " + s[3]);
                System.out.println("QuiRules.setQDGVersion(s[3]) is " + QuiRules.setQDGVersion(s[3]));
                return QuiRules.setQDGVersion(s[3]);
            }
            return QuiRules.setQDGVersion("");
        }
        return false;
    }

    protected void showErrorMessage(String errorText) {
        JOptionPane.showMessageDialog(this.mainPane, errorText, "QGV Message", 2);
    }

    protected void showConfirmationMessage(String confirmationText) {
        JOptionPane.showMessageDialog(this.mainPane, confirmationText, "QGV Message", -1);
    }

    public void setWildQSFString(String wildQSFString) {
        this.setQSFString(wildQSFString, false);
    }

    protected void setValidQSFString(String qsfString) {
        this.setQSFString(qsfString, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected synchronized void setQSFString(String qsfString, boolean isValidated) {
        if (!isValidated) {
            if (QSFUtils.is2009QuString(qsfString)) {
                qsfString = QSFUtils.convert2009String(qsfString);
            }
            qsfString = QSFUtils.cleanWildQSFString(qsfString);
            System.out.println("cleaned wildQSFString is:");
            System.out.println(qsfString);
            if (!QSFUtils.isValidQSFString(qsfString)) {
                this.showErrorMessage("Sorry, the entered QSF string has errors and cannot be loaded.");
                return;
            }
        }
        if (QSFUtils.hasQSFHyperLinkPrefix(qsfString)) {
            qsfString = QSFUtils.getQHyperLinkQuery(qsfString);
        }
        String[] splitQuString = new String[1];
        if (QSFUtils.hasInitialURLString(qsfString)) {
            System.out.println("Initial URL identified");
            this.receiveURLString(qsfString);
        } else {
            splitQuString = qsfString.split("\\&");
            int splitCount = splitQuString.length;
            System.out.println("splitCount is " + splitCount);
            this.tooLateStrings = false;
            int i = 0;
            while (i < splitCount) {
                block25: {
                    String qString = splitQuString[i];
                    System.out.println("qString is:" + qString);
                    if (qString.length() != 0) {
                        int quStringType = QSFUtils.getQSFStringType(qString);
                        System.out.println("quStringType is " + quStringType);
                        if (!this.tooLateStrings || quStringType == 5) {
                            switch (quStringType) {
                                case 0: {
                                    if (!this.setGDV(qString)) {
                                        this.showErrorMessage("Sorry, this software is too old to read the entered game string properly - please update.");
                                        this.functionBarMode = 1;
                                        break block25;
                                    } else {
                                        this.functionBarMode = 0;
                                        if (this.doSessionBackup && QGameSpace.lineHasPlies()) {
                                            QSessionManager.setSessionName();
                                            System.out.println("QSessionManager.sessionName is " + QSessionManager.sessionName);
                                        }
                                        String[] split = qString.split(";");
                                        System.out.println("split.length is " + split.length);
                                        String oldstyle = "qui";
                                        oldstyle = split.length > 1 && split[1].length() > 0 ? String.valueOf(oldstyle) + split[1].trim() : String.valueOf(oldstyle) + "15";
                                        if (split.length > 2) {
                                            oldstyle = String.valueOf(oldstyle) + split[2].trim();
                                        }
                                        this.setGameVersion("qui");
                                        this.currentBoard.passThruSpaceQuString(oldstyle);
                                        this.currentBoard.passThruSpaceQuString(qString);
                                        this.refreshInfoText();
                                        this.getGameStatus();
                                        this.refreshInfoPanel();
                                        this.currentBoard.repaint();
                                        break;
                                    }
                                }
                                case 2: {
                                    String key = QSFUtils.getKey(qString);
                                    String value = QSFUtils.getValue(qString);
                                    if (key.equalsIgnoreCase("title")) {
                                        value = QSFUtils.decodeValue(value, false);
                                        this.currentBoard.passThroughLineInfo(value);
                                        this.refreshInfoText();
                                    } else {
                                        this.currentBoard.passThruSpaceQuString(qString);
                                    }
                                    if (!key.equalsIgnoreCase("zoom") || !value.equals("0")) break;
                                    int ht = this.currentBoard.getHeight();
                                    this.mainPane.setDividerLocation(ht);
                                    break;
                                }
                                case 4: {
                                    this.receiveGUIQuString(qString);
                                    break;
                                }
                                case 3: {
                                    this.currentBoard.receiveBoardQuString(qString);
                                    break;
                                }
                                case 1: {
                                    this.receiveURLString(qString);
                                    break;
                                }
                                case 5: {
                                    if (this.setQSFVersion(qString)) {
                                        this.tooLateStrings = false;
                                        break;
                                    }
                                    System.out.println("too high message is reached");
                                    this.tooLateStrings = true;
                                    this.showErrorMessage("Sorry, this software is too old to read all the information in the entered QSF string properly - please update.");
                                    this.functionBarMode = 1;
                                    break block25;
                                }
                            }
                            if (this.doSessionBackup) {
                                this.writeSessionBackup();
                            }
                        }
                    }
                }
                ++i;
            }
        }
        this.rightClickZoomChBox.setSelected(QGraphics.canZoomByRClick);
        this.rightClickZoomChBox.setEnabled(!QGraphics.isMiniBoard);
        this.zoomTextEntry.setEnabled(!QGraphics.isMiniBoard);
        this.resetZoomItem.setEnabled(QGraphics.isZoomedIn);
        this.refreshFunctionBar();
    }

    private void receiveURLString(String urlString) {
        System.out.println("url is reached!");
        if (!QSFUtils.isValidURLString(urlString)) {
            return;
        }
        boolean isURLlocal = urlString.substring(0, 2).equalsIgnoreCase("~/");
        if (isURLlocal) {
            urlString = QSFUtils.getCoreURLString("docs" + urlString.substring(1));
        }
        if (urlString.substring(0, 4).equalsIgnoreCase("www.")) {
            urlString = "http://" + urlString;
        }
        System.out.println("urlString is " + urlString);
        this.showBrowserWindow = true;
        try {
            this.quincalaBrowser.setPage(urlString);
        }
        catch (IOException evt) {
            this.quincalaBrowser.setContentType("text/html");
            this.quincalaBrowser.setText("<html>Unfortunately, either there is no internet connection, or the entered URL doesn't work in the Quincala Browser.</html>");
        }
        this.refreshInfoPanel();
    }

    private void receiveGUIQuString(String guiQuString) {
        String key = QSFUtils.getKey(guiQuString);
        String value = QSFUtils.getValue(guiQuString);
        if (key.equals("url")) {
            this.receiveURLString(value);
        }
    }

    public void switchBoard() {
        if (this.currentGameHead.equals("qui")) {
            this.currentBoard = new QuincalaBoardPanel();
            this.currentBoard.init();
            this.setUserRules();
            System.out.println("Quincala is loaded");
            this.currentGameLoaded = "Quincala";
            this.boardProportion = 1.0;
            this.infoPanelMinimumX = 200;
        }
        if (this.currentGameHead.equals("quiBirth")) {
            this.currentBoard = new QuincalaBirth();
            this.currentBoard.init();
            System.out.println("Quincala Birth is loaded");
            this.currentGameLoaded = "Quincala Birth";
            this.boardProportion = 1.0;
            this.infoPanelMinimumX = 200;
        }
        if (this.currentGameHead.equals("drw")) {
            this.currentBoard = new QuiDrawingPanel();
            this.currentBoard.init();
            System.out.println("Board Draw is loaded");
        }
        if (this.currentGameHead.equals("glf")) {
            this.currentBoard = new GloifeGame();
            this.currentBoard.init();
            System.out.println("Gloife is loaded");
        }
        this.currentGameHead.equals("hnf");
        this.currentGameHead.equals("chs");
        if (this.currentGameHead.equals("go_")) {
            System.out.println("Classic Go is loaded");
        }
        this.currentBoard.addMouseListener(new QGLMouseListener());
    }

    public synchronized void refreshInfoText() {
        String infoPanelText = this.currentBoard.passUpWholeLineData().getWholeLineDataString();
        this.wholeLineDataPane.setContentType("text/html");
        this.wholeLineDataPane.setText(infoPanelText);
        this.currentGameLoaded = this.currentBoard.passUpWholeLineData().getFullGameName();
        this.mainTitleText = String.valueOf(this.getBuildName()) + " - " + this.currentGameLoaded;
        String matchTitleText = this.currentBoard.passUpWholeLineData().getTitleString();
        if (matchTitleText.length() > 0) {
            this.mainTitleText = String.valueOf(this.mainTitleText) + " - " + matchTitleText;
        }
        this.setTitleToTop(this.mainTitleText);
        this.maxTurnLabel.setText("/" + this.currentBoard.passUpWholeLineData().turnsOpened);
        this.adjustTurnNumberFieldSize();
    }

    private void adjustTurnNumberFieldSize() {
        int columnsNeeded = this.maxTurnLabel.getText().length() - 1;
        this.turnNumberField.setColumns(columnsNeeded);
        Dimension labelDimension = this.maxTurnLabel.getPreferredSize();
        int ht = labelDimension.height;
        int wd = labelDimension.width;
        Dimension fieldDimension = new Dimension(wd, ht * 5 / 4);
        this.turnNumberField.setMaximumSize(fieldDimension);
        this.turnNumberField.setMinimumSize(fieldDimension);
    }

    protected void writeSessionBackup() {
        this.readLocation();
        if (!this.showSessionBackupCheckBox) {
            return;
        }
        String stateString = this.getQuStringDressed("posYes", false)[0];
        this.writeSessionStateString(stateString);
        this.outputSessionStateStrings();
    }

    @Override
    protected void setPlainTextInBrowser(String page) {
        this.showBrowserWindow = true;
        this.quincalaBrowser.setContentType("text/plain");
        this.quincalaBrowser.setText(page);
        this.refreshInfoPanel();
    }

    public void stepPlayer() {
    }

    public boolean isExternalFormat(String extension) {
        boolean result = false;
        String[] knownExtensions = new String[]{"pdf", "odt", "doc", "mp3", "jpg"};
        int count = knownExtensions.length;
        int i = 0;
        while (i < count) {
            if (knownExtensions[i].equals(extension)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    protected static ImageIcon createImageIcon(String path) {
        String imageFolderPath = "";
        path = String.valueOf(imageFolderPath) + path;
        URL imgURL = QGameLabsGUI.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public class DividerSnapBackListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    public class QGLMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            int mouseButton = e.getButton();
            int x = e.getX();
            int y = e.getY();
            if (mouseButton == 1 && QGameLabsGUI.this.clickableBoard) {
                System.out.println("left click!");
                QGameLabsGUI.this.currentBoard.receiveMouseClick(x, y);
                QGameLabsGUI.this.functionBarMode = 0;
                QGameLabsGUI.this.refreshFunctionBar();
                QGameLabsGUI.this.refreshInfoText();
                if (QGameLabsGUI.this.doSessionBackup) {
                    QGameLabsGUI.this.writeSessionBackup();
                }
            }
            if (mouseButton == 3 && QGraphics.canZoomByRClick && QGameLabsGUI.this.clickableBoard) {
                System.out.println("right click!");
                QGameLabsGUI.this.currentBoard.receiveMouseZoom(x, y);
                QGraphics.receiveMouseZoom(x, y);
                QGameLabsGUI.this.currentBoard.updatePanelImage();
                if (QGraphics.radiusSeen == QGraphics.radiusSeenDefault) {
                    int ht = QGameLabsGUI.this.currentBoard.getHeight();
                    QGameLabsGUI.this.mainPane.setDividerLocation(ht);
                }
                QGameLabsGUI.this.resetZoomItem.setEnabled(QGraphics.isZoomedIn);
            }
        }
    }

    public class QuStringHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String linkText = evt.getURL().toString();
                System.out.println("linkText is " + linkText);
                QGameLabsGUI.this.receiveURLString(evt.getURL().toString());
            }
        }
    }

    public class SimpleHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                System.out.println("evt.getURL().toString() is " + evt.getURL().toString());
                try {
                    ((JEditorPane)evt.getSource()).setPage(evt.getURL());
                }
                catch (IOException e) {
                    System.out.println("e.toString() is " + e.toString());
                }
            }
        }
    }

    public class SplitPaneListener
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            int ht = QGameLabsGUI.this.currentBoard.getHeight();
            int mainPaneWidth = QGameLabsGUI.this.mainPane.getWidth();
            System.out.println("mainPaneWidth is " + mainPaneWidth);
            int dividerLoc = (int)((double)ht * QGameLabsGUI.this.boardProportion + 1.0);
            int dividerLimit = mainPaneWidth - QGameLabsGUI.this.infoPanelMinimumX;
            if (dividerLoc > dividerLimit) {
                dividerLoc = dividerLimit;
            }
            QGameLabsGUI.this.mainPane.setDividerLocation(dividerLoc);
        }
    }
}

