/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.gamequincala;

import com.quincala.core.QDuplet;
import com.quincala.core.QGamePanel;
import com.quincala.core.QGameStatus;
import com.quincala.core.QGraphics;
import com.quincala.core.QRules;
import com.quincala.core.QSFUtils;
import com.quincala.core.QWholeLineData;
import com.quincala.gamequincala.QuCalc;
import com.quincala.gamequincala.QuiGameSpace;
import com.quincala.gamequincala.QuiGraphics;
import com.quincala.gamequincala.QuiPiece;
import com.quincala.gamequincala.QuiRules;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.image.BufferedImage;
import java.util.Set;

public class QuincalaBoardPanel
extends QGamePanel {
    private boolean viewBoardOnly = false;
    BufferedImage boardImage = null;
    public boolean drawExperimentalImage = true;
    BufferedImage optionsImage = null;
    BufferedImage turnIndicatorImage = null;
    public int ht = 0;
    public int wd = 0;
    double[][] lineDef = new double[][]{{0.622, 1.117, 0.689, 1.6, 0.429, 2.0, 0.0, 2.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0}, {0.0, 6.0, 0.47, 6.0, 0.53, 0.0, 1.0, 5.0}, {1.0, 5.0, 1.47, 0.0, 1.53, 0.0, 2.0, 5.0}, {2.0, 5.0, 2.3, 5.0, 2.6, 0.0, 2.8, 4.6}, {0.0, 0.0, 0.0, 4.8, 2.9, 4.9, 3.0, 5.0}, {3.0, 5.0, 0.0, 0.0, 0.0, 0.0, 4.0, 5.0}, {4.0, 5.0, 0.0, 0.0, 0.0, 0.0, 5.0, 5.0}};
    double[][] xpandLn = new double[64][8];
    double[][] ln = new double[64][8];
    CubicCurve2D[] ornArray = new CubicCurve2D[64];
    int[] boardPolygonX;
    int[] boardPolygonY;
    int[] boardPolygonXExp;
    int[] boardPolygonYExp;
    public boolean showGrid;
    public int centerSqLocDefault;
    public int centerSqLoc;
    public double radiusSeenDefault;
    public double radiusSeen;
    public boolean[] legalOptions;
    public byte[] immortalPieces;
    public byte[] immunePieces;
    private BasicStroke greyOutlineStroke;
    private BasicStroke selectOutlineStroke;
    public BasicStroke ornLineStroke;
    private BasicStroke whiteDiamStroke;
    private BasicStroke relHandleStroke;
    private BasicStroke trailingCircleStroke;
    static final float[] dash1 = new float[]{5.0f};
    private BasicStroke bouncingLineStroke;
    public Color tableClothColour;
    public Color frameColour;
    public Color frameColourLight;
    public Color boardColourLight;
    public Color boardColour;
    public Color boardColourPoly;
    public Color boardColourLightGoalDot;
    public Color boardColourGoalDot;
    public Color selectedSquareColour;
    public Color winSquareColor;
    public Color ornOlineColour;
    public Color blackDotColour;
    public Color blackPieceColour;
    public Color whitePieceColour;
    public Color outlineColour;
    public Color releaseOutlineColour;
    public Color immortalOutlineColour;
    public Color selectedImmortalOutlineColour;
    public Color immuneOutlineColour;
    public Color selectedImmuneOutlineColour;
    public Color selectedOutlineColour;
    public Color violetColour;
    public Color releaseHandleColour;
    QuiGameSpace currentSpace;
    QuiGraphics boardGraphics;
    private QuCalc calc;
    public int boardPanelSize;
    public int unit;
    public int core;
    public int margin;
    public int pdiff;
    public int xLargestPiece;
    public int squareSize;
    public int ss;
    public int ds;
    public int tds;
    public int ts;
    public int CDs;
    public int smallestSize;
    public int pthick;
    public int pwide;
    public int xTop;
    public int yTop;
    public int markerRad;
    public Button toogleStudyModeButton;
    public Button toggleShowOptionsButton;
    public Button loadQuStringButton;
    private boolean studyMode;
    public boolean showLegal;
    private boolean edit;
    private boolean doPlay;
    public boolean doRecord;
    public int stepSpeed;
    public int boardRotation;
    public static final int EMPTY = 0;
    public static final int WHITE = 1;
    public static final int BLACK = 2;
    public static final int BOARD = 3;
    public static final int LINES = 4;
    public static final int FRAME = 4;

    public QuincalaBoardPanel() {
        int[] nArray = new int[20];
        nArray[0] = 1;
        nArray[1] = 5;
        nArray[2] = 6;
        nArray[3] = 7;
        nArray[4] = 8;
        nArray[5] = 12;
        nArray[6] = 12;
        nArray[7] = 13;
        nArray[8] = 13;
        nArray[9] = 12;
        nArray[10] = 12;
        nArray[11] = 8;
        nArray[12] = 7;
        nArray[13] = 6;
        nArray[14] = 5;
        nArray[15] = 1;
        nArray[16] = 1;
        nArray[19] = 1;
        this.boardPolygonX = nArray;
        int[] nArray2 = new int[20];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 5;
        nArray2[7] = 6;
        nArray2[8] = 7;
        nArray2[9] = 8;
        nArray2[10] = 12;
        nArray2[11] = 12;
        nArray2[12] = 13;
        nArray2[13] = 13;
        nArray2[14] = 12;
        nArray2[15] = 12;
        nArray2[16] = 8;
        nArray2[17] = 7;
        nArray2[18] = 6;
        nArray2[19] = 5;
        this.boardPolygonY = nArray2;
        this.boardPolygonXExp = new int[20];
        this.boardPolygonYExp = new int[20];
        this.showGrid = false;
        this.centerSqLoc = this.centerSqLocDefault = 84;
        this.radiusSeen = this.radiusSeenDefault = 7.0;
        this.legalOptions = new boolean[169];
        this.immortalPieces = new byte[169];
        this.immunePieces = new byte[169];
        this.greyOutlineStroke = new BasicStroke(1.0f);
        this.selectOutlineStroke = new BasicStroke(1.0f);
        this.ornLineStroke = new BasicStroke(2.0f);
        this.whiteDiamStroke = new BasicStroke(2.0f);
        this.relHandleStroke = new BasicStroke(1.0f);
        this.trailingCircleStroke = new BasicStroke(1.7f);
        this.bouncingLineStroke = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
        this.tableClothColour = new Color(230, 230, 230);
        this.frameColour = new Color(180, 180, 180);
        this.frameColourLight = new Color(225, 180, 180);
        this.boardColourLight = new Color(225, 160, 0);
        this.boardColour = new Color(180, 160, 0);
        this.boardColourPoly = new Color(30, 160, 200);
        this.boardColourLightGoalDot = new Color(225, 180, 0);
        this.boardColourGoalDot = new Color(180, 180, 0);
        this.selectedSquareColour = Color.red;
        this.winSquareColor = Color.yellow;
        this.ornOlineColour = new Color(180, 180, 180);
        this.blackDotColour = new Color(180, 180, 180);
        this.blackPieceColour = Color.black;
        this.whitePieceColour = Color.white;
        this.outlineColour = new Color(140, 140, 140);
        this.releaseOutlineColour = Color.green;
        this.immortalOutlineColour = new Color(0, 100, 255);
        this.selectedImmortalOutlineColour = Color.magenta;
        this.immuneOutlineColour = Color.yellow;
        this.selectedImmuneOutlineColour = new Color(255, 130, 0);
        this.selectedOutlineColour = Color.red;
        this.violetColour = new Color(35, 0, 228);
        this.releaseHandleColour = Color.green;
        this.currentSpace = new QuiGameSpace();
        this.boardGraphics = new QuiGraphics();
        this.calc = new QuCalc();
        this.unit = 4;
        this.xTop = 0;
        this.yTop = 0;
        this.markerRad = 1;
        this.studyMode = true;
        this.showLegal = false;
        this.doPlay = false;
        this.doRecord = false;
        this.stepSpeed = 500;
        this.boardRotation = 0;
    }

    @Override
    public void init() {
        this.init("");
    }

    @Override
    public void init(String defaultVariant) {
        this.currentSpace.initGameSpace(defaultVariant);
        this.edit = true;
        if (QRules.isPosEdit) {
            this.showLegal = false;
        }
        if (this.doConstruction) {
            this.currentSpace.setDoConstructionTrue();
        }
        QuiGraphics.initQuiGraphics();
    }

    @Override
    public void paint(Graphics g) {
        QDuplet[] relH;
        int releasedPiecesCount;
        Graphics2D g2d = (Graphics2D)g;
        this.ht = this.getHeight();
        this.wd = this.getWidth();
        QGraphics.setHeightAndWidth(this.ht, this.wd);
        int sizeCandidate = this.ht;
        if (this.wd < this.ht) {
            sizeCandidate = this.wd;
        }
        if (sizeCandidate != this.boardPanelSize) {
            this.boardPanelSize = sizeCandidate;
            QGraphics.setBoardPanelSize(sizeCandidate);
            this.updatePanelImage();
        }
        int whiteGoalDot = QuiRules.whiteGoalDot;
        int blackGoalDot = QuiRules.blackGoalDot;
        if (QGraphics.canvasTextureInt == -1) {
            g2d.setColor(QuiGraphics.tableClothColour);
        } else {
            g2d.setPaint(QGraphics.texture2);
        }
        g2d.fillRect(0, 0, this.wd, this.ht);
        if (this.drawExperimentalImage) {
            int xCanv = QGraphics.xCanv;
            int yCanv = QGraphics.yCanv;
            g2d.drawImage((Image)this.boardImage, xCanv, yCanv, null);
            if (this.showLegal) {
                float transparency = 0.5f;
                g2d.setComposite(AlphaComposite.getInstance(3, transparency));
                g2d.drawImage((Image)this.optionsImage, xCanv, yCanv, null);
                transparency = 1.0f;
                g2d.setComposite(AlphaComposite.getInstance(3, transparency));
            }
            if (this.viewBoardOnly) {
                g2d.dispose();
                return;
            }
            g2d.drawImage((Image)this.turnIndicatorImage, xCanv, yCanv, null);
        }
        if (this.currentSpace.currentState.bouncingDirectionUnit != 0) {
            int[] bLine = this.currentSpace.currentState.bouncingLineLocs;
            int xMidOrig = (int)((double)QGraphics.xTop + ((double)QGraphics.gridX(bLine[0]) + 0.5) * (double)this.ss);
            int yMidOrig = (int)((double)QGraphics.yTop + ((double)QGraphics.gridY(this.boardRotation, bLine[0]) + 0.5) * (double)QGraphics.ss);
            int xMidDest = (int)((double)QGraphics.xTop + ((double)QGraphics.gridX(this.boardRotation, bLine[1]) + 0.5) * (double)QGraphics.ss);
            int yMidDest = (int)((double)QGraphics.yTop + ((double)QGraphics.gridY(this.boardRotation, bLine[1]) + 0.5) * (double)QGraphics.ss);
            g2d.setStroke(this.bouncingLineStroke);
            g2d.setColor(this.selectedOutlineColour);
            g2d.drawLine(xMidOrig, yMidOrig, xMidDest, yMidDest);
        }
        int y = 0;
        while (y < 13) {
            int x = 0;
            while (x < 13) {
                int pwide;
                int loc = QGraphics.location(x, y);
                byte inStack = this.currentSpace.currentState.stacks[loc];
                byte releasedSizes = this.currentSpace.currentState.releasedPieces[loc];
                int height = this.calc.countBits(inStack);
                byte inBlack = this.currentSpace.currentState.blackPieces[loc];
                byte inPieceSel = this.currentSpace.currentState.pieceSelections[loc];
                int xMid = (int)((double)QGraphics.xTop + ((double)x + 0.5) * (double)QGraphics.ss) + 1;
                int yMid = (int)((double)QGraphics.yTop + ((double)y + 0.5) * (double)QGraphics.ss) + 1;
                int yPiece = yMid + (height - 2) * this.unit;
                int xPiece = xMid - this.xLargestPiece;
                int size = 1;
                while (size <= this.smallestSize) {
                    pwide = (xMid - xPiece) * 2;
                    if (this.calc.isPresent(size, inStack)) {
                        if (this.calc.isPresent(size, inBlack)) {
                            g2d.setColor(this.blackPieceColour);
                        } else {
                            g2d.setColor(this.whitePieceColour);
                        }
                        g2d.fillRect(xPiece, yPiece, pwide, this.pthick);
                        if (size == 2 || size == 8) {
                            g2d.setColor(this.outlineColour);
                            g2d.drawLine(xMid, yPiece + this.pthick / 2, xMid, yPiece + this.pthick / 2);
                            if (this.markerRad >= 1) {
                                int yOffset = this.markerRad / 2;
                                if (yOffset > 1) {
                                    yOffset = 1;
                                }
                                g2d.fillOval(xMid - this.markerRad, yPiece + this.pthick / 2 - yOffset, 2 * this.markerRad, 2 * this.markerRad);
                            } else {
                                g2d.drawLine(xMid, yPiece + (this.pthick - 1) / 2, xMid, yPiece + (this.pthick - 1) / 2);
                            }
                        }
                        if (this.calc.isPresent(size, releasedSizes)) {
                            g2d.setColor(this.releaseOutlineColour);
                            g2d.setStroke(this.selectOutlineStroke);
                        } else {
                            g2d.setColor(this.outlineColour);
                            g2d.setStroke(this.greyOutlineStroke);
                        }
                        g2d.drawLine(xPiece, yPiece, xPiece + pwide, yPiece);
                        g2d.drawLine(xPiece, yPiece, xPiece, yPiece + this.pthick);
                        g2d.drawLine(xPiece + pwide, yPiece, xPiece + pwide, yPiece + this.pthick);
                        g2d.drawLine(xPiece, yPiece + this.pthick, xPiece + pwide, yPiece + this.pthick);
                        yPiece -= this.pthick;
                    }
                    xPiece += this.pdiff;
                    size *= 2;
                }
                yPiece = yMid + (height - 2) * this.unit;
                xPiece = xMid - this.xLargestPiece;
                g2d.setStroke(this.selectOutlineStroke);
                size = 1;
                while (size <= this.smallestSize) {
                    pwide = (xMid - xPiece) * 2;
                    if (this.calc.isPresent(size, inStack)) {
                        boolean drawIt = false;
                        boolean isSelected = this.calc.isPresent(size, inPieceSel);
                        boolean isImmortal = this.calc.isPresent(size, this.immortalPieces[loc]);
                        boolean isImmune = this.calc.isPresent(size, this.immunePieces[loc]);
                        if (isImmune) {
                            g2d.setColor(this.immuneOutlineColour);
                            drawIt = true;
                        }
                        if (isImmortal) {
                            g2d.setColor(this.immortalOutlineColour);
                            drawIt = true;
                        }
                        if (isSelected) {
                            g2d.setColor(this.selectedOutlineColour);
                            drawIt = true;
                        }
                        if (isSelected && isImmune) {
                            g2d.setColor(this.selectedImmuneOutlineColour);
                        }
                        if (isSelected && isImmortal) {
                            g2d.setColor(this.selectedImmortalOutlineColour);
                        }
                        if (drawIt) {
                            g2d.drawLine(xPiece, yPiece, xPiece + pwide, yPiece);
                            g2d.drawLine(xPiece, yPiece, xPiece, yPiece + this.pthick);
                            g2d.drawLine(xPiece + pwide, yPiece, xPiece + pwide, yPiece + this.pthick);
                            g2d.drawLine(xPiece, yPiece + this.pthick, xPiece + pwide, yPiece + this.pthick);
                        }
                        yPiece -= this.pthick;
                    }
                    xPiece += this.pdiff;
                    size *= 2;
                }
                g2d.setStroke(this.greyOutlineStroke);
                if (this.currentSpace.currentState.winLocation == loc) {
                    g2d.setColor(this.winSquareColor);
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y * this.ss, this.xTop + x * this.ss, (y + 1) * this.ss + this.yTop);
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y * this.ss, this.xTop + (x + 1) * this.ss, this.yTop + y * this.ss);
                    g2d.drawLine(this.xTop + (x + 1) * this.ss, this.yTop + (y + 1) * this.ss, this.xTop + x * this.ss, this.yTop + (y + 1) * this.ss);
                    g2d.drawLine(this.xTop + (x + 1) * this.ss, this.yTop + (y + 1) * this.ss, this.xTop + (x + 1) * this.ss, this.yTop + y * this.ss);
                    g2d.drawLine(this.xTop + x * this.ss - 1, this.yTop + y * this.ss - 1, this.xTop + x * this.ss - 1, (y + 1) * this.ss + this.yTop + 1);
                    g2d.drawLine(this.xTop + x * this.ss - 1, this.yTop + y * this.ss - 1, this.xTop + (x + 1) * this.ss + 1, this.yTop + y * this.ss - 1);
                    g2d.drawLine(this.xTop + (x + 1) * this.ss + 1, this.yTop + (y + 1) * this.ss + 1, this.xTop + x * this.ss - 1, this.yTop + (y + 1) * this.ss + 1);
                    g2d.drawLine(this.xTop + (x + 1) * this.ss + 1, this.yTop + (y + 1) * this.ss + 1, this.xTop + (x + 1) * this.ss + 1, this.yTop + y * this.ss - 1);
                }
                ++x;
            }
            ++y;
        }
        if (this.showReleaseHandles && (releasedPiecesCount = (relH = this.currentSpace.currentState.ordrdReleaseHandlesArray).length) > 0) {
            g2d.setStroke(this.relHandleStroke);
            g2d.setColor(this.releaseHandleColour);
            int i = 0;
            while (i < releasedPiecesCount) {
                int xOrigAdj;
                int xMidOrig = (int)((double)this.xTop + ((double)QuiGraphics.gridX(this.boardRotation, relH[i].origLoc) + 0.5) * (double)this.ss);
                int yMidOrig = (int)((double)this.yTop + ((double)QuiGraphics.gridY(this.boardRotation, relH[i].origLoc) + 0.5) * (double)this.ss);
                int xMidDest = (int)((double)this.xTop + ((double)QuiGraphics.gridX(this.boardRotation, relH[i].destLoc) + 0.5) * (double)this.ss);
                int yMidDest = (int)((double)this.yTop + ((double)QuiGraphics.gridY(this.boardRotation, relH[i].destLoc) + 0.5) * (double)this.ss);
                byte hostGroup = this.currentSpace.currentState.stacks[relH[i].origLoc];
                int yAdjustFactor = this.calc.yAdjustFactor(relH[i].activeSizes, hostGroup);
                int yOrigAdj = yAdjustFactor * this.unit;
                hostGroup = this.currentSpace.currentState.stacks[relH[i].destLoc];
                yAdjustFactor = this.calc.yAdjustFactor(relH[i].activeSizes, hostGroup);
                int yDestAdj = yAdjustFactor * this.unit;
                int xDestAdj = xOrigAdj = this.calc.xAdjustFactor(relH[i].activeSizes, QuiRules.numSizes) * this.unit;
                if (xMidDest < xMidOrig || xMidDest == xMidOrig && yMidDest > yMidOrig) {
                    xOrigAdj = -xOrigAdj;
                }
                if (xMidDest > xMidOrig || xMidDest == xMidOrig && yMidDest > yMidOrig) {
                    xDestAdj = -xDestAdj;
                }
                g2d.drawLine(xMidOrig + xOrigAdj, yMidOrig + yOrigAdj, xMidDest + xDestAdj, yMidDest + yDestAdj);
                g2d.fillRect(xMidDest + xDestAdj - 3, yMidDest + yDestAdj - 3, 6, 6);
                ++i;
            }
        }
        if (this.showGrid) {
            g2d.setColor(new Color(220, 220, 220));
            int x = 0;
            while (x < 13) {
                int y2 = 0;
                while (y2 < 13) {
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y2 * this.ss, this.xTop + x * this.ss, y2 * this.ss + this.yTop + this.ss - 1);
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y2 * this.ss, this.xTop + x * this.ss + this.ss - 1, this.yTop + y2 * this.ss);
                    g2d.drawLine(this.xTop + x * this.ss, y2 * this.ss + this.yTop + this.ss, this.xTop + x * this.ss + this.ss, this.yTop + y2 * this.ss);
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y2 * this.ss, this.xTop + x * this.ss + this.ss - 1, y2 * this.ss + this.yTop + this.ss - 1);
                    ++y2;
                }
                ++x;
            }
            g2d.drawLine(this.xTop, this.yTop + 13 * this.ss, this.xTop + 13 * this.ss, this.yTop + 13 * this.ss);
            g2d.drawLine(this.xTop + 13 * this.ss, this.yTop, this.xTop + 13 * this.ss, this.yTop + 13 * this.ss);
        }
        g2d.dispose();
    }

    @Override
    public void setShowOptions(boolean showOptions) {
        this.showLegal = showOptions;
        System.out.println("showLegal is " + this.showLegal);
        if (this.showLegal) {
            this.updateOptionsImage();
        } else {
            this.legalOptions = new boolean[169];
        }
        this.repaint();
    }

    public void updateOptionsImage() {
        System.out.println("boardpanel.updateOptionsImage is run");
        this.legalOptions = this.currentSpace.getLegalOptions();
        this.optionsImage = QuiGraphics.getOptionsImage(this.legalOptions);
    }

    public void toggleStudyMode() {
        this.studyMode = !this.studyMode;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stepPlayer(int playerDelay) {
        this.doPlay = true;
        boolean defaultshowLegal = this.showLegal;
        String forwardStepString = "nav=6";
        this.showLegal = false;
        this.paint(this.getGraphics());
        int stepCount = 0;
        while (this.doPlay) {
            QuincalaBoardPanel quincalaBoardPanel = this;
            synchronized (quincalaBoardPanel) {
                try {
                    this.wait(playerDelay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.currentSpace.receiveSpaceQuString(forwardStepString);
            this.doPlay = QuiGameSpace.currentLine.forwardStepAvailable();
            ++stepCount;
            this.paint(this.getGraphics());
        }
        this.showLegal = defaultshowLegal;
    }

    @Override
    public void updatePanelImage() {
        this.updateBoardImage();
        if (this.showLegal) {
            this.updateOptionsImage();
        }
        this.updateTurnIndicatorImage();
    }

    @Override
    public void updatePositionImages() {
        if (this.showLegal) {
            this.updateOptionsImage();
        }
        this.updateTurnIndicatorImage();
        this.repaint();
    }

    public void updateTurnIndicatorImage() {
        this.turnIndicatorImage = QuiGraphics.getTurnIndicatorImage(this.currentSpace.currentState.passFlag, this.currentSpace.currentState.player);
    }

    public void updateBoardImage() {
        this.smallestSize = this.calc.smallestSizeInPlay(QuiRules.numSizes);
        this.core = 3;
        this.margin = 1;
        if (this.radiusSeen >= QGraphics.radiusSeenDefault - 0.5 || this.radiusSeen <= 0.5) {
            int gridSize = 1;
            gridSize = QGraphics.isMiniBoard ? 10 : 13;
            this.unit = (this.boardPanelSize / gridSize - this.margin * 2 - this.core) / 10;
            if (this.unit < 2) {
                this.unit = 2;
            }
            QuiGraphics.calcFromUnit();
            while (QuiGraphics.canvasSize > QGraphics.maxCanvasSize) {
                --this.unit;
                QuiGraphics.calcFromUnit();
            }
            System.out.println("boardpanel unit is " + this.unit);
            this.ss = this.margin * 2 + this.unit * 10 + this.core;
            int boardSize = this.ss * 13;
            this.yTop = this.xTop = (this.boardPanelSize - boardSize) / 2;
        } else {
            this.unit = (int)((double)this.boardPanelSize / (2.0 * this.radiusSeen + 1.0) - (double)(this.margin * 2) - (double)this.core) / 10;
            System.out.println("zoomed boardpanel original unit is " + this.unit);
            this.ss = this.margin * 2 + this.unit * 10 + this.core;
            while (15 * this.ss > QGraphics.maxCanvasSize) {
                --this.unit;
                this.ss = this.margin * 2 + this.unit * 10 + this.core;
            }
            System.out.println("zoomed boardpanel unit is " + this.unit);
            int centerSqXCoord = QuiGraphics.gridX(this.boardRotation, this.centerSqLoc);
            int centerSqYCoord = QuiGraphics.gridY(this.boardRotation, this.centerSqLoc);
            this.xTop = (int)((2.0 * this.radiusSeen + 1.0 - (double)(centerSqXCoord * 2) - 1.0) * (double)this.ss / 2.0);
            this.yTop = (int)((2.0 * this.radiusSeen + 1.0 - (double)(centerSqYCoord * 2) - 1.0) * (double)this.ss / 2.0);
            if (this.xTop > 0) {
                this.xTop = 0;
            }
            if (this.yTop > 0) {
                this.yTop = 0;
            }
        }
        this.markerRad = this.unit / 3;
        float thickness = 1.0f;
        switch (this.unit) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                thickness = 2.0f;
                break;
            }
            default: {
                thickness = 3.0f;
            }
        }
        this.relHandleStroke = new BasicStroke(thickness);
        this.selectOutlineStroke = new BasicStroke(thickness);
        this.ornArray = new CubicCurve2D[64];
        int k = 0;
        while (k < 64) {
            int i = 0;
            while (i < 8) {
                this.ln[k][i] = i % 2 == 0 ? this.xpandLn[k][i] * (double)this.ss + (double)this.xTop : this.xpandLn[k][i] * (double)this.ss + (double)this.yTop;
                ++i;
            }
            this.ornArray[k] = new CubicCurve2D.Double();
            this.ornArray[k].setCurve(this.ln[k][0], this.ln[k][1], this.ln[k][2], this.ln[k][3], this.ln[k][4], this.ln[k][5], this.ln[k][6], this.ln[k][7]);
            ++k;
        }
        this.pdiff = this.unit;
        if (QuiRules.numSizes == 3) {
            this.pdiff = 2 * this.unit;
        }
        this.pthick = this.unit * 2;
        this.xLargestPiece = 5 * this.unit + this.core - 1;
        this.ds = this.unit;
        this.tds = this.ds * 7 / 10 + 1;
        this.ts = this.unit * 3;
        int i = 0;
        while (i < 20) {
            this.boardPolygonXExp[i] = this.ss * this.boardPolygonX[i] + this.xTop;
            this.boardPolygonYExp[i] = this.ss * this.boardPolygonY[i] + this.yTop;
            ++i;
        }
        this.boardImage = QuiGraphics.getBoardImage();
        this.repaint();
    }

    @Override
    public void sendOnButtons(int buttonNo) {
        String forwardStepString = "nav=6";
        this.currentSpace.receiveSpaceQuString(forwardStepString);
        this.updatePositionImages();
        this.requestGameData();
    }

    @Override
    public boolean forwardAvailable() {
        return QuiGameSpace.currentLine.forwardStepAvailable();
    }

    @Override
    public boolean backwardAvailable() {
        return QuiGameSpace.currentLine.backStepAvailable();
    }

    @Override
    public int playerNo() {
        return this.currentSpace.currentState.player;
    }

    @Override
    public int turnNo() {
        return this.currentSpace.currentState.turnNumber + 1;
    }

    @Override
    public String getPurePlyString() {
        return this.currentSpace.currentState.getLineString();
    }

    public Set getChangedLocs() {
        return this.currentSpace.currentState.changedLocs;
    }

    @Override
    public void testNewG(byte stackByte, int loc) {
        this.currentSpace.currentState.setStack(stackByte, loc);
    }

    @Override
    public QGameStatus getGameStatus() {
        return this.currentSpace.getGameStatus();
    }

    @Override
    public void setZoom(String xy, double radius) {
        char x = xy.charAt(0);
        char y = xy.charAt(1);
        this.centerSqLoc = this.calc.hexCharsToLoc(x, y);
        this.radiusSeen = radius;
        if (this.radiusSeen < 1.0) {
            this.radiusSeen = 1.0;
        }
        this.updatePanelImage();
        this.repaint();
    }

    @Override
    public void resetZoom() {
        this.radiusSeen = this.radiusSeenDefault;
        this.centerSqLoc = this.centerSqLocDefault;
        this.updateBoardImage();
        this.repaint();
    }

    @Override
    public void setDoConstructionTrue() {
        this.doConstruction = true;
    }

    public void requestGameData() {
        QuiPiece[] pieceArray = this.currentSpace.currentState.getPieceArray(this.boardRotation, this.xTop, this.yTop, this.ss);
        this.immortalPieces = this.currentSpace.currentState.immortalPieces;
        this.immunePieces = this.currentSpace.currentState.noKnockPieces;
    }

    @Override
    public void receiveMouseClick(int x, int y) {
        if (x < this.xTop) {
            return;
        }
        x -= this.xTop;
        if (y < this.yTop) {
            return;
        }
        int xSquare = x / this.ss;
        int ySquare = (y -= this.yTop) / this.ss;
        if (xSquare == 12 && ySquare == 12) {
            this.rotateBoard(1);
            return;
        }
        if (xSquare == 12 && ySquare == 0) {
            this.rotateBoard(2);
            return;
        }
        if (xSquare == 0 && ySquare == 0) {
            this.rotateBoard(3);
            return;
        }
        int loc = QGraphics.location(xSquare, ySquare);
        if (loc == 84) {
            this.currentSpace.receiveSpaceQuString("ply=rt");
        } else {
            this.currentSpace.receiveSpaceQuString("loc=" + loc);
        }
        this.requestGameData();
        this.updatePositionImages();
    }

    @Override
    public void receiveMouseZoom(int x, int y) {
        if (x < this.xTop) {
            return;
        }
        x -= this.xTop;
        if (y < this.yTop) {
            return;
        }
        int xSquare = x / this.ss;
        int ySquare = (y -= this.yTop) / this.ss;
        this.centerSqLoc = QuiGraphics.location(xSquare, ySquare);
        if (this.radiusSeen < 1.0) {
            this.radiusSeen = 1.0;
        }
        this.radiusSeen = (this.radiusSeen + 5.0) % 8.0;
        if (this.radiusSeen < 1.0) {
            this.radiusSeen = 1.0;
        }
        System.out.println("radiusSeen is " + this.radiusSeen);
        if (this.radiusSeen >= 6.0) {
            this.radiusSeen = this.radiusSeenDefault;
            this.centerSqLoc = this.centerSqLocDefault;
        }
        this.updateBoardImage();
    }

    @Override
    public void receiveBoardQuString(String quString) {
        String key = QSFUtils.getKey(quString);
        String value = QSFUtils.getValue(quString);
        if (key.equals("zoom") && !QGraphics.isMiniBoard) {
            String[] splitValue = value.split(";");
            if (splitValue.length < 2) {
                if (value.equals("0")) {
                    this.resetZoom();
                    QGraphics.resetZoom();
                    this.updatePanelImage();
                }
                return;
            }
            String centre = splitValue[0];
            if (!QSFUtils.isCoordStringlet(centre)) {
                return;
            }
            double radius = QGraphics.radiusSeenDefault;
            try {
                radius = Double.parseDouble(splitValue[1]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            this.setZoom(centre, radius);
            QGraphics.setZoom(centre, radius);
            this.updatePanelImage();
            return;
        }
        if (key.equals("rotation")) {
            int cand = -1;
            try {
                cand = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid board rotation value");
            }
            if (cand > -1 && cand < 5) {
                this.boardRotation = cand;
                QGraphics.setBoardRotation(cand);
                this.updatePositionImages();
            } else {
                System.out.println("Invalid board rotation value");
            }
        }
    }

    @Override
    public void rotateBoard(int quartersClockwise) {
        this.boardRotation = (this.boardRotation + quartersClockwise) % 4;
        QGraphics.rotateBoard(quartersClockwise);
        this.updatePositionImages();
    }

    @Override
    public void passThruSpaceQuString(String quiString) {
        this.currentSpace.receiveSpaceQuString(quiString);
        if (QGraphics.fetchBoardReDefinitionFlag()) {
            this.updateBoardImage();
        }
        this.updatePositionImages();
        this.requestGameData();
    }

    @Override
    public void passThroughLineInfo(String matchInfo) {
        QuiGameSpace.currentLine.setLineTitle(matchInfo);
    }

    @Override
    public void passThruRuleModification(boolean[] userRules) {
        this.currentSpace.modifyRules(userRules);
    }

    @Override
    public QWholeLineData passUpWholeLineData() {
        QWholeLineData dataToPassUP = QuiGameSpace.currentLine.getWholeLineData();
        return dataToPassUP;
    }

    @Override
    public String[] getQuString(String quStringFormat, boolean stateOut) {
        if (QSFUtils.isBoardKey(quStringFormat)) {
            String[] boardStringReturn = new String[2];
            if (quStringFormat.equals("zoom")) {
                String centreStringlet = QSFUtils.locToHexCharString(QGraphics.centerSqLoc);
                String radiusString = "" + QGraphics.radiusSeen;
                boardStringReturn[0] = String.valueOf(centreStringlet) + ";" + radiusString;
                return boardStringReturn;
            }
        }
        String[] returnString = this.currentSpace.getQuString(quStringFormat);
        if (!stateOut) {
            return returnString;
        }
        if (QGraphics.radiusSeen < QGraphics.radiusSeenDefault) {
            System.out.println("&&zoom= will be added! ");
            if (returnString[0].length() > 0) {
                returnString[0] = String.valueOf(returnString[0]) + "&";
            }
            String centreStringlet = QSFUtils.locToHexCharString(QGraphics.centerSqLoc);
            String radiusString = "" + QGraphics.radiusSeen;
            returnString[0] = String.valueOf(returnString[0]) + "zoom=" + centreStringlet + ";" + radiusString;
        }
        if (QGraphics.boardRotation > 0) {
            System.out.println("&&rotation= will be added! ");
            if (returnString[0].length() > 0) {
                returnString[0] = String.valueOf(returnString[0]) + "&";
            }
            returnString[0] = String.valueOf(returnString[0]) + "rotation=" + QGraphics.boardRotation;
        }
        return returnString;
    }

    public class GridListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (QuincalaBoardPanel.this.edit) {
                int x = e.getX();
                int y = e.getY();
                if (x < QuincalaBoardPanel.this.xTop) {
                    return;
                }
                x -= QuincalaBoardPanel.this.xTop;
                if (y < QuincalaBoardPanel.this.yTop) {
                    return;
                }
                int xSquare = x / QuincalaBoardPanel.this.squareSize;
                int ySquare = (y -= QuincalaBoardPanel.this.yTop) / QuincalaBoardPanel.this.squareSize;
                if (xSquare == 12 && ySquare == 12) {
                    QuincalaBoardPanel.this.boardRotation = (QuincalaBoardPanel.this.boardRotation + 1) % 4;
                    System.out.println("BoardRotation is " + QuincalaBoardPanel.this.boardRotation);
                }
                if (xSquare == 12 && ySquare == 0) {
                    QuincalaBoardPanel.this.boardRotation = (QuincalaBoardPanel.this.boardRotation + 2) % 4;
                    System.out.println("BoardRotation is " + QuincalaBoardPanel.this.boardRotation);
                }
                if (xSquare == 0 && ySquare == 0) {
                    QuincalaBoardPanel.this.boardRotation = (QuincalaBoardPanel.this.boardRotation + 3) % 4;
                    System.out.println("BoardRotation is " + QuincalaBoardPanel.this.boardRotation);
                }
                int loc = QuiGraphics.location(xSquare, ySquare);
                QuincalaBoardPanel.this.currentSpace.receiveEntry(loc);
                QuincalaBoardPanel.this.repaint();
            }
        }
    }
}

