/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.gamequincala;

public class QuiStack {
    public byte sizes = 0;
    public byte blackPieces = 0;
    public byte Selections = 0;
    public byte releasedPieces = 0;
    public char[] hexMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public void setSizes(byte sizeByte) {
        this.sizes = sizeByte;
    }

    public int hexCharsToLoc(char hexChar1, char hexChar2) {
        String hexValue1 = "" + hexChar1;
        String hexValue2 = "" + hexChar2;
        int xCoord = Integer.parseInt(hexValue1, 16);
        int yCoord = Integer.parseInt(hexValue2, 16);
        int loc = (12 - yCoord) * 13 + xCoord;
        return loc;
    }

    public String locToHexCharString(int loc) {
        int hexNum1 = loc % 13;
        int hexNum2 = 12 - loc / 13;
        String hexChars = "" + this.hexMap[hexNum1] + this.hexMap[hexNum2];
        return hexChars;
    }

    public int pathIndex(int actPlayer, int ColourInt) {
        int pIndex = actPlayer * 2 + ColourInt;
        return pIndex;
    }

    public int smallestSizeInPlay(int numSizes) {
        int value = 1;
        int k = 1;
        while (k < numSizes) {
            value *= 2;
            ++k;
        }
        return value;
    }

    public byte calcTowerByte(int nSizes) {
        byte tByte = 0;
        int mask = 1;
        int i = 0;
        while (i < nSizes) {
            tByte = (byte)(tByte + mask);
            mask *= 2;
            ++i;
        }
        return tByte;
    }

    public int countBits(byte B) {
        int bCounter = 0;
        int m = 1;
        while (m < 17) {
            if ((B & m) != 0) {
                ++bCounter;
            }
            m *= 2;
        }
        return bCounter;
    }

    public boolean isEmpty(byte P) {
        boolean empty = false;
        if (P == 0) {
            empty = true;
        }
        return empty;
    }

    public boolean isWhite(byte P, byte C) {
        boolean white = false;
        if (P != 0 && C == 0) {
            white = true;
        }
        return white;
    }

    public boolean isBlack(byte P, byte C) {
        boolean black = false;
        if (P != 0 && C == P) {
            black = true;
        }
        return black;
    }

    public boolean isMixed(byte P, byte C) {
        boolean mixed = false;
        if (C > 0 && C != P) {
            mixed = true;
        }
        return mixed;
    }

    public boolean isPresent(int mask) {
        boolean presence = false;
        if ((mask & this.sizes) != 0) {
            presence = true;
        }
        return presence;
    }

    public boolean pieceIsWhite(int mask, byte C) {
        boolean white = false;
        if ((mask & C) == 0) {
            white = true;
        }
        return white;
    }

    public boolean pieceIsBlack(int mask, byte C) {
        boolean black = false;
        if ((mask & C) != 0) {
            black = true;
        }
        return black;
    }

    public boolean pieceIsSelected(int mask, byte P) {
        boolean selection = false;
        if ((mask & P) != 0) {
            selection = true;
        }
        return selection;
    }

    public int pieceColour(byte size, byte blacks) {
        int colour = 0;
        if ((size & blacks) != 0) {
            colour = 1;
        }
        return colour;
    }

    public byte joinGroups(byte GroupA, byte GroupB) {
        byte resultingGroup = (byte)(GroupA | GroupB);
        return resultingGroup;
    }

    public byte removeFromByte(byte movingPieces, byte originalStack) {
        byte resultingGroup = (byte)(movingPieces ^ originalStack);
        return resultingGroup;
    }

    public byte removeBlacks(byte movingPieces, byte originalBlacks) {
        byte resultingBlacks = (byte)(movingPieces ^ originalBlacks);
        return resultingBlacks;
    }

    public byte extractKnockedPieces(byte knockingPieces, byte oldPieces) {
        byte knockedPieces = (byte)(knockingPieces & oldPieces);
        return knockedPieces;
    }

    public byte sowingGroup(int activePlayer, byte P, byte C) {
        byte sGroup = 0;
        boolean isBottom = true;
        byte k = 1;
        while (k < 17) {
            if ((k & P) != 0 && (k & C) == k * activePlayer) {
                if (isBottom) {
                    isBottom = false;
                } else {
                    sGroup = this.joinGroups(k, sGroup);
                }
            }
            k = (byte)(k * 2);
        }
        return sGroup;
    }

    public byte allOwnPieces(int activePlayer, byte P, byte C) {
        byte pGroup = 0;
        byte k = 1;
        while (k < 17) {
            if ((k & P) != 0 && (k & C) == k * activePlayer) {
                pGroup = this.joinGroups(k, pGroup);
            }
            k = (byte)(k * 2);
        }
        return pGroup;
    }

    public int largestSize(byte B) {
        int mask = 1;
        int k = 0;
        while (k < 5) {
            if ((B & mask) != 0) break;
            mask *= 2;
            ++k;
        }
        return mask;
    }
}

