/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.gamequincala;

import com.quincala.core.QGameStatus;

public class QuiGameStatus
extends QGameStatus {
    public boolean mayMove = false;
    public boolean isMoving = false;
    public boolean mayPlaceLedge = false;
    public boolean mayPlaceHome = false;
    public boolean mayRelease = false;
    public boolean mayBounce = false;
    public boolean hasBeenRewound = false;
    public int releaseDestIndex = 0;
    public int releasedPieceColour = 0;
    public String gameName = "Quincala";

    @Override
    public String getFullGameName() {
        String fullName = String.valueOf(this.gameName) + " ";
        switch (this.GameVersion) {
            case 0: {
                fullName = String.valueOf(fullName) + "Position Editor with " + this.GameVariant + " sizes";
                break;
            }
            case 7: {
                fullName = String.valueOf(fullName) + "Football";
                break;
            }
            case 2: {
                fullName = String.valueOf(fullName) + "Displacing with " + this.GameVariant + " sizes";
                break;
            }
            case 3: {
                fullName = String.valueOf(fullName) + "Standard with " + this.GameVariant + " sizes";
                break;
            }
            case 4: {
                fullName = String.valueOf(fullName) + "Bouncing";
                break;
            }
            case 5: {
                fullName = String.valueOf(fullName) + "Unlimited";
                break;
            }
            case 1: {
                fullName = String.valueOf(fullName) + "Mixing with " + this.GameVariant + " sizes";
                break;
            }
            default: {
                fullName = String.valueOf(fullName) + "Undefined variant";
            }
        }
        return fullName;
    }

    @Override
    public String getStatusBarText() {
        String sBText = "";
        if (this.GameVersion < 1) {
            sBText = "Position Editor - any piece with red selection will be moved anywhere you click";
            return sBText;
        }
        String resultText = "";
        if (this.isWinAhead && !this.isWin) {
            resultText = String.valueOf(this.playerName[this.winColour]) + " will win!";
        }
        if (this.isEndOfLine) {
            if (this.isWin) {
                resultText = String.valueOf(this.playerName[this.winColour]) + " has won!";
            }
            if (this.resignInt == 0) {
                resultText = String.valueOf(resultText) + " (White has resigned)";
            }
            if (this.resignInt == 1) {
                resultText = String.valueOf(resultText) + " (Black has resigned)";
            }
            if (this.resignInt == 2) {
                resultText = String.valueOf(resultText) + "Draw is agreed.";
            }
            if (this.resignInt == 3) {
                resultText = String.valueOf(resultText) + "Draw by consecutive Passes.";
            }
        } else {
            if (this.mayMove) {
                sBText = " to move";
            }
            if (this.mayPlaceHome) {
                sBText = sBText.length() == 0 ? String.valueOf(sBText) + " to place" : String.valueOf(sBText) + " or place";
            }
            if (this.mayPass) {
                sBText = sBText.length() == 0 ? String.valueOf(sBText) + " to pass" : String.valueOf(sBText) + " or pass";
            }
            if (this.isMoving) {
                sBText = " is moving";
            }
            if (this.mayPlaceLedge) {
                sBText = " to place from the ledge";
            }
            if (this.mayRelease) {
                if (this.zeroPlyDestIndex == 0) {
                    sBText = " to release";
                }
                if (this.zeroPlyDestIndex == 1) {
                    sBText = " to capture";
                }
                if (this.zeroPlyDestIndex > 1) {
                    sBText = " to release to the ledge";
                }
            }
            if (sBText.length() > 0) {
                sBText = String.valueOf(this.playerName[this.playerInt]) + sBText + ".";
            }
            if (this.mayBounce) {
                sBText = String.valueOf(sBText) + " (may bounce)";
            }
            if (this.hasBeenRewound) {
                sBText = String.valueOf(sBText) + " (The entire turn has been 're-wound' to enable re-play!)";
            }
        }
        if (this.passFlag > -1 && this.resignInt != 3) {
            sBText = String.valueOf(sBText) + " (" + this.playerName[this.passFlag] + " has passed)";
        }
        if (sBText.length() == 0) {
            sBText = resultText;
        } else if (resultText.length() > 0) {
            sBText = String.valueOf(sBText) + " " + resultText;
        }
        sBText = "; " + sBText;
        return sBText;
    }

    public int opponentInt() {
        return (this.playerInt + 1) % 2;
    }

    public void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }

    public void setMayMove(boolean mayMove) {
        this.mayMove = mayMove;
    }

    public void setMayPlaceHome(boolean mayPlaceHome) {
        this.mayPlaceHome = mayPlaceHome;
    }

    public void setMayPlaceLedge(boolean mayPlaceLedge) {
        this.mayPlaceLedge = mayPlaceLedge;
    }

    public void setMayRelease(boolean mayRelease) {
        this.mayRelease = mayRelease;
    }

    public void setMayBounce(boolean mayBounce) {
        this.mayBounce = mayBounce;
    }

    public void setReleaseDestIndex(int releaseDestIndex) {
        this.releaseDestIndex = releaseDestIndex;
    }

    public void setReleasedPieceColour(int releasedPieceColour) {
        this.releasedPieceColour = releasedPieceColour;
    }

    public void setHasBeenRewound(boolean hasBeenRewound) {
        this.hasBeenRewound = hasBeenRewound;
    }
}

