/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.gamequincala;

import com.quincala.core.QDuplet;
import com.quincala.core.QGameState;
import com.quincala.core.QRules;
import com.quincala.core.QSFUtils;
import com.quincala.core.QWholeLineData;
import com.quincala.gamequincala.QuiGameStatus;
import com.quincala.gamequincala.QuiPiece;
import com.quincala.gamequincala.QuiRules;
import com.quincala.gamequincala.QuiStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class QuiGameState
extends QGameState
implements Cloneable {
    private boolean disObeyOptions = false;
    public boolean doConstruction = false;
    public boolean[] options = new boolean[169];
    public byte[] stacks = new byte[169];
    public byte[] blackPieces = new byte[169];
    public byte[] pieceSelections = new byte[169];
    public byte[] releasedPieces = new byte[169];
    public byte[] immortalPieces = new byte[169];
    public byte[] noKnockPiecesToBe = new byte[169];
    public byte[] noKnockPieces = new byte[169];
    public int activeLocation = 169;
    private ArrayList ReleaseHandles = new ArrayList();
    private ArrayList ordrdReleaseHandles = new ArrayList();
    public QDuplet[] ordrdReleaseHandlesArray = new QDuplet[0];
    public boolean doReleasing = false;
    public int bouncingDirectionUnit = 0;
    public int bouncingOrigin = 0;
    public int[] bouncingLineLocs = new int[2];
    QDuplet active = new QDuplet();
    public ArrayList activeList = new ArrayList();
    public boolean mayMove = false;
    public boolean isMoving = false;
    public boolean mayPlaceLedge = false;
    public boolean mayPlaceHome = false;
    public boolean mayPass = false;
    public int passFlag = -1;
    private boolean justPassedFlag = false;
    public boolean failedControlTest = false;
    public int controlPassInt = 0;
    public boolean hasBeenRewound = false;
    public boolean initialRetrace = false;
    public boolean buildLocString = false;
    public int confirmedPlyCount = 0;
    public int confirmedLocPos = 0;
    private boolean doCrop = false;
    public boolean hasIllegalPlies = false;
    public int presentDupletType = 0;
    public int lastPlyValue = 0;
    public int turnPhase = 0;
    private final int EMPTY = 0;
    private final int L_PLACING = 1;
    private final int H_PLACING = 2;
    private final int LEG = 3;
    private final int KNOCKING = 4;
    private final int END_LEG = 5;
    private final int RELEASING = 6;
    private final int LARGEST_PIECE = 0;
    private final int ALL_OWN_PIECES = 1;
    private final int SOWERS = 2;
    QuiStack[] stackArray = new QuiStack[169];
    public Set changedLocs = new HashSet();
    public ArrayList whiteIRHistory = new ArrayList();
    public ArrayList blackIRHistory = new ArrayList();
    public String matchString = "qui";
    public String matchHexString = "qui";
    public String lineStringHead = "qui";
    public String plyString = "";
    public String locString = "";
    public int turnNumber = 1;
    public int plyCount = 0;
    public int player = 0;
    private int homedot = this.ownHomeDot(this.player);
    public boolean whitesTurn = true;
    public int firstPlayer = 0;
    public boolean whiteStarted = true;
    public boolean isWin = false;
    public boolean isWinAhead = false;
    public boolean isEndOfLine = false;
    public int resignInt = -1;
    public int winColour = -1;
    public int winLocation = 169;
    public int winLocationAhead = 169;
    public String matchPhaseString = "";
    public String statusBarText = "";
    public String controlStatusText = "";
    public int goldenRuleFlag = -1;
    public boolean goldenRuleHolds = false;
    public String goldenRuleInfo = "";

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setStack(byte stackByte, int loc) {
        int i = 0;
        while (i < 169) {
            this.stackArray[i] = new QuiStack();
            ++i;
        }
        this.stackArray[loc].setSizes(stackByte);
        this.stackArray[loc].isPresent(2);
    }

    public QuiPiece[] getPieceArray(int boardRotation, int xTop, int yTop, int ss) {
        QuiPiece[] pieceArray = new QuiPiece[QuiRules.numPieces];
        int paIndex = 0;
        int size = 0;
        byte mask = 1;
        while (mask < QuiRules.towerByte) {
            ++size;
            int colour = 0;
            while (colour < 2) {
                int loc = 0;
                while (loc < 169) {
                    if (this.pieceIsAtLocation(mask, colour, loc)) {
                        QuiPiece quiPiece = new QuiPiece();
                        quiPiece.setLoc(loc);
                        quiPiece.setType(size);
                        quiPiece.setColour(colour);
                        quiPiece.setStackSize(this.countBits(this.stacks[loc]));
                        quiPiece.setOrderInStack(this.orderInStack(size, this.stacks[loc]));
                        quiPiece.setReleased(this.isPresent(mask, this.releasedPieces[loc]));
                        quiPiece.setFree(this.isPlain(this.stacks[loc], this.blackPieces[loc]) && this.isBlackDot(loc));
                        quiPiece.setInMixedStack(this.isMixed(this.stacks[loc], this.blackPieces[loc]));
                        pieceArray[paIndex] = quiPiece;
                        ++paIndex;
                    }
                    ++loc;
                }
                ++colour;
            }
            mask = (byte)(mask * 2);
        }
        if (!QuiRules.freedomRule || this.isEndOfLine) {
            return pieceArray;
        }
        this.immortalPieces = new byte[169];
        int index = 0;
        byte mask2 = 1;
        while (mask2 < QuiRules.towerByte) {
            int colour = 0;
            while (colour < 2) {
                int freeCount = 0;
                int i = 0;
                while (i < 4) {
                    if (pieceArray[index].isFree) {
                        ++freeCount;
                    }
                    ++index;
                    ++i;
                }
                if (freeCount < 2) {
                    index -= 4;
                    i = 0;
                    while (i < 4) {
                        if (pieceArray[index].isFree) {
                            int n = pieceArray[index].loc;
                            this.immortalPieces[n] = (byte)(this.immortalPieces[n] + mask2);
                            pieceArray[index].setImmortal(true);
                        }
                        ++index;
                        ++i;
                    }
                }
                ++colour;
            }
            mask2 = (byte)(mask2 * 2);
        }
        return pieceArray;
    }

    public QuiGameStatus getGameStatus() {
        QuiGameStatus currentGameStatus = new QuiGameStatus();
        currentGameStatus.setCurrentTurnNo(this.turnNumber);
        currentGameStatus.setPlayerInt(this.player);
        this.endOfLineTest();
        currentGameStatus.setMatchPhaseString(this.matchPhaseString);
        currentGameStatus.setStatusBarText(this.statusBarText);
        currentGameStatus.setGameVersion(QuiRules.ruleVersion);
        currentGameStatus.setGameVariant(QuiRules.numSizes);
        currentGameStatus.setMayMove(this.mayMove);
        currentGameStatus.setMayPass(this.mayPass);
        currentGameStatus.setMayPlaceHome(this.mayPlaceHome);
        currentGameStatus.setMayPlaceLedge(this.mayPlaceLedge);
        currentGameStatus.setMayRelease(this.zeroPlyDestination > 0);
        currentGameStatus.setZeroPlyDestIndex(this.zeroPlyDestIndex);
        currentGameStatus.setMoving(this.isMoving);
        currentGameStatus.setMayBounce(this.bouncingDirectionUnit != 0);
        currentGameStatus.setPassFlag(this.passFlag);
        currentGameStatus.setHasBeenRewound(this.hasBeenRewound);
        currentGameStatus.setWin(this.isWin);
        currentGameStatus.setWinAhead(this.isWinAhead);
        currentGameStatus.setWinColour(this.winColour);
        currentGameStatus.setResignInt(this.resignInt);
        currentGameStatus.setEndOfLine(this.isEndOfLine);
        return currentGameStatus;
    }

    public QWholeLineData getWholeLineData() {
        QWholeLineData currentStateEndData = new QWholeLineData();
        currentStateEndData.setGameVersion(QuiRules.ruleVersion);
        currentStateEndData.setGameVariant(QuiRules.numSizes);
        currentStateEndData.setLocString(this.locString);
        currentStateEndData.setTurnsOpened(this.turnNumber);
        int turnCount = this.turnNumber;
        if (this.turnPhase == 0 && this.resignInt == -1) {
            --turnCount;
        }
        currentStateEndData.setTurnsInLine(turnCount);
        currentStateEndData.setTurnPhase(this.turnPhase);
        currentStateEndData.setPlayer(this.player);
        currentStateEndData.setWinnerInt(this.winColour);
        currentStateEndData.setResignInt(this.resignInt);
        currentStateEndData.setEndOfLine(this.isEndOfLine);
        this.endOfLineTest();
        currentStateEndData.setGoldenRuleFlag(this.goldenRuleFlag);
        return currentStateEndData;
    }

    public String getLineString() {
        return String.valueOf(this.lineStringHead) + this.plyString;
    }

    public int getLocPos() {
        return this.locString.length();
    }

    public String getLocStringToLocPos(int locPos) {
        String extract = this.locString.substring(0, locPos);
        return extract;
    }

    public int getPlyPos() {
        return this.plyString.length();
    }

    public boolean[] getOptions() {
        return this.options;
    }

    public int[] getLocArray() {
        int length = this.locString.length();
        int[] locArray = new int[length / 2];
        int i = 0;
        while (i < length / 2) {
            char hexChar1 = this.locString.charAt(i * 2);
            char hexChar2 = this.locString.charAt(i * 2 + 1);
            locArray[i] = QSFUtils.hexCharsToLoc(hexChar1, hexChar2);
            ++i;
        }
        return locArray;
    }

    public void cropFourChars() {
        this.plyString = this.plyString.substring(0, this.getPlyPos() - 4);
        this.locString = this.locString.substring(0, this.getLocPos() - 4);
    }

    public void setDoCropTrue() {
        this.doCrop = true;
    }

    public boolean fetchDoCrop() {
        boolean value = this.doCrop;
        this.doCrop = false;
        return value;
    }

    public void setGoldeRuleFlag(int colour) {
        if (this.goldenRuleFlag < 0) {
            this.goldenRuleFlag = colour;
        }
    }

    public void newTurn() {
        this.switchPlayer();
        ++this.turnNumber;
        this.turnLocCount = 0;
        this.noKnockPieces = new byte[169];
        this.noKnockPieces = (byte[])this.noKnockPiecesToBe.clone();
        this.noKnockPiecesToBe = new byte[169];
    }

    public void switchPlayer() {
        this.player = (this.player + 1) % 2;
        this.whitesTurn = !this.whitesTurn;
        this.turnPhase = 0;
        this.activeLocation = 169;
        this.presentDupletType = 0;
    }

    public void setStacks(byte[] startStacks) {
        this.resetGameState();
        this.stacks = (byte[])startStacks.clone();
    }

    public void setBlackPieces(byte[] startBlackPieces) {
        this.blackPieces = (byte[])startBlackPieces.clone();
    }

    public void setTowerByte(int numSizes) {
        this.whiteIRHistory.add(0, this.getIRPositionString(0));
        this.blackIRHistory.add(0, this.getIRPositionString(1));
    }

    public void setPresentDupletType(int dType) {
        this.presentDupletType = dType;
    }

    public void selectUserSquare(int loc) {
        this.activeLocation = loc;
    }

    public void selectAllPieces(int loc) {
        this.pieceSelections[loc] = this.stacks[loc];
    }

    public void selectSomePieces(int loc, byte pieceSelection) {
        this.pieceSelections[loc] = pieceSelection;
    }

    public void addReleasedPiece(int loc, byte releasedPiece) {
        this.releasedPieces[loc] = this.joinGroups(this.releasedPieces[loc], releasedPiece);
    }

    public void updateReleasedPieces() {
        int i = 0;
        while (i < 169) {
            this.releasedPieces[i] = (byte)(this.releasedPieces[i] & this.stacks[i]);
            ++i;
        }
    }

    public void clearReleasedPieces() {
        this.releasedPieces = new byte[169];
    }

    public void noActiveLocation() {
        this.activeLocation = 169;
    }

    public void deSelectAllPieces() {
        this.pieceSelections = new byte[169];
    }

    public void updatePosition(int atLoc, byte newStack, byte newBlacks) {
        this.stacks[atLoc] = newStack;
        this.blackPieces[atLoc] = newBlacks;
    }

    public boolean hasPieces(int loc) {
        boolean result = false;
        if (this.stacks[loc] > 0) {
            result = true;
        }
        return result;
    }

    public boolean hasCompleteTower(int loc) {
        boolean result = false;
        if (this.stacks[loc] == QuiRules.towerByte) {
            result = true;
        }
        return result;
    }

    public boolean hasMixedGroup(int loc) {
        return this.blackPieces[loc] > 0 && this.stacks[loc] != this.blackPieces[loc];
    }

    public boolean hasPlainGroup(int loc) {
        return this.hasPlainWhite(loc) || this.hasPlainBlack(loc);
    }

    public boolean hasPlainWhite(int loc) {
        return this.stacks[loc] > 0 && this.blackPieces[loc] == 0;
    }

    public boolean hasWhitePiece(int loc) {
        return this.stacks[loc] > this.blackPieces[loc];
    }

    public boolean hasBlackPiece(int loc) {
        return this.blackPieces[loc] > 0;
    }

    public boolean hasPlainBlack(int loc) {
        return this.stacks[loc] > 0 && this.stacks[loc] == this.blackPieces[loc];
    }

    public boolean pieceIsAtLocation(int sizeMask, int colour, int loc) {
        byte blacks;
        boolean result = false;
        byte stack = this.stacks[loc];
        if ((sizeMask & stack) != 0 & (sizeMask & (blacks = this.blackPieces[loc])) == sizeMask * colour) {
            result = true;
        }
        return result;
    }

    public boolean pieceIsInReleasedPieces(int sizeMask, int colour, int loc) {
        byte blacks;
        boolean result = false;
        byte stack = this.releasedPieces[loc];
        if ((sizeMask & stack) != 0 & (sizeMask & (blacks = this.blackPieces[loc])) == sizeMask * colour) {
            result = true;
        }
        return result;
    }

    public void performUeberList(ArrayList listOfListsOfDupletLists) {
        ArrayList ueberlist = (ArrayList)listOfListsOfDupletLists.get(0);
        this.performMetaList(ueberlist);
    }

    public void performMetaList(ArrayList listOfDupletLists) {
        int s = listOfDupletLists.size();
        int i = 0;
        while (i < s) {
            ArrayList dupletlist = (ArrayList)listOfDupletLists.get(i);
            this.performDupletList(dupletlist);
            ++i;
        }
    }

    public void performDupletList(ArrayList dupletList) {
        this.changedLocs = new HashSet();
        int size = dupletList.size();
        int dType = 0;
        int from = 0;
        int to = 0;
        int i = 0;
        while (i < size) {
            QDuplet perform = (QDuplet)dupletList.get(i);
            from = perform.origLoc;
            to = perform.destLoc;
            byte movedPieces = perform.activeSizes;
            this.lastPlyValue = perform.plyValue;
            dType = perform.dupletType;
            this.changedLocs.add(new Integer(from));
            this.changedLocs.add(new Integer(to));
            byte movedBlacks = (byte)(movedPieces & this.blackPieces[from]);
            this.stacks[from] = this.removeFromByte(movedPieces, this.stacks[from]);
            this.blackPieces[from] = this.removeFromByte(movedBlacks, this.blackPieces[from]);
            this.stacks[to] = this.joinGroups(movedPieces, this.stacks[to]);
            this.blackPieces[to] = this.joinGroups(movedBlacks, this.blackPieces[to]);
            this.plyCount += this.lastPlyValue;
            if (QuiRules.immunity) {
                int immuneMovers;
                if (dType == 3) {
                    immuneMovers = movedPieces & this.noKnockPieces[from];
                    this.noKnockPieces[to] = (byte)(this.noKnockPieces[to] | immuneMovers);
                    this.noKnockPiecesToBe[to] = (byte)(this.noKnockPiecesToBe[to] | immuneMovers);
                    this.noKnockPieces[from] = (byte)(this.noKnockPieces[from] ^ immuneMovers);
                    this.noKnockPiecesToBe[from] = (byte)(this.noKnockPiecesToBe[from] ^ immuneMovers);
                }
                if (dType == 6) {
                    immuneMovers = movedPieces & this.noKnockPieces[from];
                    this.noKnockPieces[from] = (byte)(this.noKnockPieces[from] ^ immuneMovers);
                    this.noKnockPiecesToBe[from] = (byte)(this.noKnockPiecesToBe[from] ^ immuneMovers);
                }
            }
            ++i;
        }
        if (QuiRules.bouncing && dType == 3) {
            this.bouncingDirectionUnit = this.bouncingDirection(from, to);
            this.bouncingOrigin = to;
            this.bouncingLineLocs[0] = to;
            this.bouncingLineLocs[1] = to + this.bouncingDirectionUnit;
        }
        this.presentDupletType = dType;
        this.turnPhase = dType;
        for (Object e : this.changedLocs) {
        }
    }

    public void performDuplet(QDuplet perform) {
    }

    public void initMatchString(int ruleVersion, int numSizes) {
        this.matchString = String.valueOf(this.matchString) + (char)(ruleVersion + 48);
        this.matchString = String.valueOf(this.matchString) + (char)(numSizes + 48);
        this.matchHexString = String.valueOf(this.matchHexString) + (char)(ruleVersion + 48);
        this.matchHexString = String.valueOf(this.matchHexString) + (char)(numSizes + 48);
        this.lineStringHead = String.valueOf(this.lineStringHead) + (char)(ruleVersion + 48);
        this.lineStringHead = String.valueOf(this.lineStringHead) + (char)(numSizes + 48);
    }

    public void addToHistory(char quChar) {
        this.matchString = String.valueOf(this.matchString) + quChar;
    }

    public void addToPlyString(String quHexChars) {
        this.matchHexString = String.valueOf(this.matchHexString) + quHexChars;
        this.plyString = String.valueOf(this.plyString) + quHexChars;
    }

    public boolean mixingGameWinTest() {
        int whiteTower = 0;
        int blackTower = 0;
        int loc = 6;
        while (loc < 163) {
            if (this.isBlackDot(loc) && this.isMixed(this.stacks[loc], this.blackPieces[loc])) {
                blackTower |= this.blackPieces[loc];
                int whitePieces = this.stacks[loc] ^ this.blackPieces[loc];
                whiteTower |= whitePieces;
            }
            ++loc;
        }
        if (whiteTower == QuiRules.towerByte && blackTower == QuiRules.towerByte) {
            this.isWin = true;
            this.isEndOfLine = true;
            this.winColour = (this.player + 1) % 2;
        } else {
            if (whiteTower == QuiRules.towerByte) {
                this.isWin = true;
                this.isEndOfLine = true;
                this.winColour = 0;
            }
            if (blackTower == QuiRules.towerByte) {
                this.isWin = true;
                this.isEndOfLine = true;
                this.winColour = 1;
            }
        }
        return this.isEndOfLine;
    }

    public boolean endOfLineTest() {
        if (this.isEndOfLine) {
            if (this.resignInt > -1 && this.resignInt < 2) {
                this.isWin = true;
                this.winColour = (this.resignInt + 1) % 2;
                this.goldenRuleTest();
            }
            return true;
        }
        if (QuiRules.winByKnockAllSizes) {
            int i = 0;
            while (i < 2) {
                int ledgeNumber = (this.player + i) % 2;
                int knockLoc = QuiRules.knockingPaths[ledgeNumber][0];
                boolean knockTowerWin = this.hasCompleteTower(knockLoc);
                int lastLoc = QuiRules.knockingPaths[ledgeNumber][3];
                boolean lastPieceWin = this.hasPieces(lastLoc);
                if (knockTowerWin) {
                    this.isWin = true;
                    this.isEndOfLine = true;
                    this.winLocation = knockLoc;
                    this.winColour = (ledgeNumber + 1) % 2;
                }
                if (QuiRules.winByKnockingLast && lastPieceWin) {
                    this.isWin = true;
                    this.isEndOfLine = true;
                    this.winLocation = lastLoc;
                    this.winColour = (ledgeNumber + 1) % 2;
                }
                ++i;
            }
            return this.isEndOfLine;
        }
        if (QuiRules.ruleVersion > 1 && QuiRules.ruleVersion != 7) {
            int i = 0;
            while (i < 4) {
                if (this.hasCompleteTower(QuiRules.whiteDiamonds[i])) {
                    this.isWin = true;
                    this.isEndOfLine = true;
                    this.winLocation = QuiRules.whiteDiamonds[i];
                    if (i < 2) {
                        this.matchPhaseString = "White Win.";
                        this.winColour = 0;
                    } else {
                        this.matchPhaseString = "Black Win.";
                        this.winColour = 1;
                    }
                    this.goldenRuleTest();
                }
                ++i;
            }
            byte whiteQuincalaDiamondSizes = this.stacks[85];
            byte blackQuincalaDiamondSizes = this.stacks[83];
            int releaseHandlesCount = this.ordrdReleaseHandlesArray.length;
            int k = 0;
            while (k < releaseHandlesCount) {
                int nextColourToBeReleased = this.ordrdReleaseHandlesArray[k].colour;
                byte nextSizeToBeReleased = this.ordrdReleaseHandlesArray[k].activeSizes;
                if (nextColourToBeReleased == 0) {
                    whiteQuincalaDiamondSizes = this.joinGroups(whiteQuincalaDiamondSizes, nextSizeToBeReleased);
                } else {
                    blackQuincalaDiamondSizes = this.joinGroups(blackQuincalaDiamondSizes, nextSizeToBeReleased);
                }
                if (whiteQuincalaDiamondSizes == QuiRules.towerByte) {
                    this.isWinAhead = true;
                    this.winLocationAhead = 85;
                    this.matchPhaseString = "White Win.";
                    this.winColour = 0;
                    this.goldenRuleTest();
                } else if (blackQuincalaDiamondSizes == QuiRules.towerByte) {
                    this.isWinAhead = true;
                    this.winLocationAhead = 83;
                    this.matchPhaseString = "Black Win.";
                    this.winColour = 1;
                    this.goldenRuleTest();
                }
                ++k;
            }
        } else if (QuiRules.ruleVersion == 7) {
            if (this.hasWhitePiece(QuiRules.whiteGoalDot)) {
                this.isWin = true;
                this.isEndOfLine = true;
                this.winLocation = QuiRules.whiteGoalDot;
                this.matchPhaseString = "White Win";
                this.winColour = 0;
            }
            if (this.hasBlackPiece(QuiRules.blackGoalDot)) {
                this.isWin = true;
                this.isEndOfLine = true;
                this.winLocation = QuiRules.blackGoalDot;
                this.matchPhaseString = "Black Win";
                this.winColour = 1;
            }
        }
        this.statusBarText = "Turn: " + this.turnNumber + ", " + this.matchPhaseString;
        if (!this.isWin) {
            if (this.presentDupletType == 1) {
                this.statusBarText = String.valueOf(this.statusBarText) + " Placing from ledge.";
            }
            if (this.presentDupletType == 2) {
                this.statusBarText = String.valueOf(this.statusBarText) + " Placing from own home dot.";
            }
            if (this.presentDupletType == 3) {
                this.statusBarText = String.valueOf(this.statusBarText) + " Moving.";
            }
            if (this.presentDupletType == 6) {
                this.statusBarText = String.valueOf(this.statusBarText) + " Releasing.";
            }
        }
        if (this.passFlag == 0) {
            this.statusBarText = String.valueOf(this.statusBarText) + " (White passed)";
        }
        if (this.passFlag == 1) {
            this.statusBarText = String.valueOf(this.statusBarText) + " (Black passed)";
        }
        this.statusBarText = String.valueOf(this.statusBarText) + this.controlStatusText;
        return this.isEndOfLine;
    }

    public void goldenRuleTest() {
        if (this.goldenRuleFlag > -1) {
            if (this.goldenRuleFlag == this.winColour) {
                this.goldenRuleHolds = false;
                this.goldenRuleInfo = "Golden Rule failed.";
            } else {
                this.goldenRuleHolds = true;
                this.goldenRuleInfo = "Golden Rule holds.";
            }
        }
    }

    public boolean irreversibilityTest() {
        if (!QuiRules.irreversibility) {
            return true;
        }
        String iRmessage = "";
        boolean result = true;
        int offendingTurn = 0;
        String currentPosString = this.getIRPositionString(this.player);
        if (this.player == 0) {
            int size = this.whiteIRHistory.size();
            int i = 0;
            while (i < size) {
                String testString = (String)this.whiteIRHistory.get(i);
                if (testString.equals(currentPosString)) {
                    result = false;
                    ++this.controlPassInt;
                    offendingTurn = this.turnNumber - 2 * (i + 1);
                    iRmessage = "end position same as turn " + offendingTurn;
                    if (offendingTurn < 1) {
                        iRmessage = "end position same as start position (turn " + (offendingTurn += 2) + ")";
                    }
                    break;
                }
                ++i;
            }
        } else {
            String testString;
            int i = 0;
            int size = this.blackIRHistory.size();
            if (i < size && (testString = (String)this.blackIRHistory.get(i)).equals(currentPosString)) {
                result = false;
                ++this.controlPassInt;
                offendingTurn = this.turnNumber - 2 * (i + 1);
                iRmessage = "end position same as turn " + offendingTurn;
                if (offendingTurn < 1) {
                    iRmessage = "end position same as start position (turn " + (offendingTurn += 2) + ".)";
                }
            }
        }
        return result;
    }

    public void addToIRHistory() {
        System.out.println("addToIRHistory is run");
        if (this.player == 0) {
            this.whiteIRHistory.add(0, this.getIRPositionString(0));
        } else {
            this.blackIRHistory.add(0, this.getIRPositionString(1));
        }
    }

    public String getIRPositionString(int colourInt) {
        String posString = "";
        String ledgePosString = "";
        ledgePosString = colourInt == 0 ? "4c" : "80";
        int ledgeIndex = (colourInt + 1) % 2;
        int size = QuiRules.ledges[colourInt].length;
        int p = 1;
        while (p < QuiRules.towerByte) {
            int l = 0;
            while (l < size) {
                if (this.pieceIsAtLocation(p, colourInt, QuiRules.ledges[ledgeIndex][l])) {
                    posString = String.valueOf(posString) + ledgePosString;
                }
                ++l;
            }
            int i = 6;
            while (i < 163) {
                int loc;
                if (i != 13 && i != 26 && i != 39 && i != 129 && i != 142 && i != 155 && this.pieceIsAtLocation(p, colourInt, loc = i)) {
                    posString = String.valueOf(posString) + QSFUtils.locToHexCharString(loc);
                }
                ++i;
            }
            p *= 2;
        }
        return posString;
    }

    public boolean freedomTest() {
        boolean result;
        if (!QuiRules.freedomRule) {
            return true;
        }
        boolean blackFreedom = false;
        byte blackFreedomByte = 0;
        int i = 0;
        while (i < 169) {
            if (this.hasPlainBlack(i) && this.isBlackDot(i) && (blackFreedomByte = this.joinGroups(blackFreedomByte, this.stacks[i])) == QuiRules.towerByte) {
                blackFreedom = true;
                break;
            }
            ++i;
        }
        boolean whiteFreedom = false;
        byte whiteFreedomByte = 0;
        int i2 = 168;
        while (i2 >= 0) {
            if (this.hasPlainWhite(i2) && this.isBlackDot(i2) && (whiteFreedomByte = this.joinGroups(whiteFreedomByte, this.stacks[i2])) == QuiRules.towerByte) {
                whiteFreedom = true;
                break;
            }
            --i2;
        }
        boolean bl = result = blackFreedom && whiteFreedom;
        if (!result) {
            this.controlPassInt += 2;
        }
        return result;
    }

    public String getSimplePositionString() {
        int loc;
        int i;
        String simplePositionString = "";
        int p = 1;
        while (p < QuiRules.towerByte) {
            i = 0;
            while (i < 169) {
                loc = 168 - i;
                if (this.pieceIsAtLocation(p, 0, loc)) {
                    simplePositionString = String.valueOf(simplePositionString) + QSFUtils.locToHexCharString(i);
                }
                ++i;
            }
            p *= 2;
        }
        p = 1;
        while (p < QuiRules.towerByte) {
            i = 0;
            while (i < 169) {
                loc = i;
                if (this.pieceIsAtLocation(p, 1, loc)) {
                    simplePositionString = String.valueOf(simplePositionString) + QSFUtils.locToHexCharString(loc);
                }
                ++i;
            }
            p *= 2;
        }
        return simplePositionString;
    }

    public void setPositionFromString(String quPositionString) {
        int loc;
        char yChar;
        char xChar;
        int n;
        this.resetGameState();
        this.stacks = new byte[169];
        this.blackPieces = new byte[169];
        int readIndex = 0;
        int numSizes = quPositionString.length() / 16;
        this.setTowerByte(numSizes);
        byte p = 1;
        while (p < QuiRules.towerByte) {
            n = 0;
            while (n < 4) {
                xChar = quPositionString.charAt(readIndex);
                yChar = quPositionString.charAt(readIndex + 1);
                int n2 = loc = 168 - QSFUtils.hexCharsToLoc(xChar, yChar);
                this.stacks[n2] = (byte)(this.stacks[n2] + p);
                readIndex += 2;
                ++n;
            }
            p = (byte)(p * 2);
        }
        p = 1;
        while (p < QuiRules.towerByte) {
            n = 0;
            while (n < 4) {
                xChar = quPositionString.charAt(readIndex);
                yChar = quPositionString.charAt(readIndex + 1);
                int n3 = loc = QSFUtils.hexCharsToLoc(xChar, yChar);
                this.stacks[n3] = (byte)(this.stacks[n3] + p);
                int n4 = loc;
                this.blackPieces[n4] = (byte)(this.blackPieces[n4] + p);
                readIndex += 2;
                ++n;
            }
            p = (byte)(p * 2);
        }
    }

    public void resetGameState() {
        this.deSelectAllPieces();
        this.clearReleasedPieces();
        this.locString = "";
        this.plyString = "";
        this.activeLocation = 169;
        this.presentDupletType = 0;
        this.player = 0;
        this.firstPlayer = 0;
        this.isWin = false;
        this.matchPhaseString = "";
        this.statusBarText = "";
        this.goldenRuleFlag = -1;
        this.goldenRuleInfo = "";
        this.winLocation = 169;
    }

    public void resetAllowBooleans() {
        this.mayMove = false;
        this.isMoving = false;
        this.mayPlaceLedge = false;
        this.mayPlaceHome = false;
        this.mayPass = false;
    }

    public void initGameState() {
        this.setStacks(QuiRules.startStacks);
        this.setBlackPieces(QuiRules.startBlackPieces);
        this.initMatchString(QuiRules.ruleVersion, QuiRules.numSizes);
        this.evaluatePosition(0);
    }

    public void addToLocString(String addition) {
        this.locString = String.valueOf(this.locString) + addition;
        this.controlStatusText = "";
        this.hasBeenRewound = false;
    }

    public void receiveLocString(String locString) {
        int length = locString.length();
        int[] plyArray = new int[length / 2];
        int i = 0;
        while (i < length / 2) {
            char hexChar1 = locString.charAt(i * 2);
            char hexChar2 = locString.charAt(i * 2 + 1);
            plyArray[i] = QSFUtils.hexCharsToLoc(hexChar1, hexChar2);
            ++i;
        }
        this.receiveLocArray(plyArray);
    }

    public void receiveLocChars(char xChar, char yChar) {
        this.receiveLoc(QSFUtils.hexCharsToLoc(xChar, yChar));
    }

    public void receiveLocArray(int[] p, boolean brake) {
        this.receiveLocArray(p);
        if (!brake) {
            this.completeZeroPlyMoves();
        }
    }

    public void receiveLocArray(int[] p) {
        int length = p.length;
        int i = 0;
        while (i < length) {
            this.receiveLoc(p[i]);
            ++i;
        }
    }

    public void receiveLoc(int loc, boolean brake) {
        this.receiveLoc(loc);
        if (!brake) {
            this.completeZeroPlyMoves();
        }
    }

    public void completeZeroPlyMoves() {
        while (this.zeroPlyDestination > 0) {
            this.receiveLoc(this.zeroPlyDestination);
        }
    }

    public void receiveLoc(int loc) {
        if (!this.isValidEntry(loc)) {
            return;
        }
        this.addToLocString(QSFUtils.locToHexCharString(loc));
        ++this.turnLocCount;
        if (QRules.isPosEdit && loc == 84) {
            this.switchPlayer();
            this.active.fillOrigFields(loc, (byte)0);
            this.active.setTypeAndPlyValue(5, 1);
            this.setPresentDupletType(5);
        }
        if (this.presentDupletType != 6 && !QRules.isPosEdit) {
            this.addToPlyString(QSFUtils.locToHexCharString(loc));
        }
        if (loc == 972 || loc == 973) {
            this.isEndOfLine = true;
            this.resignInt = loc - 972;
            this.evaluatePosition(loc);
            return;
        }
        if (loc == 988) {
            this.isEndOfLine = true;
            this.resignInt = 2;
            this.evaluatePosition(loc);
            return;
        }
        if (this.active.origLoc == 0) {
            if (QRules.isPosEdit) {
                if (this.hasPlainBlack(loc) && this.player == 0) {
                    this.switchPlayer();
                }
                if (this.hasPlainWhite(loc) && this.player == 1) {
                    this.switchPlayer();
                }
            }
            this.passFlag = -1;
            if (loc == 84 || loc == 1001) {
                this.passFlag = this.player;
                this.active.fillOrigFields(84, (byte)0);
                this.active.setTypeAndPlyValue(5, 1);
                this.setPresentDupletType(5);
                this.noActiveLocation();
                this.deSelectAllPieces();
                this.active.fillDestField(84);
                this.activeList.add(this.active);
                this.performDupletList(this.activeList);
                this.active = new QDuplet();
                this.activeList = new ArrayList();
                if (QuiRules.drawByConsecutivePass && this.justPassedFlag) {
                    this.isEndOfLine = true;
                    this.resignInt = 3;
                }
                this.justPassedFlag = true;
                this.evaluatePosition(84);
                return;
            }
            this.justPassedFlag = false;
            if (loc == this.homedot || this.isLedge(loc)) {
                this.startActiveDuplet(loc, 0);
                this.active.setTypeAndPlyValue(2, 2);
                this.setPresentDupletType(2);
                this.allowEmptyPlacingDots(this.player);
                this.allowOwnHomeDot(this.player);
            } else {
                this.startActiveDuplet(loc, 1);
                this.active.setTypeAndPlyValue(3, 2);
                this.setPresentDupletType(3);
                this.allowLegs(loc, this.active.activeSizes);
                this.allowSameLoc(loc);
            }
            if (QRules.isPosEdit) {
                this.allowAllOptions();
            }
        } else {
            byte knockedPieces;
            if (this.active.origLoc == loc) {
                if (this.active.plyValue == 1) {
                    this.bouncingDirectionUnit = 0;
                    this.active.fillOrigFields(loc, (byte)0);
                    this.active.setTypeAndPlyValue(5, 1);
                    this.setPresentDupletType(5);
                }
                if (this.active.plyValue == 2) {
                    this.active = new QDuplet();
                    this.setDoCropTrue();
                    this.turnLocCount -= 2;
                    this.allowOwnPlain(this.player);
                    if (this.hasPieces(this.homedot) && QuiRules.homePlacing) {
                        this.allowOwnHomeDot(this.player);
                    }
                }
            }
            if (this.active.dupletType == 1) {
                this.passFlag = -1;
            }
            this.noActiveLocation();
            this.deSelectAllPieces();
            this.active.fillDestField(loc);
            if (this.isBouncingLeg(loc)) {
                this.active.setBouncingStackActive();
            }
            this.activeList.add(this.active);
            if (this.active.dupletType == 6) {
                this.ordrdReleaseHandles.remove(0);
                if (this.ordrdReleaseHandles.size() > 0) {
                    int firstLoc = this.ordrdReleaseHandlesArray[0].destLoc;
                    byte firstSize = this.ordrdReleaseHandlesArray[0].activeSizes;
                    int i = 1;
                    while (i < this.ordrdReleaseHandlesArray.length) {
                        int nextLoc = this.ordrdReleaseHandlesArray[i].destLoc;
                        byte nextSize = this.ordrdReleaseHandlesArray[i].activeSizes;
                        if (firstLoc == nextLoc && firstSize == nextSize) {
                            this.ordrdReleaseHandles.remove(0);
                        }
                        ++i;
                    }
                }
                this.ordrdReleaseHandlesArray = this.ordrdReleaseHandles.toArray(new QDuplet[this.ordrdReleaseHandles.size()]);
            }
            if (((knockedPieces = this.extractKnockedPieces(this.active.activeSizes, this.stacks[loc])) & this.noKnockPieces[loc]) > 0) {
                System.out.println("IMMUNITY RULE BROKEN!");
                this.failedControlTest = true;
                this.controlPassInt += 4;
            }
            if (knockedPieces > 0) {
                byte oldBlacks = this.blackPieces[loc];
                if (QuiRules.immunity) {
                    int blackKnockers = knockedPieces & this.blackPieces[this.active.origLoc];
                    int knockedBlacks = knockedPieces & this.blackPieces[loc];
                    int immuneKnockers = blackKnockers ^ knockedBlacks;
                    this.noKnockPieces[loc] = (byte)(this.noKnockPieces[loc] | immuneKnockers);
                    this.noKnockPiecesToBe[loc] = (byte)(this.noKnockPiecesToBe[loc] | immuneKnockers);
                }
                byte k = 16;
                while (k > 0) {
                    if (this.isPresent(k, knockedPieces)) {
                        this.active = new QDuplet();
                        int colour = this.pieceColour(k, oldBlacks);
                        int destination = this.destinationLocKnocking(k, colour);
                        this.active.fillOrigFields(loc, k);
                        this.active.setTypeAndPlyValue(4, 0);
                        this.active.fillDestField(destination);
                        this.activeList.add(0, this.active);
                    }
                    k = (byte)(k / 2);
                }
            }
            this.performDupletList(this.activeList);
            this.active = new QDuplet();
            this.activeList = new ArrayList();
            this.evaluatePosition(loc);
        }
    }

    public void winStop() {
        this.zeroPlyDestination = 0;
        this.ReleaseHandles = new ArrayList();
        this.ordrdReleaseHandles = new ArrayList();
        this.ordrdReleaseHandlesArray = new QDuplet[0];
        this.clearReleasedPieces();
        this.resetDuplets();
        this.resetAllowBooleans();
        this.doReleasing = false;
        this.pieceSelections = new byte[169];
        this.options = new boolean[169];
        this.noKnockPiecesToBe = new byte[169];
        this.noKnockPieces = new byte[169];
        this.immortalPieces = new byte[169];
    }

    public void evaluatePosition(int loc) {
        if (this.endOfLineTest()) {
            this.winStop();
            return;
        }
        byte newStack = this.stacks[loc];
        byte newBlacks = this.blackPieces[loc];
        switch (this.presentDupletType) {
            case 2: {
                if (this.hasPieces(this.homedot)) {
                    this.startActiveDuplet(this.homedot, 0);
                    this.active.setTypeAndPlyValue(2, 1);
                    this.setPresentDupletType(2);
                    this.allowEmptyPlacingDots(this.player);
                    break;
                }
                this.allowOwnPlain(this.player);
                break;
            }
            case 3: {
                byte sowers = this.sowingGroup(this.player, newStack, newBlacks);
                if (sowers > 0 || QuiRules.bouncing && this.bouncingDirectionUnit != 0) {
                    this.startActiveDuplet(loc, 2);
                    this.active.setTypeAndPlyValue(3, 1);
                    if (this.bouncingDirectionUnit != 0) {
                        byte ownPieces = this.allOwnPieces(this.player, newStack, newBlacks);
                        this.active.setBouncingStack(ownPieces);
                    }
                    this.setPresentDupletType(3);
                    this.allowLegs(loc, this.active.activeSizes);
                    this.allowSameLoc(loc);
                    break;
                }
            }
            case 5: {
                if (QRules.isPosEdit) {
                    loc = 0;
                    break;
                }
                if (QuiRules.winByMixingAllOwnSizes && this.mixingGameWinTest()) {
                    this.winStop();
                    return;
                }
                if (QuiRules.releasing) {
                    this.findReleased();
                }
            }
            case 6: {
                if (this.doReleasing) {
                    this.releasePieces();
                }
                if (this.doReleasing) break;
                boolean freePass = this.freedomTest();
                boolean IRPass = this.irreversibilityTest();
                if (freePass && IRPass && !this.failedControlTest) {
                    this.setConfirmedPlyCount();
                    this.confirmedLocPos = this.locString.length();
                    if (QuiRules.irreversibility) {
                        this.addToIRHistory();
                    }
                } else {
                    this.setFailedControlTest(true);
                    boolean restarting = false;
                    if (this.turnNumber < 3) {
                        restarting = true;
                    }
                    if (!restarting) break;
                    break;
                }
                this.switchTurns();
                break;
            }
        }
        if (QRules.isPosEdit) {
            if (this.hasPieces(loc)) {
                this.allowAllOptions();
            } else {
                this.allowAnyPieceAndPass(loc);
            }
        } else if (this.presentDupletType < 2) {
            this.allowOwnPlain(this.player);
            if (this.hasPieces(this.homedot) && QuiRules.homePlacing) {
                this.allowOwnHomeDot(this.player);
            }
            if (!QRules.isPosEdit && QuiRules.ledgePlacing) {
                this.checkLedge();
            }
        }
    }

    public void switchTurns() {
        if (QRules.isPosEdit) {
            this.switchPlayer();
        } else {
            this.newTurn();
            this.homedot = this.ownHomeDot(this.player);
        }
    }

    public void checkLedge() {
        int sizeMask = 1;
        int sizeOrd = 0;
        while (sizeOrd < QuiRules.numSizes) {
            int colour = 0;
            int c = 0;
            while (c < 2) {
                colour = (c + this.player + 1) % 2;
                int i = 6;
                while (i >= 0) {
                    int ledgeloc = QuiRules.ledges[this.player][i];
                    if (this.pieceIsAtLocation(sizeMask, colour, ledgeloc)) {
                        this.startActiveDuplet(ledgeloc, 0);
                        this.active.setTypeAndPlyValue(1, 1);
                        this.setPresentDupletType(1);
                        this.allowEmptyPlacingDots(this.player);
                        return;
                    }
                    --i;
                }
                ++c;
            }
            sizeMask *= 2;
            ++sizeOrd;
        }
    }

    public void findReleased() {
        int maxPotential = QuiRules.numSizes;
        this.ReleaseHandles = new ArrayList();
        int rloc = 0;
        while (rloc < 169) {
            if (this.hasMixedGroup(rloc) && this.isBlackDot(rloc)) {
                int dirMask = 1;
                byte mixedGroupSizes = this.stacks[rloc];
                int y = -1;
                while (y < 2) {
                    int x = -1;
                    while (x < 2) {
                        if (x == 0 && y == 0) {
                            x = 1;
                        }
                        int locDiff = x + y * 13;
                        int potential = maxPotential;
                        int evalLoc = rloc;
                        int stepCount = 0;
                        while (potential > 0) {
                            if (this.isBlockedDirection(dirMask, evalLoc)) break;
                            ++stepCount;
                            if (this.hasPieces(evalLoc += locDiff)) {
                                byte releasedPieces;
                                byte agent;
                                int agentHeight;
                                potential = 0;
                                if (!this.hasPlainGroup(evalLoc) || (agentHeight = this.countBits(agent = this.stacks[evalLoc])) < stepCount && QuiRules.leglimit || (releasedPieces = this.extractKnockedPieces(agent, mixedGroupSizes)) <= 0) continue;
                                this.addReleasedPiece(rloc, releasedPieces);
                                this.doReleasing = true;
                                int releasedHeight = this.countBits(releasedPieces);
                                int i = 0;
                                while (i < releasedHeight) {
                                    int releasedPiece = this.largestSize(releasedPieces);
                                    releasedPieces = this.removeFromByte((byte)releasedPiece, releasedPieces);
                                    QDuplet relHandle = new QDuplet();
                                    relHandle.fillOrigFields(evalLoc, (byte)releasedPiece);
                                    if (this.pieceIsAtLocation(releasedPiece, 0, rloc)) {
                                        relHandle.setReleasedPieceColour(0);
                                    } else {
                                        relHandle.setReleasedPieceColour(1);
                                    }
                                    relHandle.fillDestField(rloc);
                                    this.ReleaseHandles.add(relHandle);
                                    ++i;
                                }
                                continue;
                            }
                            if (!QuiRules.leglimit) continue;
                            --potential;
                        }
                        dirMask *= 2;
                        ++x;
                    }
                    ++y;
                }
            }
            ++rloc;
        }
        int releaseHandlesCount = this.ReleaseHandles.size();
        if (releaseHandlesCount > 0) {
            this.ordrdReleaseHandles = new ArrayList();
            int colour = 0;
            int fillIndex = 0;
            int c = 1;
            while (c < 3) {
                colour = (this.player + c) % 2;
                byte size = 1;
                while (size < 17) {
                    int i = 0;
                    while (i < releaseHandlesCount) {
                        QDuplet testDuplet = (QDuplet)this.ReleaseHandles.get(i);
                        if (testDuplet.activeSizes == size && testDuplet.colour == colour) {
                            this.ordrdReleaseHandles.add(fillIndex, this.ReleaseHandles.get(i));
                            ++fillIndex;
                        }
                        ++i;
                    }
                    size = (byte)(size * 2);
                }
                ++c;
            }
            this.ordrdReleaseHandlesArray = this.ordrdReleaseHandles.toArray(new QDuplet[releaseHandlesCount]);
        }
    }

    public void releasePieces() {
        this.doReleasing = false;
        this.zeroPlyDestination = 0;
        this.updateReleasedPieces();
        int colour = 0;
        int c = 1;
        while (c < 3) {
            colour = (this.player + c) % 2;
            byte size = 1;
            while (size < 17) {
                int rloc = 0;
                while (rloc < 169) {
                    if (this.pieceIsInReleasedPieces(size, colour, rloc)) {
                        this.active.fillOrigFields(rloc, size);
                        this.active.setTypeAndPlyValue(6, 0);
                        this.setPresentDupletType(6);
                        int destLoc = this.destinationLocReleasing(size, colour);
                        if (size == 8 && QuiRules.numSizes == 5) {
                            this.setGoldeRuleFlag(colour);
                        }
                        this.doReleasing = true;
                        this.selectSomePieces(rloc, size);
                        this.options = new boolean[169];
                        this.options[destLoc] = true;
                        this.zeroPlyDestination = destLoc;
                        return;
                    }
                    ++rloc;
                }
                size = (byte)(size * 2);
            }
            ++c;
        }
    }

    public void startActiveDuplet(int loc, int selectionType) {
        byte newStack = this.stacks[loc];
        byte newBlacks = this.blackPieces[loc];
        this.selectUserSquare(loc);
        this.deSelectAllPieces();
        switch (selectionType) {
            case 0: {
                byte largest = (byte)this.largestSize(newStack);
                this.selectSomePieces(loc, largest);
                break;
            }
            case 1: {
                byte ownPieces = this.allOwnPieces(this.player, newStack, newBlacks);
                this.selectSomePieces(loc, ownPieces);
                break;
            }
            case 2: {
                byte sowers = this.sowingGroup(this.player, newStack, newBlacks);
                this.selectSomePieces(loc, sowers);
            }
        }
        this.active.fillOrigFields(loc, this.pieceSelections[loc]);
    }

    public boolean isValidEntry(int loc) {
        boolean result = false;
        if (loc > 168) {
            int[] validOffBoardLoc = new int[]{972, 973, 988, 1001};
            ArrayList<Integer> vobl = QRules.validOffBoardLocs;
            for (int validLoc : vobl) {
                if (loc != validLoc) continue;
                result = true;
            }
        } else if (this.options[loc] || this.disObeyOptions) {
            result = true;
        } else {
            this.hasIllegalPlies = true;
        }
        return result;
    }

    public int destinationLocKnocking(int pieceSize, int pieceColour) {
        int tryLoc = 0;
        int i = 0;
        while (i < 7) {
            int pathIndex = this.pathIndex(this.player, pieceColour);
            tryLoc = QuiRules.knockingPaths[pathIndex][i];
            byte oldContent = this.stacks[tryLoc];
            if (!this.isPresent(pieceSize, oldContent)) break;
            ++i;
        }
        return tryLoc;
    }

    public int destinationLocReleasing(int pieceSize, int pieceColour) {
        int tryLoc = 0;
        int i = 0;
        while (i < 7) {
            int pathIndex = this.pathIndex(this.player, pieceColour);
            tryLoc = QuiRules.releasingPaths[pathIndex][i];
            byte oldContent = this.stacks[tryLoc];
            if (!this.isPresent(pieceSize, oldContent)) {
                this.zeroPlyDestIndex = i;
                break;
            }
            ++i;
        }
        return tryLoc;
    }

    public void resetDuplets() {
        this.active = new QDuplet();
        this.activeList = new ArrayList();
    }

    public void allowAllOptions() {
        int i = 0;
        while (i < 169) {
            if (this.isPosEditLoc(i)) {
                this.options[i] = true;
            }
            ++i;
        }
    }

    public void allowSameLoc(int loc) {
        this.options[loc] = true;
    }

    public void allowOwnPlain(int activePlayer) {
        this.options = new boolean[169];
        this.resetAllowBooleans();
        this.mayMove = true;
        if (QuiRules.allowPass) {
            this.options[84] = true;
            this.mayPass = true;
        }
        if (activePlayer == 0) {
            int i = 0;
            while (i < 169) {
                if (this.isBlackDot(i) && this.hasPlainWhite(i)) {
                    this.options[i] = true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 169) {
                if (this.isBlackDot(i) && this.hasPlainBlack(i)) {
                    this.options[i] = true;
                }
                ++i;
            }
        }
    }

    public void allowAnyPieceAndPass(int loc) {
        this.options = new boolean[169];
        int i = 0;
        while (i < 169) {
            if (this.hasPieces(i)) {
                this.options[i] = true;
            }
            ++i;
        }
        if (QuiRules.allowPass) {
            this.options[84] = true;
        }
    }

    public void allowLegs(int loc, byte movingStack) {
        this.options = new boolean[169];
        if (QRules.isPosEdit) {
            return;
        }
        this.resetAllowBooleans();
        this.isMoving = true;
        int height = this.countBits(movingStack);
        int dirMask = 1;
        int legCount = 0;
        int y = -1;
        while (y < 2) {
            int x = -1;
            while (x < 2) {
                if (x == 0 && y == 0) {
                    x = 1;
                }
                int locDiff = x + y * 13;
                int potential = height;
                int evalLoc = loc;
                if (QuiRules.bouncing && locDiff == this.bouncingDirectionUnit) {
                    ++potential;
                }
                while (potential > 0) {
                    if (this.isBlockedDirection(dirMask, evalLoc)) break;
                    this.options[evalLoc += locDiff] = true;
                    ++legCount;
                    if (this.hasPieces(evalLoc)) {
                        potential = 0;
                        continue;
                    }
                    if (!QuiRules.leglimit) continue;
                    --potential;
                }
                dirMask *= 2;
                ++x;
            }
            ++y;
        }
    }

    public void allowEmptyPlacingDots(int activePlayer) {
        int[] fullPlacingArea = QuiRules.placingAreas[activePlayer];
        int lenght = fullPlacingArea.length;
        this.options = new boolean[169];
        this.resetAllowBooleans();
        if (QuiRules.boardValues[this.activeLocation] == 5) {
            this.mayPlaceHome = true;
        } else {
            this.mayPlaceLedge = true;
        }
        int i = 0;
        while (i < lenght) {
            int optionLoc = fullPlacingArea[i];
            if (!this.hasPieces(optionLoc)) {
                this.options[optionLoc] = true;
            }
            ++i;
        }
    }

    public void allowOwnHomeDot(int activePlayer) {
        this.options[this.ownHomeDot((int)activePlayer)] = true;
        this.mayPlaceHome = true;
    }

    public void setFailedControlTest(boolean failedControlTest) {
        this.failedControlTest = failedControlTest;
    }

    public void setConfirmedPlyCount() {
        this.confirmedPlyCount = this.getPlyPos();
    }

    public String getConfirmedLocString() {
        return this.locString.substring(0, this.confirmedLocPos);
    }

    public void setControlStatusText(String controlStatusText) {
        this.controlStatusText = controlStatusText;
    }

    public void setInitialRetrace(boolean initialRetrace) {
        this.initialRetrace = initialRetrace;
    }

    public void setBuildLocString(boolean buildLocString) {
        this.buildLocString = buildLocString;
    }

    public int pathIndex(int actPlayer, int ColourInt) {
        int pIndex = actPlayer * 2 + ColourInt;
        return pIndex;
    }

    public int smallestSizeInPlay(int numSizes) {
        int value = 1;
        int k = 1;
        while (k < numSizes) {
            value *= 2;
            ++k;
        }
        return value;
    }

    public byte calcTowerByte(int nSizes) {
        byte tByte = 0;
        int mask = 1;
        int i = 0;
        while (i < nSizes) {
            tByte = (byte)(tByte + mask);
            mask *= 2;
            ++i;
        }
        return tByte;
    }

    public int countBits(byte B) {
        int bCounter = 0;
        int m = 1;
        while (m < 17) {
            if ((B & m) != 0) {
                ++bCounter;
            }
            m *= 2;
        }
        return bCounter;
    }

    public int orderInStack(int size, byte B) {
        int ordinalNumber = 0;
        int bCounter = 0;
        int m = 1;
        while (m < 17) {
            if ((B & m) != 0) {
                ++ordinalNumber;
                ++bCounter;
                if (size == m) break;
            }
            m *= 2;
        }
        return ordinalNumber;
    }

    public boolean isEmpty(byte P) {
        boolean empty = false;
        if (P == 0) {
            empty = true;
        }
        return empty;
    }

    public boolean isWhite(byte P, byte C) {
        boolean white = false;
        if (P != 0 && C == 0) {
            white = true;
        }
        return white;
    }

    public boolean isBlack(byte P, byte C) {
        boolean black = false;
        if (P != 0 && C == P) {
            black = true;
        }
        return black;
    }

    public boolean isMixed(byte P, byte C) {
        boolean mixed = false;
        if (C > 0 && C != P) {
            mixed = true;
        }
        return mixed;
    }

    public boolean isPlain(byte P, byte C) {
        boolean plain = false;
        if (P > 0 && (C == 0 || C == P)) {
            plain = true;
        }
        return plain;
    }

    public boolean isPresent(int mask, byte P) {
        boolean presence = false;
        if ((mask & P) != 0) {
            presence = true;
        }
        return presence;
    }

    public boolean pieceIsPresent(int size, int colour, byte stack, byte blacks) {
        return this.isPresent(size, stack) && this.isPresent(colour * size, blacks);
    }

    public boolean pieceIsWhite(int mask, byte C) {
        boolean white = false;
        if ((mask & C) == 0) {
            white = true;
        }
        return white;
    }

    public boolean pieceIsBlack(int mask, byte C) {
        boolean black = false;
        if ((mask & C) != 0) {
            black = true;
        }
        return black;
    }

    public boolean pieceIsSelected(int mask, byte P) {
        boolean selection = false;
        if ((mask & P) != 0) {
            selection = true;
        }
        return selection;
    }

    public int pieceColour(byte size, byte blacks) {
        int colour = 0;
        if ((size & blacks) != 0) {
            colour = 1;
        }
        return colour;
    }

    public byte joinGroups(byte GroupA, byte GroupB) {
        byte resultingGroup = (byte)(GroupA | GroupB);
        return resultingGroup;
    }

    public byte removeFromByte(byte movingPieces, byte originalStack) {
        byte resultingGroup = (byte)(movingPieces ^ originalStack);
        return resultingGroup;
    }

    public byte removeBlacks(byte movingPieces, byte originalBlacks) {
        byte resultingBlacks = (byte)(movingPieces ^ originalBlacks);
        return resultingBlacks;
    }

    public byte extractKnockedPieces(byte knockingPieces, byte oldPieces) {
        byte knockedPieces = (byte)(knockingPieces & oldPieces);
        return knockedPieces;
    }

    public byte sowingGroup(int activePlayer, byte P, byte C) {
        if (QuiRules.shortMove && this.isMixed(P, C)) {
            return 0;
        }
        byte sGroup = 0;
        boolean isBottom = true;
        byte k = 1;
        while (k < 17) {
            if ((k & P) != 0 && (k & C) == k * activePlayer) {
                if (isBottom) {
                    isBottom = false;
                } else {
                    sGroup = this.joinGroups(k, sGroup);
                }
            }
            k = (byte)(k * 2);
        }
        return sGroup;
    }

    public byte allOwnPieces(int activePlayer, byte P, byte C) {
        byte pGroup = 0;
        byte k = 1;
        while (k < 17) {
            if ((k & P) != 0 && (k & C) == k * activePlayer) {
                pGroup = this.joinGroups(k, pGroup);
            }
            k = (byte)(k * 2);
        }
        return pGroup;
    }

    public int largestSize(byte B) {
        int mask = 1;
        int k = 0;
        while (k < 5) {
            if ((B & mask) != 0) break;
            mask *= 2;
            ++k;
        }
        return mask;
    }

    public int yAdjustFactor(int size, byte groupByte) {
        int factor = 0;
        int bCounter = 0;
        int internalOrder = 0;
        int m = 1;
        while (m < 17) {
            if ((groupByte & m) != 0) {
                ++bCounter;
            }
            if (size == m) {
                internalOrder = bCounter;
            }
            m *= 2;
        }
        factor = bCounter - 2 * internalOrder;
        return factor;
    }

    public int xAdjustFactor(int sizeMask, int numSizes) {
        int number = 5;
        if (numSizes == 3) {
            int k = 1;
            while (k < 5) {
                if (sizeMask != k) {
                    number -= 2;
                    k *= 2;
                    continue;
                }
                break;
            }
        } else {
            int k = 1;
            while (k < 17) {
                if (sizeMask != k) {
                    --number;
                    k *= 2;
                    continue;
                }
                break;
            }
        }
        return number;
    }

    public boolean isBlockedDirection(int dirMask, int loc) {
        int boardValue = QuiRules.boardValues[loc];
        boolean result = false;
        if ((dirMask & boardValue) == 0) {
            result = true;
        }
        return result;
    }

    public boolean isFrame(int loc) {
        boolean result = false;
        if (QuiRules.boardValues[loc] < 5 || QuiRules.boardValues[loc] == 64) {
            result = true;
        }
        return result;
    }

    public boolean isDot(int loc) {
        boolean result = false;
        if (QuiRules.boardValues[loc] > 4) {
            result = true;
        }
        return result;
    }

    public boolean isDotOrLedge(int loc) {
        boolean result = false;
        if (QuiRules.boardValues[loc] > 2 && QuiRules.boardValues[loc] != 64) {
            result = true;
        }
        return result;
    }

    public boolean isLedge(int loc) {
        boolean result = false;
        if (QuiRules.boardValues[loc] == 3 || QuiRules.boardValues[loc] == 4) {
            result = true;
        }
        return result;
    }

    public boolean isPosEditLoc(int loc) {
        boolean result = false;
        if (QuiRules.boardValues[loc] > 0) {
            result = true;
        }
        return result;
    }

    public boolean isBlackDot(int loc) {
        boolean result = false;
        if (QuiRules.boardValues[loc] > 6 && QuiRules.boardValues[loc] != 64) {
            result = true;
        }
        return result;
    }

    public boolean isWhiteDot(int loc) {
        boolean result = false;
        if ((QuiRules.boardValues[loc] == 5 || QuiRules.boardValues[loc] == 6) && QuiRules.boardValues[loc] != 64) {
            result = true;
        }
        return result;
    }

    public boolean isReleasingDot(int loc) {
        boolean result = false;
        if (QuiRules.boardValues[loc] == 6) {
            result = true;
        }
        return result;
    }

    public boolean isHomeDot(int loc) {
        boolean result = false;
        if (QuiRules.boardValues[loc] == 5) {
            result = true;
        }
        return result;
    }

    public int ownHomeDot(int activePlayer) {
        return 97 - activePlayer * 26;
    }

    public int directionUnit(int loc0, int loc1) {
        int sign = 1;
        int unit = 1;
        int leg = loc1 - loc0;
        if (leg == 0) {
            return 0;
        }
        if (leg < 0) {
            sign = -1;
            leg = -leg;
        }
        int d = 12;
        while (d < 15) {
            if (leg % d == 0) {
                unit = d;
            }
            ++d;
        }
        return unit * sign;
    }

    public boolean isBouncingLeg(int loc2) {
        if (this.bouncingDirectionUnit == 0) {
            return false;
        }
        if (loc2 - this.bouncingOrigin == 0) {
            return false;
        }
        int unit1 = this.directionUnit(this.bouncingOrigin, loc2);
        return unit1 == this.bouncingDirectionUnit;
    }

    public int bouncingDirection(int loc0, int loc1) {
        int unit0 = this.directionUnit(loc0, loc1);
        int unit1 = 0;
        int lineDotValue = QuiRules.boardValues[loc1];
        switch (lineDotValue) {
            case 22: 
            case 151: {
                if (unit0 == 12) {
                    unit1 = -12;
                }
                if (unit0 == -1) {
                    unit1 = -13;
                }
                if (unit0 != 13) break;
                unit1 = 1;
                break;
            }
            case 7: 
            case 31: {
                if (unit0 == 13) {
                    unit1 = -13;
                }
                if (unit0 == 14) {
                    unit1 = -12;
                }
                if (unit0 != 12) break;
                unit1 = -14;
                break;
            }
            case 11: 
            case 47: {
                if (unit0 == 14) {
                    unit1 = -14;
                }
                if (unit0 == 1) {
                    unit1 = -13;
                }
                if (unit0 != 13) break;
                unit1 = -1;
                break;
            }
            case 41: 
            case 107: {
                if (unit0 == 1) {
                    unit1 = -1;
                }
                if (unit0 == 14) {
                    unit1 = 12;
                }
                if (unit0 != -12) break;
                unit1 = -14;
                break;
            }
            case 104: 
            case 233: {
                if (unit0 == -12) {
                    unit1 = 12;
                }
                if (unit0 == 1) {
                    unit1 = 13;
                }
                if (unit0 != -13) break;
                unit1 = -1;
                break;
            }
            case 224: 
            case 248: {
                if (unit0 == -13) {
                    unit1 = 13;
                }
                if (unit0 == -14) {
                    unit1 = 12;
                }
                if (unit0 != -12) break;
                unit1 = 14;
                break;
            }
            case 208: 
            case 244: {
                if (unit0 == -14) {
                    unit1 = 14;
                }
                if (unit0 == -1) {
                    unit1 = 13;
                }
                if (unit0 != -13) break;
                unit1 = 1;
                break;
            }
            case 148: 
            case 214: {
                if (unit0 == -1) {
                    unit1 = 1;
                }
                if (unit0 == 12) {
                    unit1 = 14;
                }
                if (unit0 != -14) break;
                unit1 = -12;
                break;
            }
        }
        return unit1;
    }

    public void setBouncingDirectionUnit(int bouncingDirectionUnit) {
        this.bouncingDirectionUnit = bouncingDirectionUnit;
    }

    public void setBouncingOrigin(int bouncingOrigin) {
        this.bouncingOrigin = bouncingOrigin;
    }

    public void setHasBeenRewound(boolean hasBeenRewound) {
        this.hasBeenRewound = hasBeenRewound;
    }
}

