/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.gamequincala;

import com.quincala.core.QGameLine;
import com.quincala.core.QGameSpace;
import com.quincala.core.QGameStatus;
import com.quincala.core.QPlyPosition;
import com.quincala.core.QRules;
import com.quincala.core.QSFUtils;
import com.quincala.gamequincala.QuiGameState;
import com.quincala.gamequincala.QuiGameStatus;
import com.quincala.gamequincala.QuiGraphics;
import com.quincala.gamequincala.QuiRules;

public class QuiGameSpace
extends QGameSpace {
    public boolean doConstruction = false;
    int versionInt = -1;
    int variantInt = -1;
    QuiGameState currentState = new QuiGameState();
    QuiGameState legalCheckState;
    QuiGameState stateAhead;

    public static void main(String[] args) {
    }

    public void initGameSpace(String args) {
        System.out.println();
        System.out.println("INIT GAMESPACE");
        if (args.equals("")) {
            this.receiveSpaceQuString("quiKM");
            this.receiveSpaceQuString("Quincala;KM");
        } else {
            this.receiveSpaceQuString(args);
        }
        currentLine.setWholeLineData(this.currentState.getWholeLineData());
    }

    public void setDoConstructionTrue() {
        this.doConstruction = true;
    }

    @Override
    public synchronized String[] getQuString(String quStringFormat) {
        String markedPlyString;
        boolean brake = this.currentState.zeroPlyDestination > 0;
        String[] quStringreturn = new String[]{"", "A QSF String has been copied to the clipboard."};
        if (quStringFormat.equals("0.6")) {
            quStringreturn[0] = this.currentState.getLineString();
            return quStringreturn;
        }
        if (quStringFormat.equals("title")) {
            quStringreturn[0] = currentLine.getTitle();
            return quStringreturn;
        }
        if (quStringFormat.equals("restart")) {
            quStringreturn[0] = QRules.getGameStringHead();
            return quStringreturn;
        }
        if (quStringFormat.equals("score")) {
            quStringreturn[0] = QRules.getGameStringHead();
            markedPlyString = QuiGameSpace.currentLine.purePlyString;
            quStringreturn[0] = String.valueOf(quStringreturn[0]) + ";" + markedPlyString;
        } else if (quStringFormat.equals("@")) {
            if (QuiGameSpace.currentLine.isLoadEndTurnOpen) {
                int turns = QuiGameSpace.currentLine.getWholeLineData().TurnsInLine;
                int loadedTurns = QuiGameSpace.currentLine.loadEndTurnNo;
                if (turns > loadedTurns) {
                    // empty if block
                }
                quStringreturn[0] = String.valueOf(quStringreturn[0]) + "&copymode=@";
                String titleStringCorrespond = currentLine.getTitle();
                if (titleStringCorrespond.length() > 0) {
                    quStringreturn[0] = String.valueOf(quStringreturn[0]) + "&title=" + titleStringCorrespond;
                }
            } else {
                quStringreturn[1] = "Warning: previously loaded QuString did not end at the beginning of the turn - NO QuString has been put to the clipboard!";
            }
        } else if (quStringFormat.equals("posNo")) {
            quStringreturn[0] = QRules.getGameStringHead();
            markedPlyString = currentLine.getPosStringNoFuture(brake);
            quStringreturn[0] = String.valueOf(quStringreturn[0]) + ";" + markedPlyString;
        }
        if (quStringFormat.equals("posYes")) {
            quStringreturn[0] = QRules.getGameStringHead();
            markedPlyString = currentLine.getPosStringWithFuture(brake);
            quStringreturn[0] = String.valueOf(quStringreturn[0]) + ";" + markedPlyString;
        }
        if (quStringFormat.equals("purePos")) {
            quStringreturn[0] = this.currentState.getSimplePositionString();
        }
        quStringreturn[0] = String.valueOf(quStringreturn[0]) + ";" + QuiRules.baseLineToUse + "." + QuiRules.incrementToUse;
        String titleString = currentLine.getTitle();
        if (titleString.length() > 0) {
            titleString = QSFUtils.encodeValue(titleString, false);
            quStringreturn[0] = String.valueOf(quStringreturn[0]) + "&title=" + titleString;
        }
        return quStringreturn;
    }

    protected void receiveEntry(int loc) {
        if (!this.currentState.isValidEntry(loc)) {
            return;
        }
        String locStringlet = QSFUtils.locToHexCharString(loc);
        if (!currentLine.forwardStepAvailable()) {
            if (QuiGameSpace.currentLine.isSealed) {
                this.makeNewBranch(locStringlet, loc);
            }
            this.stepForward(locStringlet, loc);
        } else if (currentLine.getStepLocString(1).equals(locStringlet)) {
            this.receiveCDButtonClick(6);
        } else if (currentLine.backStepAvailable() || !QuiGameSpace.currentLine.isSealed) {
            this.makeNewBranch(locStringlet, loc);
            this.stepForward(locStringlet, loc);
        } else {
            currentLine = new QGameLine();
            this.reloadCurrentState();
            this.stepForward(locStringlet, loc);
        }
        if (this.isIFRBreakAhead()) {
            this.rewindTurn();
        }
        boolean cfr_ignored_0 = this.currentState.isWin;
        this.stringReport();
    }

    public void makeNewBranch(String locStringlet, int loc) {
        String setUpString = QuiGameSpace.currentLine.setUpString;
        String title = currentLine.getTitle();
        int BranchNo = QuiGameSpace.currentLine.branchNo;
        boolean newLineIsBranch = false;
        String plyString = "";
        if (QuiGameSpace.currentLine.isSealed) {
            newLineIsBranch = true;
            plyString = this.currentState.plyString;
            if (plyString.length() > 0) {
                plyString = String.valueOf(plyString) + "x";
            } else {
                System.out.println("PROGRAMMING ERROR: space.makenewBranch is reached from starting position!");
            }
        } else {
            plyString = currentLine.getMarkedStem();
        }
        currentLine = new QGameLine();
        currentLine.setSetUpString(setUpString);
        currentLine.addToMarkedPlyString(plyString);
        currentLine.setLocString(this.currentState.locString);
        currentLine.setLocPos(this.currentState.getLocPos());
        if (title.length() > 0) {
            currentLine.setLineTitle(title);
            currentLine.setBranchNo(BranchNo);
        }
        currentLine.setAddBranchToMatchInfo(newLineIsBranch);
    }

    private void gotoTurn(int goalTurnInt) {
        int maxTurn = QuiGameSpace.currentLine.lineData.turnsOpened;
        if (goalTurnInt > maxTurn || goalTurnInt < 1) {
            return;
        }
        int currentTurn = this.currentState.turnNumber;
        if (goalTurnInt <= currentTurn) {
            this.reloadCurrentState();
            currentLine.setLocPos(0);
        }
        while (this.currentState.turnNumber < goalTurnInt) {
            this.receiveCDButtonClick(6);
        }
        this.stringReport();
    }

    public void stepForward(String locStringlet, int loc) {
        currentLine.addToLocPos(1);
        if (this.currentState.zeroPlyDestination <= 0) {
            currentLine.addToMarkedPlyString(locStringlet);
        }
        this.currentState.receiveLoc(loc);
        currentLine.setPlyPos(this.currentState.getPlyPos());
        currentLine.setLocString(this.currentState.locString);
        currentLine.setLocPos(this.currentState.getLocPos());
        this.cropCheck();
        currentLine.setWholeLineData(this.currentState.getWholeLineData());
    }

    public void cropCheck() {
        if (this.currentState.fetchDoCrop() && this.versionInt > 0) {
            currentLine.cropFourOffMarkedPlyString(this.currentState.getPlyPos());
            this.currentState.cropFourChars();
            currentLine.setPlyPos(this.currentState.getPlyPos());
            currentLine.setLocString(this.currentState.locString);
            currentLine.setLocPos(this.currentState.getLocPos());
        }
    }

    public void rewindTurn() {
        currentLine.setLastPlyIsIllegal(true);
        String offendingLocString = this.stateAhead.locString;
        String confirmedLocString = this.stateAhead.getConfirmedLocString();
        System.out.println("confirmedLocString is " + confirmedLocString);
        currentLine.capMarkedPlyString(this.stateAhead.getPlyPos());
        currentLine.setWholeLineData(this.stateAhead.getWholeLineData());
        QuiGameSpace.currentLine.lineData.setControlPassInt(this.stateAhead.controlPassInt);
        this.receiveSetUpString(QuiGameSpace.currentLine.setUpString);
        this.currentState.receiveLocString(confirmedLocString);
        currentLine.setLocPos(this.currentState.confirmedLocPos);
        currentLine.setPlyPos(this.currentState.getPlyPos());
        currentLine.setLocString(offendingLocString);
        this.currentState.setControlStatusText(" The entire turn is back-traced to enable re-play!");
        this.currentState.setHasBeenRewound(true);
        this.stringReport();
    }

    @Override
    protected void receiveCDButtonClick(int cdButtonNo) {
        switch (cdButtonNo) {
            default: {
                System.out.println("QSF Error: navigation value is not defined: " + cdButtonNo);
                return;
            }
            case 2: {
                boolean lastIsZeroPly = this.currentState.lastPlyValue == 0;
                QPlyPosition prevPosition = currentLine.getPreviousMarkerPlyPos(lastIsZeroPly);
                int markerIndex = prevPosition.plyPosInt;
                this.reloadCurrentState();
                this.receivePlyPosition(prevPosition);
                currentLine.setPlyPos(markerIndex);
                currentLine.setLocPos(this.currentState.getLocPos());
                break;
            }
            case 3: {
                this.reloadCurrentState();
                this.currentState.receiveLocString(currentLine.getStepLocString(-1));
                currentLine.addToLocPos(-1);
                currentLine.setPlyPos(this.currentState.getPlyPos());
                break;
            }
            case 6: {
                if (currentLine.forwardStepAvailable()) {
                    this.currentState.receiveLocString(currentLine.getStepLocString(1));
                    currentLine.setPlyPos(this.currentState.getPlyPos());
                } else if (this.currentState.zeroPlyDestination > 0) {
                    this.currentState.receiveLoc(this.currentState.zeroPlyDestination);
                    currentLine.setLocString(this.currentState.locString);
                }
                currentLine.setLocPos(this.currentState.getLocPos());
                break;
            }
            case 7: {
                if (this.currentState.zeroPlyDestination == 0) {
                    QPlyPosition nextPosition = currentLine.getNextMarkerPlyPos();
                    int nextMarkerIndex = nextPosition.plyPosInt;
                    this.reloadCurrentState();
                    this.receivePlyPosition(nextPosition);
                    currentLine.setPlyPos(nextMarkerIndex);
                    currentLine.setLocPos(this.currentState.getLocPos());
                } else {
                    this.receivePurePlyString("", false);
                }
                currentLine.setPlyPos(this.currentState.getPlyPos());
                if (!currentLine.forwardStepAvailable()) {
                    currentLine.setLocString(this.currentState.locString);
                }
                currentLine.setLocPos(this.currentState.getLocPos());
            }
        }
        if (this.isIFRBreakAhead()) {
            this.rewindTurn();
        }
        this.stringReport();
    }

    @Override
    public synchronized void receiveSpaceQuString(String quString) {
        if (!QSFUtils.is2009QuString(quString)) {
            if (QSFUtils.isKeyValueString(quString)) {
                String key = QSFUtils.getKey(quString);
                String value = QSFUtils.getValue(quString);
                if (key.equalsIgnoreCase("loc")) {
                    int loc = -1;
                    try {
                        loc = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error: space.receiveString/loc value is not an integer!");
                    }
                    this.receiveEntry(loc);
                    return;
                }
                if (key.equalsIgnoreCase("goto")) {
                    int turnInt = -1;
                    try {
                        turnInt = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error: space.receiveString/goto value is not an integer!");
                    }
                    this.gotoTurn(turnInt);
                    return;
                }
                if (key.equalsIgnoreCase("nav")) {
                    int navActionInt = -1;
                    try {
                        navActionInt = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error: space.receiveString/nav value is not an integer!");
                    }
                    this.receiveCDButtonClick(navActionInt);
                    return;
                }
                if (key.equalsIgnoreCase("ply")) {
                    int plyLoc = QSFUtils.getAsciiInt(value);
                    if (plyLoc > -1) {
                        this.receiveEntry(plyLoc);
                    }
                    return;
                }
            } else if (QSFUtils.isValidGameString(quString)) {
                String[] s = quString.split(";");
                if (s.length > 0) {
                    if (s[0].equalsIgnoreCase("qui")) {
                        s[0] = "Quincala";
                    }
                    QRules.setGameHead(s[0]);
                }
                if (s.length > 1 && QSFUtils.isValidEnvironmentString(s[0], s[1])) {
                    QRules.setEnvironmentString(s[1]);
                }
            }
        } else {
            char nose = quString.charAt(0);
            if (nose == '~') {
                String tildeHead3 = quString.substring(1, 4);
                String tildeHead4 = quString.substring(1, 5);
                String tildeBody3 = quString.substring(4);
                String tildeBody4 = quString.substring(5);
                if (tildeHead4.equalsIgnoreCase("goto")) {
                    tildeBody4 = tildeBody4.trim();
                    System.out.println("space.tildeBody is " + tildeBody4);
                    int turnInt = Integer.parseInt(tildeBody4);
                    this.gotoTurn(turnInt);
                }
                if (tildeHead3.equalsIgnoreCase("ply")) {
                    tildeBody3 = tildeBody3.trim();
                    System.out.println("tildeBody3 is " + tildeBody3);
                    int plyLoc = QSFUtils.getAsciiInt(tildeBody3);
                    this.receiveEntry(plyLoc);
                }
                return;
            }
            this.currentState.setInitialRetrace(false);
            currentLine = new QGameLine();
            String quStringHead = quString.substring(0, 3);
            String setUpString = "";
            String markedPlyString = "";
            int quStringLength = quString.length();
            if (quStringHead.equalsIgnoreCase("qui")) {
                if (quStringLength > 5) {
                    setUpString = quString.substring(0, 5);
                    markedPlyString = quString.substring(5);
                    currentLine.setSetUpString(setUpString);
                    currentLine.setMarkedPlyString(markedPlyString);
                    this.receiveSetUpString(QuiGameSpace.currentLine.setUpString);
                    this.receivePurePlyString(currentLine.getPurePlyString(), false);
                    if (!this.currentState.hasBeenRewound) {
                        currentLine.setWholeLineData(this.currentState.getWholeLineData());
                    }
                    currentLine.setLoadEndPlyPos(this.currentState.getPlyPos());
                    currentLine.setLoadEndTurnNo(this.currentState.turnNumber);
                    currentLine.setLoadEndTurnOpen(this.currentState.turnLocCount == 0);
                    if (!this.currentState.hasBeenRewound) {
                        currentLine.setLocString(this.currentState.locString);
                    }
                    currentLine.setWholeLineData(this.currentState.getWholeLineData());
                    this.currentState.setBuildLocString(false);
                    this.receiveSetUpString(QuiGameSpace.currentLine.setUpString);
                    this.receivePlyPosition(QuiGameSpace.currentLine.xPosition);
                    currentLine.setLocPos(this.currentState.getLocPos());
                } else {
                    setUpString = quString;
                    currentLine = new QGameLine();
                    currentLine.setSetUpString(setUpString);
                    this.receiveSetUpString(QuiGameSpace.currentLine.setUpString);
                    currentLine.setWholeLineData(this.currentState.getWholeLineData());
                }
            }
            if (quStringHead.equalsIgnoreCase("loc")) {
                String locString = quString.substring(4).toLowerCase();
                this.currentState.receiveLocString(locString);
            }
            if (quStringHead.equalsIgnoreCase("qup")) {
                String simplePString = quString.substring(3);
                this.currentState.setPositionFromString(simplePString);
            }
        }
        this.stringReport();
    }

    public void reloadCurrentState() {
        this.currentState = new QuiGameState();
        this.currentState.initGameState();
    }

    @Override
    protected void receiveSetUpString(String quSetUpString) {
        int quStringHeadLength = quSetUpString.length();
        if (quStringHeadLength < 5) {
            return;
        }
        int firstNo = 3;
        int secondNo = 5;
        if (quStringHeadLength > 3) {
            char firstChar = quSetUpString.charAt(3);
            firstNo = QSFUtils.getAsciiInt("" + firstChar);
        }
        if (quStringHeadLength < 5) {
            switch (firstNo) {
                case 1: 
                case 5: {
                    secondNo = 3;
                    break;
                }
            }
        } else {
            char secondChar = quSetUpString.charAt(4);
            secondNo = QSFUtils.getAsciiInt("" + secondChar);
        }
        if (secondNo >= 2) {
            this.currentState = new QuiGameState();
            if (firstNo != this.versionInt || secondNo != this.variantInt) {
                System.out.println("resetting rules!");
                this.versionInt = firstNo;
                QuiRules.setRuleParameters(firstNo);
                this.variantInt = secondNo;
                QuiRules.setSizeParameters(secondNo);
            }
            this.currentState.initGameState();
            QuiGraphics.setNumberOfSizes(QuiRules.numSizes);
            System.out.println("presentRuleVersion is " + QuiRules.ruleVersion);
        }
    }

    public void receivePlyPosition(QPlyPosition plypos) {
        this.receivePurePlyString(plypos.purePlyString, plypos.zeroplyBrake);
    }

    public void receivePurePlyString(String plyPureString) {
        this.receivePurePlyString(plyPureString, false);
    }

    public void receivePurePlyString(String plyPureString, boolean brake) {
        int length = plyPureString.length();
        int[] plyArray = new int[length / 2];
        int i = 0;
        while (i < length / 2) {
            char hexChar1 = plyPureString.charAt(i * 2);
            char hexChar2 = plyPureString.charAt(i * 2 + 1);
            plyArray[i] = QSFUtils.hexCharsToLoc(hexChar1, hexChar2);
            ++i;
        }
        this.receivePlyArray(plyArray, brake);
    }

    public void receivePlyArray(int[] p) {
        this.receivePlyArray(p, false);
    }

    public void receivePlyArray(int[] p, boolean brake) {
        int length = p.length;
        while (this.currentState.zeroPlyDestination > 0) {
            this.currentState.receiveLoc(this.currentState.zeroPlyDestination);
        }
        int i = 0;
        while (i < length) {
            this.currentState.receiveLoc(p[i]);
            this.cropCheck();
            if (i < length - 1 || !brake || this.currentState.buildLocString) {
                while (this.currentState.zeroPlyDestination > 0) {
                    this.currentState.receiveLoc(this.currentState.zeroPlyDestination);
                }
            }
            if (this.isIFRBreakAhead()) {
                this.rewindTurn();
                break;
            }
            ++i;
        }
    }

    public boolean isIFRBreakAhead() {
        this.stateAhead = new QuiGameState();
        this.stateAhead.initGameState();
        this.stateAhead.receiveLocArray(this.currentState.getLocArray(), false);
        return this.stateAhead.failedControlTest;
    }

    public void ledgeDishing(int pieceSize, int pieceColour) {
    }

    public synchronized QGameStatus getGameStatus() {
        QuiGameStatus stateStatus = new QuiGameStatus();
        stateStatus = this.currentState.getGameStatus();
        stateStatus.setForwardAvailable(currentLine.forwardStepAvailable() || this.currentState.zeroPlyDestination > 0);
        stateStatus.setBackwardAvailable(currentLine.backStepAvailable());
        if (QuiRules.irreversibilityUser && stateStatus.mayPass) {
            stateStatus.setMayPass(this.passLegality());
        }
        stateStatus.setGameVersion(QuiRules.ruleVersion);
        stateStatus.setGameVariant(QuiRules.numSizes);
        return stateStatus;
    }

    public synchronized boolean[] getLegalOptions() {
        boolean[] legalOptions = (boolean[])this.currentState.getOptions().clone();
        if (!QuiRules.irreversibility && (this.currentState.mayMove || this.currentState.mayPlaceHome || this.currentState.mayPlaceLedge) || this.currentState.zeroPlyDestination > 0) {
            return legalOptions;
        }
        int[] locArray = this.currentState.getLocArray();
        int legalCount = 0;
        int i = 0;
        while (i < 169) {
            if (legalOptions[i]) {
                QuiGameState legalCheckState = new QuiGameState();
                legalCheckState.initGameState();
                legalCheckState.receiveLocArray(locArray);
                legalCheckState.receiveLoc(i, false);
                if (legalCheckState.failedControlTest) {
                    legalOptions[i] = false;
                } else {
                    ++legalCount;
                }
            }
            ++i;
        }
        this.stringReport();
        return legalOptions;
    }

    public boolean passLegality() {
        System.out.println("passLegality is run");
        int[] locArray = this.currentState.getLocArray();
        QuiGameState legalCheckState = new QuiGameState();
        legalCheckState.initGameState();
        legalCheckState.receiveLocArray(locArray);
        legalCheckState.receiveLoc(84, false);
        return !legalCheckState.failedControlTest;
    }

    @Override
    public void modifyRules(boolean[] userRules) {
        QuiRules.setUserRules(userRules);
        this.currentState = new QuiGameState();
        this.currentState.initGameState();
    }

    public void stringReport() {
        if (QuiGameSpace.currentLine.hasRedundantPlies) {
            System.out.println("currentLine.markedPlyString has redundant or illegal plies - clean it!! ");
            System.out.println("");
        }
    }
}

