/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.gamequincala;

import com.quincala.gamequincala.QuiGraphics;
import com.quincala.gamequincala.QuincalaBoardPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;

public class QuiDrawingPanel
extends QuincalaBoardPanel {
    public boolean showGrid = true;
    public boolean showDiamonds = true;
    public boolean showBezierPolygons = false;
    public boolean toPrint = false;
    private BasicStroke ornLineStroke = new BasicStroke(2.0f);
    private BasicStroke whiteDiamStroke = new BasicStroke(2.0f);
    static final float[] dash1 = new float[]{5.0f};
    static final BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);

    @Override
    public void init() {
    }

    @Override
    public void paint(Graphics g) {
        int y;
        int x;
        Graphics2D g2d = (Graphics2D)g;
        int ht = this.getHeight();
        int wd = this.getWidth();
        int sizeCandidate = ht;
        if (wd < ht) {
            sizeCandidate = wd;
        }
        if (sizeCandidate != this.boardPanelSize) {
            this.boardPanelSize = sizeCandidate;
            System.out.println("New boardPanelSize is " + this.boardPanelSize);
            this.updateBoardImage();
        }
        if (this.toPrint) {
            g2d.setColor(Color.WHITE);
        } else {
            g2d.setColor(Color.YELLOW);
        }
        g2d.fillRect(0, 0, wd, ht);
        if (this.showGrid) {
            g2d.setColor(new Color(220, 220, 220));
            x = 0;
            while (x < 13) {
                y = 0;
                while (y < 13) {
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y * this.ss, this.xTop + x * this.ss, y * this.ss + this.yTop + this.ss - 1);
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y * this.ss, this.xTop + x * this.ss + this.ss - 1, this.yTop + y * this.ss);
                    g2d.drawLine(this.xTop + x * this.ss, y * this.ss + this.yTop + this.ss, this.xTop + x * this.ss + this.ss, this.yTop + y * this.ss);
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y * this.ss, this.xTop + x * this.ss + this.ss - 1, y * this.ss + this.yTop + this.ss - 1);
                    ++y;
                }
                ++x;
            }
            g2d.drawLine(this.xTop, this.yTop + 13 * this.ss, this.xTop + 13 * this.ss, this.yTop + 13 * this.ss);
            g2d.drawLine(this.xTop + 13 * this.ss, this.yTop, this.xTop + 13 * this.ss, this.yTop + 13 * this.ss);
        }
        if (this.showDiamonds) {
            g2d.setColor(new Color(180, 180, 180));
            x = 0;
            while (x < 13) {
                y = 0;
                while (y < 13) {
                    int loc = QuiGraphics.location(x, y);
                    int xMid = (int)((double)this.xTop + ((double)x + 0.5) * (double)this.ss) + 1;
                    int yMid = (int)((double)this.yTop + ((double)y + 0.5) * (double)this.ss) + 1;
                    if (QuiGraphics.hasStandardBlackDiamond(loc)) {
                        int i = 0;
                        while (i <= this.ds) {
                            g2d.drawLine(xMid + this.ds - i, yMid + i, xMid - this.ds + i, yMid + i);
                            g2d.drawLine(xMid + this.ds - i, yMid - i, xMid - this.ds + i, yMid - i);
                            ++i;
                        }
                    }
                    if (QuiGraphics.hasTurnedBlackDiamond(loc)) {
                        g2d.fillRect(xMid - this.tds, yMid - this.tds, 2 * this.tds, 2 * this.tds);
                    }
                    if (QuiGraphics.hasWhiteDiamond(loc)) {
                        g2d.setStroke(this.whiteDiamStroke);
                        g2d.drawLine(xMid - 2 * this.tds, yMid, xMid, yMid - 2 * this.tds);
                        g2d.drawLine(xMid - 2 * this.tds, yMid, xMid, yMid + 2 * this.tds);
                        g2d.drawLine(xMid + 2 * this.tds, yMid, xMid, yMid - 2 * this.tds);
                        g2d.drawLine(xMid + 2 * this.tds, yMid, xMid, yMid + 2 * this.tds);
                        g2d.setStroke(new BasicStroke(1.0f));
                    }
                    ++y;
                }
                ++x;
            }
        }
        g2d.setStroke(this.ornLineStroke);
        int i = 0;
        while (i < 64) {
            g2d.setColor(new Color(180, 180, 180));
            CubicCurve2D.Double orn = new CubicCurve2D.Double();
            ((CubicCurve2D)orn).setCurve(this.ln[i][0], this.ln[i][1], this.ln[i][2], this.ln[i][3], this.ln[i][4], this.ln[i][5], this.ln[i][6], this.ln[i][7]);
            g2d.draw(orn);
            ++i;
        }
        if (this.showGrid) {
            g2d.setColor(new Color(120, 120, 120));
            x = 0;
            while (x < 13) {
                int y2 = 0;
                while (y2 < 13) {
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y2 * this.ss, this.xTop + x * this.ss, y2 * this.ss + this.yTop + this.ss - 1);
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y2 * this.ss, this.xTop + x * this.ss + this.ss - 1, this.yTop + y2 * this.ss);
                    g2d.drawLine(this.xTop + x * this.ss, y2 * this.ss + this.yTop + this.ss, this.xTop + x * this.ss + this.ss, this.yTop + y2 * this.ss);
                    g2d.drawLine(this.xTop + x * this.ss, this.yTop + y2 * this.ss, this.xTop + x * this.ss + this.ss - 1, y2 * this.ss + this.yTop + this.ss - 1);
                    ++y2;
                }
                ++x;
            }
            g2d.drawLine(this.xTop, this.yTop + 13 * this.ss, this.xTop + 13 * this.ss, this.yTop + 13 * this.ss);
            g2d.drawLine(this.xTop + 13 * this.ss, this.yTop, this.xTop + 13 * this.ss, this.yTop + 13 * this.ss);
        }
        i = 0;
        while (i < 64) {
            if (this.showBezierPolygons) {
                g2d.setColor(Color.blue);
                int k = 0;
                while (k < 6) {
                    g2d.drawLine((int)this.ln[i][0 + k], (int)this.ln[i][1 + k], (int)this.ln[i][2 + k], (int)this.ln[i][3 + k]);
                    k += 2;
                }
            }
            ++i;
        }
    }
}

