/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.gamequincala;

public class QuCalc {
    public char[] hexMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public int hexCharsToLoc(char hexChar1, char hexChar2) {
        String hexValue1 = "" + hexChar1;
        String hexValue2 = "" + hexChar2;
        int xCoord = -1;
        int yCoord = -1;
        try {
            xCoord = Integer.parseInt(hexValue1, 16);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        try {
            yCoord = Integer.parseInt(hexValue2, 16);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int loc = (12 - yCoord) * 13 + xCoord;
        return loc;
    }

    public String locToHexCharString(int loc) {
        int hexNum1 = loc % 13;
        int hexNum2 = 12 - loc / 13;
        String hexChars = "" + this.hexMap[hexNum1] + this.hexMap[hexNum2];
        return hexChars;
    }

    public int pathIndex(int actPlayer, int ColourInt) {
        int pIndex = actPlayer * 2 + ColourInt;
        return pIndex;
    }

    public int smallestSizeInPlay(int numSizes) {
        int value = 1;
        int k = 1;
        while (k < numSizes) {
            value *= 2;
            ++k;
        }
        return value;
    }

    public byte calcTowerByte(int nSizes) {
        byte tByte = 0;
        int mask = 1;
        int i = 0;
        while (i < nSizes) {
            tByte = (byte)(tByte + mask);
            mask *= 2;
            ++i;
        }
        return tByte;
    }

    public int countBits(byte B) {
        int bCounter = 0;
        int m = 1;
        while (m < 17) {
            if ((B & m) != 0) {
                ++bCounter;
            }
            m *= 2;
        }
        return bCounter;
    }

    public int numberInStack(int size, byte B) {
        int ordinalNumber = 0;
        int bCounter = 0;
        int m = 1;
        while (m < 17) {
            if ((B & m) != 0) {
                ++ordinalNumber;
                ++bCounter;
                if (size == m) break;
            }
            m *= 2;
        }
        return ordinalNumber;
    }

    public int numberInStackUnsure(int size, byte B) {
        int ordinalNumber = 0;
        int testInt = 0;
        int bCounter = 0;
        int m = 1;
        while (m < 17) {
            if ((B & m) != 0) {
                ++testInt;
                ++bCounter;
                if (size == m) {
                    ordinalNumber = testInt;
                    break;
                }
            }
            m *= 2;
        }
        return ordinalNumber;
    }

    public boolean isEmpty(byte P) {
        boolean empty = false;
        if (P == 0) {
            empty = true;
        }
        return empty;
    }

    public boolean isWhite(byte P, byte C) {
        boolean white = false;
        if (P != 0 && C == 0) {
            white = true;
        }
        return white;
    }

    public boolean isBlack(byte P, byte C) {
        boolean black = false;
        if (P != 0 && C == P) {
            black = true;
        }
        return black;
    }

    public boolean isMixed(byte P, byte C) {
        boolean mixed = false;
        if (C > 0 && C != P) {
            mixed = true;
        }
        return mixed;
    }

    public boolean isPresent(int mask, byte P) {
        boolean presence = false;
        if ((mask & P) != 0) {
            presence = true;
        }
        return presence;
    }

    public boolean pieceIsPresent(int size, int colour, byte stack, byte blacks) {
        return this.isPresent(size, stack) && this.isPresent(colour * size, blacks);
    }

    public boolean pieceIsWhite(int mask, byte C) {
        boolean white = false;
        if ((mask & C) == 0) {
            white = true;
        }
        return white;
    }

    public boolean pieceIsBlack(int mask, byte C) {
        boolean black = false;
        if ((mask & C) != 0) {
            black = true;
        }
        return black;
    }

    public boolean pieceIsSelected(int mask, byte P) {
        boolean selection = false;
        if ((mask & P) != 0) {
            selection = true;
        }
        return selection;
    }

    public int pieceColour(byte size, byte blacks) {
        int colour = 0;
        if ((size & blacks) != 0) {
            colour = 1;
        }
        return colour;
    }

    public byte joinGroups(byte GroupA, byte GroupB) {
        byte resultingGroup = (byte)(GroupA | GroupB);
        return resultingGroup;
    }

    public byte removeFromByte(byte movingPieces, byte originalStack) {
        byte resultingGroup = (byte)(movingPieces ^ originalStack);
        return resultingGroup;
    }

    public byte removeBlacks(byte movingPieces, byte originalBlacks) {
        byte resultingBlacks = (byte)(movingPieces ^ originalBlacks);
        return resultingBlacks;
    }

    public byte extractKnockedPieces(byte knockingPieces, byte oldPieces) {
        byte knockedPieces = (byte)(knockingPieces & oldPieces);
        return knockedPieces;
    }

    public byte sowingGroup(int activePlayer, byte P, byte C) {
        byte sGroup = 0;
        boolean isBottom = true;
        byte k = 1;
        while (k < 17) {
            if ((k & P) != 0 && (k & C) == k * activePlayer) {
                if (isBottom) {
                    isBottom = false;
                } else {
                    sGroup = this.joinGroups(k, sGroup);
                }
            }
            k = (byte)(k * 2);
        }
        return sGroup;
    }

    public byte allOwnPieces(int activePlayer, byte P, byte C) {
        byte pGroup = 0;
        byte k = 1;
        while (k < 17) {
            if ((k & P) != 0 && (k & C) == k * activePlayer) {
                pGroup = this.joinGroups(k, pGroup);
            }
            k = (byte)(k * 2);
        }
        return pGroup;
    }

    public int largestSize(byte B) {
        int mask = 1;
        int k = 0;
        while (k < 5) {
            if ((B & mask) != 0) break;
            mask *= 2;
            ++k;
        }
        return mask;
    }

    public int yAdjustFactor(int size, byte groupByte) {
        int factor = 0;
        int bCounter = 0;
        int internalOrder = 0;
        int m = 1;
        while (m < 17) {
            if ((groupByte & m) != 0) {
                ++bCounter;
            }
            if (size == m) {
                internalOrder = bCounter;
            }
            m *= 2;
        }
        factor = bCounter - 2 * internalOrder;
        return factor;
    }

    public int xAdjustFactor(int sizeMask, int numSizes) {
        int number = 5;
        if (numSizes == 3) {
            int k = 1;
            while (k < 5) {
                if (sizeMask != k) {
                    number -= 2;
                    k *= 2;
                    continue;
                }
                break;
            }
        } else {
            int k = 1;
            while (k < 17) {
                if (sizeMask != k) {
                    --number;
                    k *= 2;
                    continue;
                }
                break;
            }
        }
        return number;
    }
}

