/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.core;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class QXLauncher {
    public static boolean openWS(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (url == null) {
            return false;
        }
        return QXLauncher.openWS(url);
    }

    public static boolean openWS(URL url) {
        try {
            BasicService bs = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
            return bs.showDocument(url);
        }
        catch (UnavailableServiceException ue) {
            System.out.println("Error caught: Service is unavailable!");
            return false;
        }
    }

    public static void open(File document) throws IOException {
        Desktop localSystem = Desktop.getDesktop();
        localSystem.open(document);
    }

    public static void open(String onlineUrlString) {
        URI uriTest = null;
        try {
            uriTest = new URI(onlineUrlString);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        try {
            QXLauncher.open(uriTest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void open(URI onLineDoc) throws IOException {
        Desktop localSystem = Desktop.getDesktop();
        if (Desktop.isDesktopSupported()) {
            localSystem.browse(onLineDoc);
        }
    }
}

