/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.core;

import com.quincala.core.QGraphics;
import com.quincala.core.QRules;
import com.quincala.core.QSFUtils;

public class QWholeLineData {
    private int goldenRuleFlag = -1;
    public String gameName = "Quincala";
    public int GameVersion = 0;
    public int GameVariant = 0;
    public int controlPassInt = 0;
    public String customString = "";
    public String locString = "";
    public int TurnsInLine = 0;
    public int turnsOpened = 0;
    public int winnerInt = -1;
    public boolean isEndOfLine = false;
    public int turnPhase = 0;
    public int player = 0;
    public boolean isSealed = false;
    public int resignInt = -1;
    public String errorMessage = "";
    public String titleString = "";
    public String titleStringHtml = "";

    public String iRMessage() {
        String iRInfo = "";
        int evalControlPassInt = this.controlPassInt;
        if (evalControlPassInt > 0) {
            iRInfo = evalControlPassInt < 4 ? " The end position of the last turn breaks " : " The last move breaks ";
            if ((evalControlPassInt & 4) > 0) {
                iRInfo = String.valueOf(iRInfo) + "the Immunity Rule";
                if ((evalControlPassInt -= 4) > 0) {
                    iRInfo = String.valueOf(iRInfo) + " and ";
                }
            }
            if ((evalControlPassInt & 1) > 0) {
                iRInfo = String.valueOf(iRInfo) + "the Irreversibility Rule";
                if (--evalControlPassInt > 0) {
                    iRInfo = String.valueOf(iRInfo) + " and ";
                }
            }
            if ((evalControlPassInt & 2) > 0) {
                iRInfo = String.valueOf(iRInfo) + "the Freedom Rule";
            }
            iRInfo = String.valueOf(iRInfo) + "; therefore the whole turn must be retaken and re-played differently in order to produce a legal end position!";
        }
        return iRInfo;
    }

    public String getFullGameName() {
        String fullName = String.valueOf(this.gameName) + " ";
        if (QGraphics.isMiniBoard) {
            fullName = "Mini " + fullName;
        }
        switch (this.GameVersion) {
            case 0: {
                fullName = String.valueOf(fullName) + "Position Editor with " + this.GameVariant + " sizes";
                break;
            }
            case 7: {
                fullName = String.valueOf(fullName) + "Football";
                break;
            }
            case 20: {
                fullName = String.valueOf(fullName) + "Knocking Game";
                break;
            }
            case 2: {
                fullName = String.valueOf(fullName) + "Knocking Game with " + this.GameVariant + " sizes";
                break;
            }
            case 3: {
                fullName = String.valueOf(fullName) + "Standard Game with " + this.GameVariant + " sizes";
                break;
            }
            case 4: {
                fullName = String.valueOf(fullName) + "Bouncing Game";
                break;
            }
            case 5: {
                fullName = String.valueOf(fullName) + "Unlimited Game";
                break;
            }
            case 22: {
                fullName = String.valueOf(fullName) + "Mixing Game";
                break;
            }
            case 1: {
                fullName = String.valueOf(fullName) + "Mixing Game with " + this.GameVariant + " sizes";
                break;
            }
            default: {
                fullName = String.valueOf(fullName) + "Undefined variant";
            }
        }
        if (QRules.withSimpleRules && !QGraphics.isMiniBoard) {
            fullName = String.valueOf(fullName) + " with Simple Rules.";
        }
        return fullName;
    }

    public String getWholeLineDataString() {
        String infoString = this.generalWLDataString();
        infoString = String.valueOf(infoString) + this.iRMessage();
        if (this.goldenRuleFlag > -1) {
            infoString = this.goldenRuleFlag == this.winnerInt ? String.valueOf(infoString) + " Golden Rule failed." : String.valueOf(infoString) + " Golden Rule holds.";
        }
        if (this.isSealed) {
            infoString = "<b>" + infoString + "</b>";
        }
        infoString = "<html>" + infoString + "</html>";
        return infoString;
    }

    public void setControlPassInt(int controlPassInt) {
        this.controlPassInt = controlPassInt;
    }

    public String getTitleString() {
        String infoWithBranch = this.titleString;
        return infoWithBranch;
    }

    public String generalWLDataString() {
        String lineDataString = this.customString;
        String turnPhaseString = "";
        String fullGameName = this.getFullGameName();
        if (fullGameName.length() > 0) {
            lineDataString = String.valueOf(lineDataString) + fullGameName + "<br>";
        }
        if (this.titleString.length() > 0) {
            lineDataString = String.valueOf(lineDataString) + this.titleStringHtml + "<br>";
        }
        String turnCountString = "Turns in line: " + this.TurnsInLine + ".";
        lineDataString = String.valueOf(lineDataString) + turnCountString;
        if (this.turnPhase == 0 && this.winnerInt == -1) {
            turnPhaseString = this.player == 0 ? (this.TurnsInLine > 0 ? "End at White to play." : "White to play.") : "End at Black to play.";
        } else {
            if (this.winnerInt == -1) {
                turnPhaseString = String.valueOf(turnPhaseString) + "End";
            }
            if (this.winnerInt == 0) {
                turnPhaseString = String.valueOf(turnPhaseString) + "White Win";
            }
            if (this.winnerInt == 1) {
                turnPhaseString = String.valueOf(turnPhaseString) + "Black Win";
            }
            turnPhaseString = this.player == 0 ? String.valueOf(turnPhaseString) + " in White's turn." : String.valueOf(turnPhaseString) + " in Black's turn.";
        }
        if (this.resignInt > -1) {
            switch (this.resignInt) {
                case 0: {
                    lineDataString = String.valueOf(lineDataString) + " Black win - White resigned.";
                    break;
                }
                case 1: {
                    lineDataString = String.valueOf(lineDataString) + " White win - Black resigned.";
                    break;
                }
                case 2: {
                    lineDataString = String.valueOf(lineDataString) + " Draw is agreed.";
                    break;
                }
                case 3: {
                    lineDataString = String.valueOf(lineDataString) + " Draw by consecutive Passes.";
                    break;
                }
                default: {
                    if (turnPhaseString.length() <= 0) break;
                    lineDataString = String.valueOf(lineDataString) + " " + turnPhaseString;
                }
            }
            if (this.errorMessage.length() > 0) {
                lineDataString = String.valueOf(lineDataString) + " " + this.errorMessage;
            }
        } else if (turnPhaseString.length() > 0) {
            lineDataString = String.valueOf(lineDataString) + " " + turnPhaseString;
        }
        return lineDataString;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setLocString(String locString) {
        this.locString = locString;
    }

    public void setTurnsInLine(int turnsInLine) {
        this.TurnsInLine = turnsInLine;
    }

    public void setWinnerInt(int winnerInt) {
        this.winnerInt = winnerInt;
    }

    public void setSealed(boolean isSealed) {
        this.isSealed = isSealed;
    }

    public void setResignInt(int resignInt) {
        this.resignInt = resignInt;
    }

    public void setEndOfLine(boolean isEndOfLine) {
        this.isEndOfLine = isEndOfLine;
    }

    public void setCustomString(String customString) {
        this.customString = customString;
    }

    public void setTitleString(String titleString) {
        this.titleString = titleString;
        this.titleStringHtml = QSFUtils.xhtmlEncodeValue(titleString, false);
    }

    public void setTurnPhase(int turnPhase) {
        this.turnPhase = turnPhase;
    }

    public void setPlayer(int player) {
        this.player = player;
    }

    public void setGameVersion(int gameVersion) {
        this.GameVersion = gameVersion;
    }

    public void setGameVariant(int gameVariant) {
        this.GameVariant = gameVariant;
    }

    public void setGoldenRuleFlag(int goldenRuleFlag) {
        this.goldenRuleFlag = goldenRuleFlag;
    }

    public void setTurnsOpened(int turnsOpened) {
        this.turnsOpened = turnsOpened;
    }
}

