/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;

public class QSFUtils {
    public static final int qsfLatestBaseLine = 0;
    public static final int qsfLatestIncrement = 1;
    public static int qsfBaseLineToUse = 0;
    public static int qsfIncrementToUse = 1;
    private static int[] boardDimensions = new int[]{13, 13};
    private static int maxRotation = 3;
    public static final char[] asciiDecimalMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final int GAME_STRING = 0;
    public static final int URL_STRING = 1;
    public static final int SPACE_KEY_STRING = 2;
    public static final int BOARD_KEY_STRING = 3;
    public static final int GUI_KEY_STRING = 4;
    public static final int QSF_VERSION_STRING = 5;
    public static final String qsfDelimiter = "&";
    public static final String qsfDelReplacement = "%26&";
    public static final String qsfSplitterExpression = "\\&";
    public static final String[] qsfFrame = new String[]{"<", ">"};
    public static final String[] qhfPrefixList = new String[]{"http://www.quincala.com/q/", "http://www.quincala.com/w/", "file:/home/ulf/Dropbox/quincala.com/web/q/applettester.html"};
    public static final String gdvErrorText = "Sorry, this software is too old to read the entered game string properly - please update.";
    public static final String qsfvErrorText = "Sorry, this software is too old to read all the information in the entered QSF string properly - please update.";
    public static final String qsfErrorText = "Sorry, the entered QSF string has errors and cannot be loaded.";
    private static final int lineLengthDefault = 50;
    private static final String[] definedGuiKeys = new String[]{"url"};
    private static final String[] definedBoardKeys = new String[]{"zoom", "rotation"};
    private static final String[] definedSpaceKeys = new String[]{"title", "ply", "goto", "nav", "loc"};
    public static final String[] definedGameHeads = new String[]{"Quincala"};
    public static final String[] validQuincalaVariants = new String[]{"13", "14", "15", "33", "34", "35", "KM"};
    private static final char[] reservedHtmlChars = new char[]{'&', '<', '>', '\"', '\''};
    private static final char[] wildChars = new char[]{'&', '#'};
    private static final char[] dodgyChars = new char[]{'@'};
    private static final char[] reservedChars = new char[]{'&', ';', '#', '/', '(', ')', '[', ']', '!', '$', '+', ',', ':', '=', '?', '*', '\''};
    private static final char[] unsafeChars = new char[]{'<', '>', '\"', '|', '{', '}', '^', '`', '\\'};
    public static String errorMessage = "";

    public static String getQSFVersion() {
        return "=QSF;0.1";
    }

    public static boolean is2009QuString(String quStrCand) {
        boolean fourthIsOK;
        if (quStrCand.length() < 5) {
            return false;
        }
        boolean result = false;
        String head = quStrCand.substring(0, 3);
        char nose = quStrCand.charAt(0);
        char fourthChar = quStrCand.charAt(3);
        boolean fourthIsDigit = Character.isDigit(fourthChar);
        boolean fourthIsMOrK = fourthChar == 'M' || fourthChar == 'K';
        boolean bl = fourthIsOK = fourthIsDigit || fourthIsMOrK;
        if (head.equalsIgnoreCase("qui") && fourthIsOK || nose == '~') {
            result = true;
        }
        System.out.println("is2009QuString is " + result);
        return result;
    }

    public static boolean isValidQSFString(String cleanQSFString) {
        if (cleanQSFString.length() == 0) {
            return true;
        }
        if (QSFUtils.hasQSFHyperLinkPrefix(cleanQSFString)) {
            cleanQSFString = QSFUtils.getQHyperLinkQuery(cleanQSFString);
        }
        if (QSFUtils.hasInitialURLString(cleanQSFString)) {
            if (!QSFUtils.isValidURLString(cleanQSFString)) {
                System.out.println("Validation Error URL");
                return false;
            }
        } else {
            String[] s = cleanQSFString.split(qsfSplitterExpression);
            int splitCount = s.length;
            int i = 0;
            while (i < splitCount) {
                String cand = s[i];
                if (cand.length() == 0) {
                    return true;
                }
                int type = QSFUtils.getQSFStringType(cand);
                switch (type) {
                    case 1: {
                        if (QSFUtils.isValidURLString(cand)) break;
                        System.out.println("Validation Error URL Single");
                        return false;
                    }
                    case 5: {
                        if (QSFUtils.isValidQSFVersionString(cand)) break;
                        System.out.println("Validation Error QSFV");
                        return false;
                    }
                    case 0: {
                        if (QSFUtils.isValidGameString(cand)) break;
                        System.out.println("Validation Error Game string");
                        return false;
                    }
                    default: {
                        if (type < 0 || type > 5) {
                            System.out.println("Validation Error string type out of range!");
                            return false;
                        }
                        if (QSFUtils.isValidKeyValueString(cand)) break;
                        System.out.println("Validation Error KeyvalueString");
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public static int getQSFStringType(String qString) {
        int type = -1;
        if (qString.length() == 0) {
            return -1;
        }
        if (QSFUtils.isURLString(qString)) {
            type = 1;
        } else if (QSFUtils.isQSFVersionString(qString)) {
            type = 5;
        } else if (QSFUtils.isKeyValueString(qString)) {
            if (QSFUtils.isGUIKey(QSFUtils.getKey(qString))) {
                type = 4;
            }
            if (QSFUtils.isBoardKey(QSFUtils.getKey(qString))) {
                type = 3;
            }
            if (QSFUtils.isSpaceKey(QSFUtils.getKey(qString))) {
                type = 2;
            }
        } else {
            type = 0;
        }
        return type;
    }

    private static boolean isValidTameURLString(String cand) {
        if (!QSFUtils.isValidURLString(cand)) {
            return false;
        }
        int length = cand.length();
        int i = 0;
        while (i < length) {
            char c = cand.charAt(i);
            if (QSFUtils.isInCharArray(c, wildChars)) {
                System.out.println("QSF String Error: the string has at least one wild character!");
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidURLString(String cand) {
        if (!QSFUtils.isURLString(cand)) {
            return false;
        }
        if (cand.substring(0, 4).equalsIgnoreCase("www.") && cand.indexOf(".", 4) > -1) {
            cand = "http://" + cand;
        }
        try {
            URL testURL = new URL(cand);
            System.out.println("URL passed test as " + testURL.toString());
        }
        catch (MalformedURLException e) {
            System.out.println("URL Candidate is caught malformed!!");
            return false;
        }
        return true;
    }

    public static boolean hasInitialURLString(String cand) {
        boolean isURLSlash;
        int slashInd = cand.indexOf(47);
        int ampInd = cand.indexOf(38);
        boolean bl = isURLSlash = slashInd > -1 && (ampInd == -1 || slashInd < ampInd);
        if (isURLSlash) {
            return true;
        }
        if (cand.length() < 4) {
            return false;
        }
        boolean isURLwww = cand.substring(0, 4).equalsIgnoreCase("www.");
        return isURLwww;
    }

    public static boolean isURLString(String urlStringCand) {
        boolean isURLSlash;
        int slashInd = urlStringCand.indexOf(47);
        boolean bl = isURLSlash = slashInd > -1;
        if (isURLSlash) {
            return true;
        }
        if (urlStringCand.length() < 4) {
            return false;
        }
        boolean isURLwww = urlStringCand.substring(0, 4).equalsIgnoreCase("www.");
        return isURLwww;
    }

    public static boolean isKeyValueString(String keyValueCand) {
        return keyValueCand.indexOf(61) > 0;
    }

    public static boolean isValidKeyValueString(String cand) {
        if (!QSFUtils.isKeyValueString(cand)) {
            return false;
        }
        String key = QSFUtils.getKey(cand);
        String value = QSFUtils.getValue(cand);
        if (QSFUtils.isGUIKey(key)) {
            if (key.equalsIgnoreCase("url") && !QSFUtils.isValidTameURLString(value)) {
                System.out.println("QSF String Error: url value error");
                return false;
            }
        } else if (QSFUtils.isBoardKey(key)) {
            if (key.equalsIgnoreCase("zoom")) {
                if (!QSFUtils.isValidCoordDoubleValue(value)) {
                    System.out.println("QSF String Error: zoom value error");
                    return false;
                }
            } else if (key.equalsIgnoreCase("rotation") && !QSFUtils.isValidIntValue(value, 0, maxRotation)) {
                System.out.println("QSF String Error: rotation value error");
                return false;
            }
        } else if (QSFUtils.isSpaceKey(key)) {
            if (key.equalsIgnoreCase("title") && !QSFUtils.isValidUSAsciiValue(value)) {
                System.out.println("QSF String Error: title value error");
                return false;
            }
        } else {
            System.out.println("QSF Validation Error: Key head is not recognised!");
            return false;
        }
        return true;
    }

    private static boolean isQSFVersionString(String cand) {
        return cand.indexOf(61) == 0;
    }

    private static boolean isValidQSFVersionString(String qsfVersionCand) {
        if (!QSFUtils.isQSFVersionString(qsfVersionCand)) {
            return false;
        }
        String[] v = qsfVersionCand.substring(1).split(";");
        if (v.length < 2 || !v[0].equalsIgnoreCase("qsf")) {
            return false;
        }
        int baseLine = 0;
        int increment = 1;
        String[] s = v[1].split("\\.");
        int fieldCount = s.length;
        System.out.println("QSF Version fieldCount is " + fieldCount);
        if (fieldCount > 0) {
            try {
                baseLine = Integer.parseInt(s[0]);
                System.out.println("baseLine is parsed as " + baseLine);
            }
            catch (NumberFormatException e) {
                System.out.println("QSF Version Validation Error: Baseline is entered as: " + s[0]);
                return false;
            }
        }
        if (fieldCount > 1) {
            try {
                increment = Integer.parseInt(s[1]);
                System.out.println("Increment is parsed as " + increment);
            }
            catch (NumberFormatException e) {
                System.out.println("QSF Version Validation Error: Increment is entered as: " + s[1]);
                return false;
            }
        }
        return true;
    }

    public static boolean isValidGameString(String gameStringCand) {
        String[] s = gameStringCand.split(";");
        if (s.length > 4) {
            System.out.println("QSF Validation Error: too many fields!");
            return false;
        }
        if (s.length > 0 && !QSFUtils.isInStringArray(s[0], definedGameHeads)) {
            System.out.println("QSF Validation Error: Game head not recognised!");
            return false;
        }
        if (s.length > 1 && !QSFUtils.isValidEnvironmentString(s[0], s[1])) {
            System.out.println("QSF Validation Error: Game environment not recognised!");
            return false;
        }
        if (s.length > 2) {
            String cand = s[2];
            int plyStrLength = cand.length();
            int i = 0;
            while (i < plyStrLength) {
                char ch = cand.charAt(i);
                if (ch < '0' || ch > 'z') {
                    System.out.println("QSF Validation Error: plystring has illegal characters!");
                    return false;
                }
                if (ch > '9' && ch < 'A') {
                    System.out.println("QSF Validation Error: plystring has illegal characters!");
                    return false;
                }
                if (ch > 'Z' && ch < 'a') {
                    System.out.println("QSF Validation Error: plystring has illegal characters!");
                    return false;
                }
                ++i;
            }
            StringBuffer b = new StringBuffer(cand);
            int i2 = plyStrLength - 1;
            while (i2 >= 0) {
                char ch = b.charAt(i2);
                if (ch > 'r') {
                    b.deleteCharAt(i2);
                }
                --i2;
            }
            cand = b.toString();
            int pureLength = cand.length();
            if (pureLength % 2 != 0) {
                System.out.println("QSF Validation Error: plystring has illegal number of characters!");
                return false;
            }
        }
        if (s.length > 3) {
            String[] str = s[3].split("\\.");
            int fieldCount = str.length;
            System.out.println("QSF Version fieldCount is " + fieldCount);
            if (fieldCount > 0) {
                try {
                    int baseLine = Integer.parseInt(str[0]);
                    System.out.println("Game Definition baseLine is parsed as " + baseLine);
                }
                catch (NumberFormatException e) {
                    System.out.println("QSF Validation Error: Game Definition string has a non-integer base part!");
                    return false;
                }
            }
            if (fieldCount > 1) {
                try {
                    int increment = Integer.parseInt(str[1]);
                    System.out.println("Game Definition increment is parsed as " + increment);
                }
                catch (NumberFormatException e) {
                    System.out.println("QSF Validation Error: Game Definition string has a non-integer incremental part!");
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isGUIKey(String keyCandidate) {
        int i = definedGuiKeys.length - 1;
        while (i >= 0) {
            if (definedGuiKeys[i].equals(keyCandidate)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean isBoardKey(String keyCandidate) {
        int i = definedBoardKeys.length - 1;
        while (i >= 0) {
            if (definedBoardKeys[i].equals(keyCandidate)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean isSpaceKey(String keyCandidate) {
        int i = definedSpaceKeys.length - 1;
        while (i >= 0) {
            if (definedSpaceKeys[i].equals(keyCandidate)) {
                return true;
            }
            --i;
        }
        return false;
    }

    private static boolean isValidIntValue(String cand, int min, int max) {
        int candInt = min - 1;
        try {
            candInt = Integer.parseInt(cand);
        }
        catch (NumberFormatException e) {
            System.out.println("QSF String Error: the value should be an integer!");
            return false;
        }
        if (candInt < min || candInt > max) {
            System.out.println("QSF String Error: the value is outside the range " + min + " - " + max);
            return false;
        }
        return true;
    }

    private static boolean isValidCoordDoubleValue(String cand) {
        String[] split = cand.split(";");
        if (split.length != 2) {
            System.out.println("QSF String Error: the value must have two fields!");
            return false;
        }
        if (!QSFUtils.isCoordStringlet(split[0])) {
            System.out.println("QSF String Error: the first field must be a coordinate");
            return false;
        }
        try {
            double d = Double.parseDouble(split[1]);
            System.out.println("double value passes test as " + d);
        }
        catch (NumberFormatException e) {
            System.out.println("QSF String Error: the second field must be a 'double' value!");
            return false;
        }
        return true;
    }

    private static boolean isValidUSAsciiValue(String cand) {
        int length = cand.length();
        int i = 0;
        while (i < length) {
            char c = cand.charAt(i);
            if (c < '!' || c > '~') {
                System.out.println("QSF String Error: value is outside US Ascii range.");
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInStringArray(String cand, String[] array) {
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i].equalsIgnoreCase(cand)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean isInIntArray(int cand, int[] array) {
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == cand) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean isInCharArray(char cand, char[] array) {
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == cand) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static String getKey(String keyValueQuString) {
        return keyValueQuString.substring(0, keyValueQuString.indexOf(61)).trim().toLowerCase();
    }

    public static String getValue(String keyValueQuString) {
        return keyValueQuString.substring(keyValueQuString.indexOf(61) + 1).trim();
    }

    public static String[] splitOnPreLimiter(String toSplit, String preLimiter) {
        String[] result = new String[]{toSplit.substring(0, toSplit.indexOf(preLimiter)).trim().toLowerCase(), toSplit.substring(toSplit.indexOf(preLimiter) + 1).trim()};
        int i = 0;
        while (i < 2) {
            System.out.println("prelimiter split[" + i + "] is " + result[1]);
            ++i;
        }
        return result;
    }

    public static boolean isValidTurnString(String turnString, String maxTurnString) {
        boolean result = true;
        int maxTurn = -1;
        try {
            maxTurn = Integer.parseInt(maxTurnString.substring(1));
        }
        catch (NumberFormatException e) {
            System.out.println("QSF Parsing Error: isValidTurnString.maxTurnString is not an integer!");
        }
        int turnInt = -1;
        int i = 0;
        while (i < turnString.length()) {
            char ch = turnString.charAt(i);
            if (!Character.isDigit(ch)) {
                result = false;
            }
            ++i;
        }
        if (result) {
            try {
                turnInt = Integer.parseInt(turnString);
            }
            catch (NumberFormatException e) {
                System.out.println("QSF Parsing Error: isValidTurnString.turnString is not an integer!");
            }
            if (turnInt == -1) {
                return false;
            }
            if (turnInt > maxTurn || turnInt < 1) {
                result = false;
            }
        }
        return result;
    }

    public static String convertToXMLDateFormat(String stringStartingWithDate) {
        if (stringStartingWithDate.length() == 0) {
            return "";
        }
        String candidate = stringStartingWithDate.trim();
        int firstSpaceIndex = candidate.indexOf("_");
        if (firstSpaceIndex > 0) {
            StringBuffer possibleDateStringBfr = new StringBuffer(candidate.substring(0, firstSpaceIndex));
            String tailEnd = candidate.substring(firstSpaceIndex);
            if (!QSFUtils.isPossibleOldDateString(possibleDateStringBfr.toString())) {
                return candidate;
            }
            if (firstSpaceIndex == 8) {
                possibleDateStringBfr.insert(6, '-');
                possibleDateStringBfr.insert(4, '-');
            } else if (firstSpaceIndex == 10) {
                possibleDateStringBfr.replace(7, 8, "-");
                possibleDateStringBfr.replace(4, 5, "-");
            }
            candidate = String.valueOf(possibleDateStringBfr.toString()) + tailEnd;
        }
        return candidate;
    }

    private static boolean isPossibleOldDateString(String dateStringCandidate) {
        int length = dateStringCandidate.length();
        int i = 0;
        while (i < length) {
            char t = dateStringCandidate.charAt(i);
            if (!Character.isDigit(t) && t != '.') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isHexCode(String cand) {
        if (cand.length() != 2) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (i < 2) {
            char ch = cand.charAt(i);
            if (!(Character.isDigit(ch) || ch >= 'A' && ch <= 'F')) {
                result = false;
            }
            ++i;
        }
        System.out.println("isHexCodeTest comes out " + result);
        return result;
    }

    public static String cleanUserInputValue(String inputString, boolean isUnicode, boolean acceptUnPrintable) {
        int i;
        StringBuffer b = new StringBuffer(inputString);
        int codePoint = 0;
        if (acceptUnPrintable) {
            i = b.length() - 1;
            while (i >= 0) {
                codePoint = b.codePointAt(i);
                --i;
            }
        }
        i = b.length() - 1;
        while (i >= 0) {
            codePoint = b.codePointAt(i);
            if (codePoint < 32) {
                b.deleteCharAt(i);
            }
            if (!isUnicode && codePoint > 126) {
                b.deleteCharAt(i);
            }
            if (isUnicode && codePoint > 65535) {
                b.deleteCharAt(i);
            }
            --i;
        }
        int dsIndex = b.indexOf("  ");
        while (dsIndex > -1) {
            System.out.println("DOUBLE SPACE is found");
            b.deleteCharAt(dsIndex);
            dsIndex = b.indexOf("  ");
        }
        b = QSFUtils.encodeValue(b, isUnicode);
        return b.toString().trim();
    }

    public static String convertUserInputString(String inputString) {
        if (inputString == null || inputString.length() == 0) {
            return "";
        }
        String returnString = inputString;
        int colonIndex = inputString.indexOf(58);
        if (colonIndex > 0) {
            String head = inputString.substring(0, colonIndex);
            String argument = inputString.substring(colonIndex + 1).trim();
            if (head.equalsIgnoreCase("title")) {
                argument = QSFUtils.cleanUserInputValue(argument, false, false);
                returnString = "title=" + argument;
            } else if (head.equalsIgnoreCase("zoom")) {
                returnString = "zoom=" + argument;
            }
        } else {
            returnString = QSFUtils.cleanWildQSFString(returnString);
        }
        return returnString;
    }

    public static String xhtmlEncodeValue(String valueString, boolean isUnicode) {
        StringBuffer b = new StringBuffer();
        int stringLength = valueString.length();
        int i = 0;
        while (i < stringLength) {
            boolean safe;
            char ch = valueString.charAt(i);
            boolean bl = safe = !QSFUtils.isInCharArray(ch, reservedHtmlChars);
            if (safe) {
                b.append(ch);
            } else {
                char charInt = ch;
                b.append("&#" + charInt + ";");
            }
            ++i;
        }
        return b.toString();
    }

    public static String encodeValue(String rawString, boolean isUnicode) {
        StringBuffer b = new StringBuffer(rawString);
        return QSFUtils.encodeValue(b, isUnicode).toString();
    }

    private static StringBuffer encodeValue(StringBuffer b, boolean isUnicode) {
        b = QSFUtils.encodeEscapeSigns(b);
        b = QSFUtils.convertSpaces(b);
        b = QSFUtils.encodeChars(unsafeChars, b);
        b = QSFUtils.encodeChars(dodgyChars, b);
        b = QSFUtils.encodeChars(reservedChars, b);
        return b;
    }

    public static String encodeChars(char[] charList, String rawString) {
        StringBuffer bfr = new StringBuffer(rawString);
        return QSFUtils.encodeChars(charList, bfr).toString();
    }

    private static StringBuffer encodeChars(char[] charList, StringBuffer rawBuffer) {
        int i = rawBuffer.length() - 1;
        while (i >= 0) {
            char ch = rawBuffer.charAt(i);
            if (QSFUtils.isInCharArray(ch, charList)) {
                String hexCode = Integer.toHexString(ch).toUpperCase();
                System.out.println("hexCode is " + hexCode);
                rawBuffer.replace(i, i + 1, "%" + hexCode);
            }
            --i;
        }
        return rawBuffer;
    }

    private static StringBuffer encodeChar(char charToEncode, StringBuffer rawBuffer) {
        String hexCode = Integer.toHexString(charToEncode).toUpperCase();
        int i = rawBuffer.length() - 1;
        while (i >= 0) {
            if (rawBuffer.charAt(i) == charToEncode) {
                rawBuffer.replace(i, i + 1, "%" + hexCode);
                System.out.println(String.valueOf(charToEncode) + " is encoded at " + i);
            }
            --i;
        }
        return rawBuffer;
    }

    public static String removeChars(char[] charList, String rawBuffer) {
        StringBuffer bfr = new StringBuffer(rawBuffer);
        return QSFUtils.removeChars(charList, bfr).toString();
    }

    private static StringBuffer removeChars(char[] charList, StringBuffer rawBuffer) {
        int i = rawBuffer.length() - 1;
        while (i >= 0) {
            char ch = rawBuffer.charAt(i);
            if (QSFUtils.isInCharArray(ch, charList)) {
                rawBuffer.deleteCharAt(i);
            }
            --i;
        }
        return rawBuffer;
    }

    public static String decodeChars(String rawString) {
        StringBuffer bfr = new StringBuffer(rawString);
        return QSFUtils.decodeChars(bfr).toString();
    }

    public static StringBuffer decodeChars(StringBuffer bfr) {
        System.out.println("decodeChars is run!");
        int i = bfr.length() - 2;
        while (i >= 0) {
            if (bfr.charAt(i) == '%') {
                String hexCandidate = bfr.substring(i + 1, i + 3);
                System.out.println("decodeChars.hexCandidate is " + hexCandidate);
                if (QSFUtils.isHexCode(hexCandidate)) {
                    int hexInt = 0;
                    try {
                        hexInt = Integer.parseInt(hexCandidate, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    System.out.println("%hexInt is " + hexInt);
                    if (32 < hexInt && hexInt < 127) {
                        String userString = "" + (char)hexInt;
                        bfr.replace(i, i + 3, userString);
                    }
                }
            }
            --i;
        }
        return bfr;
    }

    public static String decodeValue(String encodedString, boolean isUnicode) {
        StringBuffer b = new StringBuffer(encodedString);
        return QSFUtils.decodeValue(b, isUnicode).toString();
    }

    private static StringBuffer decodeValue(StringBuffer b, boolean isUnicode) {
        b = QSFUtils.restoreSpaces(b);
        b = QSFUtils.decodeChars(b);
        return b;
    }

    public static String convert2009String(String oldString) {
        String[] cutQuString = oldString.split("\r\n|\r|\n");
        int lineCount = cutQuString.length;
        String longString = "";
        int i = 0;
        while (i < lineCount) {
            longString = String.valueOf(longString) + cutQuString[i];
            ++i;
        }
        String[] splitall = longString.split(";;");
        int splitCount = splitall.length;
        int i2 = 0;
        while (i2 < splitCount) {
            String head = splitall[i2].substring(0, 3);
            System.out.println("convert-head is " + head);
            if (head.equalsIgnoreCase("qui")) {
                String environment = splitall[i2].substring(3, 5);
                System.out.println("convert-environment is " + environment);
                String plystring = splitall[i2].substring(5).trim();
                splitall[i2] = "Quincala;" + environment + ";" + plystring + ";0.1";
                System.out.println("convert-plystring is " + plystring);
            } else if (head.equalsIgnoreCase("~in")) {
                String body = splitall[i2].substring(5).trim();
                body = QSFUtils.convertSpaces(body);
                body = QSFUtils.convertToXMLDateFormat(body);
                System.out.println("convert-body is:" + body);
                splitall[i2] = "title=" + body;
            }
            ++i2;
        }
        String newString = "";
        int i3 = 0;
        while (i3 < splitCount) {
            if (i3 > 0) {
                newString = String.valueOf(newString) + "&&";
            }
            newString = String.valueOf(newString) + splitall[i3];
            ++i3;
        }
        System.out.println("convert-newString is " + newString);
        return newString;
    }

    public static String convertSpaces(String rawString) {
        StringBuffer rawStringBuffer = new StringBuffer(rawString);
        return QSFUtils.convertSpaces(rawStringBuffer).toString();
    }

    public static StringBuffer convertSpaces(StringBuffer rawStringBuffer) {
        rawStringBuffer = QSFUtils.encodeChar('_', rawStringBuffer);
        int i = rawStringBuffer.length() - 1;
        while (i >= 0) {
            if (rawStringBuffer.codePointAt(i) == 32) {
                rawStringBuffer.setCharAt(i, '_');
            }
            --i;
        }
        return rawStringBuffer;
    }

    public static String restoreSpaces(String scoreString) {
        StringBuffer scoreStringBuffer = new StringBuffer(scoreString);
        return QSFUtils.restoreSpaces(scoreStringBuffer).toString();
    }

    public static StringBuffer restoreSpaces(StringBuffer scoreStringBuffer) {
        int i = scoreStringBuffer.length() - 1;
        while (i >= 0) {
            if (scoreStringBuffer.codePointAt(i) == 95) {
                scoreStringBuffer.setCharAt(i, ' ');
            }
            --i;
        }
        return scoreStringBuffer;
    }

    private static StringBuffer removeIllegalPercentEncodings(StringBuffer encodedStringBuffer) {
        int i = encodedStringBuffer.length() - 2;
        while (i >= 0) {
            if (encodedStringBuffer.charAt(i) == '%') {
                String hexCandidate = encodedStringBuffer.substring(i + 1, i + 3);
                System.out.println("asciifyEncodedStringBfr.hexCandidate is " + hexCandidate);
                if (QSFUtils.isHexCode(hexCandidate)) {
                    int hexInt = Integer.parseInt(hexCandidate, 16);
                    System.out.println("%XYhexInt is " + hexInt);
                    if (hexInt < 33 || hexInt > 126) {
                        encodedStringBuffer.delete(i, i + 3);
                    }
                }
            }
            --i;
        }
        return encodedStringBuffer;
    }

    public static String cleanWildQSFString(String wildQSFString) {
        StringBuffer b = new StringBuffer(wildQSFString);
        int i = b.length() - 1;
        while (i >= 0) {
            boolean legal = true;
            char c = b.charAt(i);
            if (c < '!' || c > '~') {
                legal = false;
            }
            if (QSFUtils.isInCharArray(c, unsafeChars)) {
                legal = false;
            }
            if (!legal) {
                b.deleteCharAt(i);
            }
            --i;
        }
        b = QSFUtils.encodeChars(dodgyChars, b);
        return b.toString().trim();
    }

    public static String encodeQSFDelimiter(String valueString) {
        if (valueString.indexOf(qsfDelimiter) > -1) {
            StringBuffer temp = new StringBuffer(valueString);
            int daIndex = temp.indexOf(qsfDelimiter);
            while (daIndex > -1) {
                temp.replace(daIndex, daIndex + 2, qsfDelReplacement);
                daIndex = temp.indexOf(qsfDelimiter);
            }
            valueString = temp.toString();
        }
        System.out.println("convQSFString-valueString/URLcandidate is:");
        System.out.println(valueString);
        return valueString;
    }

    public static String encode2009Delimiter(String valueString) {
        if (valueString.indexOf(";;") > -1) {
            StringBuffer temp = new StringBuffer(valueString);
            int daIndex = temp.indexOf(";;");
            while (daIndex > -1) {
                temp.replace(daIndex, daIndex + 2, "%3B;");
                daIndex = temp.indexOf(";;");
            }
            valueString = temp.toString();
        }
        System.out.println("conv2009String-valueString/URLcandidate is:");
        System.out.println(valueString);
        return valueString;
    }

    public static String encodeEscapeSigns(String valueString) {
        System.out.println("encodePercentSign is called");
        StringBuffer b = new StringBuffer(valueString);
        return QSFUtils.encodeEscapeSigns(b).toString();
    }

    private static StringBuffer encodeEscapeSigns(StringBuffer b) {
        int i = b.length() - 1;
        while (i >= 0) {
            if (b.charAt(i) == '%') {
                b.replace(i, i + 1, "%25");
            }
            --i;
        }
        return b;
    }

    public static boolean isValidEnvironmentString(String gameHead, String envCand) {
        boolean result = true;
        if (gameHead.equalsIgnoreCase("quincala") && !QSFUtils.isInStringArray(envCand, validQuincalaVariants)) {
            result = false;
        }
        System.out.println("isValidEnvironmentString returns " + result);
        return result;
    }

    public static String getQHyperLinkQuery(String qsfString) {
        String query = "";
        if (QSFUtils.hasQSFHyperLinkPrefix(qsfString = qsfString.trim())) {
            System.out.println("QSF String has hyperlink prefix!");
            int qInd = qsfString.indexOf(63);
            if (qInd > -1 && qInd + 1 < qsfString.length()) {
                query = qsfString.substring(qInd + 1);
            }
        }
        return query;
    }

    public static boolean hasQSFHyperLinkPrefix(String qsfString) {
        int length = qhfPrefixList.length;
        int i = 0;
        while (i < length) {
            if (qsfString.indexOf(qhfPrefixList[i]) == 0) {
                System.out.println("string has hyperlink prefix!");
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String wrap(String longString) {
        return QSFUtils.wrap(longString, 50);
    }

    public static String wrap(String longString, int lineLength) {
        int lineCount;
        int stringLenght = longString.length();
        StringBuffer longStringBfr = new StringBuffer(longString);
        int i = lineCount = (stringLenght - 6) / lineLength;
        while (i > 0) {
            longStringBfr.insert(i * lineLength, "\n");
            --i;
        }
        String wrappedString = longStringBfr.toString();
        System.out.println("wrappedString is:");
        System.out.println(wrappedString);
        return wrappedString;
    }

    public static String getIdentityDateString() {
        String idsString = String.valueOf(QSFUtils.getYearString()) + "-" + QSFUtils.getMonthString() + "-" + QSFUtils.getDateString();
        return idsString;
    }

    public static String getHourString(Calendar now) {
        int hourInt = now.get(11);
        String hourString = "" + hourInt;
        if (hourInt < 10) {
            hourString = "0" + hourString;
        }
        return hourString;
    }

    public static String getMinuteString(Calendar now) {
        int minuteInt = now.get(12);
        String minuteString = "" + minuteInt;
        if (minuteInt < 10) {
            minuteString = "0" + minuteString;
        }
        return minuteString;
    }

    public static String getSecondString(Calendar now) {
        int secondInt = now.get(13);
        String secondString = "" + secondInt;
        if (secondInt < 10) {
            secondString = "0" + secondString;
        }
        return secondString;
    }

    public static String getYearString(Calendar now) {
        int yearInt = now.get(1);
        String yearString = "" + yearInt;
        return yearString;
    }

    public static String getYearString() {
        Calendar nowCalendar = Calendar.getInstance();
        int yearInt = nowCalendar.get(1);
        String yearString = "" + yearInt;
        return yearString;
    }

    public static String getMonthString() {
        Calendar nowCalendar = Calendar.getInstance();
        int monthInt = nowCalendar.get(2) + 1;
        String monthString = "" + monthInt;
        if (monthInt < 10) {
            monthString = "0" + monthString;
        }
        return monthString;
    }

    public static String getMonthString(Calendar now) {
        int monthInt = now.get(2) + 1;
        String monthString = "" + monthInt;
        if (monthInt < 10) {
            monthString = "0" + monthString;
        }
        return monthString;
    }

    public static String getDateString() {
        Calendar nowCalendar = Calendar.getInstance();
        int dateInt = nowCalendar.get(5);
        String dateString = "" + dateInt;
        if (dateInt < 10) {
            dateString = "0" + dateString;
        }
        return dateString;
    }

    public static String getDateString(Calendar now) {
        int dateInt = now.get(5);
        String dateString = "" + dateInt;
        if (dateInt < 10) {
            dateString = "0" + dateString;
        }
        return dateString;
    }

    public static int getAsciiInt(String asciiString) {
        int result = -1;
        try {
            result = Integer.parseInt(asciiString, 36);
        }
        catch (NumberFormatException e) {
            System.out.println("QSF Parsing Error: value is not an integer!");
        }
        return result;
    }

    public static boolean setQSFVersion(String validatedQSFDefString) {
        System.out.println("QSF definitionString received is " + validatedQSFDefString);
        if (validatedQSFDefString.length() == 0) {
            qsfBaseLineToUse = 0;
            qsfIncrementToUse = 1;
            return true;
        }
        int baseLine = 0;
        int increment = 1;
        String[] s = validatedQSFDefString.split("\\.");
        int fieldCount = s.length;
        System.out.println("QSF Version fieldCount is " + fieldCount);
        if (fieldCount > 0) {
            try {
                baseLine = Integer.parseInt(s[0]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (fieldCount > 1) {
            try {
                increment = Integer.parseInt(s[1]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (baseLine > 0 || increment > 1) {
            return false;
        }
        qsfBaseLineToUse = baseLine;
        qsfIncrementToUse = increment;
        return true;
    }

    public static String getCoreURLString(String localPath) {
        return QSFUtils.class.getResource(localPath).toString();
    }

    public static String historyURLString() {
        URL historyURL = QSFUtils.class.getResource("history/qustringhistory.txt");
        return historyURL.toString();
    }

    public static String getSessionPathString() {
        URL historyURL = QSFUtils.class.getResource("history/");
        return historyURL.toString();
    }

    public static int hexCharToInt(char hexChar) {
        String hexString = "" + hexChar;
        int i = -1;
        try {
            i = Integer.parseInt(hexString, 36);
        }
        catch (NumberFormatException e) {
            System.out.println("QUtils Error: The Character is not ascii-decimal!");
        }
        return i;
    }

    public static String locToHexCharString(int loc) {
        int hexNum1 = 0;
        int hexNum2 = 0;
        if (loc < 169) {
            hexNum1 = loc % 13;
            hexNum2 = 12 - loc / 13;
        } else {
            hexNum1 = loc / 36;
            hexNum2 = loc % 36;
        }
        String hexChars = "" + asciiDecimalMap[hexNum1] + asciiDecimalMap[hexNum2];
        return hexChars;
    }

    public static int hexStringletToLoc(String stringlet) {
        char xChar = stringlet.charAt(0);
        char yChar = stringlet.charAt(1);
        return QSFUtils.hexCharsToLoc(xChar, yChar);
    }

    public static int hexCharsToLoc(char hexChar1, char hexChar2) {
        int xCoord = QSFUtils.hexCharToInt(hexChar1);
        int yCoord = QSFUtils.hexCharToInt(hexChar2);
        if (xCoord == -1 || yCoord == -1) {
            return -1;
        }
        int loc = -1;
        loc = xCoord < 13 ? (12 - yCoord) * 13 + xCoord : xCoord * 36 + yCoord;
        return loc;
    }

    public static boolean isCoordStringlet(String slet) {
        if (slet.length() != 2) {
            return false;
        }
        return QSFUtils.isCoordChar(slet.charAt(0)) && QSFUtils.isCoordChar(slet.charAt(1));
    }

    public static boolean isCoordChar(char a) {
        int boardSize = 13;
        int i = 0;
        while (i < boardSize) {
            if (a == asciiDecimalMap[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

