/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.core;

import com.quincala.core.QSFUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class QGraphics {
    public static int boardTextureInt = -1;
    public static int canvasTextureInt = 1;
    public static final int textureCount = 2;
    public static final boolean[] hasGrain;
    public static BufferedImage bimage1;
    public static BufferedImage bimage2;
    public static TexturePaint texture1;
    public static TexturePaint texture2;
    public static int maxCanvasSize;
    public static int boardRotation;
    public static int ht;
    public static int wd;
    public static int boardPanelSize;
    public static boolean isMiniBoard;
    private static boolean reDrawBoardFlag;
    public static int xTop;
    public static int yTop;
    public static int xCanv;
    public static int yCanv;
    public static int ss;
    public static int boardSize;
    public static int canvasSize;
    protected static int boardX;
    protected static int boardY;
    public static boolean canZoomByRClick;
    public static boolean isZoomedIn;
    public static int centerSqLocDefault;
    public static int centerSqLoc;
    public static double radiusSeenDefault;
    public static double radiusSeen;
    public static int iconSize;
    private static double[][] simpleNavArrowDef;
    public static int[][] simpleNavArrowPoints;
    private static double[][] markNavArrowDef;
    public static int[][] markNavArrowPoints;
    public static Color boardColourLight;
    public static Color navArrowcolour;
    public static BufferedImage[] navArrowBuffered;
    public static ImageIcon[] navArrows;

    static {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        hasGrain = blArray;
        bimage1 = null;
        bimage2 = null;
        texture1 = null;
        texture2 = null;
        maxCanvasSize = 2000;
        boardRotation = 0;
        ht = 0;
        wd = 0;
        boardPanelSize = 0;
        isMiniBoard = false;
        reDrawBoardFlag = false;
        xTop = 0;
        yTop = 0;
        xCanv = 0;
        yCanv = 0;
        ss = 1;
        boardSize = 0;
        canvasSize = 400;
        boardX = 13;
        boardY = 13;
        canZoomByRClick = false;
        isZoomedIn = false;
        centerSqLoc = centerSqLocDefault = 84;
        radiusSeen = radiusSeenDefault = 7.0;
        iconSize = 0;
        simpleNavArrowDef = new double[][]{{0.25, 0.25, 0.5, 0.0}, {1.0, 0.5, 0.5, 0.0}};
        markNavArrowDef = new double[][]{{0.25, 0.25, 0.5, 0.0, 0.5, 0.5, 0.0}, {1.0, 0.61, 0.61, 0.14, 0.14, 0.0, 0.0}};
        boardColourLight = new Color(225, 160, 0);
        navArrowcolour = Color.black;
        navArrowBuffered = new BufferedImage[10];
        navArrows = new ImageIcon[10];
    }

    public static void initQGraphics(int iconSize) {
        QGraphics.iconSize = iconSize + (iconSize + 1) % 2 + 2;
        System.out.println("iconSize is " + QGraphics.iconSize);
        QGraphics.updateNavArrowIcons();
        QGraphics.loadTextures();
    }

    public static void loadTextures() {
        if (boardTextureInt == -1 && canvasTextureInt == -1) {
            return;
        }
        URL url1 = QGraphics.class.getResource("textures/wood057.jpg");
        URL url2 = QGraphics.class.getResource("textures/cloth012.gif");
        try {
            bimage1 = ImageIO.read(url1);
            bimage2 = ImageIO.read(url2);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Rectangle rect1 = new Rectangle(0, 0, bimage1.getWidth(), bimage1.getHeight());
        Rectangle rect2 = new Rectangle(0, 0, bimage2.getWidth(), bimage2.getHeight());
        texture1 = new TexturePaint(bimage1, rect1);
        texture2 = new TexturePaint(bimage2, rect2);
    }

    public static void updateNavArrowIcons() {
        simpleNavArrowPoints = QGraphics.expandNavArrows(simpleNavArrowDef);
        BufferedImage navArrowImage = QGraphics.updateNavArrowImage(simpleNavArrowPoints);
        int i = 0;
        while (i < 4) {
            QGraphics.navArrows[i] = new ImageIcon(QGraphics.getRotatedImage(navArrowImage, i * 90));
            ++i;
        }
        markNavArrowPoints = QGraphics.expandNavArrows(markNavArrowDef);
        navArrowImage = QGraphics.updateNavArrowImage(markNavArrowPoints);
        i = 4;
        while (i < 8) {
            QGraphics.navArrows[i] = new ImageIcon(QGraphics.getRotatedImage(navArrowImage, i * 90));
            ++i;
        }
    }

    public static int[][] expandNavArrows(double[][] arrowDef) {
        int inputLength = arrowDef[0].length;
        int outputLength = 2 * inputLength - 1;
        double[][] tempNavArrowPoints = new double[2][outputLength];
        int[][] returnNavArrowPoints = new int[2][outputLength];
        int i = 0;
        while (i < inputLength) {
            tempNavArrowPoints[0][i] = arrowDef[0][i];
            tempNavArrowPoints[1][i] = arrowDef[1][i];
            if (i < inputLength - 1) {
                tempNavArrowPoints[0][outputLength - i - 1] = -arrowDef[0][i];
                tempNavArrowPoints[1][outputLength - i - 1] = arrowDef[1][i];
            }
            ++i;
        }
        int transformX = iconSize / 2 - 1;
        int i2 = 0;
        while (i2 < outputLength) {
            returnNavArrowPoints[0][i2] = (int)((double)(iconSize - 2) * tempNavArrowPoints[0][i2]);
            returnNavArrowPoints[1][i2] = (int)((double)(iconSize - 2) * tempNavArrowPoints[1][i2]);
            returnNavArrowPoints[0][i2] = returnNavArrowPoints[0][i2] + transformX;
            ++i2;
        }
        return returnNavArrowPoints;
    }

    public static BufferedImage updateNavArrowImage(int[][] arrowPoints) {
        BufferedImage navArrowIm = new BufferedImage(iconSize, iconSize, 2);
        Graphics g = navArrowIm.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(navArrowcolour);
        int pointCount = arrowPoints[0].length;
        g2d.fillPolygon(arrowPoints[0], arrowPoints[1], pointCount);
        g2d.drawPolygon(arrowPoints[0], arrowPoints[1], pointCount);
        QGraphics.navArrowBuffered[0] = navArrowIm;
        g2d.dispose();
        return navArrowIm;
    }

    public static BufferedImage getRotatedImage(BufferedImage imageToRotate, double degreesOfRotation) {
        int canvWidth = imageToRotate.getWidth();
        int canvHeight = imageToRotate.getHeight();
        boolean xTransl = false;
        boolean yTransl = false;
        int xRot = imageToRotate.getWidth() / 2;
        int yRot = imageToRotate.getHeight() / 2;
        BufferedImage rotatedIm = new BufferedImage(canvWidth, canvHeight, 2);
        Graphics g = rotatedIm.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform identityQ = new AffineTransform();
        AffineTransform trans = new AffineTransform();
        trans.setTransform(identityQ);
        trans.translate((double)xTransl, (double)yTransl);
        trans.rotate(Math.toRadians(degreesOfRotation), xRot, yRot);
        g2d.drawImage(imageToRotate, trans, null);
        g2d.dispose();
        return rotatedIm;
    }

    public static BufferedImage getRotatedImage(BufferedImage imageToRotate, double degreesOfRotation, float transparency) {
        Dimension size = new Dimension();
        size.width = imageToRotate.getWidth(null);
        size.height = imageToRotate.getHeight(null);
        BufferedImage rotatedIm = new BufferedImage(size.width, size.height, 3);
        Graphics g = rotatedIm.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform identityQ = new AffineTransform();
        AffineTransform trans = new AffineTransform();
        trans.setTransform(identityQ);
        trans.translate(0.0, 0.0);
        trans.rotate(Math.toRadians(degreesOfRotation), 7.0, 7.0);
        g2d.setComposite(AlphaComposite.getInstance(3, transparency));
        g2d.drawImage(imageToRotate, trans, null);
        g2d.dispose();
        return rotatedIm;
    }

    public static void setDrawSizes() {
    }

    public int location(int boardX, int boardY, int boardRot, int x, int y) {
        int a = 0;
        switch (boardRot) {
            case 0: {
                a = x + (boardY - 1 - y) * boardX;
                break;
            }
            case 1: {
                a = (12 - x) * 13 + y;
                break;
            }
            case 2: {
                a = boardX - 1 - x + (boardY - 1 - y) * boardX;
                break;
            }
            case 3: {
                a = x * 13 + 12 - y;
            }
        }
        return a;
    }

    public static void setZoom(int zoomLoc, int x, int y, double radius) {
        centerSqLoc = zoomLoc;
        radiusSeen = radius;
        if (radiusSeen < 1.0) {
            radiusSeen = 1.0;
        }
        QGraphics.updateZoomedIn();
    }

    public static void setZoom(String xy, double radius) {
        char x = xy.charAt(0);
        char y = xy.charAt(1);
        centerSqLoc = QSFUtils.hexCharsToLoc(x, y);
        radiusSeen = radius;
        if (radiusSeen < 1.0) {
            radiusSeen = 1.0;
        }
        System.out.println("static radiusSeen is " + radiusSeen);
        QGraphics.updateZoomedIn();
    }

    public static void resetZoom() {
        radiusSeen = radiusSeenDefault;
        centerSqLoc = centerSqLocDefault;
    }

    public static void receiveMouseZoom(int x, int y) {
        if (x < xTop) {
            return;
        }
        x -= xTop;
        if (y < yTop) {
            return;
        }
        int xSquare = x / ss;
        int ySquare = (y -= yTop) / ss;
        centerSqLoc = QGraphics.location(xSquare, ySquare);
        if (radiusSeen < 1.0) {
            radiusSeen = 1.0;
            return;
        }
        radiusSeen = isMiniBoard ? (radiusSeen + 3.0) % 5.0 : (radiusSeen + 5.0) % 8.0;
        if (radiusSeen < 1.0) {
            radiusSeen = 1.0;
        }
        System.out.println("radiusSeen is " + radiusSeen);
        if (radiusSeen >= radiusSeenDefault - 1.0) {
            radiusSeen = radiusSeenDefault;
            centerSqLoc = centerSqLocDefault;
        }
        QGraphics.updateZoomedIn();
    }

    public static int gridX(int loc) {
        return QGraphics.gridX(boardRotation, loc);
    }

    public static int gridX(int boardRotation, int loc) {
        int X = 0;
        switch (boardRotation) {
            case 0: {
                X = loc % 13;
                break;
            }
            case 1: {
                X = 12 - loc / 13;
                break;
            }
            case 2: {
                X = 12 - loc % 13;
                break;
            }
            case 3: {
                X = loc / 13;
            }
        }
        return X;
    }

    public static int gridY(int loc) {
        return QGraphics.gridY(boardRotation, loc);
    }

    public static int gridY(int boardRotation, int loc) {
        int Y = 0;
        switch (boardRotation) {
            case 0: {
                Y = loc / 13;
                break;
            }
            case 1: {
                Y = loc % 13;
                break;
            }
            case 2: {
                Y = 12 - loc / 13;
                break;
            }
            case 3: {
                Y = 12 - loc % 13;
            }
        }
        return Y;
    }

    public static int mouseToLoc(int x, int y) {
        return 1;
    }

    public static int location(int x, int y) {
        int a = 0;
        switch (boardRotation) {
            case 0: {
                a = x + y * 13;
                break;
            }
            case 1: {
                a = (12 - x) * 13 + y;
                break;
            }
            case 2: {
                a = 12 - x + (12 - y) * 13;
                break;
            }
            case 3: {
                a = x * 13 + 12 - y;
            }
        }
        return a;
    }

    public static BufferedImage getOptionsImage(boolean[] legalOptions) {
        BufferedImage optionsImage = new BufferedImage(canvasSize, canvasSize, 3);
        Graphics g = optionsImage.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(boardColourLight);
        int y = 0;
        while (y < boardY) {
            int x = 0;
            while (x < boardX) {
                g2d.fillOval((x + 1) * ss, (y + 1) * ss, ss, ss);
                ++x;
            }
            ++y;
        }
        g2d.dispose();
        return optionsImage;
    }

    public static int getHeight() {
        return ht;
    }

    public static void setHeight(int boardPanelHeight) {
        ht = boardPanelHeight;
    }

    public static int getWidth() {
        return wd;
    }

    public static void setWidth(int boardPanelWidth) {
        wd = boardPanelWidth;
    }

    public static void setHeightAndWidth(int boardPanelHeight, int boardPanelWidth) {
        ht = boardPanelHeight;
        wd = boardPanelWidth;
    }

    public static void rotateBoard(int quartersClockwise) {
        boardRotation = (boardRotation + quartersClockwise) % 4;
        System.out.println("boardRotation is " + boardRotation);
    }

    public static void setBoardRotation(int boardRot) {
        boardRotation = boardRot;
        System.out.println("boardRotation is " + boardRotation);
    }

    public static int getXTop() {
        return xTop;
    }

    public static int getYTop() {
        return yTop;
    }

    public static int getBoardPanelSize() {
        return boardPanelSize;
    }

    public static void setBoardPanelSize(int boardPanelSize) {
        QGraphics.boardPanelSize = boardPanelSize;
        System.out.println("setting boardPanelSize to " + boardPanelSize);
    }

    public static void setReDrawBoardFlag() {
        reDrawBoardFlag = true;
    }

    public static boolean fetchBoardReDefinitionFlag() {
        System.out.println("boardReDefinitionFlag is fetched");
        boolean flag = reDrawBoardFlag;
        reDrawBoardFlag = false;
        return flag;
    }

    public static void toggleZoomByRClick() {
        canZoomByRClick = !canZoomByRClick;
        System.out.println("canZoomByRClick is " + canZoomByRClick);
    }

    public static void setRadiusSeenDefault(double radiusSeenDefault) {
        QGraphics.radiusSeenDefault = radiusSeenDefault;
        radiusSeen = radiusSeenDefault;
        System.out.println("QGraphics.setRadius to is " + radiusSeen);
    }

    private static void updateZoomedIn() {
        isZoomedIn = radiusSeen < radiusSeenDefault;
    }
}

