/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.core;

import com.quincala.core.QPlyPosition;
import com.quincala.core.QRules;
import com.quincala.core.QWholeLineData;
import java.util.ArrayList;

public class QGameLine {
    public boolean doConstruction = false;
    public int turnsInLine = 0;
    public boolean lastPlyIsIllegal = false;
    public boolean hasRedundantPlies = false;
    public boolean isSealed = false;
    public boolean isPosted = false;
    public int resignInt = -1;
    public int winnerInt = -1;
    public String winnerString = "";
    public QWholeLineData lineData = new QWholeLineData();
    protected String titleString = "";
    public int branchNo = 0;
    public QPlyPosition xPosition = new QPlyPosition();
    public QPlyPosition[] markers;
    private int markerCount = 2;
    public String setUpString = "";
    public String markedPlyString = "";
    public String purePlyString = "";
    public String locString = "";
    public int loadEndPlyPos = 0;
    public int loadEndTurnNo = 1;
    public boolean isLoadEndTurnOpen = false;
    public StringBuffer markedPlyStringBfr = new StringBuffer("");
    public StringBuffer purePlyStringBfr = new StringBuffer("");
    public int plyPos = 0;
    public int locPos = 0;
    public int xPos = -1;
    public int markingsOffset = 0;
    public int turnCount = 0;
    public int lastBranchIndex = 0;
    public boolean addBranchToMatchInfo = false;
    public int lastTurnIndex = 0;
    public int lastTurnPhaseIndex = 0;
    public int releaseCount = 0;

    public void resetGameLine() {
        this.setPlyPos(0);
        this.markedPlyString = "";
        this.markingsOffset = 0;
        this.lastBranchIndex = 0;
        this.lastTurnIndex = 0;
        this.lastTurnPhaseIndex = 0;
    }

    public void setPlyPos(int currentPos) {
        this.plyPos = currentPos;
    }

    public String getMarkedPlyString() {
        String markedPString = this.markedPlyStringBfr.toString();
        return markedPString;
    }

    public String getPurePlyString() {
        String purePString = this.purePlyStringBfr.toString();
        return purePString;
    }

    public String getMarkedPlyStringToCurrent() {
        String b = this.markedPlyStringBfr.substring(0, this.plyPos);
        System.out.println("MarkedPlyStringToCurrent is " + b);
        return b;
    }

    public String getMarkedStem() {
        char ch;
        if (this.plyPos == 0) {
            System.out.println("PROGRAMMING ERROR: line.getMarkedStem is reached from starting position!");
            return "";
        }
        int markedBufferLength = this.markedPlyStringBfr.length();
        StringBuffer stem = new StringBuffer(0);
        int coordCount = 0;
        int breakIndex = 0;
        int i = 0;
        while (i < markedBufferLength) {
            ch = this.markedPlyStringBfr.charAt(i);
            if (ch == 'r') {
                ++coordCount;
                stem.append(ch);
                if (++i >= markedBufferLength) break;
                ++coordCount;
                stem.append(this.markedPlyStringBfr.charAt(i));
            } else if (ch > 'r') {
                stem.append(ch);
            } else {
                ++coordCount;
                stem.append(ch);
            }
            if (coordCount >= this.plyPos) {
                breakIndex = i;
                break;
            }
            ++i;
        }
        i = breakIndex + 1;
        while (i < markedBufferLength) {
            ch = this.markedPlyStringBfr.charAt(i);
            if (ch <= 'r') break;
            stem.append(ch);
            System.out.println("stem is " + stem.toString());
            ++i;
        }
        return stem.toString();
    }

    public void addToMarkedPlyString(String plyStringToAdd) {
        this.markedPlyStringBfr.append(plyStringToAdd);
        this.analyzeBuffers();
    }

    public void setMarkedPlyString(String markedPlyString) {
        this.markedPlyStringBfr = new StringBuffer(markedPlyString);
        this.isSealed = true;
        this.analyzeBuffers();
    }

    public void cropFourOffMarkedPlyString(int cropPlyPos) {
        System.out.println("CROPPING!");
        int cropCount = 0;
        int i = this.getMarkedPlyPos(cropPlyPos) - 1;
        while (cropCount < 4) {
            if (this.markedPlyStringBfr.charAt(i) < 's') {
                this.markedPlyStringBfr.deleteCharAt(i);
                ++cropCount;
            }
            --i;
        }
        this.analyzeBuffers();
    }

    public void capMarkedPlyString(int capPlyPos) {
        int newLength = this.getMarkedPlyPos(capPlyPos);
        this.markedPlyStringBfr.setLength(newLength);
        this.analyzeBuffers();
    }

    private int getMarkedPlyPos(int currentPlyPos) {
        int markedLength = this.markedPlyStringBfr.length();
        int ppP = 0;
        int i = 0;
        while (i < markedLength) {
            if (ppP == currentPlyPos) break;
            if (this.markedPlyStringBfr.charAt(i) < 's') {
                ++ppP;
            }
            ++i;
        }
        return i;
    }

    public void setSetUpString(String setUpStringToSet) {
        this.setUpString = setUpStringToSet;
    }

    public void analyzeBuffers() {
        int mrkdPlStrngLength = this.markedPlyStringBfr.length();
        int i = mrkdPlStrngLength - 1;
        while (i >= 0) {
            char testChar = this.markedPlyStringBfr.charAt(i);
            if (testChar == ' ' || testChar == '\u00a0') {
                char textCharInt = this.markedPlyStringBfr.charAt(i);
                this.markedPlyStringBfr.deleteCharAt(i);
                System.out.println("removed " + textCharInt + " char at " + i);
            }
            --i;
        }
        this.markedPlyString = this.markedPlyStringBfr.toString();
        this.purePlyStringBfr = new StringBuffer();
        int markedLength = this.markedPlyStringBfr.length();
        int i2 = 0;
        while (i2 < markedLength) {
            char ci = this.markedPlyStringBfr.charAt(i2);
            if (ci == 'r') {
                this.purePlyStringBfr.append(ci);
                if (i2 < markedLength - 1) {
                    this.purePlyStringBfr.append(this.markedPlyStringBfr.charAt(i2 + 1));
                    ++i2;
                }
            } else if (ci != 'x' && ci <= 'r') {
                this.purePlyStringBfr.append(ci);
            }
            ++i2;
        }
        this.purePlyString = this.purePlyStringBfr.toString();
        this.isValidPurePlyString();
        int plyStringLength = this.purePlyStringBfr.length();
        this.hasRedundantPlies = false;
        int i3 = plyStringLength - 2;
        while (i3 >= 0) {
            if (!QRules.gameHead.equalsIgnoreCase("Quincala")) break;
            String stringLet = this.purePlyStringBfr.substring(i3, i3 + 2);
            if (stringLet.equals("56") || stringLet.equals("76")) {
                this.hasRedundantPlies = true;
                this.purePlyStringBfr.delete(i3, i3 + 2);
            }
            if (stringLet.equals("66") || stringLet.equals("r9")) {
                this.purePlyStringBfr.replace(i3, i3 + 2, "rt");
            }
            if (stringLet.equals("r3")) {
                System.out.println("r3 is found!! and converted");
                this.purePlyStringBfr.replace(i3, i3 + 2, "rg");
            }
            i3 -= 2;
        }
        this.purePlyString = this.purePlyStringBfr.toString();
        int plyPosCount = 0;
        int markedBrfLngth = this.markedPlyStringBfr.length();
        int i4 = 0;
        while (i4 < markedBrfLngth) {
            char testChar = this.markedPlyStringBfr.charAt(i4);
            if (testChar < 's') {
                ++plyPosCount;
            } else if ((testChar == 'x' || testChar == 'v') && this.xPos < 0) {
                this.setPlyPos(plyPosCount);
                this.xPos = plyPosCount;
                if (this.xPos % 2 == 0) {
                    this.xPosition.setZeroplyBrake(false);
                } else {
                    ++this.xPos;
                }
                this.xPosition.setPurePlyString(this.purePlyString.substring(0, this.xPos));
            }
            ++i4;
        }
        QPlyPosition endPosition = new QPlyPosition();
        endPosition.setPurePlyString(this.purePlyString);
        ArrayList<QPlyPosition> markerList = new ArrayList<QPlyPosition>(2);
        markerList.add(0, new QPlyPosition());
        markerList.add(1, endPosition);
        if (this.xPos == 0) {
            markerList.remove(0);
            markerList.add(0, this.xPosition);
        } else if (this.xPos == this.purePlyString.length() - 1) {
            markerList.remove(1);
            markerList.add(1, this.xPosition);
        } else {
            markerList.add(1, this.xPosition);
        }
        this.markers = markerList.toArray(new QPlyPosition[markerList.size()]);
        int i5 = 0;
        while (i5 < this.markers.length) {
            ++i5;
        }
    }

    public boolean forwardStepAvailable() {
        return this.locPos < this.locString.length();
    }

    public boolean backStepAvailable() {
        return this.locPos > 0;
    }

    public String getStepLocString(int stepValue) {
        String extract = "";
        if (stepValue == 1) {
            extract = String.valueOf(extract) + this.locString.substring(this.locPos, this.locPos + 2);
        }
        if (stepValue == 0) {
            extract = String.valueOf(extract) + this.locString.substring(0, this.locPos);
        }
        if (stepValue == -1) {
            extract = String.valueOf(extract) + this.locString.substring(0, this.locPos - 2);
        }
        return extract;
    }

    public void addToLocPos(int locPosAddition) {
        this.locPos += 2 * locPosAddition;
    }

    public String getLocStringToLocPos(int locPos) {
        String extract = this.locString.substring(0, locPos);
        return extract;
    }

    public String getPosStringWithFuture(boolean brake) {
        StringBuffer sb = new StringBuffer(this.purePlyStringBfr.toString());
        if (brake) {
            if (this.plyPos > 0) {
                sb = sb.insert(this.plyPos - 1, "x");
            }
        } else if (this.plyPos > 0) {
            sb = sb.insert(this.plyPos, "x");
        }
        return sb.toString();
    }

    public String getPosStringNoFuture(boolean brake) {
        System.out.println("purePlyStringBfr is " + this.purePlyStringBfr.toString());
        String result = this.getPosStringWithFuture(brake);
        if (result.length() > this.plyPos) {
            result = result.substring(0, this.plyPos + 1);
        }
        return result;
    }

    public String getStepString(int stepValue) {
        String extract = "";
        if (stepValue > 0) {
            extract = String.valueOf(extract) + this.purePlyString.substring(this.plyPos, this.plyPos + 2);
        }
        if (stepValue == 0) {
            extract = this.purePlyString.substring(0, this.plyPos);
        }
        if (stepValue < 0) {
            extract = this.purePlyString.substring(0, this.plyPos - 2);
        }
        return extract;
    }

    public void addToPlyPos(int plyPosAddition) {
        this.plyPos += 2 * plyPosAddition;
    }

    public QPlyPosition getNextMarkerPlyPos() {
        System.out.println("markers.length is " + this.markers.length);
        int markerIndex = this.markers.length - 1;
        int i = 0;
        while (i < this.markers.length) {
            if (this.markers[i].plyPosInt > this.plyPos) {
                markerIndex = i;
                break;
            }
            ++i;
        }
        QPlyPosition nextPos = this.markers[markerIndex];
        return nextPos;
    }

    public QPlyPosition getPreviousMarkerPlyPos(boolean lastIsZeroPly) {
        int markerIndex = 0;
        int i = this.markerCount - 1;
        while (i >= 0) {
            if (this.markers[i].plyPosInt < this.plyPos) {
                markerIndex = i;
                break;
            }
            if (this.markers[i].plyPosInt == this.plyPos && lastIsZeroPly && this.markers[i].zeroplyBrake) {
                markerIndex = i;
                break;
            }
            --i;
        }
        return this.markers[markerIndex];
    }

    private boolean isValidPurePlyString() {
        boolean validity = true;
        int stringLength = this.purePlyString.length();
        if (stringLength % 2 == 1) {
            validity = false;
        }
        return validity;
    }

    public void setWholeLineData(QWholeLineData info) {
        this.lineData = info;
        if (this.lineData.isSealed) {
            this.isSealed = true;
        }
        this.lineData.setSealed(this.isSealed);
        this.turnsInLine = info.TurnsInLine;
        this.winnerInt = info.winnerInt;
    }

    public void addToLocString(String addition) {
        this.locString = String.valueOf(this.locString) + addition;
        this.locString.length();
    }

    public void setLocString(String locString) {
        this.locString = locString;
    }

    public void setLocPos(int locPos) {
        this.locPos = locPos;
        this.locString.length();
    }

    public void setSealedTrue() {
        this.isSealed = true;
        System.out.println("QGameLine.isSealed is " + this.isSealed);
    }

    public boolean isIllegalPly() {
        return this.lastPlyIsIllegal && this.plyPos == this.purePlyStringBfr.length();
    }

    public void setDoConstructionTrue() {
        this.doConstruction = true;
    }

    public void setLoadEndTurnOpen(boolean isLoadEndTurnOpen) {
        this.isLoadEndTurnOpen = isLoadEndTurnOpen;
    }

    public void setLoadEndPlyPos(int loadEndPlyPos) {
        this.loadEndPlyPos = loadEndPlyPos;
    }

    public void setLoadEndTurnNo(int loadEndTurnNo) {
        this.loadEndTurnNo = loadEndTurnNo;
    }

    public void setLineTitle(String lineTitle) {
        char branchIndicator;
        String branchIndicatorString;
        this.titleString = lineTitle;
        System.out.println("lineTitle is set as " + lineTitle);
        this.addBranchToMatchInfo = false;
        this.branchNo = 0;
        String[] splitMatchInfo = lineTitle.split("branch");
        if (splitMatchInfo.length > 1 && (branchIndicatorString = splitMatchInfo[1].trim()).length() > 0 && Character.isDigit(branchIndicator = branchIndicatorString.charAt(0))) {
            this.branchNo = Character.getNumericValue(branchIndicator);
            System.out.println("branchNo is " + this.branchNo);
        }
    }

    public String getTitle() {
        if (this.titleString.length() == 0) {
            return "";
        }
        String title = this.titleString;
        if (this.addBranchToMatchInfo) {
            String[] splitMatchInfo = this.titleString.split("branch");
            title = splitMatchInfo.length > 1 ? String.valueOf(title) + ".?" : String.valueOf(title) + " branch ?";
        }
        return title;
    }

    public QWholeLineData getWholeLineData() {
        this.lineData.setTitleString(this.getTitle());
        return this.lineData;
    }

    public void setLastPlyIsIllegal(boolean lastPlyIsIllegal) {
        this.lastPlyIsIllegal = lastPlyIsIllegal;
    }

    public void setBranchNo(int branchNo) {
        this.branchNo = branchNo;
    }

    public void setPosted(boolean isPosted) {
        this.isPosted = isPosted;
    }

    public void setAddBranchToMatchInfo(boolean isBranch) {
        this.addBranchToMatchInfo = isBranch;
    }
}

