/*
 * Decompiled with CFR 0.152.
 */
package com.quincala.core;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.jnlp.ClipboardService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class QClipBoardBridge {
    public static void copyWS(String stringToCopy) {
        ClipboardService cs;
        try {
            cs = (ClipboardService)ServiceManager.lookup("javax.jnlp.ClipboardService");
        }
        catch (UnavailableServiceException e) {
            cs = null;
            System.out.println("caught: cs is null");
        }
        if (cs != null) {
            StringSelection ss = new StringSelection(stringToCopy);
            cs.setContents(ss);
        }
    }

    public String pasteWS() {
        Transferable tr;
        ClipboardService cs;
        String s = "";
        try {
            cs = (ClipboardService)ServiceManager.lookup("javax.jnlp.ClipboardService");
        }
        catch (UnavailableServiceException e) {
            cs = null;
            System.out.println("caught: cs is null");
        }
        if (cs != null && (tr = cs.getContents()).isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                s = (String)tr.getTransferData(DataFlavor.stringFlavor);
                System.out.println("Clipboard contents: " + s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    public static void putStringOnClipboard(String stringToCopy) {
        StringSelection s = new StringSelection(stringToCopy);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(s, s);
    }

    public String getStringOnClipBoard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable data = clipboard.getContents(this);
        String stringFromClipBoard = "";
        try {
            stringFromClipBoard = (String)data.getTransferData(DataFlavor.stringFlavor);
            System.out.println("clipboard has string: " + stringFromClipBoard);
        }
        catch (Exception ex) {
            System.out.println("error message: " + data.toString());
        }
        DataFlavor[] flavourList = data.getTransferDataFlavors();
        System.out.println("flavourList.length is " + flavourList.length);
        if (flavourList.length > 0) {
            System.out.println("flavourList[0].getHumanPresentableName() is " + flavourList[0].getHumanPresentableName());
            System.out.println("flavourList[0].getMimeType() is " + flavourList[0].getMimeType());
        }
        return stringFromClipBoard;
    }
}

