/*
**********************************************************************
*                        License Notice
*
* QGameLabsGUI.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd 2010.
* All Rights Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/

package com.quincala.gui2D;

/*
 * working from page 379
 */

import javax.swing.*;

import java.awt.event.*;
import java.awt.*;
import javax.swing.plaf.*;
import javax.swing.event.*;
import java.io.*;

import java.util.List;



import java.text.DateFormat;
import java.util.*;

//import com.quincala.*;
//nope, would be too easy; each package has to be imported separately ...

import com.quincala.gamequincala.*;
import com.quincala.gloife.*;
//import com.quincala.gamequincala.QuincalaGUITransitional.GridListener;
import com.quincala.core.*;
//import com.quincala.core.QRules.*;//no - look up how to shorten calls?



public class QGameLabsGUI extends QApplication {
//	public class QGameLabsGUI extends QApplet {

	/*
	 * to convert to applet; just swap above!
	 */

	/*
	 * to convert to applet, copy in the name
	 * QGameLabsApplet, then just swap above
	 * also in licence
	 * not deleting
	 * frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	 * seems OK ???
	 */


	/*
	 * Old text:
	 * for conversion to applet, also:
	 * set QRules.isAppletViewer to true
	 * rename go() to init(); also in qGateway()!!
	 * comment out second line:
	 * //frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	 * copy all bin/com files to X:/Quincala software/com
	 * maybe update java.policy.applet occasionally??
	 * How to delete the old jFrame in applet???
	 */


	//session backup:



	//if showConstruction = true, this test string will be loaded at startup
//	String testQString = "qui356061615748486463626161bbaa9988886143436c6b6b3344446b6a6a43252636x778888";//simple releasing test
	//String testQString = "qui35554433443588983526";
	String testQString = "";
	//TODO use the QRules testQstring with boolean!
	//also doConstruction!


	//Build Values:

	//only for linux with bottom bar arrow ...
	private boolean maximus = false;//for UNR on netbooks
	//the is the version that is optimised for the asus EEE PC 1000 running UNR

//	public String[] textSizeChoices = {"10", "11", "12", "13", "14", "16", "18", "20", "22"};//3
//	public int textSizeIndexOnLoad = 3;
	public String[] textSizeChoices = {"22", "20", "18", "16", "14", "13", "12", "11", "10"};
	public int textSizeIndexOnLoad = 4;
	public int guiTextSize = 0;//is set from both above in init()!

	//USER RULES
	//TODO MIGRATE THESE TO QRULES TOO!
	public boolean enableImmunity = true;
	public boolean enableIR = false;
	//END USER RULES

	public boolean showRulesOptions = false;
	public boolean showControlPanel = true;
	public boolean showTextInputField = false;//set both these false in 0.9+
	private boolean showTextInputFieldDefault = false;

	private boolean showSessionBackupCheckBox = QBuildParameters.tournamentEdition &&
	!QBuildParameters.useJNLPServices && !isApplet;

	public boolean showBrowserWindow = false;
	private boolean showLegalText = false;

	private boolean doSessionBackup = QBuildParameters.tournamentEdition;
	//i.e. if enabled its on, otherwise off!
	public boolean showOptions = false;//implemented!
	//GUI modes
	private boolean showToolTips = true;
	private boolean showArrows = true;
	private boolean showRelHandles = true;
	//private boolean autoCopyStringField = true;//obsolete

	public String[] speedChoices = {"30", "60", "120", "180", "240"};
	public int speedIndexOnLoad = 2;


	//End Build Values

	private boolean tooLateStrings = false;
	/*
	 * this goes true if a qsf version higher
	 * than the software can take is entered
	 * it will only go false again if a new
	 * qsf version string with a low enough
	 * version is entered.
	 */

	private String errorFlag = "";

//	QGeneralTexts myTexts = new QGeneralTexts();
	QGraphics boardGraphics = new QGraphics();
	int turnNumberTest = 0;//for testing only
	public boolean clickableBoard = true;//needed?
	//allows mouselistener to accept clicks: read from the gamewidget?

	//private boolean showLegal = false;
	//this directs if legal options are shown on the board
	//kept on the board panel ...

	private int functionBarMode = 1;
	//start on 1; set to 0 if click on board
	private String copyMode;
	public boolean stateOutMode = false;
	//depreciated; always output title if present
	public boolean wrapMode;

	//these are defining the current game board: SHOULD BE IN QRULES!!!
	private String currentGameHead = "qui";//qui, brd: error!, glf, chs, go_, hnf
	//start of a QString; determines what game to launch/display
	public String currentGameLoaded = "Quincala 3.5";
	public String gameName = "Quincala";
	public int gameVersion = 1;
	//TODO loads default to mixing game; maybe get this in init?
	public int gameVariant = 5;//abstract enough?
	//public String headTitleString = "Quincala Game Labs 0.6 - ";
	public String headTitleString;
	//public String matchInfoText = "";
	public int passFlag = -1;
//	public String mainTitleText = headTitleString + currentGameLoaded + matchInfoText;//transitional
	public String mainTitleText;

	public String inputFieldDefaultText = "Input Box";

	public int boardX = 13;
	public int boardY = 13;
	double boardProportion = 1.0d;
	int infoPanelMinimumX = 200;

	private int playerDelay = 500;//default speed is 120
	//should default speed be saved til next session? in userdata.dat?
	//how long the player waits between each step




	//these values are manipulated by getGameStatus()
	//and used in GUI
	public boolean forwardAvailable = false;
	public boolean backwardAvailable = false;
	public boolean doPlay = false;
	//step player uses it to convey that it is working;
	//maybe just disable the other buttons? also Gridlistener!
	public int currentTurnNo = 1;
	public int playerNo = 0;

//	public int GameVersion = 3;
//	public int GameVariant = 5;
	//public QXLauncher myLauncher = new QXLauncher();
	//not needed to instantiate this; static methods are called directly on class!

	//Font functionBarFont;
	//initi this one here or, metter system??
//	Font functionBarFont = new Font("serif", Font.BOLD, guiTextSize);
	Font functionBarFont;
	Font textBoxFont;
	Font legalTextFont;
	Font copyModeFont;


//	JFrame frame;

	JMenuBar browserMenuBar;//or in init menubar?
	JMenu browserPortalMenu;
	JMenuItem localPortalAction;


	JMenuBar topMenuBar;//or in init menubar?

	JMenu gameMenu;

	JMenuItem sameGameAction;

	JMenu quincalaPosEditSubmenu;
	JMenuItem qPosEditWith5Sizes;
	JMenuItem qPosEditWith4Sizes;
	JMenuItem qPosEditWith3Sizes;

	JMenu miniQuincalaSubmenu;
	JMenuItem miniQuincalaKnocking;
	JMenuItem miniQuincalaMixing;

	JMenu quincalaStandardSubmenu;
	JMenuItem qReleaseWith5Sizes;
	JMenuItem qReleaseWith4Sizes;
	JMenuItem qReleaseWith3Sizes;

	JMenu quincalaKnockingSubmenu;
	JMenuItem qKnockingWith5Sizes;
	JMenuItem qKnockingWith4Sizes;
	JMenuItem qKnockingWith3Sizes;


	JMenuItem quincalaFootballNew;


	JMenu quincalaMixingSubmenu;
	JMenuItem qMixingWith5Sizes;
	JMenuItem qMixingWith4Sizes;
	JMenuItem qMixingWith3Sizes;

	JMenuItem quincalaBouncingNew;
	JMenuItem quincalaUnlimitedNew;


	JMenu viewMenu;
	JCheckBoxMenuItem viewRulesOptions;
	JCheckBoxMenuItem viewControlPanel;
	JMenuItem textSizesMenuItem;
	JCheckBoxMenuItem viewTextInputField;//only in 0.9+
	JMenuItem zoomTextEntry;
	JMenuItem resetZoomItem;

	//==text sizes until here

	JMenu actionMenu;
	JMenuItem resignActionItem;
	JMenuItem agreeDrawActionItem;
	JMenuItem PassActionItem;
//	JCheckBoxMenuItem viewTextInputField;//only in 0.9+

	JMenu helpMenu;
	JMenuItem homePageItem;
	JMenuItem onlineHelpItem;
	JMenuItem ruleSheetItem;
	JMenuItem onlineScoresItem;
	JMenuItem onlineTutorialsItem;
	JMenuItem legalItem;

	JSplitPane mainPane;//try QSplitPane?? or QSplitPaneListener?
	QGamePanel currentBoard;
	JPanel drawPanel;//type :-)


	JPanel infoPanel = new JPanel();
	JPanel checkPanel0;
	JPanel checkPanel1;
	JPanel checkPanel2;
	JPanel checkPanel3;
	JPanel checkPanel4;
	JPanel functionBar = new JPanel();

//	JTextArea wholeLineDataBox;//to be replaced by:
	JScrollPane wholeLineDataScrollPane;
	//TODO try to put scrollpane after and not in go()
	JEditorPane wholeLineDataPane = new JEditorPane();


	JTextArea matchBox;
	JTextArea legalTextBox;
	//JScrollPane scrollPane;//needs a container??
	JScrollPane legalTextScrollPane;
	JEditorPane quincalaBrowser = new JEditorPane();


	//JButton buttons - needs to go here to toggle text & font?
	JCheckBox ImmunityRuleBn;
	JCheckBox IRBn;
	JCheckBox sessionBackupCheckBox;
	JCheckBox toggleShowOptionsButton;
	JCheckBox showArrowsBn;
	JCheckBox showRelHandlesBn;
	JCheckBox rightClickZoomChBox;
	JButton historyOutBn;
	JCheckBox showToolTipBn;
	JButton testNewGenerationBn;
	JButton functionButton;
	JButton previousMarkerButton;
	JButton backwardButton;
	JButton playButton;
	JButton forwardButton;
	JButton nextMarkerButton;
	JButton rotateBoardButton;
	JLabel turnLabel;
	JTextField turnNumberField;
	JLabel maxTurnLabel;

	JButton addXButton;
	JButton addZButton;
	JButton pZButton;
	JButton rPZButton;
	JButton titleButton;//obsolete?

	JButton copyButton = new JButton();//needed?
	JRadioButton scoreOutModeBn;
	JRadioButton correspondenceOutModeBn;
	JRadioButton posNoFutureOutModeBn;
	JRadioButton posWithFutureOutModeBn;
	JRadioButton purePositionOutModeBn;//will be implemented later!
	JRadioButton gifOutModeBn;
	ButtonGroup copyModes;
	JCheckBox stateOutModeBn;
	JCheckBox wrapModeBn;

	JButton pasteButton;
	JTextField inputField;
	//JButton loadStringButton;

	JLabel setSpeedLabel;
	JComboBox speedChoser;

	JLabel setTextSizeLabel;
	JComboBox textSizeChoser;

	JLabel statusLabel;

	JButton helpButton;
	JButton legalButton;

//	ImageIcon pageDownArrowIcon = createImageIcon("icons/pageUp.gif");
//	ImageIcon pageDownArrowIcon;
//	ImageIcon downArrowIcon = createImageIcon("icons/up.gif");
//	ImageIcon downArrowIcon;
	//playArrowIcon
	//ImageIcon upArrowIcon = createImageIcon("icons/down.gif");
//	ImageIcon upArrowIcon;
//	ImageIcon upArrowIcon = new ImageIcon(QGraphics.navArrowIm);
//	ImageIcon pageUpArrowIcon = createImageIcon("icons/pageDown.gif");
//	ImageIcon pageUpArrowIcon;





	public static void main (String[] args){
		/*
		 * this is never run when in
		 * applet context!
		 */

		QGameLabsGUI gui =  new QGameLabsGUI();
		gui.initialise();
		//must not be init() - confuses Applet!!
		gui.go();

		//temporary until zoom for mini board is sorted!
		gui.rightClickZoomChBox.setEnabled(!QGraphics.isMiniBoard);
		gui.zoomTextEntry.setEnabled(!QGraphics.isMiniBoard);
		gui.resetZoomItem.setEnabled(!QGraphics.isMiniBoard);


		if (QBuildParameters.loadTestString)
			gui.setWildQSFString(QBuildParameters.testQString);

		gui.writeSessionBackup();

	}

	public void initialise(){

		System.out.println("QSessionManager.sessionName is " + QSessionManager.sessionName);
		//This could be used to set initial values, such as
		headTitleString = "Quincala Game Viewer";
		if(QBuildParameters.maySaveToDisk){
			headTitleString = "Quincala Game Labs";
		}
		//also make gui graphics such as navigation arrow icons etc
		guiTextSize = Integer.parseInt(textSizeChoices[textSizeIndexOnLoad]);
//		setTextSizes();//requires buttons etc to be made; put in go()!

		QGraphics.initQGraphics(guiTextSize);


		UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
		//otherwise tab enter will not select new button!

		//while the above works a treat, the below doesn't :-(
		UIManager.put("JRadioButton.defaultButtonFollowsFocus", Boolean.TRUE);

	}

	public void go(){
		//JFrame.setDefaultLookAndFeelDecorated(true);

		legalTextScrollPane = new JScrollPane(quincalaBrowser);
		wholeLineDataScrollPane = new JScrollPane(wholeLineDataPane);
		//scrollpanes seems to have to be made before creating JFrame ...

//		this has to be in front of frame creator to work with maximus in UNR!
		manageWindowManagers();//Test this!

		setCloseOperation();
		//performs this:
//		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);



		//myTexts.setMainTitleText();
		//frame.setTitle(myTexts.mainTitelText);//make dynamic!


		switchBoard();//is a kind of initBoard() ...
		initInfoPanel();
		//refreshInfoText();//must be after switchBoard and initInfoPanel, which initiates linedata etc




		mainPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,true,
				currentBoard,infoPanel);
		mainPane.setOneTouchExpandable(true);
		mainPane.addComponentListener(new SplitPaneListener());
		mainPane.addMouseListener(new DividerSnapBackListener());
//		frame.addMouseListener(new DividerSnapBackListener());

		Dimension infoMinSize = new Dimension(infoPanelMinimumX,400);
		infoPanel.setMinimumSize(infoMinSize);
		Dimension boardMinSize = new Dimension(500,500);
		currentBoard.setMinimumSize(boardMinSize);
		mainPane.setPreferredSize(new Dimension(930, 510));
		mainPane.setBackground(new Color(230,230,230));//table cloth colour


		initMenuBar();
		initFunctionBar();



		getGameStatus();
		setToolTips();
		setShowOptions();

		//experimenting with menu bar - globalise
		//and make initMenuBar(), maybe refreshMenuBar()
		//to make it context sensitive?
		//also shortcuts!! globalise??


//		guiTextSize = Integer.parseInt(textSizeChoices[textSizeIndexOnLoad]);//done in init()
		setTextSizes();

		setJMenuBar(topMenuBar);

		getContentPane().add(BorderLayout.SOUTH, functionBar);
		getContentPane().add(BorderLayout.CENTER, mainPane);


//		UIManager.put("ToolTip.font",
//		new FontUIResource("SansSerif", Font.BOLD, 16));
		//needs package javax.swing.plaf.*;

//		pack();
		packApplication();
		/*
		 * using both pack() and setSize() makes stringField focus!!
		 * however, this creates a bug in java 1.5 where the functionbar
		 * is duplicated behind the board.
		 * try pack afterwards having set preferred size for the board?
		 */
		//
//		if (atomEdition){
//		frame.setSize(950,570);
//		} else {
//		frame.setSize(950,750);
//		}

		//eee 950,570
		//eeePc 1024,600 - ok, vaio & bob (test) 950,750; conroe 950,850
		//atom edition is for small netbooks, especially if they run
		//maximiser (e.g. UNR!)
		if (QBuildParameters.loadMaximized || maximus)
			setMaximized();//performs:
			//setExtendedState(Frame.MAXIMIZED_BOTH);
		inputField.requestFocusInWindow();//must go here!


		setVisible(true);



		//actually this is a routine that happens everytime board is
		//resized!! should be separated out and referred to in
		//splitpane listener!
		int ht = currentBoard.getHeight();
		int wd = currentBoard.getWidth();
//		System.out.println("ht is " + ht);
		mainPane.setDividerLocation(ht);
		//QBoardGraphics.setHeightAndWidth(ht, wd);
//		refreshBoardSizes();

		//here get the initial infoText!
		refreshInfoText();
		focusFunctionBar();

	}

	public void initMenuBar(){

		topMenuBar = new JMenuBar();
		topMenuBar.removeAll();
		topMenuBar.revalidate();

		gameMenu = new JMenu("Game");
		gameMenu.setMnemonic(KeyEvent.VK_G);

		viewMenu = new JMenu("View");
		viewMenu.setMnemonic(KeyEvent.VK_W);

		actionMenu = new JMenu("Action");
		actionMenu.setMnemonic(KeyEvent.VK_A);

		helpMenu = new JMenu("Help");
		helpMenu.setMnemonic(KeyEvent.VK_H);
		//gameMenu.setFont(functionBarFont);
		//gameMenu.revalidate();
		/*
		 * this menu is in effect changing the game tree
		 * browsed, for short 'Game'
		 * 'New Game' or 'New' wouldn't cover switching to and fro
		 * Position Editor
		 */



//		// Create and add simple menu item to one of the drop down menu
		sameGameAction = new JMenuItem("Same Game Again", KeyEvent.VK_S);
		//sameGameAction.setFont(functionBarFont);
		sameGameAction.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Same Game!");
				String restartString = getQuString("restart", false)[0];
				System.out.println("restartString is " + restartString);
				setValidQSFString(restartString);

//				focusFunctionBar();//needed?

			}
		});



		quincalaPosEditSubmenu = new JMenu("Quincala Position Editor");
		quincalaPosEditSubmenu.setMnemonic(KeyEvent.VK_E);
		quincalaPosEditSubmenu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala quincalaPosEditSubmenu!");
				//qStringGateway("qui33");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		qPosEditWith5Sizes = new JMenuItem("5 sizes", KeyEvent.VK_5);
		qPosEditWith5Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qPosEditWith5Sizes with 5 sizes!");
				setValidQSFString("Quincala;05;");//maybe last ; not needed?

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		qPosEditWith4Sizes = new JMenuItem("4 sizes", KeyEvent.VK_4);
		qPosEditWith4Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qPosEditWith4Sizes with 4 sizes!");
				setValidQSFString("Quincala;04;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});
		qPosEditWith3Sizes = new JMenuItem("3 sizes", KeyEvent.VK_3);
		qPosEditWith3Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qPosEditWith3Sizes with 3 sizes!");
				setValidQSFString("qui03");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		//==
		miniQuincalaSubmenu = new JMenu("Mini Quincala");
		miniQuincalaSubmenu.setMnemonic(KeyEvent.VK_M);
		miniQuincalaSubmenu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Mini Quincala submenu!");
				//qStringGateway("qui33");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		miniQuincalaKnocking = new JMenuItem("Mini Quincala Knocking", KeyEvent.VK_K);
		miniQuincalaKnocking.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Mini Quincala Knocking!");
				setValidQSFString("Quincala;KM;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		miniQuincalaMixing = new JMenuItem("Mixing", KeyEvent.VK_M);
		miniQuincalaMixing.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Mini Quincala Mixing!");
				setValidQSFString("Quincala;MM;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		//==


		quincalaStandardSubmenu = new JMenu("Quincala Standard");
		quincalaStandardSubmenu.setMnemonic(KeyEvent.VK_Q);
		quincalaStandardSubmenu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala Standard submenu!");
				//qStringGateway("qui33");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		qReleaseWith5Sizes = new JMenuItem("5 sizes", KeyEvent.VK_5);
		qReleaseWith5Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala Standard with 5 sizes!");
				setValidQSFString("Quincala;35;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		qReleaseWith4Sizes = new JMenuItem("(4 sizes)", KeyEvent.VK_4);
		qReleaseWith4Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala Standard with 4 sizes!");
				setValidQSFString("Quincala;34;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});
		qReleaseWith3Sizes = new JMenuItem("3 sizes", KeyEvent.VK_3);
		qReleaseWith3Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala Standard with 3 sizes!");
				setValidQSFString("Quincala;33;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});



		quincalaKnockingSubmenu = new JMenu("(Quincala Knocking)");
		quincalaKnockingSubmenu.setMnemonic(KeyEvent.VK_K);
		quincalaKnockingSubmenu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala Knocking Submenu!");
				//qStringGateway("qui33");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});



		qKnockingWith5Sizes = new JMenuItem("(5 sizes)", KeyEvent.VK_5);
		qKnockingWith5Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qKnockingWith5Sizes!");
				setValidQSFString("Quincala;25;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		qKnockingWith4Sizes = new JMenuItem("(4 sizes)", KeyEvent.VK_4);
		qKnockingWith4Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qKnockingWith4Sizes!");
				setValidQSFString("Quincala;24;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});
		qKnockingWith3Sizes = new JMenuItem("(3 sizes)", KeyEvent.VK_3);
		qKnockingWith3Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qDisplacingWith3Sizes!");
				setValidQSFString("Quincala;23;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		//==

		quincalaMixingSubmenu = new JMenu("Quincala Mixing");
		quincalaMixingSubmenu.setMnemonic(KeyEvent.VK_X);
		quincalaMixingSubmenu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala quincalaMixingSubmenu!");
				//qStringGateway("qui33");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});



		qMixingWith5Sizes = new JMenuItem("5 sizes", KeyEvent.VK_5);
		qMixingWith5Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qMixingWith5Sizes!");
				setValidQSFString("Quincala;15;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		qMixingWith4Sizes = new JMenuItem("(4 sizes)", KeyEvent.VK_4);
		qMixingWith4Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qMixingWith4Sizes!");
				setValidQSFString("Quincala;14;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});
		qMixingWith3Sizes = new JMenuItem("3 sizes", KeyEvent.VK_3);
		qMixingWith3Sizes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("Quincala qMixingWith3Sizes!");
				setValidQSFString("Quincala;13;");

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		quincalaFootballNew = new JMenuItem("(Quincala Football)", KeyEvent.VK_F);
		quincalaFootballNew.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("quincalaFootballNew!");

				setValidQSFString("Quincala;73;");

//				focusFunctionBar();//needed?

			}
		});


		quincalaBouncingNew = new JMenuItem("(Quincala Bouncing)", KeyEvent.VK_B);
		quincalaBouncingNew.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("quincalaBouncingNew!");

				setValidQSFString("Quincala;45;");

//				focusFunctionBar();//needed?

			}
		});

		quincalaUnlimitedNew = new JMenuItem("<html>(Quincala <u>U</u>nlimited)</html>", KeyEvent.VK_U);
		quincalaUnlimitedNew.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("quincalaUnlimitedNew!");

				setValidQSFString("Quincala;53;");

//				focusFunctionBar();//needed?

			}
		});

		viewControlPanel = new JCheckBoxMenuItem("Control Panel");
		viewControlPanel.setMnemonic(KeyEvent.VK_C);
		viewControlPanel.setSelected(showControlPanel);
		viewControlPanel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("viewControlPanel menuitem");
				showControlPanel = !showControlPanel;
				System.out.println("showControlPanel is " + showControlPanel);
				refreshInfoPanel();

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		viewRulesOptions = new JCheckBoxMenuItem("Rules Options ...");
		viewRulesOptions.setMnemonic(KeyEvent.VK_R);
		viewRulesOptions.setSelected(showRulesOptions);
		viewRulesOptions.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("viewRulesOptions menuitem");
				showRulesOptions = !showRulesOptions;
				System.out.println("showRulesOptions is " + showRulesOptions);
				refreshInfoPanel();

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		viewTextInputField = new JCheckBoxMenuItem("Text Input");
		viewTextInputField.setMnemonic(KeyEvent.VK_T);
		viewTextInputField.setSelected(showTextInputField);
		viewTextInputField.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("viewTextInputField menuitem");
				showTextInputField = !showTextInputField;
				System.out.println("showTextInputField is " + showTextInputField);
				functionBarMode = 1;
				refreshFunctionBar();

//				focusFunctionBar();//needed? Maybe once gototurn is implemented?

			}
		});

		textSizesMenuItem = new JMenuItem("Text Sizes ...", KeyEvent.VK_T);
		textSizesMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("textSizesMenuItem menu item!");
//
				Object[] possibilities = {"22", "20", "18", "16", "14", "13", "12", "11", "10"};
				String s = (String)JOptionPane.showInputDialog(
									mainPane,
				                    "Please choose a font size and press Enter",
				                    "Text Size Input",
				                    JOptionPane.PLAIN_MESSAGE,
				                    null,
				                    possibilities,
				                    possibilities[textSizeIndexOnLoad]);

				if ((s != null) && (s.length() > 0)) {
					guiTextSize = Integer.parseInt(s);
					setTextSizes();

				    return;
				} else {
					//no string returned
				}


				refreshFunctionBar();//has focusFunctionBar() in it?


//				inputField.setText(currentZoomString);
//				inputField.requestFocusInWindow();
			}
		});

		zoomTextEntry = new JMenuItem("Zoom:", KeyEvent.VK_Z);
		zoomTextEntry.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("ZoomTextEntry menu item!");
//				qStringGateway("qui15");
//				showTextInputFieldDefault = showTextInputField;
//				showTextInputField = true;
//				functionBarMode = 1;
//				refreshFunctionBar();
				//set focus needed??
				//TODO tell menu this?

				String currentZoomString = "Zoom: " + getQuString("zoom", false)[0];


				//System.out.println("currentInfoString.length() is " + currentInfoString.length());
//				if (currentInfoString.length() < 8)//since prefix 'Title: ' is already there!
//					currentInfoString += QuStringUtils.getIdentityDateString() + " ";
				//actually the number 8 is dependent on the user key prefix - calculate when i18n!

				System.out.println("%currentZoomString is " + currentZoomString);
//				currentZoomString = QuStringUtils.restoreUserInputString(currentZoomString);
				//should never be any need for % encoding in zoom string!

				String s = (String) JOptionPane.showInputDialog(
						mainPane,
	                    "Edit centre coordinate and radius after the prefix: \"Zoom:\"",
	                    "QGV input",
	                    JOptionPane.PLAIN_MESSAGE,
	                    null,
	                    null,
	                    currentZoomString);

				String quString = QSFUtils.convertUserInputString(s);
				setValidQSFString(quString);
				refreshFunctionBar();
				focusFunctionBar();

//				inputField.setText(currentZoomString);
//				inputField.requestFocusInWindow();
			}
		});

		resetZoomItem = new JMenuItem("Reset Zoom", KeyEvent.VK_O);
		resetZoomItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("resetZoomItem!");

				setValidQSFString("zoom=66;7");
				refreshFunctionBar();
				focusFunctionBar();

			}
		});


		resignActionItem = new JMenuItem("Resign now", KeyEvent.VK_R);
		resignActionItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("quincalaUnlimitedNew!");

				setValidQSFString("ply=r" + playerNo);
				//should really get playerNo from state!
				//maybe store it as static in QGameState??
				functionBarMode = 0;
				refreshFunctionBar();//needed to show status and nav arrows

			}
		});

		agreeDrawActionItem = new JMenuItem("Agree Draw now", KeyEvent.VK_W);
		agreeDrawActionItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("agreeDrawMenuItem!");

				setValidQSFString("ply=rg");
				functionBarMode = 0;
				refreshFunctionBar();//needed to show status and nav arrows

			}
		});

		PassActionItem = new JMenuItem("Pass", KeyEvent.VK_P);
		PassActionItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("PassActionItem!");

				setValidQSFString("ply=rt");
				functionBarMode = 0;
				refreshFunctionBar();//needed to show status and nav arrows

			}
		});

		homePageItem = new JMenuItem("Quincala Home Page", KeyEvent.VK_Q);
		homePageItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("homePageItem!");


				openExternalResource("http://www.quincala.com/");

//				focusFunctionBar();//needed?

			}
		});

		onlineHelpItem = new JMenuItem("Online Help (PDF)", KeyEvent.VK_H);
		onlineHelpItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("onlineHelpItem!");


				//no luck with this local file; maybe use open file instead?
//				openExternalResource("/home/ulf/Dropbox/quincala.com/web/pdf/Quincala%20Game%20Viewer%20Help.pdf");
				openExternalResource("http://www.quincala.com/0.9/Quincala%20Game%20Viewer%20Help.pdf");

//				focusFunctionBar();//needed?

			}
		});

		ruleSheetItem = new JMenuItem("Online Rules (PDF)", KeyEvent.VK_R);
		ruleSheetItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("ruleSheetItem!");

				String ruleVersionFileName = QRules.getRuleSheetName();
				openExternalResource("http://www.quincala.com/0.9/" +
						ruleVersionFileName);

//				focusFunctionBar();//needed?

			}
		});

		onlineScoresItem = new JMenuItem("Online Scores etc", KeyEvent.VK_S);
		onlineScoresItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("onlineScoresItem!");

				openExternalResource("http://www.quincala.com/material.html");

//				focusFunctionBar();//needed?

			}
		});

		onlineTutorialsItem = new JMenuItem("Online Tutorials", KeyEvent.VK_T);
		onlineTutorialsItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("onlineTutorialsItem!");

				openExternalResource("http://www.quincala.com/tutorials.html");

//				focusFunctionBar();//needed?

			}
		});

		legalItem = new JMenuItem("Legal Information", KeyEvent.VK_L);
		legalItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("legalItem!");

				//TODO make dialoque!
				legalButton.doClick();


//				focusFunctionBar();//needed?

			}
		});



		refreshMenuBar();
	}

	private void openExternalResource(String resourceURLString){
		String message = "This will try to open the " +
			"selected resource in your default browser.";

		if(isApplet)
			message = "This will try to open the " +
			"selected resource in a new tab or window of this browser.";



		showConfirmationMessage(message);
		//TODO enable cancel open resource!


		openExternalUrlString(resourceURLString);
	}


	public void refreshMenuBar(){



		topMenuBar.add(gameMenu);
		gameMenu.add(sameGameAction);
		gameMenu.addSeparator();

		if(QBuildParameters.doConstruction){
			gameMenu.add(quincalaPosEditSubmenu);
			quincalaPosEditSubmenu.add(qPosEditWith5Sizes);
			quincalaPosEditSubmenu.add(qPosEditWith4Sizes);
			quincalaPosEditSubmenu.add(qPosEditWith3Sizes);
			gameMenu.addSeparator();
		}




		if(QBuildParameters.doConstruction){
			gameMenu.add(miniQuincalaSubmenu);
			miniQuincalaSubmenu.add(miniQuincalaKnocking);
			miniQuincalaSubmenu.add(miniQuincalaMixing);
		} else
			gameMenu.add(miniQuincalaKnocking);
		gameMenu.addSeparator();

		gameMenu.add(quincalaMixingSubmenu);
		quincalaMixingSubmenu.add(qMixingWith5Sizes);
		quincalaMixingSubmenu.add(qMixingWith4Sizes);
		quincalaMixingSubmenu.add(qMixingWith3Sizes);

		if(QBuildParameters.doConstruction){
			gameMenu.add(quincalaKnockingSubmenu);
			quincalaKnockingSubmenu.add(qKnockingWith5Sizes);
			quincalaKnockingSubmenu.add(qKnockingWith4Sizes);
			quincalaKnockingSubmenu.add(qKnockingWith3Sizes);
		}
		gameMenu.add(quincalaStandardSubmenu);
		quincalaStandardSubmenu.add(qReleaseWith5Sizes);
		quincalaStandardSubmenu.add(qReleaseWith4Sizes);
		quincalaStandardSubmenu.add(qReleaseWith3Sizes);


		if (QBuildParameters.softwareBuildInt > 8){
			gameMenu.add(quincalaBouncingNew);
			gameMenu.add(quincalaUnlimitedNew);
		}

		if(QBuildParameters.doConstruction)
			gameMenu.add(quincalaFootballNew);

		//action menu
		topMenuBar.add(actionMenu);
		actionMenu.add(PassActionItem);
		actionMenu.add(resignActionItem);
		actionMenu.add(agreeDrawActionItem);

		//viewMenu
		topMenuBar.add(viewMenu);
		viewMenu.add(viewControlPanel);
		viewMenu.add(textSizesMenuItem);
//		viewMenu.add(viewRulesOptions);


//		if (QRules.softwareBuildInt > 8)
//			viewMenu.add(viewTextInputField);
		//need pop ups to confirm successful copy before
		//remove text input field by default
		viewMenu.addSeparator();
		viewMenu.add(zoomTextEntry);
		viewMenu.add(resetZoomItem);


		topMenuBar.add(helpMenu);
		helpMenu.add(homePageItem);
		helpMenu.add(onlineHelpItem);
		helpMenu.add(ruleSheetItem);
		helpMenu.add(onlineScoresItem);
		helpMenu.add(onlineTutorialsItem);
		helpMenu.addSeparator();
		helpMenu.add(legalItem);



	}

	public void initInfoPanel(){

		infoPanel.removeAll();//needed - otherwise all buttons lost with glf command ...
		//otherwise the buttons keep stacking up for each switch of game...

		JLabel showText = new JLabel(" View: ");//leading space good
		showText.setOpaque(true);//needed?


		ImmunityRuleBn = new JCheckBox("Immunity Rule");
		//ImmunityRuleBn.setMnemonic(KeyEvent.VK_M);//temp button - no short cut
		ImmunityRuleBn.setSelected(enableImmunity);
		ImmunityRuleBn.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				/*
				 * use event?
				 */

				enableImmunity = !enableImmunity;
				System.out.println("ImmunityRuleBn is set " + enableImmunity);
				//TODO make userRule method out of this & IRBn!!
				setUserRules();


				focusFunctionBar();
			}
		});

		IRBn = new JCheckBox("Old Irreversibility Rule");
		//IRBn.setMnemonic(KeyEvent.VK_I);//temp button - no short cut
		IRBn.setSelected(enableIR);
		IRBn.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				/*
				 * use event?
				 */

				enableIR = !enableIR;
				System.out.println("IRBn is set " + enableIR);

				setUserRules();

				//testing since rulemodification triggers sending quistring again!
//				refreshInfoText();
//				functionBarMode = 0;
//				getGameStatus();
//				refreshInfoPanel();
//				currentBoard.repaint();

				focusFunctionBar();
			}
		});


		showToolTipBn = new JCheckBox("ToolTips");
		showToolTipBn.setMnemonic(KeyEvent.VK_T);
		if(QBuildParameters.tournamentEdition){
			showToolTips = false;
		}
		showToolTipBn.setSelected(showToolTips);
		showToolTipBn.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {

				/*
				 * use event? read state?
				 */
				showToolTips = !showToolTips;
				System.out.println("showToolTips is " + showToolTips);
				//how do I revalidate the whoe thing??
				setToolTips();
				focusFunctionBar();
			}
		});

		showArrowsBn = new JCheckBox("Arrows");
		showArrowsBn.setMnemonic(KeyEvent.VK_W);
		showArrowsBn.setSelected(true);
		showArrowsBn.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				/*
				 * use event?
				 */
				showArrows = !showArrows;
				System.out.println("showArrows is " + showArrows);
				focusFunctionBar();
			}
		});

		showRelHandlesBn = new JCheckBox("ReleasingHandles");
		showRelHandlesBn.setMnemonic(KeyEvent.VK_E);
		showRelHandlesBn.setSelected(true);
		showRelHandlesBn.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				/*
				 * use event?
				 */
				//showArrows = !showArrows;
				//showRelHandles = !showRelHandles;

				currentBoard.toggleShowReleasingHandles();
				System.out.println("showRelHandlesBn is " + showRelHandlesBn);
				focusFunctionBar();
			}
		});

		sessionBackupCheckBox = new JCheckBox("Session Back Up");
//		sessionBackupCheckBox.setMnemonic(KeyEvent.VK_O);
		sessionBackupCheckBox.setSelected(doSessionBackup);
		//if change default also change default in boardPanel!
		sessionBackupCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				System.out.println("sessionBackupCheckBox!");
				/*
				 * use event? better; then can change default in
				 * only one place (here!)
				 * for now keep default synced
				 * between GUI and boardpanel!
				 */
				doSessionBackup = !doSessionBackup;
//				showBrowserWindow = doSessionBackup;

				if (doSessionBackup){
					//action on tick:
					showLegalText = false;
					outputSessionStateStrings();
					showBrowserWindow = true;
				} else {
					//action on untick:
					if(showLegalText){
						setLegalText();
						showBrowserWindow = true;
					} else {
						showBrowserWindow = false;
					}
				}


				refreshInfoPanel();

				focusFunctionBar();
				//needed to put focus back onto turn number box

			}
		});


		toggleShowOptionsButton = new JCheckBox("Options");
		toggleShowOptionsButton.setMnemonic(KeyEvent.VK_O);
//		if(QBuildParameters.tournamentEdition){
//			showOptions = true;
//		}
		toggleShowOptionsButton.setSelected(showOptions);
		//if change default also change default in boardPanel!
		toggleShowOptionsButton.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				System.out.println("Toggle ShowOptions!");
				/*
				 * use event? better; then can change default in
				 * only one place (here!)
				 * for now keep default synced
				 * between GUI and boardpanel!
				 */
				showOptions = !showOptions;
				setShowOptions();
				focusFunctionBar();

			}
		});

		rightClickZoomChBox = new JCheckBox("Right Click Zoom");
		rightClickZoomChBox.setMnemonic(KeyEvent.VK_K);
		rightClickZoomChBox.setSelected(QGraphics.canZoomByRClick);
		rightClickZoomChBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				System.out.println("rightClickZoomChBox!");
				/*
				 * use event? better; then can change default in
				 * only one place (here!)
				 * for now keep default synced
				 * between GUI and boardpanel!
				 */
				QGraphics.toggleZoomByRClick();
				focusFunctionBar();

			}
		});



		setTextSizeLabel = new JLabel("Text size: ");
//		setTextSizeLabel.setFont(functionBarFont);


		textSizeChoser = new JComboBox(textSizeChoices);
		textSizeChoser.setSelectedIndex(textSizeIndexOnLoad);
		textSizeChoser.setMaximumSize(new Dimension(50,150));
		textSizeChoser.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JComboBox cb = (JComboBox)e.getSource();
				System.out.println(cb);
				String choiceString = (String)cb.getSelectedItem();
				guiTextSize = Integer.parseInt(choiceString);
				System.out.println("guiTextSize is " + guiTextSize);
				//refresh all text sizes!!
				setTextSizes();
			}
		});

		historyOutBn = new JButton("HistoryOut");
		historyOutBn.setMnemonic(KeyEvent.VK_Y);
		historyOutBn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("historyOutBn");
				focusFunctionBar();
				//BareBonesBrowserLaunch.openURL(historyURLString());

			}
		});

		testNewGenerationBn = new JButton("Test New Gen");
		testNewGenerationBn.setMnemonic(KeyEvent.VK_T);
		testNewGenerationBn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("testNewGenerationBn");
				currentBoard.testNewG((byte) 8, 16);
				focusFunctionBar();
			}
		});

//		wholeLineDataBox = new JTextArea(10,20);
//		wholeLineDataBox.setLineWrap(true);
//		wholeLineDataBox.setWrapStyleWord(true);

//		wholeLineDataBox.setEditable(false);
		//if not set at all you can enter text in box!!


		//formatted:

		wholeLineDataPane.setEditable(false);
		wholeLineDataPane.putClientProperty(JEditorPane.HONOR_DISPLAY_PROPERTIES, Boolean.TRUE);
//		legalEditorPane.addHyperlinkListener(new SimpleHyperlinkListener());
//		wholeLineDataPane.addHyperlinkListener(new QuStringHyperlinkListener());
		//just for experiment - simple is enough for legal text!

		//why do I need to do this twice?? make a setLegalText()?
		//seems to be to initialise the size - do that with other means!!
		Dimension preferredWholeLinePaneSize = new Dimension(200,400);//no idea of size ...
		wholeLineDataPane.setPreferredSize(preferredWholeLinePaneSize);

		//this is not in use; legal html instead ...

//		legalTextBox = new JTextArea(getLegalText(),10,20);
////		getLegalText() from QGUI
//		legalTextBox.setLineWrap(true);
//		legalTextBox.setWrapStyleWord(true);
//		//legalTextBox. //add vertical scroller ...
//		legalTextBox.setEditable(false);

		//scrollPane = new JScrollPane(legalTextBox);
//		GridBagConstraints c = new GridBagConstraints();
//		c.gridwidth = GridBagConstraints.REMAINDER;

//		c.fill = GridBagConstraints.HORIZONTAL;
//		checkPanel4.add(legalTextBox, c);

//		c.fill = GridBagConstraints.BOTH;
//		c.weightx = 1.0;
//		c.weighty = 1.0;
//		checkPanel4.add(scrollPane, c);


		quincalaBrowser.setEditable(false);
		quincalaBrowser.putClientProperty(JEditorPane.HONOR_DISPLAY_PROPERTIES, Boolean.TRUE);
//		legalEditorPane.addHyperlinkListener(new SimpleHyperlinkListener());
		quincalaBrowser.addHyperlinkListener(new QuStringHyperlinkListener());

//		legalTextPane.add(browserMenuBar);
//		browserMenuBar
		//just for experiment - simple is enough for legal text!


		//why do Ineed to do this twice?? make a setLegalText()?
		//seems to be to initialise the size - do that with other means!!
		Dimension preferredLegalPaneSize = new Dimension(200,400);//no idea of size ...
		quincalaBrowser.setPreferredSize(preferredLegalPaneSize);

//		try {
//		legalEditorPane.setPage(getCoreURLString("docs/ABGamesLegalCore.html"));
//		}
//		catch (IOException e) {
//		legalEditorPane.setContentType("text/html");
////		jep.setText("<html>Could not load http://www.oreilly.com </html>");
//		legalEditorPane.setText("missing document");
//		}

//		legalEditorPane.setContentType("text/html");
////		jep.setText("<html>Could not load http://www.oreilly.com </html>");
//		legalEditorPane.setText("<html>missing document</html>");





		infoPanel.setLayout(new BoxLayout(infoPanel, BoxLayout.Y_AXIS));

		refreshInfoPanel();


	}


	public void initFunctionBar(){ //is a panel, not a bar

//		bottomBar = new JPanel();//needed?
//		bottomBar.setBackground(Color.RED);

		//bottomBar.setLayout(new BorderLayout(bottomBar, BorderLayout.LINE_START));


//		fnButtonPanel = new JPanel();
//		fnButtonPanel.setAlignmentX(0);//lEFT?
//		fnButtonPanel.setBackground(Color.yellow);
		//fnButtonPanel.setLayout(new BoxLayout(functionBar, BoxLayout.X_AXIS));




		functionBar = new JPanel();//needed?
		functionBar.setBackground(Color.LIGHT_GRAY);
		functionBar.setLayout(new BoxLayout(functionBar, BoxLayout.X_AXIS));
		functionBar.setBorder(BorderFactory.createEmptyBorder(2,2,2,2));
		functionBar.setFocusable(true);

		functionButton = new JButton("Fn:");
		functionButton.setFont(functionBarFont);
		functionButton.setMnemonic(KeyEvent.VK_F);
		functionButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("functionButton!");
				toggleFunctionBar();
			}
		});


//		functionBar = new JPanel();//needed?
//		functionBar.setBackground(Color.GRAY);
		//functionBar.setLayout(new BoxLayout(functionBar, BoxLayout.X_AXIS));
		//Font cdButtonFont = new Font("serif", Font.BOLD, 13);

//		functionButton = new JButton("Fn");
//		functionButton.setFont(cdButtonFont);
//		functionButton.setMnemonic(KeyEvent.VK_F);
//		functionBar.add(functionButton);
//		functionButton.addActionListener(new ActionListener() {
//		public void actionPerformed(ActionEvent e) {
//		System.out.println("functionButton!");
//		toggleFunctionBar();
//		}
//		});

//		previousMarkerButton = new JButton(QGraphics.navArrows[6]);//"|<"
		previousMarkerButton = new JButton();//"|<"
		previousMarkerButton.setMnemonic(KeyEvent.VK_PAGE_DOWN);
//		previousMarkerButton.setFont(functionBarFont);//icon!
		previousMarkerButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("previousMarkerButton!");
				sendButtonPresses(QGameSpace.PREV_MARK);
				focusFunctionBar();
			}
		});


		backwardButton = new JButton();//"<"
//		backwardButton = new JButton(QGraphics.navArrows[2]);//"<"
		backwardButton.setMnemonic(KeyEvent.VK_LEFT);
		//backwardButton.setFont(functionBarFont);//icon!
		backwardButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("backwardButton!");
				sendButtonPresses(QGameSpace.BACK_STEP);
				focusFunctionBar();
			}
		});


		playButton = new JButton(">>");
		playButton.setMnemonic(KeyEvent.VK_P);//no opens window menu!
		playButton.setFont(functionBarFont);
		playButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("playButton!");

				//stepPlayer();

				//this is transitional solution; before pause button
				doPlay = true;
				//disable buttons!
				setButtonsAbility(false);
				currentBoard.stepPlayer(playerDelay);
				doPlay = false;
				getGameStatus();
				refreshFunctionBar();
//				focusFunctionBar();//?
			}
		});


//		forwardButton = new JButton(QGraphics.navArrows[0]);
		forwardButton = new JButton();//adding icons in setTextSizes()
		forwardButton.setMnemonic(KeyEvent.VK_RIGHT);
		//forwardButton.setFont(functionBarFont);//icon!
		forwardButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("forwardButton!");
				sendButtonPresses(QGameSpace.FORWARD_STEP);
				focusFunctionBar();
			}
		});

		nextMarkerButton = new JButton();
//		nextMarkerButton = new JButton(QGraphics.navArrows[2]);
		nextMarkerButton.setMnemonic(KeyEvent.VK_PAGE_UP);
		//nextMarkerButton.setFont(functionBarFont);//icon!
		nextMarkerButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("nextMarkerButton!");
				sendButtonPresses(QGameSpace.NEXT_MARK);
				focusFunctionBar();
			}
		});



		rotateBoardButton = new JButton("R");
		rotateBoardButton.setMnemonic(KeyEvent.VK_R);
//		rotateBoardButton.setFont(functionBarFont);//to setTextSize()
		rotateBoardButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("rotateBoardButton!");
				currentBoard.rotateBoard(1);
				//no need to redraw board panel?
				focusFunctionBar();
			}
		});

		addXButton = new JButton("+Y");
		addXButton.setMnemonic(KeyEvent.VK_Y);
//		addXButton.setFont(functionBarFont);
		addXButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("addBranchButton!");

				focusFunctionBar();
			}
		});


		addZButton = new JButton("+Z");
		addZButton.setMnemonic(KeyEvent.VK_Z);
//		addZButton.setFont(functionBarFont);
		addZButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("addZButton!");

				focusFunctionBar();
			}
		});

		pZButton = new JButton("Pz");
		//pZButton.setMnemonic(KeyEvent.VK_X);
//		pZButton.setFont(functionBarFont);
		pZButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("pZButton!");

				focusFunctionBar();
			}
		});

		rPZButton = new JButton("rPz");
		//rPZButton.setMnemonic(KeyEvent.VK_X);
//		rPZButton.setFont(functionBarFont);
		rPZButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("rPZButton!");

				focusFunctionBar();
			}
		});

		turnLabel = new JLabel("Turn ");
		maxTurnLabel = new JLabel("/1");
		turnNumberField = new JTextField("1",1);//to get the size
		turnNumberField.setHorizontalAlignment(JTextField.TRAILING);



//		turnNumberField.setPreferredSize(turnNumberField.getPreferredSize());
//		turnNumberField.setText("0");
		//turnNumberField.setPreferredSize(new Dimension(2,1));

		//int fieldht = rotateBoardButton.getMaximumSize().height;

		adjustTurnNumberFieldSize();


		turnNumberField.setFocusable(true);//needed!
		//stringField.requestFocus(true);
		turnNumberField.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("turnNumberField!");
				String turnString = turnNumberField.getText();
				//here test for simply a number
				boolean isValidTurnString = QSFUtils.isValidTurnString(turnString, maxTurnLabel.getText());

//				System.out.println("isValidTurnString is " + isValidTurnString);

				if (isValidTurnString){
					setValidQSFString("goto=" + turnString);
					//TODO add VIP to goto field
					//testing again??? maybe send raw!
//					int turnInt = Integer.parseInt(turnString);
				} else {
					getGameStatus();//which involves setting correct turn again
//					alternatively, store currentTurn somewhere ...
					//probably better to re-calc everything
				}

				//int gotoTurnNo = Integer.parseInt(turnString);
				//here test for allowed number
//				System.out.println("gotoTurnNo is " + gotoTurnNo);

				//here send command ~goto turnNo
				//qStringGateway(qString);
				turnNumberField.requestFocusInWindow();
				turnNumberField.selectAll();
			}
		});


		statusLabel = new JLabel();//doesn't need to start with any text!
//		statusLabel.setFont(functionBarFont);




		scoreOutModeBn = new JRadioButton("score");
		//scoreOutMode.setMnemonic(KeyEvent.VK_X);//key-event??
		scoreOutModeBn.setSelected(true);
		if (QBuildParameters.softwareBuildInt > 6){
			copyMode = "score";
		} else {
			copyMode = "0.6";
		}


		scoreOutModeBn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("scoreOutMode!");
				copyMode = "score";
				focusFunctionBar();
			}
		});


		correspondenceOutModeBn = new JRadioButton("@");
		//correspondenceOutMode.setMnemonic(KeyEvent.VK_X);//key-event??
		correspondenceOutModeBn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("correspondenceOutMode!");
				copyMode = "@";
				focusFunctionBar();
			}
		});

		posNoFutureOutModeBn = new JRadioButton("~pos|");
		//posNoFutureOutMode.setMnemonic(KeyEvent.VK_X);//key-event??
		posNoFutureOutModeBn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("posNoFutureOutMode!");
				copyMode = "posNo";
				focusFunctionBar();
			}
		});


		posWithFutureOutModeBn = new JRadioButton("~pos~");
		posWithFutureOutModeBn.setMnemonic(KeyEvent.VK_X);//key-event??
		posWithFutureOutModeBn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("posWithFutureOutMode!");
				copyMode = "posYes";
				focusFunctionBar();
			}
		});

		purePositionOutModeBn = new JRadioButton("|pos|");//will be implemented later!
		purePositionOutModeBn.setMnemonic(KeyEvent.VK_X);//key-event??
		purePositionOutModeBn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("purePositionOutMode!");
				copyMode = "purePos";
				focusFunctionBar();
			}
		});


		gifOutModeBn = new JRadioButton("gif");//will be implemented later!
		//gifOutModeBn.setMnemonic(KeyEvent.VK_G);//key-event??
		gifOutModeBn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("gifOutMode!");
				copyMode = "gif";
				focusFunctionBar();
			}
		});


		ButtonGroup copyModes = new ButtonGroup();
		copyModes.add(scoreOutModeBn);
		copyModes.add(correspondenceOutModeBn);
		copyModes.add(posNoFutureOutModeBn);
		copyModes.add(posWithFutureOutModeBn);
		copyModes.add(purePositionOutModeBn);//will be implemented later!
		copyModes.add(gifOutModeBn);//will be implemented later!


		stateOutModeBn = new JCheckBox("info");
		//infoOutModeBn.setMnemonic(KeyEvent.VK_W);

		stateOutModeBn.setSelected(stateOutMode);


		stateOutModeBn.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				/*
				 * use event?
				 */
				stateOutMode = !stateOutMode;
				System.out.println("stateOutMode is " + stateOutMode);
				focusFunctionBar();
			}
		});

		wrapModeBn = new JCheckBox("wrap");
		//infoOutModeBn.setMnemonic(KeyEvent.VK_W);

		wrapModeBn.setSelected(true);
		wrapMode = true;

		wrapModeBn.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				/*
				 * use event?
				 */
				wrapMode = !wrapMode;
				System.out.println("wrapMode is " + wrapMode);
				focusFunctionBar();
			}
		});

		copyButton = new JButton("Copy:");
//		copyPlyStringButton.setFont(functionBarFont);

		copyButton.setMnemonic(KeyEvent.VK_C);
		copyButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("CopyButton!");
				//use textField.selectAll();

				String[] quStringToCopy = getQuStringDressed(copyMode, stateOutMode);
				//this is the only time frames are true?

				//ClipBoardBridge clipBoardBridge = new ClipBoardBridge();
				if(QBuildParameters.useJNLPServices){
					QClipBoardBridge.copyWS(quStringToCopy[0]);
				} else {
					System.out.println("JNLPService is not used!!!");
					QClipBoardBridge.putStringOnClipboard(quStringToCopy[0]);
				}


				//It works!!


//				stringField.setText("");
//				stringField.setText(quStringToCopy[0]);
//				stringField.requestFocusInWindow();
//				stringField.selectAll();

//				//make proper copy and paste! using the Bridge ...
//				stringField.copy();//or rightclick?


				showConfirmationMessage(quStringToCopy[1]);
//				inputField.setText(quStringToCopy[1]);
//				inputField.requestFocusInWindow();
//				stringField.selectAll();

			}
		});

		pasteButton = new JButton("Paste");
//		pasteClipboardButton.setFont(functionBarFont);
		pasteButton.setMnemonic(KeyEvent.VK_V);
//		pasteButton.requestFocusInWindow();
//		pasteButton.setFocusable(true);//probably is true by default?
		//no: how do I press focused button with Enter?
		pasteButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("pasteClipboardButton!");

				/*
				 * first display warning message, since
				 * current game line is lost on pasting!
				 */

//				JOptionPane.showConfirmDialog(frame,
//						, 2);




				Object[] options = {"OK",
						"Cancel Pasting"};
				int n = JOptionPane.showOptionDialog(mainPane,
						 "Warning - clicking OK " +
							"will attempt to load the " +
							"contents of the " +
							"clipboard\n- erasing the " +
							"current game line!",
							"QGV Message",
						JOptionPane.OK_CANCEL_OPTION,
						JOptionPane.WARNING_MESSAGE,
						null,
						options,
						options[0]);

				/*
				 * the integer returned is 0 for OK, 1 for cancel
				 * and -1 for closing before asking
				 * BUG: using tab and Enter still returns 0!!
				 */
				System.out.println("integer returned is " + n);
				if (n != 0)
					return;

//				JOptionPane.showMessageDialog(frame,errorText,"QGV Message", 2);


				/*
				 * get from clipboard and remove line breaks
				 * before sending qStringGateway!
				 * In the meantime one can still
				 * paste strings in textbox ...
				 */
				String stringOnClipBoard = "";
				QClipBoardBridge clipBoardBridge = new QClipBoardBridge();

				if(QBuildParameters.useJNLPServices){
					stringOnClipBoard = clipBoardBridge.pasteWS();
				} else {
					stringOnClipBoard = clipBoardBridge.getStringOnClipBoard();
				}

//				QClipBoardBridge clipBoardBridge = new QClipBoardBridge();
//				String stringOnClipBoard = clipBoardBridge.getStringOnClipBoard();
				if (stringOnClipBoard.length() > 0){
					setWildQSFString(stringOnClipBoard);
					refreshFunctionBar();
					focusFunctionBar();
//					TODO actually on valid quStrings should switch function bar
				} else {
					showErrorMessage("No string on clipboard!");
					//Can't test without restart :-)
//					inputField.setText("No string on clipboard!");
//					inputField.requestFocusInWindow();
//					inputField.selectAll();
				}


//				stringField.setText("");
//				stringField.setText(getQuiString());
//				stringField.requestFocusInWindow();
//				stringField.selectAll();

//				//make proper copy and paste!
//				stringField.copy();//or rightclick?
//				stringField.setText("A Pure Ply String is now copied to the clipboard!");


//				stringField.requestFocusInWindow();
//				stringField.selectAll();

			}
		});

		titleButton = new JButton("Title:");
//		copyInfoButton.setFont(functionBarFont);
		titleButton.setMnemonic(KeyEvent.VK_I);
		titleButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("titleButton!");

				/*
				 * TODO develop editInfoButton to open a dialogue with
				 * input fields for pgn type labels:
				 * White/Black player, date, event, timer etc
				 *
				 */


				String currentInfoString = "Title: " + getQuString("title", false)[0];
				String today = QSFUtils.getIdentityDateString();

				//System.out.println("currentInfoString.length() is " + currentInfoString.length());
				if (currentInfoString.length() < 8)//since prefix 'Title: ' is already there!
					currentInfoString += today  + " ";
				//actually the number 8 is dependent on the user key prefix - calculate when i18n!

				boolean addTournamentTemplate = today.equals(QBuildParameters.tournamentDateString);
				boolean titleEntered = currentInfoString.length() > 19;

				if(addTournamentTemplate && !titleEntered){
					currentInfoString += "Rnd ? Brd ? ";
				}

				System.out.println("%currentInfoString is " + currentInfoString);
//				currentInfoString = currentInfoString;

				//test JOptionPane
				String s = (String)JOptionPane.showInputDialog(
						mainPane,
	                    "Add or edit the title after the prefix: \"Title:\"",
	                    "QGV input",
	                    JOptionPane.PLAIN_MESSAGE,
	                    null,
	                    null,
	                    currentInfoString);

				String quString = QSFUtils.convertUserInputString(s);
				setValidQSFString(quString);
				refreshFunctionBar();
				focusFunctionBar();

				System.out.println("InputString is: " + s);

//				inputField.setText(currentInfoString);
//				inputField.requestFocusInWindow();

				//old dopyInfoOut button:
//				String matchInfoGot = currentBoard.passUpWholeLineData().matchInfo;
//				if (matchInfoGot.length() > 0){
//				stringField.setText("");
//				stringField.setText(matchInfoGot);
//				//make proper copy and paste routines!!
//				stringField.requestFocusInWindow();
//				stringField.selectAll();
//				stringField.copy();//or rightclick?
//				stringField.setText("The Title Bar information is now copied to the clipboard!");
//				stringField.requestFocusInWindow();
//				stringField.selectAll();
//				} else {
//				stringField.setText("No match information entered: Please enter again with the prefix 'info'!");
//				stringField.requestFocusInWindow();
//				stringField.selectAll();
//				}


			}
		});


		inputField = new JTextField(5);//mimimun 5 char seen
		inputField.setFocusable(true);//needed!
		//stringField.requestFocus(true);
		inputField.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("stringField!");
				String userInputString = inputField.getText();
				inputField.setText("");//to empty it
				//Here take the tags away; or modify them
				//specifically TITLE: instead of ~info
				String quString = QSFUtils.convertUserInputString(userInputString);
				setValidQSFString(quString);
				showTextInputField = showTextInputFieldDefault;
//				functionBarMode = 0;
				refreshFunctionBar();

				if (showTextInputField){
					inputField.setText(inputFieldDefaultText);
					//stringField.requestFocusInWindow();
//					stringField.selectAll();
				}
				focusFunctionBar();

			}
		});

		//string in: obsolete; just do Enter!!
//		loadStringButton = new JButton(myTexts.stringButtonsTexts[2]);
//		loadStringButton.setFont(functionBarFont);
//		loadStringButton.setMnemonic(KeyEvent.VK_ENTER);
//		loadStringButton.addActionListener(new ActionListener() {
//		public void actionPerformed(ActionEvent e) {
//		System.out.println("loadStringButton!");
//		/*
//		* TODO grab string at stringField!
//		*/
//		//board.loadQuString();//will then be obsolete
//		functionBarMode = 0;
//		switchFunctionBar();
//		currentBoard.repaint();//definitely needed!
//		}
//		});

		setSpeedLabel = new JLabel("Animation speed (steps/minute): ");
//		setSpeedLabel.setFont(functionBarFont);


		speedChoser = new JComboBox(speedChoices);
		speedChoser.setSelectedIndex(speedIndexOnLoad);
		speedChoser.setMaximumSize(new Dimension(50,150));
		speedChoser.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JComboBox cb = (JComboBox)e.getSource();
				System.out.println(cb);
				String choiceString = (String)cb.getSelectedItem();
				int chosenSpeed = Integer.parseInt(choiceString);
				System.out.println("chosenSpeed is " + chosenSpeed);
				playerDelay = (int) 60000 / chosenSpeed;
				System.out.println("playerDelay is " + playerDelay);
				focusFunctionBar();
			}
		});






//		bottomBar.add(fnButtonPanel);
//		bottomBar.add(functionBar);


//		statusLabel = new JLabel(getStatusText());


		helpButton = new JButton("??");
		helpButton.setMnemonic(KeyEvent.VK_F1);
//		helpButton.setFont(functionBarFont);
		helpButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("helpButton!");
				//for now use it for quincala test page
				showBrowserWindow = !showBrowserWindow;
				if(QBuildParameters.softwareBuildInt > 8){
					try {
//						legalTextPane.setPage(getCoreURLString("docs/ABGamesLegalCore.html"));
						//legalTextPane.setPage(getCoreURLString("docs/wiki/index.htm"));

						quincalaBrowser.setPage(QSFUtils.getCoreURLString("docs/browsertest.html"));

					} catch (IOException evt) {//not very effective exception handling ...
						quincalaBrowser.setContentType("text/html");
//						jep.setText("<html>Could not load http://www.oreilly.com </html>");
						quincalaBrowser.setText("<html>missing document</html>");
					}

					refreshInfoPanel();
					focusFunctionBar();
				}

			}
		});

		legalButton = new JButton("\u00a7\u00a9!");
		legalButton.setMnemonic(KeyEvent.VK_Q);
		//Alt+ ! doesn't work
//		legalButton.setFont(functionBarFont);

		legalButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.out.println("legalButton!");
//				showLegalText = !showLegalText;

				if (showLegalText){
					showLegalText = false;
					if(doSessionBackup){
						outputSessionStateStrings();
						showBrowserWindow = true;
					} else {
						showBrowserWindow = false;
					}
				} else {
					showLegalText = true;
					showBrowserWindow = true;
				}



//				System.out.println("showBrowserWindow is " + showBrowserWindow);

				if (showLegalText){
					setLegalText();
				} else if (doSessionBackup){
					outputSessionStateStrings();
				} else {
					showBrowserWindow = false;
				}


				refreshInfoPanel(); //BUGGY! but shows when new QuString!
				focusFunctionBar();

			}
		});

		refreshFunctionBar();

	}

	public void toggleFunctionBar(){
		functionBarMode = (functionBarMode + 1) % 2;
		refreshFunctionBar();

		//initFunctionBar();

//		QuGUISwing gui =  new QuGUISwing();
		//this.go();

	}

	public void setUserRules(){
		//O~ don't bother with separate booleans?
		//or useful to keep track of various other games?!
		boolean[] userRules = new boolean[2];
		userRules[0] = enableIR;
		userRules[1] = enableImmunity;

		currentBoard.passThruRuleModification(userRules);
	}

	public void setGameVersion(String body){
		if(body.length() == 0 || body.charAt(0) > 58 || body.charAt(0) < 47){
			gameVersion = -1;
			System.out.println("No game version is set");

		} else {
			//		= firstBodyChar is a number so can be parsed
			gameVersion = (int) Integer.parseInt(body.substring(0,1));
			System.out.println("gameVersion is " + gameVersion);
		}
	}

	public void setLegalText(){
		try {
			quincalaBrowser.setPage(QSFUtils.getCoreURLString("docs/ABGamesLegalCore.html"));
			//legalTextPane.setPage(getCoreURLString("docs/wiki/index.htm"));
			//legalTextPane.setPage("http://dl.dropbox.com/u/3897108/Qwiki1.htm");
		} catch (IOException evt) {
			quincalaBrowser.setContentType("text/html");
//			jep.setText("<html>Could not load http://www.oreilly.com </html>");
			quincalaBrowser.setText("<html>missing document</html>");
		}
	}

	public void refreshInfoPanel(){
		//remove all components first ...
		infoPanel.removeAll();
		infoPanel.revalidate();//needed unless restart with new QuString ...

		//keeping this in initInfoPanel ...
		//infoPanel.setLayout(new BoxLayout(infoPanel, BoxLayout.Y_AXIS));

		if (showRulesOptions){
			checkPanel0 = new JPanel();
			checkPanel0.setLayout(new BoxLayout(checkPanel0, BoxLayout.X_AXIS));
			if (currentGameHead.equals("qui") &&  gameVersion > 0){
				//the panel creation has to be outside - works as reset!
				checkPanel0.add(Box.createHorizontalGlue());
				checkPanel0.add(ImmunityRuleBn);
				checkPanel0.add(IRBn);
			}

			infoPanel.add(checkPanel0);
		}

		if (showControlPanel){

//			testNewGenerationBn.setAlignmentX(Component.RIGHT_ALIGNMENT);
			checkPanel1 = new JPanel();

			checkPanel1.setLayout(new BoxLayout(checkPanel1, BoxLayout.X_AXIS));
			checkPanel2 = new JPanel();
			//checkPanel2.setBackground(Color.green);
			checkPanel2.setLayout(new BoxLayout(checkPanel2, BoxLayout.X_AXIS));

			checkPanel3 = new JPanel();
			//checkPanel2.setBackground(Color.green);
			checkPanel3.setLayout(new BoxLayout(checkPanel3, BoxLayout.Y_AXIS));

			checkPanel4 = new JPanel();
			//checkPanel2.setBackground(Color.green);
			checkPanel4.setLayout(new BoxLayout(checkPanel4, BoxLayout.Y_AXIS));

			//CONTENT OF CHECKPANEL 1 STARTS HERE

			if (showSessionBackupCheckBox)
				checkPanel1.add(sessionBackupCheckBox);
			checkPanel1.add(Box.createHorizontalGlue());
			//checkPanel1.add(showText);

			//add if gameVersion = 3+
			if (QuiRules.releasing)
				checkPanel1.add(showRelHandlesBn);

			if (QBuildParameters.doConstruction){
				checkPanel1.add(showArrowsBn);
			}
			//checkPanel1.add(Box.createRigidArea(new Dimension(5,0)));

			checkPanel1.add(toggleShowOptionsButton);

			//CONTENT OF CHECKPANEL 2 STARTS HERE

//			checkPanel2.add(Box.createHorizontalGlue());
			if(QBuildParameters.doConstruction)
				checkPanel2.add(historyOutBn);
			//checkPanel2.add(showText);
//			checkPanel2.add(setTextSizeLabel);
//			checkPanel2.add(textSizeChoser);
			checkPanel2.add(rightClickZoomChBox);

			checkPanel2.add(Box.createHorizontalGlue());
			checkPanel2.add(showToolTipBn);



			infoPanel.add(checkPanel1);
			infoPanel.add(checkPanel2);

		}


		if (QBuildParameters.doConstruction)
			infoPanel.add(testNewGenerationBn);

//		checkPanel3.add(wholeLineDataBox);
//		infoPanel.add(checkPanel3);

		infoPanel.add(wholeLineDataScrollPane);

		if (showBrowserWindow){
//			checkPanel4.add(legalTextBox);
//			infoPanel.add(checkPanel4);

			infoPanel.add(legalTextScrollPane);

		}








//		JLabel matchBoxLabel = new JLabel("Matches displayed:");
//		controlPanel.add(matchBoxLabel);


//		matchBox = new JTextArea(10,20);
//		matchBox.setLineWrap(true);
//		controlPanel.add(matchBox);
//		JScrollPane scroller1 = new JScrollPane(matchBox);
//		scroller1.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
//		scroller1.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
//		controlPanel.add(scroller1);

//		JButton getAnnosButton = new JButton("Get Annotations");
//		controlPanel.add(getAnnosButton);//

//		checkPanel3.add(wholeLineDataBox);
//		if (showLegalText){
//		checkPanel4.add(legalTextBox);
//		//checkPanel4.add(scrollPane);//needs a container for both??
//		}

		//experiment with JEditorPane for displaying html formatted text ...





//		JButton saveAnnosButton = new JButton("Save Annotations");
//		controlPanel.add(saveAnnosButton);

		//infoPanel.add(Box.createVerticalGlue());//NO EFFECT ??



		infoPanel.repaint();
	}



	public void refreshFunctionBar(){

		getGameStatus();
		//remove all components first ...
		functionBar.removeAll();

//		System.out.println("functionBarMode is " + functionBarMode);


		functionBar.add(functionButton);
//		functionButton.setFont(functionBarFont);

		//adding this divider puts the cdButtons to the right!! :-(
		functionBar.add(Box.createRigidArea(new Dimension(7,0)));
		//functionBar.add(new JSeparator(SwingConstants.VERTICAL));


		//use this border??



		switch(functionBarMode){
		case 0:
			functionBar.add(previousMarkerButton);
			functionBar.add(backwardButton);
			if (QBuildParameters.doConstruction)
				functionBar.add(playButton);
			functionBar.add(forwardButton);
			functionBar.add(nextMarkerButton);
			functionBar.add(Box.createRigidArea(new Dimension(5,0)));
			functionBar.add(rotateBoardButton);
			functionBar.add(Box.createRigidArea(new Dimension(5,0)));
			functionBar.add(turnLabel);
			functionBar.add(turnNumberField);


			functionBar.add(maxTurnLabel);


//			functionBar.add(Box.createHorizontalGlue());


//			functionBar.add(Box.createRigidArea(new Dimension(5,0)));



//			functionBar.add(Box.createRigidArea(new Dimension(5,0)));
			functionBar.add(statusLabel);
			if (QBuildParameters.doConstruction){
				functionBar.add(addXButton);
				functionBar.add(addZButton);
				functionBar.add(pZButton);
				functionBar.add(rPZButton);
			}
//			turnNumberField.setText("1");
			//turnNumberField.requestFocusInWindow();
			turnNumberField.selectAll();

			break;
		case 1:


			functionBar.add(copyButton);

			functionBar.add(scoreOutModeBn);
			if (QBuildParameters.softwareBuildInt > 8)
				functionBar.add(correspondenceOutModeBn);
			functionBar.add(posWithFutureOutModeBn);
			functionBar.add(posNoFutureOutModeBn);
			if (QBuildParameters.doConstruction)
				functionBar.add(gifOutModeBn);

			//functionBar.add(purePositionOutMode);


//			functionBar.add(infoOutModeBn);
			functionBar.add(wrapModeBn);
			functionBar.add(Box.createRigidArea(new Dimension(7,0)));
			functionBar.add(pasteButton);

			functionBar.add(Box.createRigidArea(new Dimension(5,0)));
			functionBar.add(titleButton);
			if (showTextInputField){
				functionBar.add(Box.createRigidArea(new Dimension(2,0)));
				functionBar.add(inputField);
				inputField.setText(inputFieldDefaultText);

//				stringField.selectAll();
//				focusFunctionBar();
			}


//			stringField.requestFocusInWindow();
			//no, doesn't work:
//			stringField.selectAll();
//			stringField.revalidate();
//			stringField.repaint();


			break;
//			case 2:
//			functionBar.add(setTextSizeLabel);
//			functionBar.add(textSizeChoser);
//			if (doConstruction){
//			functionBar.add(Box.createRigidArea(new Dimension(7,0)));
//			functionBar.add(setSpeedLabel);
//			functionBar.add(speedChoser);
//			}


//			break;

		default://should be there for prudence?
			break;
		}

		//before help and copyright button
		functionBar.add(Box.createHorizontalGlue());
		functionBar.add(Box.createRigidArea(new Dimension(7,0)));

		//add
//		functionBar.add(helpButton);
		functionBar.add(legalButton);

		//to make space for the Asus status bar collapse arrow
		if (QBuildParameters.leaveBottomBarArrowSpace)
			functionBar.add(Box.createRigidArea(new Dimension(30,0)));



		functionBar.revalidate();

		focusFunctionBar();
//		TODO test focusFunctionBar() thoroughly!

	}

	public void focusFunctionBar(){
//		functionBar.requestFocusInWindow();
		if (functionBarMode == 0){
			turnNumberField.selectAll();
			turnNumberField.requestFocusInWindow();//for now until below
		}
		//turnNumberField.requestFocusInWindow();//implement ...
		if (functionBarMode == 1){
			//get forwardAvailable?
			System.out.println("backwardAvailable is " + backwardAvailable);


			if(backwardAvailable || forwardAvailable){
				//= a line is loaded
				functionButton.requestFocusInWindow();
			} else {
				pasteButton.requestFocusInWindow();
			}


//			if (showTextInputField){
//				stringField.requestFocusInWindow();//Yes,yes!!
//			} else {
//				topMenuBar.requestFocusInWindow();
//			}

		}
//		if (functionBarMode == 2)
//		textSizeChoser.requestFocusInWindow();//??
//		functionBar.revalidate();
		functionBar.repaint();
	}

	public void sendButtonPresses(int cdNo){

		/*
		 * this method might not be necessary once I have
		 * implemented a ControllerEventListener to evaluate
		 * gamestate after each button click ...
		 */
		//old system bypassing the QSFstring gateway:
//		currentBoard.sendOnButtons(cdNo);
		//try sending as QSF string:
		setQSFString("nav=" + cdNo, true);
		//true for isValidated!

		currentBoard.repaint();
		//evaluate effect here:
		getGameStatus();
		if (doSessionBackup)
			writeSessionBackup();

		//functionBar.repaint();//good? needed?
	}

	public String getBuildName(){
		String name = "Quincala Game";

		if (!QBuildParameters.maySaveToDisk){
			name += " Viewer";
		} else {
			name += " Labs";
		}

		if(isApplet)
			name += " Applet";

		name += " " + QBuildParameters.softwareVersion;

		if(QBuildParameters.tournamentEdition){
			name += " Tournament Edition " +
			QBuildParameters.tournamentDateString + " ";
		}

		if(QBuildParameters.useJNLPServices)
			name += " JNLP";

		return name;
	}

	public synchronized void getGameStatus(){
		/*
		 * currently triggered by cd buttons; not by clicking??
		 * this collects the status of the current game, notably
		 * forward/backwardAvailable, Turn no, whose turn, turn phase
		 * maybe also game version?
		 * In the future this can be triggered by a controllerEvent?
		 * then title and game status doesn't need to be initially painted?
		 */
		QGameStatus currentStatus = currentBoard.getGameStatus();
//		System.out.println("gui.getGameStatus is run");
//		forwardAvailable = currentBoard.forwardAvailable();
//		backwardAvailable = currentBoard.backwardAvailable();
		forwardAvailable = currentStatus.forwardAvailable;
		backwardAvailable = currentStatus.backwardAvailable;
//		System.out.println("getGameStatus:backwardAvailable is " + backwardAvailable);
		boolean fComparison  = currentStatus.forwardAvailable;
		boolean bcomparison = currentStatus.backwardAvailable;
		if (fComparison != forwardAvailable || bcomparison != backwardAvailable){
			errorFlag += "forward/backward is not equal!!";
			System.out.println("!!!forward/backward is not equal!!");
		}


		passFlag = currentStatus.passFlag;
//		System.out.println("gui.passFlag is " + passFlag);
		currentTurnNo = currentStatus.currentTurnNo;
		playerNo = currentStatus.playerInt;

		PassActionItem.setEnabled(currentStatus.mayPass);
//		System.out.println("mayPass is " + currentStatus.mayPass);

		//this is a bit double: better to get it off wholeLineData!
		//currentGameLoaded = currentStatus.getFullGameName();

		gameVersion = currentStatus.GameVersion;
		gameVariant = currentStatus.GameVariant;



		refreshInfoText();

		ImmunityRuleBn.setEnabled(!backwardAvailable && !forwardAvailable);
		IRBn.setEnabled(!backwardAvailable && !forwardAvailable);
		//must be at beginning, and no line loaded!!

		previousMarkerButton.setEnabled(backwardAvailable);
		backwardButton.setEnabled(backwardAvailable);
		playButton.setEnabled(forwardAvailable);
		forwardButton.setEnabled(forwardAvailable);
		nextMarkerButton.setEnabled(forwardAvailable);
		/*
		 * small bug: nextMarkerButton displays a
		 * mark as if it has been pressed??
		 * even though the end is reached by >
		 * revalidate() did not sort it ...
		 * still there after setting status bar		 *
		 */
		turnNumberField.setText("" + currentStatus.currentTurnNo);
//		System.out.println("gui.getGameStatus is run and currentTurnNo is " + currentStatus.currentTurnNo);
		statusLabel.setText(currentStatus.getStatusBarText());
		//focusFunctionBar(); no help
//		statusLabel.setText(currentStatus.statusBarText);
		//TODO Bug that a leg needs to be played before text changes???

		//get set here?

	}

//	public String getStatusText(){
//	String statusText = null;
//	System.out.println("gui.getStatusText is run");




//	String playerText = "White";
//	if (playerNo == 1)
//	playerText = "Black";
//	statusText = "Turn: " + currentTurnNo + ", " + playerText
//	+ "'s turn." + errorFlag;

//	if(passFlag == 0){
//	statusText += "(White Passed!)";
//	}
//	if(passFlag == 1){
//	statusText += "(Black Passed!)";
//	}
//	return statusText;
//	}

//	public void toggleOptionsButton(){
//	//could be an inner class if I wanted to generalise toggle buttons
//	//develop from Head First p 395
//	toggleShowOptionsButton.setText(myTexts.optionButtonText());
//	//controlPanel.repaint();//not needed
//	}

//	public void rotateBoard(){
//		currentBoard.rotateBoard(1);//make setting??//obsolete?
////		QGraphics.rotateBoard(1);
////		currentBoard.updatePanelImage();//could update PositionImage; however
//		//some boardgames might not be completely symmetrical
//		//currentBoard.updateOptionsImage();
//	}

	public void setButtonsAbility(boolean buttonsAbility){
		/*
		 * nope; looks active even though it doesn't keep record ...
		 */
		forwardButton.setEnabled(buttonsAbility);
		//System.out.println("forwardButton is able: " + buttonsAbility);
		functionBar.revalidate();
		functionBar.repaint();
	}

	public void setShowOptions(){
		currentBoard.setShowOptions(showOptions);
	}

	public void updateGUIIcons(){


		//upArrowIcon = new ImageIcon(QGraphics.navArrowIm);

//		upArrowIcon.setImage(QGraphics.navArrowIm);
	}

	public void setTextSizes(){
		QGraphics.initQGraphics(guiTextSize);
		forwardButton.setIcon(QGraphics.navArrows[1]);
		backwardButton.setIcon(QGraphics.navArrows[3]);
		nextMarkerButton.setIcon(QGraphics.navArrows[5]);
		previousMarkerButton.setIcon(QGraphics.navArrows[7]);


		UIManager.put("ToolTip.font", new FontUIResource("SansSerif",
				Font.PLAIN, guiTextSize));

		//nope; only internal frames can have title bar font changed ...
		//JFrame is determined by OS
		//try make internal frames for each ~anew?
		//also: 		JFrame.setDefaultLookAndFeelDecorated(true);//in go()?
//		UIManager.put("InternalFrame.titleFont", new FontUIResource("SansSerif",
//		Font.BOLD, guiTextSize));
//		UIManager.put("InternalFrame.titleFont", new FontUIResource("SansSerif",
//		Font.BOLD, guiTextSize));
//		SwingUtilities.updateComponentTreeUI(frame);

		//upArrowIcon.

		//gameMenu.setFont(functionBarFont);//

////		UIManager.put("Menu.font", new FontUIResource("SansSerif",
////		Font.PLAIN, guiTextSize));
//		menuBar.revalidate();//nope

		functionBarFont = new Font("Serif", Font.BOLD, guiTextSize);//do upstairs ...
		//TODO diversify the fonts a bit here ...
		copyModeFont = new Font("Serif", Font.ITALIC, (int)(guiTextSize * 0.85));
		textBoxFont = new Font("Serif", Font.PLAIN, guiTextSize + 1);
		legalTextFont = new Font("Serif", Font.PLAIN, guiTextSize + 1);

		//nope, no effect:
		UIManager.put("OptionPane.messageFont", new FontUIResource(functionBarFont));


//		UIManager.put("OptionPane.font", new FontUIResource(functionBarFont));
		UIManager.put("TextField.textFont", new FontUIResource(functionBarFont));
		UIManager.put("OptionPane.buttonFont", new FontUIResource(functionBarFont));

		//nope:
//	    java.util.Enumeration keys = UIManager.getDefaults().keys();
//	    while (keys.hasMoreElements()) {
//	      Object key = keys.nextElement();
//	      Object value = UIManager.get (key);
//	      if (value instanceof javax.swing.plaf.FontUIResource)
//	        UIManager.put (key, functionBarFont);
//	      }



//		JOptionPane pain = new JOptionPane();
//		pain.setFont(functionBarFont);
//		pain.showInputDialog(frame, "Enter some text : ",
//				"Roseindia.net", 1);
//		SwingUtilities.updateComponentTreeUI(frame);
//		JOptionPane.

		functionButton.setFont(functionBarFont);
		//functionBar.setFont(functionBarFont);//nope doesn't work ...

		ImmunityRuleBn.setFont(functionBarFont);
		IRBn.setFont(functionBarFont);
		sessionBackupCheckBox.setFont(functionBarFont);
		showToolTipBn.setFont(functionBarFont);
		showArrowsBn.setFont(functionBarFont);
		showRelHandlesBn.setFont(functionBarFont);
		toggleShowOptionsButton.setFont(functionBarFont);
		rightClickZoomChBox.setFont(functionBarFont);
		historyOutBn.setFont(functionBarFont);
		testNewGenerationBn.setFont(functionBarFont);

		//wholeLineDataBox.setFont(textBoxFont);//obsolete
		wholeLineDataPane.setFont(textBoxFont);
//		legalTextBox.setFont(textBoxFont);//obsolete
		quincalaBrowser.setFont(legalTextFont);
		//reload??

		infoPanel.revalidate();
		infoPanel.repaint();

		rotateBoardButton.setFont(functionBarFont);
		addXButton.setFont(functionBarFont);
		addZButton.setFont(functionBarFont);
		pZButton.setFont(functionBarFont);
		rPZButton.setFont(functionBarFont);
		turnLabel.setFont(functionBarFont);
		maxTurnLabel.setFont(functionBarFont);
		turnNumberField.setFont(functionBarFont);
		statusLabel.setFont(functionBarFont);

		titleButton.setFont(functionBarFont);
		copyButton.setFont(functionBarFont);

		scoreOutModeBn.setFont(copyModeFont);
		correspondenceOutModeBn.setFont(copyModeFont);
		posNoFutureOutModeBn.setFont(copyModeFont);
		posWithFutureOutModeBn.setFont(copyModeFont);
		purePositionOutModeBn.setFont(copyModeFont);
		gifOutModeBn.setFont(copyModeFont);
		stateOutModeBn.setFont(copyModeFont);
		wrapModeBn.setFont(copyModeFont);

		pasteButton.setFont(functionBarFont);
		inputField.setFont(functionBarFont);//??

				setSpeedLabel.setFont(functionBarFont);
		speedChoser.setFont(functionBarFont);
		setTextSizeLabel.setFont(functionBarFont);
		textSizeChoser.setFont(functionBarFont);

		helpButton.setFont(functionBarFont);
		legalButton.setFont(functionBarFont);


		gameMenu.setFont(functionBarFont);
		sameGameAction.setFont(functionBarFont);

		quincalaPosEditSubmenu.setFont(functionBarFont);
		qPosEditWith5Sizes.setFont(functionBarFont);
		qPosEditWith4Sizes.setFont(functionBarFont);
		qPosEditWith3Sizes.setFont(functionBarFont);


		miniQuincalaSubmenu.setFont(functionBarFont);
		miniQuincalaKnocking.setFont(functionBarFont);
		miniQuincalaMixing.setFont(functionBarFont);

		quincalaStandardSubmenu.setFont(functionBarFont);
		qReleaseWith5Sizes.setFont(functionBarFont);
		qReleaseWith4Sizes.setFont(functionBarFont);
		qReleaseWith3Sizes.setFont(functionBarFont);

		quincalaKnockingSubmenu.setFont(functionBarFont);
		qKnockingWith5Sizes.setFont(functionBarFont);
		qKnockingWith4Sizes.setFont(functionBarFont);
		qKnockingWith3Sizes.setFont(functionBarFont);


		quincalaFootballNew.setFont(functionBarFont);


		quincalaMixingSubmenu.setFont(functionBarFont);
		qMixingWith5Sizes.setFont(functionBarFont);
		qMixingWith4Sizes.setFont(functionBarFont);
		qMixingWith3Sizes.setFont(functionBarFont);

		quincalaBouncingNew.setFont(functionBarFont);
		quincalaUnlimitedNew.setFont(functionBarFont);


		viewMenu.setFont(functionBarFont);
		viewControlPanel.setFont(functionBarFont);
		viewRulesOptions.setFont(functionBarFont);
		viewTextInputField.setFont(functionBarFont);
		textSizesMenuItem.setFont(functionBarFont);
		zoomTextEntry.setFont(functionBarFont);
		resetZoomItem.setFont(functionBarFont);

		actionMenu.setFont(functionBarFont);
		PassActionItem.setFont(functionBarFont);
		resignActionItem.setFont(functionBarFont);
		agreeDrawActionItem.setFont(functionBarFont);

		helpMenu.setFont(functionBarFont);
		homePageItem.setFont(functionBarFont);
		onlineHelpItem.setFont(functionBarFont);
		ruleSheetItem.setFont(functionBarFont);
		onlineScoresItem.setFont(functionBarFont);
		onlineTutorialsItem.setFont(functionBarFont);
		legalItem.setFont(functionBarFont);


		adjustTurnNumberFieldSize();
		functionBar.revalidate();
		functionBar.repaint();
		//these two, or this one:
			//switchFunctionBar();//works if font is set again in switchFunctionBar!!

		//alternatively set font when adding, in switchFunctionBar (refactor?)





	}

	public void setToolTips(){//setToolTipFont ???
		if (showToolTips){

			gameMenu.setToolTipText("(Alt + G) Start a new Game or switch to another one");//when is this done??

			ImmunityRuleBn.setToolTipText("(Alt + M) Enable the new rule about knocking that might replace the irreversibility rule");
			IRBn.setToolTipText("(Alt + U) Keep the old rule about not repeating previous positions");
			sessionBackupCheckBox.setToolTipText("Saves a text file in your home directory with the current or end state of each session");
			showToolTipBn.setToolTipText("(Alt + T) Toggle these informative/annoying pop-ups");

			rightClickZoomChBox.setToolTipText("(Alt + K) Enable zooming in on the board by right clicking");
			showRelHandlesBn.setToolTipText("(Alt + E) Show the green releasing indicator lines");
			toggleShowOptionsButton.setToolTipText("(Alt + O) Show all legal options");

			historyOutBn.setToolTipText("(Alt + Y) Open a log file of QSF Strings from previous sessions in a separate window");

			//wholeLineDataBox.setToolTipText("Shows data concerning the whole line");
			wholeLineDataPane.setToolTipText("<html>Shows Game variant, match information (if present) " +
					"and calculated data concerning the whole line;<br>the text " +
			"is <b>bold</b> if the line is <i>sealed.</i></html>");
			quincalaBrowser.setToolTipText("Shows the legal terms of use and licence as well as copyright messages etc.");

			functionButton.setToolTipText("<html>(Alt + F) Toggle the bar to the right between <i>navigation</i> and " +
					"<i>input/output</i> mode</html>");//add drawing mode!

			previousMarkerButton.setToolTipText("(Alt + PageDown) Back to the previous marker or to the beginning");
			backwardButton.setToolTipText("(Alt + Left Arrow) Back one step");
			forwardButton.setToolTipText("(Alt + Right Arrow) Forward one step");
			nextMarkerButton.setToolTipText("(Alt + PageUp) Forward to the next marker or to the end");//bookmark?
			addXButton.setToolTipText("<html>(Alt + X) Create an <i>example</i> (new tab) starting from this position</html>");

			rotateBoardButton.setToolTipText("(Alt + R) Rotate the game board 90\u00b0 clockwise");//degrees character in Unicode

			turnLabel.setToolTipText(null);
			maxTurnLabel.setToolTipText("Shows the number of turns the line contains");
			turnNumberField.setToolTipText("Type a turn number and press Enter to navigate to the beginning of that turn");

			statusLabel.setToolTipText("Shows current status of displayed game");


			copyButton.setToolTipText("(Alt + C) Copy a QSF String to the clipboard in the format defined to the right");

			scoreOutModeBn.setToolTipText("<html>Simple Match Mode:<br>The copied QSF String will load from the beginning - <br>" +
					"suitable for complete game scores</html>");
			correspondenceOutModeBn.setToolTipText("<html>Correspondence Game Mode:<br>The copied QSF String will " + "" +
			"load from the beginning of the last move - <br>suitable for correspondence games by email or chat clients including Skype.</html>");
			posNoFutureOutModeBn.setToolTipText("<html>Position Mode:<br>The copied QSF String will " +
			"load to the current position WITHOUT future moves -<br>suitable for showing a real world or legal position</html>");
			posWithFutureOutModeBn.setToolTipText("<html>Variation or Example Mode:<br>The copied QSF String will " +
			"load to the current position WITH future moves - <br>suitable for a game variation or example move</html>");
			purePositionOutModeBn.setToolTipText("<html>Pure Position Mode:<br>The copied QSF  String will " +
			"load to the current position with NO past NOR future -<br>suitable for custom starting positions or 'flat' examples</html>");
			gifOutModeBn.setToolTipText("Put the graphic image of the board on the clipboard as a .gif file");
//			infoOutModeBn.setToolTipText("The copied QuString will contain information as on title bar (if present)");
			wrapModeBn.setToolTipText("Copied long QSF Strings will be wrapped to more than one line");
			pasteButton.setToolTipText("<html>(Alt + V) Load a QSF String from the clipboard<br>- can " +
					"cope with line breaks and email reply/forwarding characters!</html>");
			titleButton.setToolTipText("<html>(Alt + i) Enter or edit the line title:<br>" +
			"after clicking this, please type after the prefix 'Title:', then click OK</html>");


			inputField.setToolTipText("Combined Input and Message Box; used for editing the line title, etc");//


			setTextSizeLabel.setToolTipText("Set the size of all text (including tooltips)");
			setSpeedLabel.setToolTipText("Set the speed of animation");


			helpButton.setToolTipText("<html>(Alt + F1) Open help files and rules (when implemented) - <br> " +
			"for now please refer to the separate file 'Quincala Game Viewer Help'</html>");
			legalButton.setToolTipText("(Alt + Q) Toggle the legal and copyright message in the info area");

		} else {
			gameMenu.setToolTipText(null);
			ImmunityRuleBn.setToolTipText(null);
			IRBn.setToolTipText(null);
			showToolTipBn.setToolTipText(null);//or keep always?
			showRelHandlesBn.setToolTipText(null);
			rightClickZoomChBox.setToolTipText(null);
			toggleShowOptionsButton.setToolTipText(null);

			historyOutBn.setToolTipText(null);

			//wholeLineDataBox.setToolTipText(null);//obsolete
			wholeLineDataPane.setToolTipText(null);
			quincalaBrowser.setToolTipText(null);

			functionButton.setToolTipText(null);

			previousMarkerButton.setToolTipText(null);
			backwardButton.setToolTipText(null);
			forwardButton.setToolTipText(null);
			nextMarkerButton.setToolTipText(null);
			addXButton.setToolTipText(null);
			rotateBoardButton.setToolTipText(null);

			turnLabel.setToolTipText(null);
			maxTurnLabel.setToolTipText(null);
			turnNumberField.setToolTipText(null);

			statusLabel.setToolTipText(null);

			titleButton.setToolTipText(null);
			copyButton.setToolTipText(null);

			scoreOutModeBn.setToolTipText(null);
			correspondenceOutModeBn.setToolTipText(null);
			posNoFutureOutModeBn.setToolTipText(null);
			posWithFutureOutModeBn.setToolTipText(null);
			purePositionOutModeBn.setToolTipText(null);
			gifOutModeBn.setToolTipText(null);
			stateOutModeBn.setToolTipText(null);

			pasteButton.setToolTipText(null);
			inputField.setToolTipText(null);

			setTextSizeLabel.setToolTipText(null);
			setSpeedLabel.setToolTipText(null);

			helpButton.setToolTipText(null);
			legalButton.setToolTipText(null);

		}
	}


	public String[] getQuStringDressed(String quStringFormat, boolean stateOut){
		String[] qStringReturn = getQuString(quStringFormat, stateOut);

		qStringReturn[0] = QSFUtils.getQSFVersion() +
		QSFUtils.qsfDelimiter + qStringReturn[0];

		//here add suitable frames to match medium: for assume text mode (<>)
		qStringReturn[0] = QSFUtils.qsfFrame[0] + qStringReturn[0] + QSFUtils.qsfFrame[1];
		//develop to use other prefix/frames for html, wiki out

		//finally wrap the whole thing if user ticked it:
		if (wrapMode)
			qStringReturn[0] = QSFUtils.wrap(qStringReturn[0]);
		//TODO MAKE MORE STREAMLINED NO-WRAP FOR SAME GAME ETC?
		//NEEDED WHEN ENVIRONMENT IS LONG??

		return qStringReturn;

	}

	public synchronized String[] getQuString(String quStringFormat, boolean stateOut){
		/*
		 * this gives info to zoom and title dialogue,
		 * so no qsf version string here!
		 */

		//first make sure that the strings are not being written at the moment:
//		setQSFString("", true);
		/*
		 * the setQSFString method is synchronised, and also
		 * will be the only gateway through which this gui
		 * communicates with the other layers
		 * TODO make mouse click go through this!!
		 */

		String[] qStringReturn = currentBoard.getQuString(quStringFormat, stateOut);

		return qStringReturn;
	}

//wait with this
//	public void set20009QuString(String oldString){
//		String qsfString = QSFUtils.convert2009String(oldString);
//		setWildQSFString(qsfString);
//	}

	public boolean setQSFVersion(String versionString){

		/*
		 * returns false if error ...
		 * only make this returnable until a separate message
		 * system is in place
		 */

//		String[] s = qsfString.split(QSFUtils.qsfSplitterExpression);
		/*
		 * for QSF 0.1, only look at the first one,
		 * if it has a valid version string, set it;
		 * otherwise set to 0.1
		 * Useless?? Just keep 0.1 and look for 0.2 inside the string?
		 */

		versionString = versionString.trim();
		if (versionString.length() == 0)
			return QSFUtils.setQSFVersion("");

		char first = versionString.charAt(0);
		if(first == '=' && (versionString.length() > 7)){
			//is the one we are looking for
			String[] v = versionString.substring(1).split(";");
			if (v.length < 2 || !v[0].equalsIgnoreCase("qsf"))
				return QSFUtils.setQSFVersion("");

			/*
			 * potentially enable more than one string format ...
			 */

			return QSFUtils.setQSFVersion(v[1]);
		}



//		for (int i = s.length - 1; i >= 0; i--) {
//			//backwards to catch the last one first
//			s[i] = s[i].trim();
//			char first = s[i].charAt(0);
//			if(first == '=' && (s[i].length() > 7)){
//				//is the one we are looking for
//				String[] v = s[i].substring(1).split(";");
//				if (v.length < 2 || !v[0].equalsIgnoreCase("qsf"))
//					return QSFUtils.setQSFVersion("");
//
//				/*
//				 * potentially enable more than one string format ...
//				 */
//
//				return QSFUtils.setQSFVersion(v[1]);
//			}
//		}
		//none picked up; set to latest by sending empty string
		return QSFUtils.setQSFVersion("");

	}

	public boolean setGDV(String qsfString){
		/*
		 * returns false if error ...
		 * only make this returnable until a separate message
		 * system is in place
		 */

		//only game strings reach here
		String[] s = qsfString.split(";");
		if (s[0].equalsIgnoreCase("Quincala")){
			if (s.length > 3){
				System.out.println("s[3] is " + s[3]);
				System.out.println("QuiRules.setQDGVersion(s[3]) is " + QuiRules.setQDGVersion(s[3]));
				return QuiRules.setQDGVersion(s[3]);
			} else { //just set to latest by sending an empty string:

				return QuiRules.setQDGVersion("");
			}

		}

		return false;//if head is not right for instance
	}

	protected void showErrorMessage(String errorText){
		JOptionPane.showMessageDialog(mainPane,errorText,"QGV Message", 2);
	}

	protected void showConfirmationMessage(String confirmationText){
		JOptionPane.showMessageDialog(mainPane,confirmationText,"QGV Message", JOptionPane.PLAIN_MESSAGE);
	}


	public void setWildQSFString(String wildQSFString){
		//is overriding!
		setQSFString(wildQSFString, false);
	}


	protected void setValidQSFString(String qsfString){
		//maybe still racing conflict?
		//but much less time!
		setQSFString(qsfString, true);
	}



	protected synchronized void setQSFString(String qsfString, boolean isValidated){

		if (!isValidated){

			//2009 format is like qui355544;;~info Ulf v Bob
			if (QSFUtils.is2009QuString(qsfString))
				qsfString = QSFUtils.convert2009String(qsfString);

			//from QSF 0.1, there are unsafe chars and
			//chars outside us-ascii range: remove!
			qsfString = QSFUtils.cleanWildQSFString(qsfString);
			//Chars can change lists in backwards compatible ways:
			//(unsafe - safe, reserved - safe - reserved)

			System.out.println("cleaned wildQSFString is:");
			System.out.println(qsfString);

			//finally validate the string:
			if(!QSFUtils.isValidQSFString(qsfString)){
				showErrorMessage(QSFUtils.qsfErrorText);
				return;//or jump??
			}

		}

		//if the string has hyperlink prefix, remove it:
		if (QSFUtils.hasQSFHyperLinkPrefix(qsfString)){
			qsfString = QSFUtils.getQHyperLinkQuery(qsfString);
		}

		//then see if it has an initial URL, else split
		String[] splitQuString = new String[1];
		if(QSFUtils.hasInitialURLString(qsfString)){
			//only valid url strings are let through:
			System.out.println("Initial URL identified");
			receiveURLString(qsfString);

		} else {
			//split and deal with each single string
			splitQuString = qsfString.split(QSFUtils.qsfSplitterExpression);
			int splitCount = splitQuString.length;
			System.out.println("splitCount is " + splitCount);

			tooLateStrings = false;//reset for each new string

			for(int i = 0; i < splitCount; i++){
				//no need to trim, since all spaces removed by cleaning!
				String qString = splitQuString[i];
				System.out.println("qString is:" + qString);

				if (qString.length() == 0)
					continue;//try next qString entered.

				//TODO replace string type with booleans?
				int quStringType = QSFUtils.getQSFStringType(qString);
				System.out.println("quStringType is " + quStringType);
				if(tooLateStrings && quStringType != 5){
					/*
					 * only a new version string should be let through if
					 * a too late qsf version has been shown.
					 */
					continue;
				}

				switch (quStringType){
				case QSFUtils.GAME_STRING://game string - fall through when sorted title ...
					//first figure out if the software supports the relevant
					// game definition
					if (!setGDV(qString)){
						//returns false if can't set!

						showErrorMessage(QSFUtils.gdvErrorText);
						functionBarMode = 1;
//						System.out.println("functionBarMode is " + functionBarMode);

						continue;//try next string
					}
//					//else is able to deal with it:
					functionBarMode = 0;
					//do this first, to read old line:
					if(doSessionBackup && QGameSpace.lineHasPlies()){
						//only make a new session name if the old one
						//has any plies ie moves!
						QSessionManager.setSessionName();
						System.out.println("QSessionManager.sessionName is " + QSessionManager.sessionName);
					}

					//temporarily convert new to old qustring
					String[] split = qString.split(";");//3 for QSF 1.0
					System.out.println("split.length is " + split.length);
					String oldstyle = "qui";
					if (split.length > 1 && split[1].length() > 0){
						oldstyle += split[1].trim();
					} else {
						oldstyle += "15";//patch work!!
					}

					if (split.length > 2)
						oldstyle += split[2].trim();
//					String body =  "qui";
//					System.out.println("body is " + body);
					setGameVersion("qui");
					currentBoard.passThruSpaceQuString(oldstyle);
					//slowly build this:
					currentBoard.passThruSpaceQuString(qString);

					//finally
					refreshInfoText();

					getGameStatus();
					refreshInfoPanel();
					currentBoard.repaint();


					break;
				case QSFUtils.SPACE_KEY_STRING://Space keyvalue string
					String key = QSFUtils.getKey(qString);
//					System.out.println("key is " + key);
					String value = QSFUtils.getValue(qString);
					if (key.equalsIgnoreCase("title")){

						value = QSFUtils.decodeValue(value, false);
						//false since no unicode allowed in title values

						currentBoard.passThroughLineInfo(value);
						refreshInfoText();


					} else
						currentBoard.passThruSpaceQuString(qString);
						if (key.equalsIgnoreCase("zoom") && value.equals("0")){
							//unless the divider sets itself from zoom level??
							//value listener?? also change mouse listener!
							int ht = currentBoard.getHeight();
							mainPane.setDividerLocation(ht);
						}
					break;
				case QSFUtils.GUI_KEY_STRING://GUI keyvalue string
					receiveGUIQuString(qString);
					break;
				case QSFUtils.BOARD_KEY_STRING://Board keyvalue string
					currentBoard.receiveBoardQuString(qString);


					break;
				case QSFUtils.URL_STRING://URL string
					receiveURLString(qString);
					break;
				case QSFUtils.QSF_VERSION_STRING://QSF version string

					if (setQSFVersion(qString)){
						//within limits
						tooLateStrings = false;
					} else {
						//returns false if too high!
						System.out.println("too high message is reached");
						tooLateStrings = true;
						showErrorMessage(QSFUtils.qsfvErrorText);
						functionBarMode = 1;
						continue;
					}
					break;
				default:
					break;
				}
				if (doSessionBackup)
					writeSessionBackup();
				//after each single qsf string
			}//for each single string
		} //end initial url single string

		//zoom for miniboard??
		rightClickZoomChBox.setSelected(QGraphics.canZoomByRClick);
		rightClickZoomChBox.setEnabled(!QGraphics.isMiniBoard);
		zoomTextEntry.setEnabled(!QGraphics.isMiniBoard);
		resetZoomItem.setEnabled(QGraphics.isZoomedIn);

		refreshFunctionBar();
		//functionButton.requestFocusInWindow();
		//otherwise alt+F doesn't work after new game string!
	}



	private void receiveURLString(String urlString){
		System.out.println("url is reached!");
		/**
		 * This method adds http:// if needed and tries to
		 * send the URL to the QGV browser
		 */

		if (!QSFUtils.isValidURLString(urlString))//validated by the browser?
			return;

		boolean isURLlocal = urlString.substring(0, 2).equalsIgnoreCase("~/");
		if (isURLlocal)
			urlString = QSFUtils.getCoreURLString("docs" + urlString.substring(1));//remove ~

		//this adds http:// to www.site.com
		//but not https://site.com; site.com is not validated as an URL
		if (urlString.substring(0, 4).equalsIgnoreCase("www."))
				urlString = "http://" + urlString;

		System.out.println("urlString is " + urlString);


		showBrowserWindow = true;
		try {
			quincalaBrowser.setPage(urlString);//which should now be an URL string
			//legalTextPane.setPage(getCoreURLString("docs/wiki/index.htm"));
			//legalTextPane.setPage("http://dl.dropbox.com/u/3897108/Qwiki1.htm");
		} catch (IOException evt) {//not very effective exception handling ...
			quincalaBrowser.setContentType("text/html");
//			jep.setText("<html>Could not load http://www.oreilly.com </html>");
			quincalaBrowser.setText("<html>Unfortunately, either there is " +
					"no internet connection, or the entered URL " +
					"doesn't work in the Quincala Browser.</html>");
		}

		refreshInfoPanel();


	}

	private void receiveGUIQuString(String guiQuString){
		String key = QSFUtils.getKey(guiQuString);
		String value = QSFUtils.getValue(guiQuString);

		if(key.equals("url")){
			//keep game interface
			receiveURLString(value);
		}


	}

	public void switchBoard(){
		/*
		 * like this name :-)
		 * This loads the suitable board panel as currentBoard
		 * depending on currentGameHead
		 * [three letter game identifyer, e.g. "qui"]
		 */

		/*
		 * TODO BUG dispose of the old window?? leave for 0.6!
		 * try maximising then enter quiBirth or glf ...
		 * old board is disabled!
		 */

		if (currentGameHead.equals("qui")){ //Quincala
			currentBoard = new QuincalaBoardPanel();
			currentBoard.init();//to init game engine etc!!
			setUserRules();
			System.out.println("Quincala is loaded");
			currentGameLoaded = "Quincala";
			boardProportion = 1.0d;
			infoPanelMinimumX = 200;

		}
		if (currentGameHead.equals("quiBirth")){//Qui Birth transimation!
			currentBoard = new QuincalaBirth();
			currentBoard.init();
			System.out.println("Quincala Birth is loaded");
			currentGameLoaded = "Quincala Birth";
			boardProportion = 1.0d;
			infoPanelMinimumX = 200;
			//here add instructions not to show toggle options etc
		}
		if (currentGameHead.equals("drw")){ //draw board, rework as drawing tool
			currentBoard = new QuiDrawingPanel();
			currentBoard.init();
			System.out.println("Board Draw is loaded");
		}
		if (currentGameHead.equals("glf")){ //Gloife
			currentBoard = new GloifeGame();
			currentBoard.init();
			System.out.println("Gloife is loaded");
		}
		if (currentGameHead.equals("hnf")){ //Hnefatafl

		}
		if (currentGameHead.equals("chs")){ //Chess (FullChess)

		}
		if (currentGameHead.equals("go_")){ //Gloife
			//currentBoard = new GoGame();
			System.out.println("Classic Go is loaded");
		}
		if(QBuildParameters.doConstruction){
			currentBoard.setDoConstructionTrue();
			System.out.println("gui.doConstruction is " + QBuildParameters.doConstruction);
		}

//		currentBoard.init();//to init game engine etc!!
//		//TODO propagate doConstruction
//		setUserRules();

		currentBoard.addMouseListener(new QGLMouseListener());
		//should be the Glass Pane?? I want it to cover boardPanel only ...


		//currentBoard.add(drawPanel);
		//drawPanel.repaint();



	}

//	public void setMatchInfoText(String infoText){
////		Date now = new Date();
////		DateFormat dateNow = DateFormat.getDateInstance(DateFormat.SHORT);
////		String dateString = dateNow.format(now);
////		DateFormat timeNow = DateFormat.getTimeInstance(DateFormat.SHORT);
////		String timeString = timeNow.format(now);
////		matchInfoText += infoText + " " + dateString + " " + timeString;
//		//matchInfoText = infoText;
//		currentBoard.passThroughLineInfo(infoText);
//		refreshInfoText();
//	}



//	public void refreshTitleBar(){



//	//make dynamic!
////	initInfoPanel();
////	refreshInfoPanel();

//	}

	public synchronized void refreshInfoText(){
		//TODO this method is called too often: 3 times per click ...
		String infoPanelText = currentBoard.passUpWholeLineData().getWholeLineDataString();
		//html formatted

		//wholeLineDataBox.setText(infoPanelText);

		wholeLineDataPane.setContentType("text/html");
		wholeLineDataPane.setText(infoPanelText);

		//this is to keep the title bar up to date:
		currentGameLoaded = currentBoard.passUpWholeLineData().getFullGameName();
		mainTitleText = getBuildName() + " - " + currentGameLoaded;

		String matchTitleText = currentBoard.passUpWholeLineData().getTitleString();
		//not formatted
		if (matchTitleText.length() > 0){
			mainTitleText += " - " + matchTitleText;
		}
		setTitleToTop(mainTitleText);
//		setTitle(mainTitleText);

		maxTurnLabel.setText("/" + currentBoard.passUpWholeLineData().turnsOpened);
		adjustTurnNumberFieldSize();
	}

	private void adjustTurnNumberFieldSize() {
//		System.out.println("adjustTurnNumberFieldSize is run");
		int columnsNeeded = maxTurnLabel.getText().length() - 1;

		turnNumberField.setColumns(columnsNeeded);

//		also need to try to limit the label dimension ...
		Dimension labelDimension = maxTurnLabel.getPreferredSize();
		int ht = labelDimension.height;
		int wd = labelDimension.width;
//		System.out.println("label wd is " + wd);
		Dimension fieldDimension = new Dimension(wd, ht * 5 / 4);

		//maybe try various variants of this:
		turnNumberField.setMaximumSize(fieldDimension);

		turnNumberField.setMinimumSize(fieldDimension);
		//otherwise the field disappears if status message is too long for window!

//		turnNumberField.setSize(fieldDimension);


//		int fieldwd = turnNumberField.getWidth();
//		System.out.println("fieldwd is " + fieldwd);

	}

	protected void writeSessionBackup(){

		/*
		 * this writes a file to the current home directory!
		 * when using jar file ...
		 * How to add to the history file in bin/?
		 * possible in jar?
		 * how to create a new directory??
		 * Maybe just have an option to save sessions in home directory ...
		 * against policy but useful for tournament?
		 */

		//testing
		readLocation();

		if(!showSessionBackupCheckBox)
			return;

		String stateString = getQuStringDressed("posYes", false)[0];//no state out??
		writeSessionStateString(stateString);
		//for testing:
		outputSessionStateStrings();

	}



	protected void setPlainTextInBrowser(String page){
		//overriding QApplication; QApplet??

		showBrowserWindow = true;
		quincalaBrowser.setContentType("text/plain");
		quincalaBrowser.setText(page);
		refreshInfoPanel();
	}

	public void stepPlayer(){

		/*
		 * need to have the metronome here, so status bar can be
		 * repainted (and maybe pause button listened to?)
		 * is doPlay needed?
		 */



//		/*
//		* needs threading?? why doesn't repaint() work inside the loop?
//		* this is called by play button
//		* (or space bar) - it plays the current
//		* loaded line until the end
//		* Unfortunately it hogs the Listeners
//		* There is no way to stop it ...
//		* Useful for defined steps as in play a
//		* turnphse at the time?
//		*/
//		doPlay = true;
//		boolean defaultshowLegal = board.showLegal;
//		board.setShowOptions(false);
//		//paint(getGraphics());
//		board.repaint();//really boardOrnaments ...
//		int stepCount = 0;
////		while(doPlay && quincala.currentLine.forwardStepAvailable) {
//		while(doPlay) { //only reach if forwardStepAvailable
//		synchronized(this) {
//		try {
//		wait(playerDelay);
//		} catch (Exception e) {
//		}
//		}
//		sendButtonPresses(6);
//		getGameStatus();
//		doPlay = forwardAvailable;
//		//clumsy! but works ...
//		stepCount++;
//		System.out.println("stepCount is " + stepCount);
//		board.repaint();
//		//hmmm seems the repaint has to be another thread?
//		//board.repaint(getGraphics()); //repaint(); //
//		if (stepCount > 5) //for testing
//		break;
//		}

//		board.setShowOptions(defaultshowLegal);
	}

	public class QGLMouseListener extends MouseAdapter {
		public void mouseClicked(MouseEvent e) {
			/*
			 * this needs to know the boardParams already ...
			 * in order to draw to scale on the board.
			 * Should be on Glass Pane?
			 */
//			System.out.println(e);

			int mouseButton = e.getButton();
			//System.out.println("mouseButton is " + mouseButton);
			/*
			 * left mouse button is 1, right is 2, wheel button is 2
			 */
			int x = e.getX();
			int y = e.getY();
			if (mouseButton == 1 && clickableBoard){ //left button
				System.out.println("left click!");
				//old system, bypassing the QSF string gateway:
				currentBoard.receiveMouseClick(x, y);

				//new system needed? Receive entry is synched
				//maybe better for simplicity??


				//get set here?
				//currentBoard.updatePanelImage();
				//currentBoard.repaint();
				functionBarMode = 0;
				refreshFunctionBar();
				//do a combined request pipe?


				refreshInfoText();
				if (doSessionBackup)
					writeSessionBackup();


			}
			if (mouseButton == 3 && QGraphics.canZoomByRClick && clickableBoard){//right button
				System.out.println("right click!");
				currentBoard.receiveMouseZoom(x, y);
				//depreciated: still used for pieces
				QGraphics.receiveMouseZoom(x, y);
				currentBoard.updatePanelImage();

				//here let divider snap back when no zoom
				if (QGraphics.radiusSeen == QGraphics.radiusSeenDefault){
					//unless the divider sets itself from zoom level??
					//value listener??
					int ht = currentBoard.getHeight();
					mainPane.setDividerLocation(ht);
				}
				//currentBoard.updateOptionsImage();
				resetZoomItem.setEnabled(QGraphics.isZoomedIn);
			}

		}
	}

	public class DividerSnapBackListener extends MouseAdapter {
		public void mouseClicked(MouseEvent e) {
			/*
			 * TODO make a proper dividerlistener, extending JSplitPane ...
			 * maybe with graphics too?
			 * QSplitPane overrides mouseadapter, contains boardProportion/set~
			 * This is a QuickFix ... if it works ...
			 * try glasspane ...
			 */
//			System.out.println("divider: " + e);

//			System.out.println("GOTCHA!");
		}
	}

	public class SimpleHyperlinkListener implements HyperlinkListener {
		public void hyperlinkUpdate(HyperlinkEvent evt) {
			if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
				//JEditorPane pane = (JEditorPane)evt.getSource();
				System.out.println("evt.getURL().toString() is " + evt.getURL().toString());
				try {
					//set new page from wherever the link was clicked!
					((JEditorPane)evt.getSource()).setPage(evt.getURL());
					// Or just in legalTextPane
					//legalEditorPane.setPage(evt.getURL());
				} catch (IOException e) {
					System.out.println("e.toString() is " + e.toString());
				}
			}
		}
	}

	public class QuStringHyperlinkListener implements HyperlinkListener {
		public void hyperlinkUpdate(HyperlinkEvent evt) {
			/*
			 * This is used for html doc also containing
			 * links to pdf and text files etc
			 * to be launched in external app
			 */

			/*
			 * detect target="_blank" to open in external browser?
			 */
			if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
				String linkText = evt.getURL().toString();

//				System.out.println("evt.toString() is " + evt.toString());
//				System.out.println("evt.getDescription().toString() is " + evt.getDescription().toString());
//				System.out.println("evt.getEventType().toString() is " + evt.getEventType().toString());
//				System.out.println("evt.getSource().toString() is " + evt.getSource().toString());
//
//				System.out.println("evt.getSourceElement().getAttributes().toString() is " + evt.getSourceElement().getAttributes().toString());
				System.out.println("linkText is " + linkText);

				if (QBuildParameters.browserTest){

//					((JEditorPane)evt.getSource()).setText(linkText);
					quincalaBrowser.setContentType("text/plain");
					String lengthString = "Link has " + linkText.length() + "chars:\n";
					quincalaBrowser.setText(lengthString + linkText);

					return;
				} else {

					receiveURLString(evt.getURL().toString());


					//or
//					try {
//
//						//set new page from wherever the link was clicked!
//						((JEditorPane)evt.getSource()).setPage(evt.getURL());
//						// Or just in legalTextPane
//						//legalEditorPane.setPage(evt.getURL());
//					} catch (IOException e) {
//						//unfortunately exception doesn't catch non-html/txt file
//						System.out.println("e.toString() is " + e.toString());
//						//filter out qgn and qsl
//
//
//					}

				}



//
////				get the first four letters
//				String head = linkText.substring(0, 4);
//				System.out.println("head is " + head);
//
//				//also get the last three letters:
//				int linkLength = linkText.length();
//				String extension = linkText.substring(linkLength - 3);
//				System.out.println("extension is " + extension);
//
//
//				//nope only sorted QuStrings:
//				/* from http://forums.sun.com/thread.jspa?threadID=648553
//
//http://forums.sun.com/thread.jspa?threadID=650234&tstart=0
//seems good
//You can use getResourceAsStream to open the PDF in the jar
//
//or
//You can programmatically extract it using Java or you can use Runtime to extract it.
//				 */
////				String test = evt.getSource().getClass().toString();
////				System.out.println("test is " + test);
//
//
//
//
//
//				//first of all, filter out qgn and qsl
//
//				if (extension.equalsIgnoreCase("qgn")){
//					System.out.println("Make a .qgn importer!");
//				} else if (extension.equalsIgnoreCase("qsl")){
//					//simply extract the penultimate of the URL as a quistring!
//					String[] cutlinkText = linkText.split("/");
////					for(int i = 0; i < cutlinkText.length; i++){
////					System.out.println("cutlinkText" + "[" + i + "] is " + cutlinkText[i]);
////					}
//					if (cutlinkText.length > 1){
//						String quStringCandidate = cutlinkText[cutlinkText.length - 2];
//						//System.out.println("quStringCandidate is " + quStringCandidate);
//						setWildQSFString(quStringCandidate);
//						//where it will be cleaned and validated further!
//						//TODO maybe send to special methods for hyperlinks?
//					} else {
//						System.out.println("quStringCandidate is too short!!");
//					}
//				} else if (head.equalsIgnoreCase("http")){
//					//==the link is pointing to the internet
//					//or should I let www. through too?
//
//					//first filter out all quString and external file formats
//					//then pass it on to the pane to try to render it ...
//
//					if (isExternalFormat(extension)) {
//						//BUG the link get all wrong - write a routine to put it right?
//						//linkText is http://www.looseswede.net/files/NDAPrivate.pdf
//						File onlineFileToLaunch = new File(linkText);
//						//onlineFileToLaunch is http:\www.looseswede.net\files\NDAPrivate.pdf
//						//Probably try to download it, then open it??
//						System.out.println("onlineFileToLaunch is " + onlineFileToLaunch);
//						try{
//							QXLauncher.open(onlineFileToLaunch);//static just calls the class!
//						} catch (IOException eio) {
//							System.out.println("Unable to get doc: " + linkText);
//							System.out.println("Because " + eio.getMessage());
//
//						}
//					} else {
//						//finally it might be an html or txt file
//						try {
//							//set new page from wherever the link was clicked!
//							((JEditorPane)evt.getSource()).setPage(evt.getURL());
//							// Or just in legalTextPane
//							//legalEditorPane.setPage(evt.getURL());
//						} catch (IOException e) {
//							//unfortunately exception doesn't catch non-html/txt file
//							System.out.println("e.toString() is " + e.toString());
//							//filter out qgn and qsl
//
//
//						}
//					}
//				}  else {
//					//this is local files
//					//could use
//					// else if (head.equalsIgnoreCase("file"), but
//					//probably safe to assume all have jar: or file:/ prefix here?
//
//					//fist remove any "jar:" prefix
//					if (head.equalsIgnoreCase("jar:")){
//						linkText = linkText.substring(4);
//						head = linkText.substring(0, 4);
//						System.out.println("cut head is " + head);
//					}
//
//					//then remove the file:/ prefix:
//					linkText = linkText.substring(6);
//					//System.out.println("cut linkText is now " + linkText);
//
//					if (extension.equalsIgnoreCase("htm") || extension.equalsIgnoreCase("tml") || extension.equalsIgnoreCase("txt")){
//						//catching all htm, html and txt pages
//						try {
//							//set new page from wherever the link was clicked!
//							((JEditorPane)evt.getSource()).setPage(evt.getURL());
//							// Or just in legalTextPane
//							//legalEditorPane.setPage(evt.getURL());
//						} catch (IOException e) {
//							System.out.println("e.toString() is " + e.toString());
//
//						}
//
//
//					}  else {
//						System.out.println("reached here!! yes");
//						//local files with pdf type extensions
//						//can't open from jar file!!
//
//						//testing:
////						InputStream stream = null;
////						try
////						{
////						stream = getClass().getResourceAsStream("/com/test.pdf");
////						}
////						catch(Exception ex)
////						{
////						ex.printStackTrace();
////						System.out.println("Exception is caught");
////						}
////						System.out.println("stream.toString() is " + stream.toString());
//						File localFileToLaunch = new File(linkText);
//
////						File localFileToLaunch = null;
////						try{
////						localFileToLaunch = new File(linkText);
////						} finally {
////						//no idea??!!
////						}
//						//or what exception does it throw??
////						} catch (IOException e) {
//
////						}
//
//						System.out.println("localFileToLaunch is " + localFileToLaunch);
//						try{
//							QXLauncher.open(localFileToLaunch);//static just calls the class!
//						} catch (IOException e) {
//							System.out.println("Unable to get doc: " + linkText);
//							System.out.println("Because " + e.getMessage());
//
//						}
//
//					}
//
//
//
//
//
//
//
//					//old ideas and devs:
//
//
//					//what about text file from the internet?
//					//suggestion open those in pane, only local ones to local apps
////					if (extension.equalsIgnoreCase("pdf")){
////					//String fullPath = getCoreURLString(linkText);
////					File fileToLaunch = new File(linkText.substring(6));
////					//take file:/ away
////					try{
////					QXLauncher.open(fileToLaunch);//static just calls the class!
////					} catch (IOException e) {
////					System.out.println("Unable to get doc: " + linkText+ e.getMessage());
////					System.out.println("Because " + e.getMessage());
//
////					}
////					}
//					//actually for fullLinkListener ...
//					/*
//					 * Problem is that for pdf etc, one shouldn't aim at sending
//					 * the file name as a qui string ...
//					 * for QuincalaLinkListener, put file laucnher ifs
//					 * inside the head.equals("file") !!
//					 */
////					if (head.equalsIgnoreCase("file")){
////					//simply extract the last of the URL as a quistring?
////					String[] cutlinkText = linkText.split("/");
//////					for(int i = 0; i < cutlinkText.length; i++){
//////					System.out.println("cutlinkText" + "[" + i + "] is " + cutlinkText[i]);
//////					}
////					String quStringCandidate = cutlinkText[cutlinkText.length - 1];
////					//System.out.println("quStringCandidate is " + quStringCandidate);
////					if(quStringCandidate.substring(0,3).equalsIgnoreCase("qui"))
////					qStringGateway(quStringCandidate);
////					}
//
//				}
			}
		}
	}



	public boolean isExternalFormat(String extension){
		boolean result = false;
		String[] knownExtensions = {"pdf", "odt", "doc", "mp3","jpg"};
		int count = knownExtensions.length;
		for (int i = 0; i < count; i++){
			if(knownExtensions[i].equals(extension)){
				result = true;
				break;
			}

		}

		return result;
	}

	public class SplitPaneListener extends ComponentAdapter {
//		public void componentHidden(ComponentEvent e) {
//		System.out.println(e.getComponent().getClass().getName() + " --- Hidden");
//		}

//		public void componentMoved(ComponentEvent e) {
//		System.out.println(e.getComponent().getClass().getName() + " --- Moved");
//		}

		public void componentResized(ComponentEvent e) {
//			System.out.println(e.getComponent().getClass().getName() + " --- Resized ");
			int ht = currentBoard.getHeight();
//			System.out.println("ht is " + ht);

			int mainPaneWidth = mainPane.getWidth();
//			int mainPaneHeight = mainPain.getHeight();
			System.out.println("mainPaneWidth is " + mainPaneWidth);
//			System.out.println("mainPaneHeight is " + mainPaneHeight);




			int dividerLoc = (int) (ht * boardProportion + 1);
			int dividerLimit = mainPaneWidth - infoPanelMinimumX;
			if (dividerLoc > dividerLimit){
				dividerLoc = dividerLimit;
			}
			mainPane.setDividerLocation(dividerLoc);

//			int wd = currentBoard.getWidth();

//			QBoardGraphics.setHeightAndWidth(ht, wd);//done on every paint!
//			currentBoard.updatePanelImage();


			//this sets the boardpanel automatically
			//maybe tell the boardpanel to update sizes??
//			refreshBoardSizes();
		}




//		public void componentShown(ComponentEvent e) {
//		System.out.println(e.getComponent().getClass().getName() + " --- Shown");

//		}

	}

	protected static ImageIcon createImageIcon(String path) {
		String imageFolderPath = "";
		path = imageFolderPath + path;
		java.net.URL imgURL = QGameLabsGUI.class.getResource(path);
		if (imgURL != null) {
			return new ImageIcon(imgURL);
		} else {
			System.err.println("Couldn't find file: " + path);
			return null;
		}
	}







	//keep these for reference!
//	class ForwardButtonListener implements ActionListener {
//	public void actionPerformed(ActionEvent event){

//	}

//	}

//	class PlayButtonActionListener implements ActionListener {
//	public void actionPerformed(ActionEvent e) {
//	System.out.println("Playbutton!");
//	//toggleShowOptions();
//	}
//	}





}
