/*
**********************************************************************
*                        License Notice
*
* QApplication.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the GPL licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/

package com.quincala.gui2D;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;

import javax.swing.JFrame;

import  com.quincala.core.*;

public class QApplication extends JFrame {

	/*
	 * rethink the structure!
	 */

//	String sessionName = QSessionManager.getSessionNameTimeString();//loads OK

	protected final boolean isApplet = false;


    protected void readLocation(){
    	//tested from gui.writeSessionBackup

    	String c = "";

    	if(!QBuildParameters.useJNLPServices)
    		c = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();

    	//note: getting protectionDomain is not allowed under JNLP!!

    	//if ending is .jar, remove last bit after /;
    	//make sure it is a directory; should be ok
    	//use to write files in, to cover for Linux and windows differences
    	//test on Mac!

    	System.out.println("This class Path: "+ c);

//    	return c;
    }

	protected void writeSessionStateString(String stateString){
		/*
		 * this writes a file to the current home directory!
		 * when using jar file ...
		 * How to add to the history file in bin/?
		 * possible in jar?
		 * how to create a new directory??
		 * Maybe just have an option to save sessions in home directory ...
		 * against policy but useful for tournament?
		 */
//		String historyPathString = getSessionPathString();// useless for now
//		String fullPathString = historyPathString + sessionName + ".txt";
//		System.out.println("fullPathString is " + fullPathString);

		try {
			BufferedWriter out = new BufferedWriter(new FileWriter(QSessionManager.sessionName));
			out.write(stateString);
//			System.out.println("stateString is " + stateString);
			out.close();
		} catch (IOException e) {

		}
	}

	protected void outputSessionStateStrings(){

		String page = QSessionManager.sessionName + ":\n\n";
//		String historyPathString = QSFUtils.getSessionPathString();
		try {
			BufferedReader in = new BufferedReader(new FileReader(QSessionManager.sessionName));
			String line;

			while ((line = in.readLine()) != null) {
				page += line;
//				process(str);
			}
			in.close();
			System.out.println("page is " + page);
			setPlainTextInBrowser(page);

		} catch (IOException e) {
			System.out.println("not found file exception is thrown");
		}
	}

	protected void setPlainTextInBrowser(String page){

	}

	protected void openExternalUrlString(String externalURLString){
//		getAppletContext().showDocument(externalURL,"_blank");
		if(QBuildParameters.useJNLPServices){
			//for now use the clipboard class for this?
			QXLauncher.openWS(externalURLString);

		} else {
			QXLauncher.open(externalURLString);
		}

	}

	protected void packApplication(){
		pack();
	}

	protected void setCloseOperation(){
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	protected void setMaximized(){
		setExtendedState(Frame.MAXIMIZED_BOTH);
	}

	protected void setTitleToTop(String mainTitleText){
		setTitle(mainTitleText);
	}

	protected void manageWindowManagers(){
		/*
		 * TODO test with maximus in virtual
		 * machine UNR 10.4
		 */

//		if(maximus){
//			//Yess!!!
//			/*
//			 * maximus is a Daemon? in UNR, Ubuntu Netbook Remix that
//			 * automatically maximises windows and puts their title bar
//			 * at the very top, saving a valuable 24 pixels
//			 * Without set look and feel true the jar doesn't load with maximus
//			 * with decorations, java duplicates the title bar!
//			 * by creating the frame twice and load maximised, maximus is happy!
//			 * Well, almost: if unmaximise and then maximise, the title bar
//			 * disappears until you click the window to focus ...
//			 * solution is to let UNR focus when mouse is over the window
//			 * Preferences,Windows,Window Selection: tick first!
//			 */
//			JFrame.setDefaultLookAndFeelDecorated(true);
//			frame = new JFrame();
//			JFrame.setDefaultLookAndFeelDecorated(false);
//			frame = new JFrame();
//			frame.setUndecorated(true);
//			//frame.setResizable(false);//better set auto focus on mouseover in UNR!
//
//		} else {
//			//frame = new JFrame();
//
//			//JFrame.setDefaultLookAndFeelDecorated(false);
//			frame = new JFrame();//Applet in Browser can't cope with jframes close operation ...
//			//frame.setUndecorated(true);
//		}
	}

}
