/*
**********************************************************************
*                        License Notice
*
* QApplet.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the GPL licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/

package com.quincala.gui2D;

import java.applet.*;
import javax.swing.*;

import java.net.*;

import com.quincala.core.QGraphics;
import com.quincala.core.QSFUtils;

import java.awt.event.*;
import java.awt.*;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;


/*
 * idea to keep go() and init() in
 * the super classes, and call
 * first(), second() methods?
 * switch platform just by changing superclass
 * would be ideal!
 */


public class QApplet extends JApplet {

	protected final boolean isApplet = true;

//	public void start(){
//		/*
//		 * maybe not override?
//		 */
//
//	}

	public void init(){

		initialise();
		go();
//		rightClickZoomChBox.setEnabled(!QGraphics.isMiniBoard);
//		zoomTextEntry.setEnabled(!QGraphics.isMiniBoard);
//		resetZoomItem.setEnabled(!QGraphics.isMiniBoard);

		String base = getDocumentBase().toString();
		if (base != null){
			System.out.println("base is " + base);
			//here check if is in hyperlink format etc?

			setWildQSFString(base);
		}



	}
	public void initialise(){

	}

    protected void readLocation(){
    	//not used for applets
    }

	public void go(){

	}

	public void setWildQSFString(String wildString){

	}

	public void start(){

//		String base = getDocumentBase().toString();
//		if (base == null)
//			base = "";

	}

	protected void openExternalUrlString(String externalURLString){
		//this works off-line at least!
		URL externalURL = null;
		try {
			externalURL = new URL(externalURLString);
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			System.out.println("Exception: external URL String " +
					externalURLString + "does not form an URL");
			e.printStackTrace();
		}
		getAppletContext().showDocument(externalURL,"_blank");
	}

	protected void packApplication(){
		//keep empty; only used for applications?
	}

	protected void setCloseOperation(){
//		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		//keep empty
	}

	protected void setMaximized(){
//		setExtendedState(Frame.MAXIMIZED_BOTH);
		//keep empty
	}


	protected void setTitleToTop(String mainTitleText){
//		setTitle(mainTitleText);//for applets??
	}

	protected void manageWindowManagers(){
		//keep empty? or to cope with different browsers?
	}

	protected void writeSessionStateString(String stateString){

		/*
		 * this needs to be here to compile the LabsGUI as
		 * JApplet?
		 */
	}

	protected void outputSessionStateStrings(){
		/*
		 * this needs to be here to compile the LabsGUI as
		 * JApplet?
		 */
	}

}
