/*
**********************************************************************
*                        License Notice
*
* QuincalaBoardPanel.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

//import net.looseswede.QuUtils.QuCalc;

//import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*; //for scanner

import java.awt.Image;
import java.awt.image.BufferedImage;


//import javax.swing.*;


import com.quincala.core.*;

//import com.quincala.gamequincala.QuincalaGUIAWT.GridListener;
//import com.quincala.gamequincala.QuincalaGUIAWT.MyKeyListener;
//import java.io.*;

//import java.awt.event.KeyAdapter;
////import java.awt.event.KeyListener;
//import java.awt.event.KeyEvent;
//import java.awt.event.MouseAdapter;
//import java.awt.event.MouseEvent;




public class QuincalaBoardPanel extends QGamePanel  {
	//TODO fill squares after board is defined in rules!

	private boolean viewBoardOnly = false;
	//only used by me to capture a clean board for design right purposes etc

	//experimental
	//QuiBoardMaker boardMaker = new QuiBoardMaker();//maybe static??
	BufferedImage boardImage = null;
	public boolean drawExperimentalImage = true;
	BufferedImage optionsImage = null;
	BufferedImage turnIndicatorImage = null;

	public int ht = 0;
	public int wd = 0;//temporary


	//put this in QuiBoardGraphics?
	double[][] lineDef = {
			//{0.00, 0.00, 1.0, 0.00, 0.66666, 2.00, 0.00, 2.00},//change 2 & 4 only
			{0.622, 1.117, 0.689, 1.60, 0.429, 2.0, 0.0, 2.0},//first approximation
			{0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.00, 1.00},
			{0.00, 6.00, 0.47, 6.00, 0.53, 0.00, 1.00, 5.00},
			{1.00, 5.00, 1.47, 0.00, 1.53, 0.00, 2.00, 5.00},//control 3 segments
			{2.00, 5.00, 2.30, 5.00, 2.6, 0.0, 2.80, 4.60},//4. wave lft
			{0.0, 0.0, 0.0, 4.80, 2.9, 4.90, 3.00, 5.00},//5. wave rght
			{3.00, 5.00, 0.0, 0.0, 0.0, 0.0, 4.00, 5.00},
			{4.00, 5.00, 0.0, 0.0, 0.0, 0.0, 5.00, 5.00},
			};
	double[][] xpandLn = new double[64][8];
	double[][] ln = new double[64][8];
	CubicCurve2D[] ornArray = new CubicCurve2D[64];

	//this is the board polygon:
	int[] boardPolygonX =  {1, 5, 6, 7, 8, 12, 12,
							13, 13, 12, 12, 8, 7,
							6, 5, 1, 1, 0, 0, 1};
	int[] boardPolygonY =  {1, 1, 0, 0, 1, 1, 5, 6,
							7, 8, 12, 12, 13, 13, 12,
							12, 8, 7, 6, 5};
	int[] boardPolygonXExp = new int[20];
	int[] boardPolygonYExp = new int[20];

	//gridlines
	public boolean showGrid = false;//implement "showgrid" quString ...?
//	public boolean showDiamonds = true;
//	public boolean showBezierPolygons = false;
//	public boolean toPrint = false;



	//zooming:
//	public int centerSqXCoord = 6; //6 is middle of board
//	public int centerSqYCoord = 6;//as in notation direction!
	public int centerSqLocDefault = 84;
	public int centerSqLoc = centerSqLocDefault;//new generation
	public double radiusSeenDefault = 7;
	public double radiusSeen = radiusSeenDefault;//make int and unit centisquare?
	//normal: radius seen: 6.5 or 7;
	//for centre work: 6,5,1; south gate: 6,1,0.5; wave: 8,1,0.5
	//full centre: 6,6,1.8, full line segment: 8,1,1.7
	//small petal 7,5,-0.1


	//private boolean showReleaseHandles = true;
	//needs here as well as in QGamePanel??

	public boolean[] legalOptions = new boolean[169];
	public byte[] immortalPieces = new byte[169];
	public byte[] immunePieces = new byte[169];

	//do all these public to enable QuiBirth?
	private BasicStroke greyOutlineStroke = new BasicStroke(1.0f);
	private BasicStroke selectOutlineStroke = new BasicStroke(1.0f);
    public BasicStroke ornLineStroke = new BasicStroke(2.0f);
    private BasicStroke whiteDiamStroke = new BasicStroke(2.0f);
    private BasicStroke relHandleStroke = new BasicStroke(1.0f);
    private BasicStroke trailingCircleStroke = new BasicStroke(1.7f);
	final static float dash1[] = {5.0f};
    private BasicStroke bouncingLineStroke = new BasicStroke(2.0f,
                                          BasicStroke.CAP_BUTT,
                                          BasicStroke.JOIN_MITER,
                                          10.0f, dash1, 0.0f);

    public Color tableClothColour = new Color(230,230,230);
    public Color frameColour = new Color(180, 180, 180);
    public Color frameColourLight = new Color(225, 180, 180);

    public Color boardColourLight = new Color(225, 160, 0);//options
    public Color boardColour = new Color(180, 160, 0);
    //for testing
    public Color boardColourPoly = new Color(30, 160, 200);

    //these are transitional but works: make better markings
    public Color boardColourLightGoalDot = new Color(225, 180, 0);
    public Color boardColourGoalDot = new Color(180, 180, 0);

    public Color selectedSquareColour = Color.red;
    public Color winSquareColor = Color.yellow;

    public Color ornOlineColour = new Color(180,180,180);
    public Color blackDotColour = new Color(180,180,180);

    public Color blackPieceColour = Color.black;
    public Color whitePieceColour = Color.white;
    public Color outlineColour = new Color(140, 140, 140);
    public Color releaseOutlineColour = Color.green;
//  public Color immortalOutlineColour = Color.blue;
    public Color immortalOutlineColour = new Color(0, 100, 255);
    public Color selectedImmortalOutlineColour = Color.magenta;

    public Color immuneOutlineColour = Color.yellow;
    public Color selectedImmuneOutlineColour = new Color(255, 130, 0);//G+ for more yellow ...


    public Color selectedOutlineColour = Color.red;

    //spare:
    public Color violetColour = new Color(35, 0, 228);//test



    public Color releaseHandleColour = Color.green;



	QuiGameSpace currentSpace = new QuiGameSpace();
	QuiGraphics boardGraphics = new QuiGraphics();

	private QuCalc calc = new QuCalc();//use QuiUtils instead!!
	//TODO get calc functionality to QuiUtils
	//QuiController quiController = new QuiController();
	//insert this one!

	public void init() {
		init("");
	}


	public void init(String defaultVariant) { // is what is run initially

		//This line is the make do input line for game variants!
		//experiment
//		System.out.println("immortalOutlineColour.getRed() is " + immortalOutlineColour.getRed());
//		System.out.println("immortalOutlineColour.getGreen() is " + immortalOutlineColour.getGreen());
//		System.out.println("immortalOutlineColour.getBlue() is " + immortalOutlineColour.getBlue());
		currentSpace.initGameSpace(defaultVariant);
		/*
		 * by sending quincala.initGame(""), the game engine
		 * sets up its own default ("35"); sending another valid
		 * quString overrides the game engine default
		 */
		edit = true;
		//setLayout(new FlowLayout());


		if (QRules.isPosEdit)
			showLegal = false;

		//setDrawSizes();//doesn't work ...

		if(doConstruction)
			currentSpace.setDoConstructionTrue();

//	    expandOrnLineDef();//this is init only!//old
	    QuiGraphics.initQuiGraphics();//new




		//addMouseListener(new GridListener());
		//addKeyListener(new MyKeyListener());//no luck ...
	}

	public void paint(Graphics g) {
		//System.out.println("PAINT boardpanel");
		Graphics2D g2d = (Graphics2D) g;

//		maybe put this check somewhere else?:
		//can't put call to paint from updateBoardImage??
		ht = this.getHeight();
		wd = this.getWidth();
		QGraphics.setHeightAndWidth(ht, wd);//do it anyway
		//otherwise double images in wide screen mode
		//TODO this is silly; try just from panel listener!
		int sizeCandidate = ht;
		if (wd < ht)
			sizeCandidate = wd;

		if (sizeCandidate != boardPanelSize){
			boardPanelSize = sizeCandidate;
			//System.out.println("New boardPanelSize is " + boardPanelSize);
//			update scale if new panel size:

			//new:
			//splitpanelistener might miss this
			QGraphics.setBoardPanelSize(sizeCandidate);
			//QuiBoardGraphics.setDrawSizes();//or double??

			//old:
			updatePanelImage();//does set drawsizes by itself
		}


		//int ss = squareSize; // short for square size ...
		//int boardValue;
		boolean legal;
		byte inStack;
		int height;
		byte inBlack;
		byte inPieceSel;
		//byte inSquareSel;
		//int activeSquare = currentSpace.currentState.activeLocation;
		//active square not used in 0.6+
		int whiteGoalDot = QuiRules.whiteGoalDot;
		int blackGoalDot = QuiRules.blackGoalDot;
		int xMid; // defines the midpoint of the location
		int yMid;
		int xPiece; // defines top corner of a piece in a stack
		int yPiece;
		int pwide; //holds the width of the piece

		//TODO BUG? zoom with drawn window causes double image if this commented out:
		//0. draw "table cloth" behind canvas for when panel is not square
		//could optimise by if (wd != ht) :-)
        if(QGraphics.canvasTextureInt == -1){
        	g2d.setColor(QuiGraphics.tableClothColour);//tableClothColour
        } else {
        	g2d.setPaint(QGraphics.texture2);
//        	g2d.setColor(Color.white);//in case no texture used
        	//TODO add canvas textures
        }
//		g2d.setColor(QuiGraphics.tableClothColour);
		//no colour should be stored in this class!
        g2d.fillRect(0, 0, wd, ht);

		//1. draw frame as rectangle/square

		//testing open turn:
//		if (currentSpace.currentState.turnLocCount ==0){
//			g2d.setColor(Color.green);
//		} else {
//			g2d.setColor(frameColour);
//		}
		//alternatively:






		//Ximage do bouncing lines too!!!
		if(drawExperimentalImage){
			int xCanv = QGraphics.xCanv;
			int yCanv = QGraphics.yCanv;
			g2d.drawImage(boardImage, xCanv, yCanv, null);
			if(showLegal){
				float transparency = 0.5f;
				g2d.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, transparency));
				g2d.drawImage(optionsImage, xCanv, yCanv, null);
				//is there an easier way to reset transparency settings for turnIndicator etc?
				transparency = 1.0f;
				g2d.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, transparency));

			}
			if(viewBoardOnly){
				g2d.dispose();
				return;
			}

			g2d.drawImage(turnIndicatorImage, xCanv, yCanv, null);

		}


		//experiment navARR


		if (currentSpace.currentState.bouncingDirectionUnit != 0){
//	System.out.println("bouncing line will be drawn!");
	int[] bLine = currentSpace.currentState.bouncingLineLocs;
	//TODO this is a bit clumsy; also for releasing handles ...
	int xMidOrig = (int) (QGraphics.xTop + (QGraphics.gridX(bLine[0]) + 0.5) * ss);
	int yMidOrig = (int) (QGraphics.yTop + (QGraphics.gridY(boardRotation, bLine[0]) + 0.5) * QGraphics.ss);
	int xMidDest = (int) (QGraphics.xTop + (QGraphics.gridX(boardRotation, bLine[1]) + 0.5) * QGraphics.ss);
	int yMidDest = (int) (QGraphics.yTop + (QGraphics.gridY(boardRotation, bLine[1]) + 0.5) * QGraphics.ss);
	g2d.setStroke(bouncingLineStroke);
	g2d.setColor(selectedOutlineColour);//seems good choice
	g2d.drawLine(xMidOrig, yMidOrig, xMidDest, yMidDest);
}

		//6. make pieces
		for (int y = 0; y < 13; y++) { //I like y before x; follows the alexian rows
			for (int x = 0; x < 13; x++) {

				//first define variable values specific to x and y
				int loc = QGraphics.location(x,y);
				/*
				 * QuGame doesn't know which type of board the caller uses, but provides
				 * formulas for the standard 2D board with rotation
				 */
				inStack = currentSpace.currentState.stacks[loc];
				byte releasedSizes = currentSpace.currentState.releasedPieces[loc];
				height = calc.countBits(inStack);
				inBlack = currentSpace.currentState.blackPieces[loc];
				inPieceSel = currentSpace.currentState.pieceSelections[loc];
				//inSquareSel = quincala.current.squareSelections[loc];

				xMid = (int) (QGraphics.xTop + (x + 0.5) * QGraphics.ss) + 1;
				yMid = (int) (QGraphics.yTop + (y + 0.5) * QGraphics.ss) + 1;

				//here pieces are drawn on top - make sure diamonds are smaller than one piece thick

				/**
				 * The pieces are represented by two 5 bit bytes, inStack and inBlack,
				 * the first contain all pieces, the latter all black pieces.
				 * The largest size is represented by 1, then by 2, 4, 8 & 16
				 * The stack is the sum of these numbers, and the bytes can be manipulated
				 * using bitwise operators.
				 * New Gen: sizes are 1, 2, 3, 4 & 5!
				 */

//				this is the top corners of the largest piece present in the stack
				yPiece = (int) (yMid + (height - 2 ) * unit);//defines top left corner to middle of the square
				xPiece = (int) (xMid - xLargestPiece);

				for (int size = 1; size <= smallestSize; size *=2) {
					/*
					 * this loops through all potential sizes on the dot,
					 * starting with the largest piece, as represented by
					 * 2 exp i
					 */

					//fist calculate the width of the potential piece
					pwide = (xMid - xPiece)* 2; //should I add 1???

					//then query if the piece is present, and if so, what colour it is
					if (calc.isPresent(size, inStack)){ //this means the size is there
						if (calc.isPresent(size, inBlack)){ //this means the piece is black
							g2d.setColor(blackPieceColour);
						} else { //so this means it is white!
							g2d.setColor(whitePieceColour);
						}
						//now draw rectangle
						g2d.fillRect(xPiece,yPiece,pwide,pthick);

						//here draw a grey dot if size D/d or B/b (size = 2 or 8)
						if(size == 2 || size == 8){
							g2d.setColor(outlineColour);//same as outline
							g2d.drawLine(xMid,yPiece + pthick/2,xMid,yPiece + pthick/2);//dot
							if (markerRad >= 1){
								int yOffset = markerRad/2;
								if (yOffset > 1)
									yOffset = 1;
								//maybe play with this? - not so big offset for large zooms?
								g2d.fillOval(xMid - markerRad, yPiece + pthick/2 - yOffset, 2 * markerRad, 2 * markerRad);//
							} else {
								g2d.drawLine(xMid,yPiece + (pthick - 1)/2,xMid,yPiece + (pthick - 1)/2);
							}
							/*
							 * Hmmr - not great for very small boards ... Try on palm etc ..
							 */

//
						}

						//now draw outline in light grey or green if released!
						if(calc.isPresent(size, releasedSizes)){
							g2d.setColor(releaseOutlineColour);
							g2d.setStroke(selectOutlineStroke);
//						} else if (size == immortalPieces[loc]){
//							g2d.setColor(immortalOutlineColour);
//							g2d.setStroke(selectOutlineStroke);
						} else {
							g2d.setColor(outlineColour);
							g2d.setStroke(greyOutlineStroke);
						}
						g2d.drawLine(xPiece,yPiece,xPiece+pwide,yPiece);//top line
						g2d.drawLine(xPiece,yPiece,xPiece,yPiece+pthick);//left line down
						g2d.drawLine(xPiece+pwide,yPiece,xPiece+pwide,yPiece+pthick);//right line down
						g2d.drawLine(xPiece,yPiece+pthick,xPiece+pwide,yPiece+pthick);//bottom line

						yPiece -= pthick; //the height coordinate of the next piece is set in preparation
					}
					xPiece += pdiff; //the width coordinate of the next piece is set in preparation
				}

				//now draw selection of pieces by means of outline again!
//				this is the top corners of the largest piece present in the stack
				yPiece = (int) (yMid + (height - 2 ) * unit);
				xPiece = (int) (xMid - xLargestPiece);
				g2d.setStroke(selectOutlineStroke);



				for (int size = 1; size <= smallestSize; size *=2) {
					/*
					 * this loops through all potential sizes on the dot,
					 * starting with the largest piece, as represented by
					 * 2 exp i
					 */
					//fist calculate the width of the piece
					pwide = (xMid - xPiece)* 2; //should I add 1???
					if (calc.isPresent(size, inStack)){ //this means the size is there
						boolean drawIt = false;
						boolean isSelected = calc.isPresent(size, inPieceSel);
						boolean isImmortal = calc.isPresent(size, immortalPieces[loc]);
						boolean isImmune = calc.isPresent(size, immunePieces[loc]);
						if (isImmune){
							g2d.setColor(immuneOutlineColour);
							drawIt = true;
						}
						if (isImmortal){//immortal overrides immune
							g2d.setColor(immortalOutlineColour);
							drawIt = true;
						}

						if (isSelected){ //this means the piece is selected
							g2d.setColor(selectedOutlineColour);
							drawIt = true;
						}
						if(isSelected && isImmune)
							g2d.setColor(selectedImmuneOutlineColour);
						if(isSelected && isImmortal)
							g2d.setColor(selectedImmortalOutlineColour);
						if (drawIt){
							//now draw outline - don't draw the rectangle ...
							g2d.drawLine(xPiece,yPiece,xPiece+pwide,yPiece);//top line
							g2d.drawLine(xPiece,yPiece,xPiece,yPiece+pthick);//left line down
							g2d.drawLine(xPiece+pwide,yPiece,xPiece+pwide,yPiece+pthick);//right line down
							g2d.drawLine(xPiece,yPiece+pthick,xPiece+pwide,yPiece+pthick);//bottom line
						}
						yPiece -= pthick; //the height of the next piece is set in preparation
					}
					xPiece += pdiff; //the width of the next piece is set in preparation
				}


				//6. draw outline of square
				// presence 32 and 64 (96) is violet, 32 alone is green, 64
				// alone is red (user selection)

				//here active square is red!
//				if (activeSquare == loc) {
//					g2d.setColor(selectedSquareColour);
//
//				//if (inSquareSel > 0){ //only draw an outline if the square is selected!
//
//				g2d.drawLine(xTop + x * ss, yTop + y * ss, xTop + x
//						* ss, (y + 1) * ss + yTop);
//				g2d.drawLine(xTop + x * ss, yTop + y * ss, xTop
//						+ (x + 1) * ss, yTop + y * ss);
//				g2d.drawLine(xTop + (x + 1) * ss, yTop + (y + 1) *
//						ss, xTop + (x) * ss, yTop + (y + 1) * ss);
//				g2d.drawLine(xTop + (x + 1) * ss,
//						yTop + (y + 1) * ss, xTop + (x + 1) * ss,
//						yTop + y * ss);
//				}

				//~findwinsquare
				g2d.setStroke(greyOutlineStroke);//??
				if (currentSpace.currentState.winLocation == loc) {
					g2d.setColor(winSquareColor);

				g2d.drawLine(xTop + x * ss, yTop + y * ss, xTop + x
						* ss, (y + 1) * ss + yTop);
				g2d.drawLine(xTop + x * ss, yTop + y * ss, xTop
						+ (x + 1) * ss, yTop + y * ss);
				g2d.drawLine(xTop + (x + 1) * ss ,
						yTop + (y + 1) * ss, xTop + (x) * ss, yTop
								+ (y + 1) * ss );
				g2d.drawLine(xTop + (x + 1) * ss ,
						yTop + (y + 1) * ss , xTop + (x + 1) * ss,
						yTop + y * ss);

				//add another line outside:
				g2d.drawLine(xTop + x * ss - 1, yTop + y * ss - 1, xTop + x
				* ss - 1, (y + 1) * ss + yTop + 1);
				g2d.drawLine(xTop + x * ss - 1, yTop + y * ss - 1, xTop
				+ (x + 1) * ss + 1, yTop + y * ss - 1);
				g2d.drawLine(xTop + (x + 1) * ss + 1,
				yTop + (y + 1) * ss + 1, xTop + (x) * ss - 1, yTop
						+ (y + 1) * ss + 1);
				g2d.drawLine(xTop + (x + 1) * ss + 1,
				yTop + (y + 1) * ss + 1, xTop + (x + 1) * ss + 1,
				yTop + y * ss - 1);
				}

			}// end of x loop

		}//end of y loop
		//this finishes the square specific drawings!


//TURN INDICATOR OLD POSITION - WIN SQUARE OVERWRITES PASS TRAIL ...




		//here draw releasing handles if present:

		//1. get arraylist ReleaseHandles
//		QDuplet[] relH = quincala.orderedReleaseHandles;
		if (showReleaseHandles){
			QDuplet[] relH = currentSpace.currentState.ordrdReleaseHandlesArray;


			//if size>0 make loop to draw lines
			int releasedPiecesCount = relH.length;
			if (releasedPiecesCount>0){
				//sorted: put it in engine??
				//anyway insert noReleasedPieces ...
				g2d.setStroke(relHandleStroke);
				g2d.setColor(releaseHandleColour);

				for (int i = 0; i < releasedPiecesCount; i++){

					//make new generation pieces to know where?


					int xMidOrig = (int) (xTop + (boardGraphics.gridX(boardRotation, relH[i].origLoc) + 0.5) * ss);
					int yMidOrig = (int) (yTop + (boardGraphics.gridY(boardRotation, relH[i].origLoc) + 0.5) * ss);
					int xMidDest = (int) (xTop + (boardGraphics.gridX(boardRotation, relH[i].destLoc) + 0.5) * ss);
					int yMidDest = (int) (yTop + (boardGraphics.gridY(boardRotation, relH[i].destLoc) + 0.5) * ss);

					byte hostGroup = currentSpace.currentState.stacks[relH[i].origLoc];
					int yAdjustFactor = calc.yAdjustFactor(relH[i].activeSizes, hostGroup);
					int yOrigAdj = yAdjustFactor * unit;//test for 3 and 4 sizes games too

					hostGroup = currentSpace.currentState.stacks[relH[i].destLoc];
					yAdjustFactor = calc.yAdjustFactor(relH[i].activeSizes, hostGroup);
					int yDestAdj = yAdjustFactor * unit;//test for 3 and 4 sizes games too
					//TODO here put yAdjust(Orig & Dest) + 2 * unit if from bottom of piece?

					//int xOrigAdj = calc.xAdjustFactor(relH[i].activeSizes) * unit - core;//a core in...

					int xOrigAdj = calc.xAdjustFactor(relH[i].activeSizes, QuiRules.numSizes) * unit;//on the corner?

					int xDestAdj = xOrigAdj; //always same size!
					if (xMidDest < xMidOrig || ((xMidDest == xMidOrig) && (yMidDest > yMidOrig)))
						xOrigAdj = -xOrigAdj;
					if (xMidDest > xMidOrig || ((xMidDest == xMidOrig) && (yMidDest > yMidOrig)))
							xDestAdj = -xDestAdj;

					g2d.drawLine(xMidOrig + xOrigAdj, yMidOrig + yOrigAdj, xMidDest + xDestAdj, yMidDest + yDestAdj);
					//add an oval at end of line; colour set already!
					g2d.fillRect(xMidDest + xDestAdj - 3, yMidDest + yDestAdj - 3, 6, 6);
					//ok but off centre ... adjust manually!

				}

			}
		}
		if (showGrid){
			g2d.setColor(new Color(220,220,220));
			for (int x = 0; x < 13; x++){
				for (int y = 0; y < 13; y++){
					//vertical:
					g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ x * ss, (y * ss) + yTop+ ss-1);
					//horizontal:
		            g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ (x * ss) + ss-1, yTop+ y * ss);
		            //also cross hairs:
		            //up
		            g2d.drawLine(xTop+ x * ss, (y * ss) + yTop+ ss, xTop+ (x * ss) + ss, yTop+ y * ss);
					//down
		            g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ (x * ss) + ss-1, (y * ss) + yTop+ ss-1);


				}
			}
			g2d.drawLine(xTop, yTop + 13*ss, xTop + (13*ss), yTop + 13 * ss);
			g2d.drawLine(xTop + (13*ss), yTop, xTop + (13*ss), yTop + 13 * ss);


		}






		g2d.dispose();//is dispose necessary in g2d?? Yep, seems like it.
	}






	public void setShowOptions(boolean showOptions){
		/*
		 * when using animation temporarily disable showLegal by
		 * defaultShowLegal = showLegal; showLegal;
		 * ... showLegal = defaultShowLegal
		 */
		showLegal = showOptions;
		System.out.println("showLegal is " + showLegal);
		if (showLegal){
			updateOptionsImage();
		} else {
			legalOptions = new boolean[169];
		}
		repaint();
	}

	public void updateOptionsImage(){
		System.out.println("boardpanel.updateOptionsImage is run");
		legalOptions = currentSpace.getLegalOptions();
		optionsImage = QuiGraphics.getOptionsImage(legalOptions);
	}

	public void toggleStudyMode(){
		studyMode = !studyMode;
//		System.out.println("studyMode is " + studyMode);
		repaint();
	}

//	public void loadQuString(){
//		Scanner myScanner = new Scanner(System.in);
//		System.out.println("Please enter QuString:");
//		String quString = myScanner.next();
//		quincala.receiveQuString(quString);
//
//	}



	public class GridListener extends MouseAdapter {
		public void mouseClicked(MouseEvent e) {
			/*
			 * replaced by recieveMouseClick() below!
			 */
//			System.out.println(e);
			if (edit) {
				int x = e.getX();
				int y = e.getY();
				if (x < xTop)
					return;
				x -= xTop; // this is the left margin
				if (y < yTop)
					return;
				y -= yTop; // this is the top margin
				int xSquare = x / squareSize;
				int ySquare = y / squareSize;

				if (xSquare == 12 && ySquare == 12) { // bottom right corner
					boardRotation = (boardRotation + 1) % 4;
					System.out.println("BoardRotation is " + boardRotation);
				}
				if (xSquare == 12 && ySquare == 0) { // top right corner
					boardRotation = (boardRotation + 2) % 4;
					System.out.println("BoardRotation is " + boardRotation);
				}
				if (xSquare == 0 && ySquare == 0) { // top left corner
					boardRotation = (boardRotation + 3) % 4;
					System.out.println("BoardRotation is " + boardRotation);
				}

				/*
				 * QuGame doesn't know which type of board the caller uses, but provides
				 * formulas for the standard 2D board with rotation
				 */

				//this sends on all clicks to the game engine QuGame quincala ...
				int loc = boardGraphics.location(xSquare,ySquare);
				currentSpace.receiveEntry(loc);

				repaint();
			}

		}
	}

	public void stepPlayer(int playerDelay){
		/*
		 * this is called by play button
		 * (or space bar) - it plays the current
		 * loaded line until the end
		 * Unfortunately it hogs the Listeners
		 * There is no way to stop it ...
		 * Useful for defined steps as in play a
		 * turnphse at the time?
		 */

		doPlay=true;
		boolean defaultshowLegal = showLegal;
		String forwardStepString = "nav=" + QGameSpace.FORWARD_STEP;
		showLegal = false;
		paint(getGraphics());
		int stepCount = 0;
//    	while(doPlay && quincala.currentLine.forwardStepAvailable) {
		while(doPlay) { //only reach if forwardStepAvailable
    		synchronized(this) {
    			try {
    				wait(playerDelay);
    				} catch (Exception e) {
    				}
    		}
    		currentSpace.receiveSpaceQuString(forwardStepString);//6
    		doPlay = currentSpace.currentLine.forwardStepAvailable();
    		//clumsy! but works ...
    		stepCount++;
    		//System.out.println("stepCount is " + stepCount);
    		paint(getGraphics()); //repaint(); //
//    		if (stepCount > 5) //for testing
//    			break;
    	}

    	showLegal = defaultshowLegal;
	}

//	public void setDrawSizes() { //seriously random!!!
//		// here the sizes of the board are set initially
//		// all relating to squaresizes and numSizes (from Q2DGrid Class)
//
//		numberOfSizes = quincala.numSizes;
//		smallestSize = calc.smallestSizeInPlay(numberOfSizes);
//		core = 3;//1 fits perfectly into square; increase to widen the top piece - always odd!
//		margin = 3;
//		//unit = boardPanelSize /149;//??
//		unit = (int) (boardPanelSize/13 - margin * 2 - core)/10;
//		//unit is 1-6 on my screen
//
//		squareSize = margin * 2 + unit * 10 + core; //is this correct?? test with MarkSquares ...
//		pdiff = unit * 5 / numberOfSizes; // this is how much the pieces differ in size each side
//		pthick = unit*2 + 1; //piece thickness; the + 1 allows for a core of the piece, enabling centering
//		xLargestPiece = pdiff * numberOfSizes + core - 1;
//		ds = unit; // this is the size of the black diamonds, usually 3, but try unit ...
//		tds = ds * 7 / 5; //size of turned black diamond: 7/5 is approx SQRT(2)???
//		ts = unit*3; // this is the size of the turn indicator, experiment
//		//CDs = unit*2; // this is the size of the CD buttons, usually square size/5
//		xTop = 0; // should be more than squaresize!
//		yTop = 0;
//	}

	public void updatePanelImage(){
		updateBoardImage();
		if (showLegal)
			updateOptionsImage();

		updateTurnIndicatorImage();
	}

	public void updatePositionImages(){
		if (showLegal)
			updateOptionsImage();
		updateTurnIndicatorImage();
		repaint();//??
	}

	public void updateTurnIndicatorImage(){
		//System.out.println("player passed to maker is " + currentSpace.currentState.player);
		turnIndicatorImage = QuiGraphics.getTurnIndicatorImage(currentSpace.currentState.passFlag, currentSpace.currentState.player);

	}

	public void updateBoardImage() {
		//System.out.println("setDrawSizes is reached");
		// here the sizes of the board are set initially
		// all relating to squaresizes and numSizes (from Q2DGrid Class)

		/*
		 * TODO with black diamonds unit as well as pieces - sticking out
		 * try unit - 1? Then unit must be 1 or over!
		 */

		//experimental - it works!!



		//

//		numberOfSizes = currentSpace.currentRules.numSizes;
		smallestSize = calc.smallestSizeInPlay(QuiRules.numSizes);
		core = 3;//1 fits perfectly into square; increase to widen the top piece - always odd!
		margin = 1;

		//Zooming:
		//centre board on panel:
		if (radiusSeen >= (QGraphics.radiusSeenDefault - 0.5) || radiusSeen <= 0.5){ //normal board
			int gridSize = 1;
			if (QGraphics.isMiniBoard){
				gridSize = 10;
			} else {
				gridSize = 13;
			}

			unit = (int) (boardPanelSize/gridSize - margin * 2 - core)/10;

//			unit = (int) (boardPanelSize/13 - margin * 2 - core)/10;
			if (unit < 2)
				unit = 2;//minimum value for unit!

			QuiGraphics.calcFromUnit();
			while (QuiGraphics.canvasSize > QGraphics.maxCanvasSize){
				unit -= 1;
				QuiGraphics.calcFromUnit();
			}
			System.out.println("boardpanel unit is " + unit);
			ss = margin * 2 + unit * 10 + core;
			int boardSize = ss * 13;
			xTop = (boardPanelSize - boardSize) / 2;
			yTop = xTop;//for now ...
		} else { //zooming in ...
			unit = (int) (boardPanelSize/(2 * radiusSeen + 1) - margin * 2 - core)/10;
			System.out.println("zoomed boardpanel original unit is " + unit);
			//QuiGraphics.calcFromUnit();

			ss = margin * 2 + unit * 10 + core;
			while (15 * ss > QGraphics.maxCanvasSize){
				unit -= 1;
				ss = margin * 2 + unit * 10 + core;
			}
			System.out.println("zoomed boardpanel unit is " + unit);


			int centerSqXCoord = QuiGraphics.gridX(boardRotation, centerSqLoc);
			int centerSqYCoord = QuiGraphics.gridY(boardRotation, centerSqLoc);
//			System.out.println("centerSqLoc is " + centerSqLoc);
//			System.out.println("centerSqXCoord is " + centerSqXCoord);
//			System.out.println("centerSqYCoord is " + centerSqYCoord);
			xTop = (int) ((2 * radiusSeen + 1 - centerSqXCoord * 2 - 1) * ss /2);
			yTop = (int) ((2 * radiusSeen + 1 - centerSqYCoord * 2 - 1) * ss /2);
			if (xTop >0)
				xTop = 0;
			if (yTop >0)
				yTop = 0; //when zooming we don't want a margin to the top!
		}
		//unit is 1-6 on my screen
		//System.out.println("unit is " + unit);
		//System.out.println("squareSize is " + ss);
		markerRad = unit / 3;

		float thickness = 1.0f;
		switch (unit){ //or a more elegant formula??
		case 1:
		case 2:
		case 3:
			//relHandleStroke = new BasicStroke(1.0f);

			break;
		case 4:
		case 5:
			thickness = 2.0f;
			//relHandleStroke = new BasicStroke(2.0f);
			break;
		case 6:
		default:
			thickness = 3.0f;
			break;
		}
		relHandleStroke = new BasicStroke(thickness);
		selectOutlineStroke = new BasicStroke(thickness);
//		if (unit > 4)
//			relHandleStroke = new BasicStroke(2.0f);


		//set strokes here:
//		ornLineStroke = new BasicStroke(2.0f);
//		whiteDiamStroke = new BasicStroke(2.0f);




//		expandOrnLineDef();//this is init only!
		//finally, scale the ornamental lines and relate to x,yTop
		//this is new size only:
		ornArray = new CubicCurve2D[64];
		for (int k = 0; k < 64; k++){
			for (int i = 0; i < 8; i++){
				if (i % 2 == 0){ //x-coordinate
					ln[k][i] = xpandLn[k][i] * ss + xTop;
				} else {
					ln[k][i] = xpandLn[k][i] * ss + yTop;
				}
			}
			ornArray[k] = new CubicCurve2D.Double();
			ornArray[k].setCurve(ln[k][0], ln[k][1], ln[k][2], ln[k][3], ln[k][4],
					ln[k][5], ln[k][6], ln[k][7]);
		}




		pdiff = unit; // this is how much the pieces differ in size each side
		if (QuiRules.numSizes == 3)
			pdiff = 2 * unit; //use ECA for games with three sizes ...
		pthick = unit * 2; //piece thickness; the + 1 allows for a core of the piece, enabling centering
		xLargestPiece = 5 * unit + core - 1;//
		ds = unit; // this is the size of the black diamonds, usually 3, but try unit ...
		tds = ds * 7 / 10 + 1;//round up by + 1
		//tds = size of turned black diamond & half white diamond: 7/5 is approx SQRT(2)???
		ts = unit*3; // this is the size of the turn indicator, experiment
		//CDs = unit*2; // this is the size of the CD buttons, usually square size/5

		//expand the board polygon:
		for(int i = 0; i < 20; i++){
			boardPolygonXExp[i] = (int) (ss * boardPolygonX[i]) + xTop;
			boardPolygonYExp[i] = (int) (ss * boardPolygonY[i]) + yTop;
		}

		//all preceding is obsolete

		boardImage = QuiGraphics.getBoardImage();
		repaint();


	}

//	public void expandOrnLineDef(){
//		//firstly put let the lines follow input on 0,2 and 0,4:
//
//		if (lineDef[0][0] == 0){ //starts at origo, so calculate!
//			lineDef[0][3] = lineDef[0][2];
//			lineDef[1][3] = lineDef[0][2];
//			lineDef[1][4] = 1 - lineDef[0][4] / 2;
//			lineDef[1][5] = 1 + lineDef[0][4] / 2;
//		} else { //there is no complete first line to calculate ...
//			//make the small petal the first line?
//			lineDef[1][3] = 1;
//			lineDef[1][4] = (double) 2/3;
//			lineDef[1][5] = (double) 4/3;
//		}
//
//		//first segment second control point must be 45
//		lineDef[2][5] = 6 - lineDef[2][4];
//
//		//this is giving a lot of control to [3][2] and [3][4]
//		//postulating the identity of segments 3, 6 & 7
//		double verticalParam = lineDef[3][2] - 1;
//		double horizontParam = 2 -lineDef[3][4];
//		lineDef[3][3] = 5 - verticalParam;//1.4 -> 4.6
//		lineDef[3][5] = 5;
//
//		lineDef[6][2] = 3 + verticalParam;
//		lineDef[6][3] = 5 + verticalParam;
//		lineDef[6][4] = 4 - horizontParam;
//		lineDef[6][5] = 5;
//		lineDef[6][6] = 4;
//		lineDef[6][7] = 5;
//
//		lineDef[7][2] = 4 + horizontParam;
//		lineDef[7][3] = 5;
//		lineDef[7][4] = 5 - verticalParam;
//		lineDef[7][5] = 5 + verticalParam;
//
//		//this assumes that the wave tip is 90�, and the means
//		//to that is horizontal control point 2 for wave left
//		//and vertical for wave right
//		lineDef[4][5] = lineDef[4][7];
//
//		lineDef[5][0] = lineDef[4][6];
//		lineDef[5][1] = lineDef[4][7];
//		lineDef[5][2] = lineDef[4][6];
//		lineDef[5][5] = lineDef[5][4] + 2;
//
//		//this puts the makes point 8,1 equal both sides ...
//		lineDef[4][2] = 2 + horizontParam;
//
//		//good to print the values ...
////		System.out.println("These are the final values defining the lines:");
////		for (int k = 0; k < 8; k++){
////			for (int i = 0; i < 8; i++){
////				System.out.print(lineDef[k][i] + " ");
////			}
////			System.out.println();
////		}
////		System.out.println();
//
//
//
////		filling the ornamental lines
//		//0. load the original 8 defining lines into xpandLn
//		for (int k = 0; k < 8; k++){
//			for (int i = 0; i < 8; i++){
//				xpandLn[k][i] = lineDef[k][i];
//			}
//		}
//
//		//1. set x = -x to make 16
//		for (int k = 0; k < 8; k++){
//			for (int i = 0; i < 8; i++){
//				if (i % 2 == 0){ //x-coordinate
//					xpandLn[k + 8][i] = - xpandLn[k][i];
//				} else {
//					xpandLn[k + 8][i] = xpandLn[k][i];
//				}
//			}
//		}
//		//1. set y = -y to make 32
//		for (int k = 0; k < 16; k++){
//			for (int i = 0; i < 8; i++){
//				if (i % 2 == 0){ //x-coordinate
//					xpandLn[k + 16][i] = xpandLn[k][i];
//				} else {
//					xpandLn[k + 16][i] = - xpandLn[k][i];
//				}
//			}
//		}
//
//		//3. mirror x to y to make 64
//		for (int k = 0; k < 32; k++){
//			for (int i = 0; i < 8; i++){
//				if (i % 2 == 0){ //x-coordinate
//					xpandLn[k + 32][i] = xpandLn[k][i + 1];
//				} else { //y-coordinate
//					xpandLn[k + 32][i] = xpandLn[k][i - 1];
//				}
//			}
//
//		}
//
//
//		//4. put into middle
//		for (int k = 0; k < 64; k++){
//			for (int i = 0; i < 8; i++){
//				xpandLn[k][i] = xpandLn[k][i] + 6.5;
//			}
//		}
//	}

	//transitional methods:



	public void sendOnButtons(int buttonNo){
		String forwardStepString = "nav=" + QGameSpace.FORWARD_STEP;
		currentSpace.receiveSpaceQuString(forwardStepString);//6
		//repaint();//probably needed ...
		updatePositionImages();//otherwise turnindicator stays!
		requestGameData();
	}

	public boolean forwardAvailable(){
		return currentSpace.currentLine.forwardStepAvailable();
	}

	public boolean backwardAvailable(){
		return currentSpace.currentLine.backStepAvailable();
	}

	public int playerNo(){
		return currentSpace.currentState.player;
	}

	public int turnNo(){
		return currentSpace.currentState.turnNumber + 1;
		//since internally turn number is from 0
	}



	public String getPurePlyString(){
		return currentSpace.currentState.getLineString();
	}

	public Set getChangedLocs(){
		return currentSpace.currentState.changedLocs;
	}

	//end transitional methods

	//new generation testing
	public void testNewG(byte stackByte, int loc){
		currentSpace.currentState.setStack(stackByte, loc);
	}

	public QGameStatus getGameStatus(){
//		QuiGameStatus passing = new QuiGameStatus();
//		passing = quincala.currentState.getGameStatus();
//		System.out.println("passing.currentTurnNo is " + passing.currentTurnNo);
		return currentSpace.getGameStatus();
	}

//	public void setZoom(int zoomLoc, int x, int y, double radius){
//		//first clear old panel
//
//
////		centerSqXCoord = x;
////		centerSqYCoord = y;
//		centerSqLoc = zoomLoc;
//		radiusSeen = radius;
//		setDrawSizes();
//		QuiBoardGraphics.setZoom(zoomLoc, x, y, radius);//new
//		//keep this for both versions
//		repaint();
//
//	}

	public void setZoom(String xy, double radius){
//		QGraphics.setZoom(xy, radius);
		//first clear old panel?
		char x = xy.charAt(0);
		char y = xy.charAt(1);
		centerSqLoc = calc.hexCharsToLoc(x,y);
		radiusSeen = radius;
//		radiusSeen = QGraphics.radiusSeen;//to ease the transition ...
		if (radiusSeen < 1)
			radiusSeen = 1;
		updatePanelImage();
		//QuiBoardGraphics.setZoom(xy, radius);//new
		//keep this for both versions
		repaint();
	}

	public void resetZoom(){
		radiusSeen = radiusSeenDefault;
		centerSqLoc = centerSqLocDefault;
		updateBoardImage();
		repaint();
	}

	//new generation methods:
	public void setDoConstructionTrue(){
		//this part of QGamePanel?
		doConstruction = true;

	}

	public void requestGameData(){

		/*
		 * is called after string, button or click input!
		 * combine at least string & button input!
		 * this will eventually grow into making the images
		 * for paint to paint ...
		 */

		//is this the same as updateBoardImage()???

//		if(showLegal){
//			updateOptionsImage();
//		}

		QuiPiece[] pieceArray = currentSpace.currentState.getPieceArray(boardRotation, xTop, yTop, ss);
		//temporaliy just update immortalArray
		immortalPieces = currentSpace.currentState.immortalPieces;//or clone??
		immunePieces = currentSpace.currentState.noKnockPieces;//or clone?
	}


	public void receiveMouseClick(int x, int y){
		if (x < xTop)
			return;
		x -= xTop; // this is the left margin
		if (y < yTop)
			return;
		y -= yTop; // this is the top margin
		int xSquare = x / ss;
		int ySquare = y / ss;

		if (xSquare == 12 && ySquare == 12) { // bottom right corner
			rotateBoard(1);
			return;
		}
		if (xSquare == 12 && ySquare == 0) { // top right corner
			rotateBoard(2);
			return;
		}
		if (xSquare == 0 && ySquare == 0) { // top left corner
			rotateBoard(3);
			return;
		}

		int loc = QGraphics.location(xSquare,ySquare);
		if (loc==84){
			currentSpace.receiveSpaceQuString("ply=rt");
		} else {
			currentSpace.receiveSpaceQuString("loc=" + loc);
//			currentSpace.receiveEntry(loc);
		}


		requestGameData();
		updatePositionImages();
	}

	public void receiveMouseZoom(int x, int y){//depreciated
		//still used for pieces!!


		if (x < xTop)
			return;
		x -= xTop; // this is the left margin
		if (y < yTop)
			return;
		y -= yTop; // this is the top margin
		int xSquare = x / ss;
		int ySquare = y / ss;

		centerSqLoc = QuiGraphics.location(xSquare,ySquare);
		if (radiusSeen < 1)
			radiusSeen = 1;
		radiusSeen = ((radiusSeen + 5) % 8);
		if (radiusSeen < 1)
			radiusSeen = 1;
		System.out.println("radiusSeen is " + radiusSeen);
		if (radiusSeen >= 6){
			//resetting zoom with mouse!
			radiusSeen = radiusSeenDefault;
			centerSqLoc = centerSqLocDefault;
		}
		updateBoardImage();
	}

	public void receiveBoardQuString(String quString){
		//this recieves quSTrings to do with the board
		//such as zoom and rotation
		String key = QSFUtils.getKey(quString);
		String value = QSFUtils.getValue(quString);
		if(key.equals("zoom") && !QGraphics.isMiniBoard){



			String[] splitValue = value.split(";");
			if (splitValue.length < 2){
				if (value.equals("0")){
					resetZoom();
					QGraphics.resetZoom();
					updatePanelImage();
				}
				//also need to set divider location??
				return;
			}

			String centre = splitValue[0];
			if (!QSFUtils.isCoordStringlet(centre))
				 return;
			double radius = QGraphics.radiusSeenDefault;
			try {
				radius = Double.parseDouble(splitValue[1]);
			} catch (NumberFormatException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				//make pop-up message that format of radius is
				//not valid!
			}
			//TODO investigate parse double depending on language?

			setZoom(centre, radius);//old
			QGraphics.setZoom(centre, radius);//new
			updatePanelImage();
			return;
		}

		if(key.equals("rotation")){
			int cand = -1;
			try {
				cand = Integer.parseInt(value);
			} catch (NumberFormatException e) {
				// TODO Auto-generated catch block
//				e.printStackTrace();
				System.out.println("Invalid board rotation value");
			}
			if (cand > -1 && cand < 5){
				boardRotation = cand;
				QGraphics.setBoardRotation(cand);
				updatePositionImages();//needed if zoomed in; topX,Y depends on rotation!
			} else {
				System.out.println("Invalid board rotation value");
			}

		}



	}

	public void rotateBoard(int quartersClockwise){
		boardRotation = (boardRotation + quartersClockwise) % 4;//old??
		QGraphics.rotateBoard(quartersClockwise);
		updatePositionImages();//needed if zoomed in; topX,Y depends on rotation!
	}

	public void passThruSpaceQuString(String quiString){
		currentSpace.receiveSpaceQuString(quiString);
		if(QGraphics.fetchBoardReDefinitionFlag())
			updateBoardImage();//only different sort of game need new board?

		updatePositionImages();//strings will change the full position!
		//for now only turnindicator, but later also all the pieces!
		requestGameData();

	}

	public void passThroughLineInfo(String matchInfo){
		//TODO this is old - use standard channel!
		currentSpace.currentLine.setLineTitle(matchInfo);
	}

	public void passThruRuleModification(boolean[] userRules){
		currentSpace.modifyRules(userRules);
	}

	public QWholeLineData passUpWholeLineData(){
		//System.out.println("passUpWholeLineData is run!");
		QWholeLineData dataToPassUP = currentSpace.currentLine.getWholeLineData();
		return dataToPassUP;
	}

	public String[] getQuString(String quStringFormat, boolean stateOut){

		if (QSFUtils.isBoardKey(quStringFormat)){
			String[] boardStringReturn = new String[2];

			if (quStringFormat.equals("zoom")){
				String centreStringlet = QSFUtils.locToHexCharString(QGraphics.centerSqLoc);
				String radiusString = "" + QGraphics.radiusSeen;
				//return only value!!
				boardStringReturn[0] = centreStringlet + ";" + radiusString;
				return boardStringReturn;
			}
		}

		String[] returnString = currentSpace.getQuString(quStringFormat);
		//here add Board strings such as zoom (and rotation) if state out:
		if (!stateOut)
			return returnString;

		if (QGraphics.radiusSeen < QGraphics.radiusSeenDefault){
			//output zoom string!
			System.out.println("&&zoom= will be added! ");
			//only add delimiter if spaceQuStrings prevalent
			if (returnString[0].length() > 0)
				returnString[0] += QSFUtils.qsfDelimiter;

			String centreStringlet = QSFUtils.locToHexCharString(QGraphics.centerSqLoc);
			String radiusString = "" + QGraphics.radiusSeen;
			returnString[0] += "zoom=" + centreStringlet + ";" + radiusString;
		}
		if (QGraphics.boardRotation > 0){

			System.out.println("&&rotation= will be added! ");
			//only add delimiter if spaceQuStrings prevalent
			if (returnString[0].length() > 0)
				returnString[0] += QSFUtils.qsfDelimiter;

			returnString[0] += "rotation=" + QGraphics.boardRotation;
		}

		//add frames on GUI level only!
		return returnString;

	}

	//end new generation

	public int boardPanelSize;
	public int unit = 4; //this determines the size of everything drawn,
	//and sets the following in the method setDrawSizes():
	public int core;//this is the vertical core of a stack, to fit it into a square ...
	public int margin; // is the margin round a tower to the square
	public int pdiff; // this is how much the pieces differ in size each side, same as unit for 5 size variants
	public int xLargestPiece; // the x coordinate for the largest piece in play (half the width of the largest pieces)
	public int squareSize; // size of an individual square, is always odd!
	public int ss; // size of an individual square, is always odd!
	public int ds; // this is the size of the black diamonds
	public int tds; //this is the size of the turned black diamond
	public int ts; // this is the size of the turn indicator
	public int CDs; // this is the size of the CD buttons
//	public int numberOfSizes;//this is how many sizes are in play - set in quincala.current
	public int smallestSize; //derived from numberOfSizes
	public int pthick; // this is how thick the individual pieces are
	public int pwide; // this is half the width of the largest piece
	public int xTop = 0; // should be more than squaresize!
	public int yTop = 0;
	public int markerRad = 1;//the radius of the little marker oval on sizes DB


	public Button toogleStudyModeButton;
	public Button toggleShowOptionsButton;
	//public Button toggleAutoReleaseButton;
	public Button loadQuStringButton;


	private boolean studyMode = true;
	/* this allows back buttons and branches
	 * false is competitive mode, where no takebacks are allowed
	 */
	public boolean showLegal = false; //this directs if legal options are shown on the board
	private boolean edit;
	private boolean doPlay = false;// doPlay true means the match is played
									// out, pause button displayed
	public boolean doRecord = false; //record button is not pressed - display it in black
	public int stepSpeed = 500; //the speed of the stepPlayer()



	public int boardRotation = 0;//belongs here in GUI!//??


	//use these for colour schemes?
	public final static int EMPTY = 0;
	public final static int WHITE = 1;
	public final static int BLACK = 2; // Grey, make white
	public final static int BOARD = 3;
	public final static int LINES = 4;
	public final static int FRAME = 4;// to make it same colour as lines?
}