/*
**********************************************************************
*                        License Notice
*
* QuincalaBirth.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2009 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

import com.quincala.core.*;

public class QuincalaBirth extends QuincalaBoardPanel {

	/*
	 * QuincalaBirth is a transimation rather than a game
	 * It shows the birth of the quincala board from the
	 * original tower of hanoi
	 */

	//NOTE will it break once the BoardPanel uses a new image model?

	public QWholeLineData infoMessage;
	public String infoText;

	public void init(){




		//for when the info text can be html ...
//		infoText = "<html><body>This is not a game, but a <i>transanimation</i>: it shows " +
//				"the birth of the Quincala board. Please use the navigation " +
//				"buttons below left to explore it. Just press play to watch it " +
//				"unfold!</body></html>";
		infoText = "This is not a game, but a \"transanimation\": it shows " +
		"the birth of the Quincala board. Please use the navigation " +
		"buttons below left to explore it. Just press play to watch it " +
		"unfold!";
		infoMessage  = new QWholeLineData();
		infoMessage.setCustomString(infoText);

//		expandOrnLineDef();//this is init only!
	}

	public void paint(Graphics g) {
		//System.out.println("PAINT boardpanel");
		Graphics2D g2d = (Graphics2D) g;

		//make this a separate method in QuincalasBoardPanel!:
		int ht = this.getHeight();
		int wd = this.getWidth();
		int sizeCandidate = ht;
		if (wd < ht)
			sizeCandidate = wd;

		if (sizeCandidate != boardPanelSize){
			boardPanelSize = sizeCandidate;
			//System.out.println("New boardPanelSize is " + boardPanelSize);
//			update scale if new panel size:
			updateBoardImage();
		}

//		0. draw "table cloth"
		g2d.setColor(Color.white);//tableClothColour
		g2d.fillRect(0, 0, wd, ht);//fills whole panel

		//4. draw ornamental lines
		g2d.setStroke(ornLineStroke);//as above
		g2d.setColor(ornOlineColour);
		//g2d.setColor(Color.black);
		for (int i=0; i < 64; i++){
//			CubicCurve2D orn = new CubicCurve2D.Double();
//			orn.setCurve(ln[i][0], ln[i][1], ln[i][2], ln[i][3], ln[i][4],
//					ln[i][5], ln[i][6], ln[i][7]);

			//filling this draws over Options!
			//so: order???
//			if ((i % 8) == 1){//small petals
//				g2d.setColor(new Color(180, 160, 0));
//				g2d.fill(ornArray[i]);
//				g2d.setColor(new Color(180,180,180));
//			}
			g2d.draw(ornArray[i]);
			/*
			 * TODO Bug! filling does not quite work because
			 * of the order of drawing ...
			 * Ideally all large petals would be drawn before
			 * all small petals ...
			 * rearrange the array when sizing it?
			 * for i=0-7, for k=0-63, next line is k%i + 8 * i
			 * or expand like this in the first place?
			 */


		}

	}

	public QGameStatus getGameStatus(){
		//here put status!

		return new QGameStatus();
	}

	public QWholeLineData passUpWholeLineData(){



		return infoMessage;
	}

}
