/*
**********************************************************************
*                        License Notice
*
* QuiStack.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

public class QuiStack {

	/*
	 * This is new generation OO; to replace QuCalc
	 * probably not extending BoardFunction but QGamePiece
	 * To be held in one array in GameState
	 */

	/*
	 * Stack TODO
	 * change to int? quicker and less typecasting
	 * query sizes as 1-5 rather than mask
	 *
	 */

	public byte sizes = 0;//set to B and refactor?
	public byte blackPieces = 0;//set to P and refactor

	public byte Selections = 0;
	public byte releasedPieces = 0;
	//the QuStack initialises as "empty potential to house pieces"


	public char[] hexMap = {'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f'};

	//new gen:
	public void setSizes(byte sizeByte){
		sizes = sizeByte;
	}
	//probably use addSizes instead??

	//end new gen


	//this returns an alexian location number from two hexChars
	public int hexCharsToLoc(char hexChar1, char hexChar2){
		//System.out.println(hexChar1 + " " + hexChar2);
		String hexValue1 = "" + hexChar1;
		String hexValue2 = "" + hexChar2;
		//System.out.println(hexValue1 + " " + hexValue2);
		int xCoord = Integer.parseInt(hexValue1, 16);
		int yCoord = Integer.parseInt(hexValue2, 16);
		//System.out.println(xCoord + " " + yCoord);
		//int loc = yCoord * 13 + xCoord;
		int loc = (12 - yCoord) * 13 + xCoord;
		return loc;
	}

	public String locToHexCharString(int loc){
		int hexNum1 = loc % 13;
		int hexNum2 = 12 - (loc / 13);
		//int hexNum2 = loc / 13;
		String hexChars = "" + hexMap[hexNum1] + hexMap[hexNum2];
		return hexChars;
	}



	public int pathIndex(int actPlayer, int ColourInt){ // to define what path to use
		int pIndex;
		pIndex = actPlayer * 2 + ColourInt;
		return pIndex;
	}

	public int smallestSizeInPlay(int numSizes){
		/*
		 * 	this is returns the value of 2 exp numSizes
		 * I use a simple loop rather than importing the whole
		 * math package ...
		 */
		int value = 1;
		for (int k = 1; k < numSizes; k++){
			value *=2;
		}
		return value;
	}

	public byte calcTowerByte(int nSizes){
		//rather than importing maths
		byte tByte = 0;
		int mask = 1;
		for (int i = 0; i < nSizes; i++){
			tByte += mask;
			mask *=2;
		}
		return tByte;
	}




	//these four deal with whole groups represented by bytes
	public int countBits(byte B){
		int bCounter = 0;
		for (int m = 1; m < 17; m *=2) { //enlarge to 64 in case bigger bytes???
			if ((B & m) != 0) // this means the piece is there
				bCounter++;
		}
		return bCounter;
	}

	//the following interprets the byte values stored into types of group
	//consider using the corresp methods in QuGameState: hasMixedGroup() etc
	public boolean isEmpty(byte P){
		boolean empty = false;
		if (P ==0)
			empty = true;
		return empty;
	}

	public boolean isWhite(byte P, byte C){
		boolean white = false;
		if (P != 0 && C == 0)
				white = true;
		return white;
	}

	public boolean isBlack(byte P, byte C){
		boolean black = false;
		if (P != 0 && C == P)
				black = true;
		return black;
	}

	public boolean isMixed(byte P, byte C){
		boolean mixed = false;
		if (C > 0 && C != P)
				mixed = true;
		return mixed;
	}

	//these three deal with individual pieces, represented by a mask and a byte
	public boolean isPresent(int mask){//new gen!
		boolean presence = false;
		if ((mask & sizes) != 0)
			presence = true;
		return presence;
	}

	//too complicated - work round it! FIX (NEW GEN)
//	public boolean pieceIsPresent(int size, int colour, byte stack, byte blacks){
//		//boolean result = false;
//		return (isPresent(size,stack) && isPresent(colour*size,blacks));
//	}

	public boolean pieceIsWhite(int mask, byte C){
		boolean white = false;
		if ((mask & C) == 0)
			white = true;
		return white;
	}

	public boolean pieceIsBlack(int mask, byte C){
		boolean black = false;
		if ((mask & C) != 0)
			black = true;
		return black;
	}

//	??
	public boolean pieceIsSelected(int mask, byte P){
		boolean selection = false;
		if ((mask & P) != 0)
			selection = true;
		return selection;
	}



	//this one returns the colour of a piece, 0 is white and 1 is black
	public int pieceColour(byte size, byte blacks){
		int colour = 0;
		if ((size & blacks) != 0){ //test for black
			colour = 1;
		}
		return colour;
	}



	//the following three deals with moving the pieces on the board
	//they should all be performed on both stacks and blacks, when needed!
	public byte joinGroups(byte GroupA, byte GroupB){ //perform with both stacks and blacks!
		byte resultingGroup = (byte) (GroupA | GroupB);
		return resultingGroup;
	}

	public byte removeFromByte(byte movingPieces, byte originalStack){//perform with both stacks and blacks!
		byte resultingGroup = (byte) (movingPieces ^ originalStack);
		return resultingGroup;
	}

	public byte removeBlacks(byte movingPieces, byte originalBlacks){
		byte resultingBlacks = (byte) (movingPieces ^ originalBlacks);
		return resultingBlacks;
	}

	public byte extractKnockedPieces(byte knockingPieces, byte oldPieces){//performa with both stacks and blacks!
		byte knockedPieces = (byte) (knockingPieces & oldPieces);
		return knockedPieces;
	}


	public byte sowingGroup(int activePlayer, byte P, byte C) {
		//returns what can move on when bottom piece left
		byte sGroup = 0;
		boolean isBottom = true;
		for (byte k = 1; k < 17; k*=2) {
			//loop up through the potential tower
			if ((k & P) != 0){ //do isPresent()?
				if ((k & C) == (k*activePlayer)) {
					//this means it is of player's own colour
					if (isBottom){ //hitting largest piece
						isBottom = false;
					} else { //identifying the pieces we are after
						sGroup = joinGroups(k, sGroup);
						//add to sowingGroup
					}
				}
			}
		}
		return sGroup;
	}

	public byte allOwnPieces(int activePlayer, byte P, byte C) {
		/*
		 * not tested yet
		 * ~O use better formulas?
		 */
		//returns all pieces of the player's own colour
		byte pGroup = 0;
		for (byte k = 1; k < 17; k*=2) {
			//loop up through the potential tower
			if ((k & P) != 0){ //use isPresent()?
				if ((k & C) == (k*activePlayer)) {
					//this means it is of player's own colour
						pGroup = joinGroups(k, pGroup); //add to pGroup
				}
			}
		}
		return pGroup;
	}

	public int largestSize(byte B) { //does not depend on player colour!
		int	mask = 1;
		for (int k = 0; k < 5; k++) { //this should be k < numPieces ...
			if ((B & mask) != 0){ //this means the piece is there
					break;		//try just return mask; instead of break!
			}
			mask *= 2; //here mask is multiplied by 2
		}
		return mask;

	}




}
