/*
**********************************************************************
*                        License Notice
*
* QuiRules.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

import com.quincala.core.*;
import java.util.ArrayList;

public class QuiRules extends QRules{
	/*
	 * this class will set the rules for the variant played:
	 * including
	 * All rules are set to game 5 and then changed by switches!
	 */

//	public static final double latestQuincalaGameDefinition = 0.2d;
	public static final int latestBaseLine = 0;
	public static final int latestIncrement = 2;
	/*
	 *qdv 0.0 is with irrevers
	 *0.1 is no irreversibility (2009 strings), 0.2 is with mini- aliases
	 *ignore smaller placing areas!!
	 */

//	public static double quincalaGameDefinitionToUse = latestQuincalaGameDefinition;
	public static int baseLineToUse = latestBaseLine;
	public static int incrementToUse = latestIncrement;
	//initialised to latest; only change if input is older!
	//also reset if new main QSF String

	//THESE ARE USER RULES - get rid of these of QDF 0.2
	public static boolean irreversibilityUser = false;
	private static boolean immunityUser = true;
	//END USER RULES

	//for now hard code if variant is in place:


	//new for QGD 0.2:
	public static boolean freedomRule = true;// false for simple variant
	public static boolean ledgePlacing = false;// false for simple variant
	public static boolean minimumRule= false;//true for simple variant

	//also add colour knocking paths and smaller board?
	//Mini-Quincala?


	//or make a method to calc?
	//add 03, 390 etc when implemented!



	//starting positions is a separate class off rules!
	public static byte[] startStacks;//need to initialise??
	public static byte[] startBlackPieces;
	public static String StartingPosition;

	//public boolean permissiveRules = true; //this switches if duplets are checked for legality
	//set to true initially since squirrels don't normally check
	public static String environment = "15";
	//this is the default environment for Quincala

	public static int ruleVersion = 1; //used to refer to!
	//private int nSizesMax;//keep these ones public? or move in to setRules?
	public static int numSizes = 5; //default is 5
	public static int numPieces = 40;//is numSizes * 8!
	public static byte towerByte = 0;
	//public byte towerByte = 0;
	//public boolean legalNumberPieces = true;

	public static boolean activePLayerLossAtTie = true;//true for all games so far!
	public static boolean winByCentreTower = false;
	public static boolean allowPass = true;//to test set false; not implemented!!
	//simple knocking game
	public static boolean winByKnockAllSizes = false;
	public static boolean drawByMixingLast = false;//??? TBC Probably Not
	public static boolean shortMove = false;//??? Looks good

	//simple mixing game
	public static boolean winByMixingAllOwnSizes = false;
	public static boolean winByKnockingLast = false;
	public static boolean drawByConsecutivePass = false;

	public static boolean goalDotWin = false;
	public static int whiteGoalDot = -1; //these are only accessed in game 1
	public static int blackGoalDot = -1; //make them -1??

//	public static boolean posEdit = false;//belongs to QRules!!
	//Position Editor true keeps only a very liberal moving rule
	//store posEdit in QRules, use in QGameState.addToPlyString

	public static boolean homePlacing = true; //placing from home dot
	public static boolean releasing = false; //
	public static boolean fullReleasing = true;
	//(full move release won't be implemented for now)
	public static boolean bouncing = true;
	public static boolean leglimit = false; //limiting legs to the number of pieces moving
	public static boolean immunity = true;
	public static boolean irreversibility = false;

	// used by winTest() to look for wins; Index < 2 is White Win
	public static int[] whiteDiamonds = { 71, 85, 83, 97 };

	/*
	 * not more than 7 pieces of any one size can be knocked, thus paths are enough with 7 spaces ...
	 */
//	public int[] pathWhitePlayerKnocksWhitePiece = {5,4,3,2,1,25,38}; //where White player knocks his own pieces
//	public int[] pathWhitePlayerKnocksBlackPiece = {71,5,4,3,2,1,25}; //71 & above
//	public int[] pathBlackPlayerKnocksWhitePiece = {97,163,164,165,166,167,143}; // 97 & below
//	public int[] pathBlackPlayerKnocksBlackPiece = {163,164,165,166,167,143,130}; // where Black player knocks his own pieces
	private static final int[] pathWhitePlayerKnocksWhitePiece = {4,3,2,1,13,26,39}; //where White player knocks his own pieces
	private static final int[] pathWhitePlayerKnocksBlackPiece = {71,4,3,2,1,13,26}; //71 & above
	private static final int[] pathBlackPlayerKnocksWhitePiece = {97,164,165,166,167,155,142}; // 97 & below
	private static final int[] pathBlackPlayerKnocksBlackPiece = {164,165,166,167,155,142,129}; // where Black player knocks his own pieces

//	private static final int[] miniQuincalaWhitePieceKnockPath = {
//		30, 29, 41, 54
//		};//not corner
//	private static final int[] miniQuincalaBlackPieceKnockPath = {
//		138, 139, 127, 114
//		};

	//up on the ledge:
	private static final int[] miniQuincalaWhitePieceKnockPath = {
		41, 54, 106, 119
		};//not corner
	private static final int[] miniQuincalaBlackPieceKnockPath = {
		127, 114, 62, 49
		};

	private static final int[][] knockingPathsMiniQ = {
		miniQuincalaWhitePieceKnockPath,
		miniQuincalaBlackPieceKnockPath,
		miniQuincalaWhitePieceKnockPath,
		miniQuincalaBlackPieceKnockPath
		};
	private static final int[][] knockingPathsGame6 = {
		pathWhitePlayerKnocksWhitePiece,
		pathWhitePlayerKnocksBlackPiece,
		pathBlackPlayerKnocksWhitePiece,
		pathBlackPlayerKnocksBlackPiece
		}; //define in setRules() for greater flexibility!
	private static final int[][] knockPathsGame1 = {
		pathWhitePlayerKnocksWhitePiece,
		pathWhitePlayerKnocksWhitePiece,
		pathBlackPlayerKnocksBlackPiece,
		pathBlackPlayerKnocksBlackPiece};
//	public static int[][] knockPathsSimple = {pathWhitePlayerKnocksWhitePiece,pathWhitePlayerKnocksWhitePiece,pathBlackPlayerKnocksBlackPiece,pathBlackPlayerKnocksBlackPiece};
	public static int[][] knockingPaths;

	//releasing paths
//	public int[] pathWreleasesW = {85,97,5,4,3,2,1};//7 is enough!
//	public int[] pathWreleasesB = {83,97,5,4,3,2,1};
//	public int[] pathBreleasesW = {85,71,163,164,165,166,167,143,130};
//	public int[] pathBreleasesB = {83,71,163,164,165,166,167,143,130};
	private static int[] pathWreleasesW = {85,97,4,3,2,1,13};//7 is enough!
	private static int[] pathWreleasesB = {83,97,4,3,2,1,13};
	private static int[] pathBreleasesW = {85,71,164,165,166,167,155,142};
	private static int[] pathBreleasesB = {83,71,164,165,166,167,155,142};

	public static int[][] releasingPaths = {pathWreleasesW,pathWreleasesB,pathBreleasesW,pathBreleasesB};

	//ledges:
	//knocking paths will use these when dishingOut function implemented
//	public int[] ledgeNearWhite0 = {130,143,167,166,165,164,163};
//	public int[] ledgeNearWhite = {163,164,165,166,167,143,130};
//	public int[] ledgeNearBlack0 = {38,25,1,2,3,4,5};
//	public int[] ledgeNearBlack = {5,4,3,2,1,25,38};
	public static int[] ledgeNearWhite0 = {129,142,155,167,166,165,164};
	private static int[] ledgeNearWhite = {164,165,166,167,155,142,129};
	public static int[] ledgeNearBlack0 = {39,26,13,1,2,3,4};
	private static int[] ledgeNearBlack = {4,3,2,1,13,26,39};
	//these should both be reverse order from own knocking paths
	public static int[][] ledges = {ledgeNearWhite,ledgeNearBlack};


	private static int[] whitePlacingArea = {
			14,24,27,28,36,37,40,41,42,48,
			49,50,53,54,55,56,60,61,62,63,
			66,67,68,69,70,72,73,74,75,76,
			78,79,80,81,82,86,87,88,89,90
	};
	private static int[] blackPlacingArea = {
			78,79,80,81,82,86,87,88,89,90,
			92,93,94,95,96,98,99,100,101,102,
			105,106,107,108,112,113,114,115,118,119,
			120,126,127,128,131,132,140,141,144,154
	};
//	public int[][] placingAreas = {whitePlacingArea,blackPlacingArea};
	public static int[][] placingAreas = new int[2][40]; //or the other way round?
	//this is read by gamestate!



	public static int[] boardValues;
	// holds info on allowed directions and ledge identity
	//TODO should the knocking path not go round the one corner? Controls on ledge?
	public final static int[] standardBoardValues = {
		0,4,4,4,4,4,224,64,64,64,64,0,0,
		0,208,248,104,224,244,250,233,224,208,248,104,4,
		0,214,255,255,254,255,255,255,251,255,255,107,4,
		0,22,255,255,255,255,255,255,255,255,255,11,0,
		0,148,254,255,255,127,31,223,255,255,251,41,0,
		0,244,255,255,127,11,5,22,223,255,255,233,0,
		148,222,255,255,107,6,1,6,214,255,255,123,41,
		0,151,255,255,251,104,5,208,254,255,255,47,0,
		0,148,223,255,255,251,248,254,255,255,127,41,0,
		0,208,255,255,255,255,255,255,255,255,255,104,0,
		3,214,255,255,223,255,255,255,127,255,255,107,0,
		3,22,31,11,7,151,95,47,7,22,31,11,0,
		0,0,2,2,2,2,7,3,3,3,3,3,0
			};

	private static final int[] miniQuincalaValues = {
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,4,4,4,4,224,64,64,64,64,-1,-1,
		-1,-1,0,208,104,244,250,233,208,104,0,-1,-1,
		-1,-1,0,22,255,126,31,219,255,11,0,-1,-1,
		-1,-1,0,244,126,11,1,22,219,233,0,-1,-1,
		-1,-1,148,222,107,1,1,1,214,123,41,-1,-1,
		-1,-1,0,151,219,104,1,208,126,47,0,-1,-1,
		-1,-1,0,208,255,219,248,126,255,104,0,-1,-1,
		-1,-1,0,22,11,151,95,47,22,11,0,-1,-1,
		-1,-1,2,2,2,2,7,3,3,3,3,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

	};
/*
 * Testing that all edge dots have the right values:
<Quincala;KM;62536a7953444479888844433334888999983
444988843444489888844353588979735262697a6a6263737a
695953748958475845748938473623948596a6263636a6969;
0.2&title=edge_test>
 */



//METHODS


	public static void setRuleParameters(int ruleVersion) {

		QRules.setPosEdit(false);//always reset this and set true if 0
		//nope; posedit is P, version 0 records plies!!


		QuiRules.ruleVersion = ruleVersion;

		if (ruleVersion > 9) { //is a letter variant - base it on pos edit??
			QRules.setWithSimpleRules(true);

			//re-set all to game 5 in case rules are changed in a session
			whiteGoalDot = -1; //these are only accessed in game 1
			blackGoalDot = -1; //make them -1??

			allowPass = true;
			winByCentreTower = false;
			winByKnockAllSizes = false;
			drawByMixingLast = false;//??? TBC
			shortMove = false;

			//simple mixing game
			winByKnockingLast = false;
			drawByConsecutivePass = true;
			winByMixingAllOwnSizes = false;


			goalDotWin = false;
			homePlacing = false; //placing from home dot
			releasing = false; //
			fullReleasing = false;
			bouncing = false;
			leglimit = true;
			//these two can be varied by the user as default resilient over variant!
			immunity = false;
			irreversibility = false;
			//end userRules - replace by full choice pop up window!


			freedomRule = false;
//			minimumRule= false;//these two are always opposite or both false

			ledgePlacing = false;

			//TODO use strings instead of cloning when defining knockingPaths
			knockingPaths = knockingPathsMiniQ.clone();

			//no placing in simple games
//			placingAreas[0] = whitePlacingArea;//as for ruleversion 1!
//			placingAreas[1] = blackPlacingArea;//do clone??

		} else { //is an esoteric variant
			QRules.setWithSimpleRules(false);
			//re-set all to game 5 in case rules are changed in a session
			whiteGoalDot = -1; //these are only accessed in game 1
			blackGoalDot = -1; //make them -1??

			allowPass = true;
			winByCentreTower = true;//complete tower on a white dot

			winByKnockAllSizes = false;
			drawByMixingLast = false;//??? TBC
			shortMove = false;

			//simple mixing game
			winByKnockingLast = false;
			drawByConsecutivePass = false;

			winByMixingAllOwnSizes = false;
			goalDotWin = false;
			homePlacing = true; //placing from home dot
			releasing = true; //
			fullReleasing = false;
			bouncing = true;
			leglimit = false;
			//these two can be varied by the user as default resilient over variant!
			immunity = immunityUser;
			irreversibility = irreversibilityUser;
			//end userRules - replace by full choice pop up window!


			freedomRule = true;
			minimumRule= false;//these two are always opposite or both false

			ledgePlacing = true;

			//TODO use strings instead of cloning when defining knockingPaths
			knockingPaths = knockingPathsGame6.clone();

			placingAreas[0] = whitePlacingArea;//as for ruleversion 1!
			placingAreas[1] = blackPlacingArea;//do clone??
		}



		switch (ruleVersion){
		case 0:
			QRules.setPosEdit(true);
//			posEdit = true;//moved to QRules!
			bouncing = false;
			releasing = false;
			immunity = false;
			irreversibility = false;
			//releasing/homeplacing/bouncing??
			break; //this keeps the rest of booleans as game 5

		case 7:
			goalDotWin = true;

			whiteGoalDot = 6;
			blackGoalDot = 162;
			placingAreas[1] = whitePlacingArea;
			placingAreas[0] = blackPlacingArea;


		case 1:
			knockingPaths = (int[][]) knockPathsGame1.clone();
			//use string instead?
			winByMixingAllOwnSizes = true;
			winByCentreTower = false;//false for both case 7 and 1
		case 2:
			homePlacing = false;
			releasing = false;
		case 3:
			bouncing = false;
		case 4:
			leglimit = true;
		case 5:

			break;
		case 6:
			leglimit = true;
			fullReleasing = true;
			System.out.println("Game 6 with full move release won't " +
			"be implemented for now!");
			break;

		case 20://K for simple Knocking
			winByKnockAllSizes = true;
			drawByMixingLast = false;//???
			winByKnockingLast = false;
			allowPass = false;
			drawByConsecutivePass = false;
			shortMove = true;//TBC
			break;
		case 22://M for simple Mixing
			winByMixingAllOwnSizes = true;//to try the knocking game!
			winByKnockingLast = true;
			drawByConsecutivePass = true;

//			ledgePlacing = false;// false for simple variant
//			immunity = false;//false for simple variant
//
//			freedomRule = false;//false for simple variant

			//here put simple knock path (dependent on size of board!!)
//			QRules.setWithSimpleRules(true);
//			minimumRule= true;//true for simple variant???
			break;
		default:
			break;


		}
		//however:
		if (ruleVersion == 5){
			leglimit = false;

		}

		//finally tell BoardGraphics to draw the goal dots:
		QuiGraphics.setWhiteGoalDot(whiteGoalDot);
		QuiGraphics.setBlackGoalDot(blackGoalDot);

		setValidOffBoardLocs();

		//for now - how to adopt to QGD 0.2?
		printRuleParams();
//		if (withSimpleRules){
//			setRuleVariants();
//			printRuleParams();
//		}

	}

	public static void setSizeParameters(int sizeParam) {

		if (ruleVersion > 19){//K is 20, M is 22
			numSizes = 3;
			numPieces = numSizes * 8;
			setTowerByte();
//			System.out.println("Setting board to Mini values!");

			boardValues = miniQuincalaValues.clone();
			//need to clone?? well, works now; test later!

//			System.out.println("top left is " + boardValues[0] );
//			knockingPaths = knockingPathsMiniQ.clone();
			//in setRuleParams for now - try here again when only one space string is sent!
			QuiGraphics.setMiniBoard(true);
		} else {
			numSizes = sizeParam;
			numPieces = numSizes * 8;
			setTowerByte();
			boardValues = standardBoardValues.clone();
//			System.out.println("Setting board to standard values!");
//			System.out.println("top left is " + boardValues[0] );
			QuiGraphics.setMiniBoard(false);
		}

		//in any case: force a redraw:
		QGraphics.setReDrawBoardFlag();




		//here set starting positions
		QuStartPositions startpos = new QuStartPositions();
		StartingPosition = "qui" + ruleVersion + 0; //for White starts ...
		if (ruleVersion == 1){
			//TODO Add goal dots??
		}
		StartingPosition += startpos.getStartPosString(ruleVersion, numSizes);
		System.out.println("StartingPosition is " + StartingPosition);
		//TODO use this to init GameState!

		//	no need to clone!?
		startStacks = (byte[]) startpos.setStacksStartPos(ruleVersion, numSizes).clone();
		startBlackPieces = (byte[]) startpos.setBlacksStartPos(ruleVersion, numSizes).clone();
	}

	private static void setTowerByte(){

		switch(numSizes){
		case 3:
			towerByte = 7;//make 21!
			break;
		case 4:
			towerByte = 15;
			break;
		case 5:
			towerByte = 31;
			System.out.println("towerByte is " + towerByte);
			break;
		}


	}

	public static void setRuleVariants(){//make static!!
		System.out.println("setRuleVariants is RUN");
		//simple game hard coded at the moment - develop to QGD 0.2!


//		irreversibility = irreversibilityUser;//!!!!!
	}

	private static void printRuleParams(){
		//for rule testing!
		System.out.println("====");
		System.out.println("RULES ARE SET TO:");
		System.out.println("ruleVersion is " + ruleVersion);
		System.out.println("winByCentreTower is " + winByCentreTower);
		System.out.println("QRules.posEdit is " + QRules.isPosEdit);
		System.out.println("whiteGoalDot is " + whiteGoalDot);
		System.out.println("blackGoalDot is " + blackGoalDot);
		System.out.println("goalDotWin is " + goalDotWin);
		System.out.println("homePlacing is " + homePlacing);
		System.out.println("releasing is " + releasing);
		System.out.println("fullReleasing is " + fullReleasing);
		System.out.println("bouncing is " + bouncing);
		System.out.println("leglimit is " + leglimit);
		System.out.println("irreversibility is " + irreversibility);

		System.out.println();
		System.out.println("freedom is " + freedomRule);
		System.out.println("immunity is " + immunity);
		System.out.println("minimumRule is " + minimumRule);
		System.out.println("ledgePlacing is " + ledgePlacing);
		// simple mixing game
		System.out.println("winByMixingAllOwnSizes is " + winByMixingAllOwnSizes);
		System.out.println("winByKnockingLast is " + winByKnockingLast);
		System.out.println("allowPass is " + allowPass);
		System.out.println("drawByConsecutivePass is " + drawByConsecutivePass);
		//simple knocking
		System.out.println("winBySimpleKnock is " + winByKnockAllSizes);
		System.out.println("drawByMixingLast is " + drawByMixingLast); //??? TBC//M for simple Mixing
		System.out.println("shortMove is " + shortMove);
//		System.out.println("winByMixingAllOwnSizes is " + winByMixingAllOwnSizes);//to try the knocking game!


		System.out.println("valid off board locs are " + QRules.validOffBoardLocs);


		System.out.println("END OF PRINT RULES");
		System.out.println("====");
	}

	public static void setGoalDots(int whiteGD, int blackGD) { //only if want to change the default
		//no need for an if (ruleVariant == 1) since default set anyway ...
			whiteGoalDot = whiteGD;
			blackGoalDot = blackGD;
	}

//	public void setImmunity(boolean immunity) {
//		this.immunity = immunity;
//	}
//
//	public void setIrreversibility(boolean irreversibility) {
//		this.irreversibility = irreversibility;
//	}

	public static void setUserRules(boolean[] userRules){
		irreversibilityUser = userRules[0];
		immunityUser = userRules[1];
		setRuleParameters(ruleVersion);
		//to update all the rule params!
	}

	public static void setEnvironment(String environment) {
		//test for validity again!
		if (!QSFUtils.isValidEnvironmentString(gameHead, environment))
			return;
		if (environment.length() != 2)
			return;
		//you can never be too careful
		//malformed environment strings will be ignored
		QuiRules.environment = environment;
		int ruleNo = (int) environment.charAt(0) - 48;
		int sizeNo = (int) environment.charAt(1) - 48;
		setRuleParameters(ruleNo);
		setSizeParameters(sizeNo);

	}

	public static boolean setQDGVersion(String definitionString){
		/*
		 * returns false if error ...
		 * only make this returnable until a separate message
		 * system is in place
		 */

		System.out.println("definitionString received is " + definitionString);
		/*
		 * this sets QGD version to latest if not otherwise specified
		 * it sets nothing if version is too high;
		 * a message to update software should be sent
		 * for now this is accomplished by returning false
		 */
		if (definitionString.length() == 0){
			baseLineToUse = latestBaseLine;
			incrementToUse = latestIncrement;
			return true;
		}


		int baseLine = latestBaseLine;
		int increment = latestIncrement;
		String[] s = definitionString.split("\\.");
		int fieldCount = s.length;
		System.out.println("fieldCount is " + fieldCount);
		if (fieldCount > 0)
			baseLine = Integer.parseInt(s[0]);
		if (fieldCount > 1)
			increment = Integer.parseInt(s[1]);

//		System.out.println("baseLine is " + baseLine);
//		System.out.println("increment is " + increment);
		if(baseLine > latestBaseLine || increment > latestIncrement)
			return false;

		//else:
		baseLineToUse = baseLine;
		incrementToUse = increment;

		return true;
	}

	public static void setValidOffBoardLocs() {

		ArrayList<Integer> al = new ArrayList<Integer>();
//		if (white can resign)
		al.add(972);//r0 white can resign
		al.add(973);//r1 black can resign
		//if draw by agreement
		al.add(988);
		if(allowPass)
			al.add(1001);

//		Integer[] offBoardLocs = al.toArray();

		QRules.setValidOffBoardLocs(al);
	}





}
