/*
**********************************************************************
*                        License Notice
*
* QuiPiece.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

import com.quincala.core.*;
//import java.awt.Color;


public class QuiPiece extends QPiece {

	/*
	 * this holds the information on each individual piece
	 * and its state, as well as methods for drawing it (calculate
	 * the points necessary for ~) etc
	 */



	public int stackSize = 0; //how many pieces in stack
	public int orderInStack = 0; //where among them

	public boolean isReleased = false;

	public boolean isInMixedStack = false;//replace by
	public boolean isFree = true;

	public boolean isImmortal = false;



	//used internally to make pieces; not yet ...
//	private Color blackPieceColour = Color.black;
//	private Color whitePieceColour = Color.white;
//	private Color outlineColour = new Color(140, 140, 140);
//	private Color releaseOutlineColour = Color.green;
//	private Color selectedOutlineColour = Color.red;


	public int[] sideViewPoints(int rotation, int xTop, int yTop, int ss){
		//the variables should be set? when how?
		int[] piecePoints = new int[4];
		// start with four points for a plain rect filling all occupied squares
		piecePoints[0] = xTop + gridX() * ss;
		piecePoints[1] = yTop + gridY() * ss;
		piecePoints[2] = ss;
		piecePoints[3] = ss;

		return piecePoints;
	}


	public int[] tiltViewPoints(int rotation, int xTop, int yTop, int ss){
		int[] piecePoints = new int[5]; //?


		return piecePoints;
	}

//	could also just set squareInt to 13; but these are tested and optimised ...
	public int gridX(){
		int X = 0;
		switch (boardRotation){
			case 0:
				X = loc % 13;
				break;
			case 1:
				X = 12 - (loc / 13);
				break;
			case 2:
				X = 12 - (loc % 13);
				break;
			case 3:
				X = loc / 13;
				break;
		}
		return X;
	}

	public int gridY(){
		int Y = 0;
		switch (boardRotation){
			case 0:
				Y = loc / 13;
				break;
			case 1:
				Y = loc % 13;
				break;
			case 2:
				Y = 12 - (loc / 13);
				break;
			case 3:
				Y = 12 - (loc % 13);
				break;
		}
		return Y;
	}


	public void setImmortal(boolean isImmortal) {
		this.isImmortal = isImmortal;
	}
	public void setInMixedStack(boolean isInMixedStack) {
		this.isInMixedStack = isInMixedStack;
	}
	public void setReleased(boolean isReleased) {
		this.isReleased = isReleased;
	}
	public void setOrderInStack(int orderInStack) {
		this.orderInStack = orderInStack;
	}
	public void setStackSize(int stackSize) {
		this.stackSize = stackSize;
	}


	public void setFree(boolean isFree) {
		this.isFree = isFree;
	}

}
