/*
**********************************************************************
*                        License Notice
*
* QuiGraphics.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.image.BufferedImage;

import com.quincala.core.QGraphics;

public class QuiGraphics extends QGraphics {
	/*
	 * This holds the graphical information about the board;
	 * also methods for drawing the various quincala specific
	 * graphics
	 * the super class QGraphics holds graphic data
	 * and drawing methods for the GUI and common elements
	 * and methods for board games
	 */

	public static int[] boardElements;

	public static final int[] standardQuincalaElements = {
			0,0,0,0,0,0,3,0,0,0,0,0,0,
			0,4,3,4,3,4,3,4,3,4,3,4,0,
			0,3,3,3,3,3,3,3,3,3,3,3,0,
			0,4,3,3,3,3,3,3,3,3,3,4,0,
			0,3,3,3,3,3,3,3,3,3,3,3,0,
			0,4,3,3,3,4,2,4,3,3,3,4,0,
			3,3,3,3,3,2,1,2,3,3,3,3,3,
			0,4,3,3,3,4,2,4,3,3,3,4,0,
			0,3,3,3,3,3,3,3,3,3,3,3,0,
			0,4,3,3,3,3,3,3,3,3,3,4,0,
			0,3,3,3,3,3,3,3,3,3,3,3,0,
			0,4,3,4,3,4,3,4,3,4,3,4,0,
			0,0,0,0,0,0,3,0,0,0,0,0,0
	}; //graphical elements

	private static final int[] miniQuincalaElements = {
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,0,0,0,0,3,0,0,0,0,-1,-1,
		-1,-1,0,4,4,4,3,4,4,4,0,-1,-1,
		-1,-1,0,4,3,3,3,3,3,4,0,-1,-1,
		-1,-1,0,4,3,4,1,4,3,4,0,-1,-1,
		-1,-1,3,3,3,1,1,1,3,3,3,-1,-1,
		-1,-1,0,4,3,4,1,4,3,4,0,-1,-1,
		-1,-1,0,4,3,3,3,3,3,4,0,-1,-1,
		-1,-1,0,4,4,4,3,4,4,4,0,-1,-1,
		-1,-1,0,0,0,0,3,0,0,0,0,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
	};

	//public int[] boardLines = {}; //bezier

	//variable width; each line is 8 points!
	private static final double[][] allLineDef = {
			{0.00, 0.00, 1.0, 0.00, 0.66666, 2.00, 0.00, 2.00},//change 2 & 4 only : large petal
			//{0.622, 1.117, 0.689, 1.60, 0.429, 2.0, 0.0, 2.0},//first approximation
			{0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.00, 1.00},//;small petal
			{0.00, 6.00, 0.47, 6.00, 0.53, 0.00, 1.00, 5.00},
			{1.00, 5.00, 1.47, 0.00, 1.53, 0.00, 2.00, 5.00},//control 3 segments
			{2.00, 5.00, 2.30, 5.00, 2.6, 0.0, 2.80, 4.60},//4. wave lft
			{0.0, 0.0, 0.0, 4.80, 2.9, 4.90, 3.00, 5.00},//5. wave rght
			{3.00, 5.00, 0.0, 0.0, 0.0, 0.0, 4.00, 5.00},
			{4.00, 5.00, 0.0, 0.0, 0.0, 0.0, 5.00, 5.00},
			{0.00, 4.00, 0.50, 4.00, 0.65, 3.35, 1.00, 3.00},// first of mini board
			{1.00, 3.00, 1.35, 2.65, 1.50, 2.65, 1.85, 2.65},
			{1.85, 2.65, 1.85, 2.76, 1.95, 2.95, 2.00, 3.00},
			{2.00, 3.00, 2.30, 3.30, 2.70, 3.30, 3.00, 3.00}
	};
	private static double[][] boardLineDef;

	private static int lineCount;
	private static double[][] xpandLn;
	private static double[][] ln;
//	public static CubicCurve2D[] ornArray = new CubicCurve2D[lineCount *
	public static CubicCurve2D[] ornArray;

	//TODO public static etc??
	//these are the board polygons:
	private static final int[] boardPolygonX =  {
		1, 5, 6, 7, 8, 12, 12, 13,
		13, 12, 12, 8, 7,
		6, 5, 1, 1, 0, 0, 1};
	private static final int[] boardPolygonY =  {
		1, 1, 0, 0, 1, 1, 5,
		6, 7, 8, 12, 12,
		13, 13, 12, 12, 8, 7, 6, 5};

	private static final int[] miniBoardPolygonX =  {
		3, 5, 6, 7, 8, 10,
		10, 11, 11, 10, 10,
		8, 7, 6, 5, 3, 3, 2, 2, 3
	};

	private static final int[] miniBoardPolygonY =  {
		3, 3, 2, 2, 3, 3,
		5, 6, 7, 8, 10, 10,
		11, 11, 10, 10, 8, 7, 6, 5
	};

//	these values are expanded in setDrawSizes:
	//mini option there or in redraw board?


	public static int[] boardPolygonXExp = new int[20];
	public static int[] boardPolygonYExp = new int[20];



	private static void redefineBoard(){

		/*
		 * this will either define a full size or
		 * a baby size (mini-Quincala) board
		 */
		System.out.println("QuiGraphics.redefineBoard is RUN");

		if(isMiniBoard){
			boardElements = miniQuincalaElements;

			boardLineDef = new double[8][6];
			lineCount = 6;
			int k = 0;
			for (int i = 0; i < 6; i++) {
				if(i == 2)
					k = 6;//to skip the big lines
				boardLineDef[i] = allLineDef[i + k];
				for (int j = 0; j < 8; j++) {
					System.out.print(boardLineDef[i][j] + ", ");
				}
				System.out.println();
			}

			QGraphics.setRadiusSeenDefault(5.0);

//			{
//					{0.00, 0.00, 1.0, 0.00, 0.66666, 2.00, 0.00, 2.00},//change 2 & 4 only : large petal
//					//{0.622, 1.117, 0.689, 1.60, 0.429, 2.0, 0.0, 2.0},//first approximation
//					{0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.00, 1.00},//;small petal
//					{0.00, 6.00, 0.47, 6.00, 0.53, 0.00, 1.00, 5.00},
//					{1.00, 5.00, 1.47, 0.00, 1.53, 0.00, 2.00, 5.00},//control 3 segments
//					{2.00, 5.00, 2.30, 5.00, 2.6, 0.0, 2.80, 4.60},//4. wave lft
//					{0.0, 0.0, 0.0, 4.80, 2.9, 4.90, 3.00, 5.00},//5. wave rght
//					{3.00, 5.00, 0.0, 0.0, 0.0, 0.0, 4.00, 5.00},
//					{4.00, 5.00, 0.0, 0.0, 0.0, 0.0, 5.00, 5.00},
//					{0.00, 4.00, 0.50, 4.00, 0.65, 3.35, 1.00, 3.00},// first of mini board
//					{1.00, 3.00, 1.35, 2.65, 1.50, 2.65, 1.85, 2.65},
//					{1.85, 2.65, 1.85, 2.76, 1.95, 2.95, 2.00, 3.00},
//					{2.00, 3.00, 2.30, 3.30, 2.70, 3.30, 3.00, 3.00}
//			};

		} else {
			boardElements = standardQuincalaElements;

			boardLineDef = new double[8][8];
			lineCount = 8;
			for (int i = 0; i < 8; i++) {
				boardLineDef[i] = allLineDef[i];
				for (int j = 0; j < 8; j++) {
					System.out.print(boardLineDef[i][j] + ", ");
				}
				System.out.println();
			}
			QGraphics.setRadiusSeenDefault(7.0);
		}


		//for both varieties:
		expandBoardLineDef();
//		setDrawSizes();//no getBoardImage needs to run anyway!
		//or don't call from getBoardImage?

	}

	//public static int boardPanelSize;
	public static int unit = 4; //this determines the size of everything drawn,
	//and sets the following in the method setDrawSizes():
	public static int core;//this is the vertical core of a stack, to fit it into a square ...
	public static int margin; // is the margin round a tower to the square
	public static int pdiff; // this is how much the pieces differ in size each side, same as unit for 5 size variants
	public static int xLargestPiece; // the x coordinate for the largest piece in play (half the width of the largest pieces)
	//public static int squareSize; // size of an individual square, is always odd!

	public static int ds; // this is the size of the black diamonds
	public static int tds; //this is the size of the turned black diamond
	public static int ts; // this is the size of the turn indicator

	public static int numberOfSizes = 5;//this is how many sizes are in play - set in quincala.current
	public static int smallestSize; //derived from numberOfSizes
	public static int pthick; // this is how thick the individual pieces are
	public static int pwide; // this is half the width of the largest piece
	public static int markerRad = 1;//the radius of the little marker oval on the sizes D and B

	public static int whiteGoalDot = -1;
	public static int blackGoalDot = -1;


	/*
	 * this is an experimental class, to see if I can create
	 * BufferedImages for the graphics
	 * Yep, even rotate already created ones!
	 */

	/*
	 *    // Create an image that does not support transparency
        BufferedImage bimage = g2d.getDeviceConfiguration().createCompatibleImage(
            width, height, Transparency.OPAQUE);

        // Create an image that supports transparent pixels
        bimage = g2d.getDeviceConfiguration().createCompatibleImage(
            width, height, Transparency.BITMASK);

        // Create an image that supports arbitrary levels of transparency
        bimage = g2d.getDeviceConfiguration().createCompatibleImage(
            width, height, Transparency.TRANSLUCENT);

	 */


	/*
	 * Scaling, Shearing, Translating, and Rotating a Buffered Image

    AffineTransform tx = new AffineTransform();
    tx.scale(scalex, scaley);
    tx.shear(shiftx, shifty);
    tx.translate(x, y);
    tx.rotate(radians, bufferedImage.getWidth()/2, bufferedImage.getHeight()/2);

    AffineTransformOp op = new AffineTransformOp(tx, AffineTransformOp.TYPE_BILINEAR);
    bufferedImage = op.filter(bufferedImage, null);

	 */

	//from board panel
	//put this in QuiBoardGraphics?
//	double[][] lineDef = {
//			//{0.00, 0.00, 1.0, 0.00, 0.66666, 2.00, 0.00, 2.00},//change 2 & 4 only
//			{0.622, 1.117, 0.689, 1.60, 0.429, 2.0, 0.0, 2.0},//first approximation
//			{0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.00, 1.00},
//			{0.00, 6.00, 0.47, 6.00, 0.53, 0.00, 1.00, 5.00},
//			{1.00, 5.00, 1.47, 0.00, 1.53, 0.00, 2.00, 5.00},//control 3 segments
//			{2.00, 5.00, 2.30, 5.00, 2.6, 0.0, 2.80, 4.60},//4. wave lft
//			{0.0, 0.0, 0.0, 4.80, 2.9, 4.90, 3.00, 5.00},//5. wave rght
//			{3.00, 5.00, 0.0, 0.0, 0.0, 0.0, 4.00, 5.00},
//			{4.00, 5.00, 0.0, 0.0, 0.0, 0.0, 5.00, 5.00},
//			};
//	double[][] xpandLn = new double[64][8];
//	double[][] ln = new double[64][8];
//	CubicCurve2D[] ornArray = new CubicCurve2D[64];


	private static BasicStroke greyOutlineStroke = new BasicStroke(1.0f);
	private static BasicStroke selectOutlineStroke = new BasicStroke(1.0f);
    public static BasicStroke ornLineStroke = new BasicStroke(2.0f);
    private static BasicStroke whiteDiamStroke = new BasicStroke(2.0f);
    private static BasicStroke relHandleStroke = new BasicStroke(1.0f);
    private static BasicStroke trailingCircleStroke = new BasicStroke(1.7f);
	final static float dash1[] = {5.0f};
    private static BasicStroke bouncingLineStroke = new BasicStroke(2.0f,
                                          BasicStroke.CAP_BUTT,
                                          BasicStroke.JOIN_MITER,
                                          10.0f, dash1, 0.0f);


	//this is the board polygon:
//	int[] boardPolygonX =  {1, 5, 6, 7, 8, 12, 12,
//							13, 13, 12, 12, 8, 7,
//							6, 5, 1, 1, 0, 0, 1};
//	int[] boardPolygonY =  {1, 1, 0, 0, 1, 1, 5, 6,
//							7, 8, 12, 12, 13, 13, 12,
//							12, 8, 7, 6, 5};
//	int[] boardPolygonXExp = new int[20];
//	int[] boardPolygonYExp = new int[20];

    public static Color tableClothColour = new Color(230,230,230);
    public static Color frameColour = new Color(180, 180, 180);
    public static Color frameColourLight = new Color(225, 180, 180);

//    public static Color boardColourLight = new Color(225, 160, 0);//options
    public static Color boardColourLight = new Color(255, 140, 0);//BRIGHTER WHEN TRANPARENT!

    public static Color boardColour = new Color(180, 160, 0);
    //for testing
    public static Color boardColourPoly = new Color(30, 160, 200);

    //these are transitional but works: make better markings
    public static Color boardColourLightGoalDot = new Color(225, 180, 0);
    public static Color boardColourGoalDot = new Color(180, 180, 0);

    public static Color selectedSquareColour = Color.red;
    public static Color winSquareColor = Color.yellow;

    public static Color blackPieceColour = Color.black;
    public static Color whitePieceColour = Color.white;
    public static Color outlineColour = new Color(140, 140, 140);
    public static Color releaseOutlineColour = Color.green;
//  public Color immortalOutlineColour = Color.blue;
    public static Color immortalOutlineColour = new Color(0, 100, 255);
    public static Color selectedImmortalOutlineColour = Color.magenta;

    public static Color immuneOutlineColour = Color.yellow;
    public static Color selectedImmuneOutlineColour = new Color(255, 130, 0);//G+ for more yellow ...


    public static Color selectedOutlineColour = Color.red;

    //spare:
    public static Color violetColour = new Color(35, 0, 228);//test



    public static Color releaseHandleColour = Color.green;

    public static Color ornOlineColour = new Color(180,180,180);
    public static Color blackDotColour = new Color(180,180,180);

	//end from board panel

//	public static BufferedImage board = null;//private?? or even not global?

	public static BufferedImage rotatedIm = null;

	AffineTransform identity = new AffineTransform();

//	private static int wd = 0;
//	private static int ht = 0;
//	private static int xTop = 0;
//	private static int yTop = 0;
//
//	private static int ss = 0;


	//== METHODS==

	public static void initQuiGraphics(){
		completeOrnLineDef();
		redefineBoard();
	}

	//private once all drawing migrated:
	public static void calcFromUnit(){
		ss = margin * 2 + unit * 10 + core;
		boardSize = ss * 13;
		canvasSize = ss * 15;
		System.out.println("QuiGraphics.calcFromUnit()canvasSize is " + canvasSize);
	}

	public static void setDrawSizes() {
		//System.out.println("setDrawSizes is reached");
		// here the sizes of the board are set initially
		// all relating to squaresizes and numSizes (from Q2DGrid Class)

		/*
		 * TODO with black diamonds unit as well as pieces - sticking out
		 * try unit - 1? Then unit must be 1 or over!
		 */

		System.out.println("static setdrawsizes is run!");



		//

		//numberOfSizes = currentSpace.currentRules.numSizes;
		smallestSize = QuiUtils.smallestSizeInPlay(numberOfSizes);
		//System.out.println("static smallestSize is " + smallestSize);
		core = 3;//1 fits perfectly into square; increase to widen the top piece - always odd!
		margin = 1;

		//Zooming:
		//centre board on panel:
		System.out.println("QuiGraphics.setDrawsizes radiusSeen is " + radiusSeen);
		if (radiusSeen >= (radiusSeenDefault - 0.5) || radiusSeen <= 0.5){ //normal zoom
			int gridSize = 1;
			if (isMiniBoard){
				gridSize = 10;//looks good to me
			} else {
				gridSize = 13;
			}

			unit = (int) (boardPanelSize/gridSize - margin * 2 - core)/10;
//			System.out.println("static boardPanelSize is " + boardPanelSize);
			if (unit < 2)
				unit = 2;//minimum value for unit? try 1 to cramp more in...
			calcFromUnit();
//			System.out.println("normal board canvasSize is " + canvasSize);

			while (canvasSize > maxCanvasSize){
				unit -= 1;
				calcFromUnit();
			}


			xTop = (boardPanelSize - boardSize) / 2;
			yTop = xTop;//for now ...

			xCanv = (boardPanelSize - canvasSize) / 2;
			yCanv = xCanv;//is this good?

		} else { //zooming in ...
			unit = (int) (boardPanelSize/(2 * radiusSeen + 1) - margin * 2 - core)/10;
			calcFromUnit();

			//needs to be set twice, since needed within the preceding clause!
			while (canvasSize > maxCanvasSize){
				unit -= 1;
				calcFromUnit();
			}
//			System.out.println("zoom board unit is " + unit);
//			System.out.println("zoom board canvasSize is " + canvasSize);

			int centerSqXCoord = gridX(boardRotation, centerSqLoc);
			int centerSqYCoord = gridY(boardRotation, centerSqLoc);
//			System.out.println("centerSqLoc is " + centerSqLoc);
//			System.out.println("centerSqXCoord is " + centerSqXCoord);
//			System.out.println("centerSqYCoord is " + centerSqYCoord);
			xTop = (int) ((2 * radiusSeen + 1 - centerSqXCoord * 2 - 1) * ss /2);
			yTop = (int) ((2 * radiusSeen + 1 - centerSqYCoord * 2 - 1) * ss /2);
			//no, this is just ((radiusSeen - centerSqYCoord) * ss) !!!
			if (xTop >0)
				xTop = 0;
			if (yTop >0)
				yTop = 0; //when zooming we don't want a margin to the top!

			xCanv = (int) ((radiusSeen - centerSqXCoord - 1) * ss);
			yCanv = (int) ((radiusSeen - centerSqYCoord -1) * ss);//is this good?
			if (xCanv > -ss)
				xCanv = -ss;
			if (yCanv > -ss)
				yCanv = -ss;
		}

		//unit is 1-6 on my screen
		//System.out.println("unit is " + unit);
		//System.out.println("squareSize is " + ss);
		markerRad = unit / 3;

		float thickness = 1.0f;
		switch (unit){ //or a more elegant formula??
		case 1:
		case 2:
		case 3:
			//relHandleStroke = new BasicStroke(1.0f);

			break;
		case 4:
		case 5:
			thickness = 2.0f;
			//relHandleStroke = new BasicStroke(2.0f);
			break;
		case 6:
		default:
			thickness = 3.0f;
			break;
		}
		relHandleStroke = new BasicStroke(thickness);
		selectOutlineStroke = new BasicStroke(thickness);
//		if (unit > 4)
//			relHandleStroke = new BasicStroke(2.0f);


		//set strokes here:
//		ornLineStroke = new BasicStroke(2.0f);
//		whiteDiamStroke = new BasicStroke(2.0f);




//		expandOrnLineDef();//this should be run on init only!
		//finally, scale the ornamental lines and relate to x,yTop
		//this is new size only:
		int expandedLinesCount = xpandLn.length;
		ornArray = new CubicCurve2D[expandedLinesCount];
		for (int k = 0; k < expandedLinesCount; k++){
			for (int i = 0; i < 8; i++){//always 8 points to a line
				if (i % 2 == 0){ //x-coordinate
					ln[k][i] = (xpandLn[k][i] + 1) * ss;
				} else {
					ln[k][i] = (xpandLn[k][i] + 1) * ss;
				}
			}
			ornArray[k] = new CubicCurve2D.Double();
			ornArray[k].setCurve(ln[k][0], ln[k][1], ln[k][2], ln[k][3], ln[k][4],
					ln[k][5], ln[k][6], ln[k][7]);
		}




		pdiff = unit; // this is how much the pieces differ in size each side
		if (numberOfSizes == 3)
			pdiff = 2 * unit; //use ECA for games with three sizes ...
		pthick = unit * 2; //piece thickness; the + 1 allows for a core of the piece, enabling centering
		xLargestPiece = 5 * unit + core - 1;//
		ds = unit; // this is the size of the black diamonds, usually 3, but try unit ...
//		tds = ds * 7 / 10 + 2;
		//round up by + 2 looks too big unit <4 && unit > 8 classic 6 too, but good otherwise ...
		//tds = size of turned black diamond & half white diamond: 7/5 is approx SQRT(2)???

		ts = unit*3; // this is the size of the turn indicator, experiment
		//CDs = unit*2; // this is the size of the CD buttons, usually square size/5

		//for some odd reason, the turned dots need a graded increase
		//make dots as images and rotate them at some point?
		if (ds < 3){
			tds = ds + 1;
		} else if (ds < 6){
			tds = ds;
		} else if (ds < 8){
			tds = ds - 1;
		} else 	if (ds < 12){
			tds = ds - 2;
		} else
			tds = ds - 3;

//		System.out.println("static unit is " + unit);
//		System.out.println("static turned dot size, tds, is " + tds);


		//expand the board polygon:
		if(isMiniBoard){
			int polyPointCount = miniBoardPolygonX.length;
			for(int i = 0; i < polyPointCount; i++){
				boardPolygonXExp[i] = (int) (ss * (miniBoardPolygonX[i] + 1));
				boardPolygonYExp[i] = (int) (ss * (miniBoardPolygonY[i] + 1));
			}
		} else {
			int polyPointCount = boardPolygonX.length;
			for(int i = 0; i < polyPointCount; i++){
				boardPolygonXExp[i] = (int) (ss * (boardPolygonX[i] + 1));
				boardPolygonYExp[i] = (int) (ss * (boardPolygonY[i] + 1));
			}
		}

		//experimentalImage = boardMaker.getBoardImage(wd, ht, xTop, yTop, ss);
		//this is called from board panel!!


	}



	public static BufferedImage getBoardImage(){

		System.out.println("getBoardImage is run");
		/*
		 * refactor this as setBoardImage
		 * just get the global image?
		 * if not, only make buffered image inside the methods!
		 * and store in boardpanel for redrawing
		 */

//		how to add an image ... & size the buffer accordingly!
//      size = new Dimension();
//      castle = new ImageIcon("slanec.jpg").getImage();
//      size = new Dimension();
//      size.width = castle.getWidth(null);
//      size.height = castle.getHeight(null);


		//or in beginning of setDrawSizes??
//		if (fetchBoardReDefinitionFlag())
//			redefineBoard();

		setDrawSizes();//for now -
		//should be done before calling this method
		//or is this method only called when new sizes??

		//the following are used by optionsImage too
//		wd = QBoardGraphics.getWidth();
//		ht = QBoardGraphics.getHeight();
//		xTop = QBoardGraphics.getXTop();//use getter??
//		yTop = QBoardGraphics.getYTop();

		//ss = QuiBoardGraphics.ss;
//		int ds = QuiBoardGraphics.ds;
//		int tds = QuiBoardGraphics.tds;


		//CubicCurve2D[] ornArray = QuiGraphics.ornArray;

//		int[] boardPolygonXExp = QuiBoardGraphics.boardPolygonXExp;
//		int[] boardPolygonYExp = QuiBoardGraphics.boardPolygonYExp;

		BufferedImage board =  new BufferedImage(canvasSize, canvasSize,
                BufferedImage.TYPE_INT_RGB);

        Graphics g = board.getGraphics();
        Graphics2D g2d = (Graphics2D) g;




        //g.drawImage(castle, 0, 0, null);//how to add images
//        g2d.setColor(Color.red);
//        g2d.fillRect(0, 0, 200, 200);

		//0. draw "table cloth"
        if(QGraphics.canvasTextureInt == -1){
        	g2d.setColor(tableClothColour);//tableClothColour
        } else {
        	g2d.setPaint(QGraphics.texture2);
//        	g2d.setColor(Color.white);//in case no texture used
        	//TODO add canvas textures
        }

		g2d.fillRect(0, 0, canvasSize, canvasSize);//fills whole canvas

		//1. draw frame as rectangle/square

		g2d.setColor(frameColour);
		int m = 1;//mini board offset
		int gridSize = 13;
		if(isMiniBoard){
			m = 3;
			gridSize = 9;
			g2d.fillRect(m*ss - 1, m*ss - 1, gridSize * ss + 2, gridSize * ss + 2);
			//TODO make cut corner board!
		} else {
			g2d.fillRect(m*ss - 1, m*ss - 1, gridSize * ss + 2, gridSize * ss + 2);
		}



		//2. draw polygon of board
        if(QGraphics.boardTextureInt == -1){
        	g2d.setColor(boardColour);//no texture
        } else {
        	g2d.setPaint(QGraphics.texture1);
//        	g2d.setColor(Color.white);//in case no texture used
        	//TODO add board textures
        }
//        boardPolygonXExp

		g2d.fillPolygon(boardPolygonXExp, boardPolygonYExp,20);

		//3. draw goal dots if used

		if (whiteGoalDot > -1){
			int gdx = gridX(whiteGoalDot);
			int gdy = gridY(whiteGoalDot);
			g2d.setColor(boardColourGoalDot);
			g2d.fillRect(ss + gdx * ss, ss + gdy * ss, ss, ss);
		}
		if (blackGoalDot > -1){
			int gdx = gridX(blackGoalDot);
			int gdy = gridY(blackGoalDot);
			g2d.setColor(boardColourGoalDot);
			g2d.fillRect(ss + gdx * ss, ss + gdy * ss, ss, ss);
		}
//		if (loc == whiteGoalDot || loc == blackGoalDot){
		//
//									//only used in Game 1
//									g2d.setColor(boardColourGoalDot);
//									g2d.fillRect(xTop + x * ss, yTop + y * ss, ss, ss);


		//4. draw ornamental lines
		g2d.setStroke(ornLineStroke);//as above
		g2d.setColor(ornOlineColour);
		//g2d.setColor(Color.black);
		System.out.println("ornArray.length is " + ornArray.length);


		for (int i=0; i < lineCount; i++){//to draw all large petals first!
			for (int j = 0; j < 8; j++) {
				//this draws all the lines
				g2d.draw(ornArray[j * lineCount + i]);
				}
			if (i == 0){// after all large petals have been drawn
				//fill the small petal areas
		        if(QGraphics.boardTextureInt == -1){
		        	g2d.setColor(boardColour);//no texture
		        } else {
		        	g2d.setPaint(QGraphics.texture1);
//		        	g2d.setColor(Color.white);//in case no texture used
		        	//TODO add board textures
		        }
				for (int k = 0; k < 8; k++)
					g2d.fill(ornArray[k * lineCount + 1]);

				//add one small rectangle to cover what small petal fill
				//did not erase
				g2d.fillRect(29 * ss / 4, 29 * ss / 4, ss/2, ss/2);
				//fill rectangle a quarter of ss round middle

				g2d.setColor(ornOlineColour);//back to line colour
			}


		}

		//5. draw diamonds on top
		g2d.setColor(blackDotColour);
		for (int x = 0; x < 13; x++){
			for (int y = 0; y < 13; y++){

				int loc = location(x,y);
				//the following two were global to paint???
				int xMid = (int) ((x + 1.5) * ss) + 1; //needs casting!
				int yMid = (int) ((y + 1.5) * ss) + 1;


				//here diamonds are drawn on top
				if (hasStandardBlackDiamond(loc)) {
					for (int i = 0; i <= ds; i++) {
						g2d.drawLine(xMid + ds - i, yMid + i, xMid - ds + i,
								yMid + i);
						g2d.drawLine(xMid + ds - i, yMid - i, xMid - ds + i,
								yMid - i);
					}
				}

				if (hasTurnedBlackDiamond(loc)) {
					g2d.fillRect(xMid - tds, yMid - tds, 2 * tds, 2 * tds);
				}

				if (hasWhiteDiamond(loc)) {
					//use same stroke as ornamental lines?
					g2d.setStroke(whiteDiamStroke);
					g2d.drawLine(xMid - 2 * tds, yMid, xMid, yMid - 2 * tds);//from left /
					g2d.drawLine(xMid - 2 * tds, yMid, xMid, yMid + 2 * tds);//from left \
					//g2d.setStroke(new BasicStroke(3.0f));
					g2d.drawLine(xMid + 2 * tds, yMid, xMid, yMid - 2 * tds);//from right \
					g2d.drawLine(xMid + 2 * tds, yMid, xMid, yMid + 2 * tds);//from right /



				}
			}
		}





        //need to use affine?? ...
        //g2d.rotate(1);//holy grail! radians ..
//        g2d.rotate(45.0 * Math.PI / 180.0);//holy grail!

        g2d.dispose();

		return board;
	}

	public static BufferedImage getTurnIndicatorImage(int passFlag, int playerInt){

		System.out.println("getTurnIndicatorImage is run");

		 BufferedImage turnIndicatorImage =  new BufferedImage(canvasSize, canvasSize,
	                BufferedImage.BITMASK);

	        Graphics g = turnIndicatorImage.getGraphics();
	        Graphics2D g2d = (Graphics2D) g;

	        //TODO make turnindicator triangle per colour then rotate

		// then make turn indicator: (use polygon?/ test time)


		// define MidX and MidY ...
		int xMid = 15 * ss / 2;
		int yMid = 15 * ss / 2;
		//int ts = QuiBoardGraphics.ts;
		//first draw a pass mark if a player has passed by clicking on
		//the turnindicator
		//int passFlag = currentSpace.currentState.passFlag;
		if (passFlag > -1){
			if (passFlag == 0){//white passed
				g2d.setColor(whitePieceColour);
			} else { //black passed
				g2d.setColor(blackPieceColour);
			}
			g2d.setStroke(trailingCircleStroke);
			g2d.drawOval(7 * ss, 7 * ss, ss, ss);
			//g2d.draw(new Ellipse2D.Double(xMid - ss/2, yMid - ss/2, ss, ss));
		}

		if (playerInt == 0) { // white player's turn
			g2d.setColor(whitePieceColour);
			switch (boardRotation) { // putting the loop inside each case
			// should save time?
			case 0:
				for (int i = 0; i <= ts; i++)
					g2d.drawLine(xMid + ts - i, yMid + i, xMid - ts + i,
									yMid + i);
				break;
			case 1:
				for (int i = 0; i <= ts; i++)
					g2d.drawLine(xMid - i, yMid + ts - i, xMid - i, yMid
									- ts + i);
				break;
			case 2:
				for (int i = 0; i <= ts; i++)
					g2d.drawLine(xMid + ts - i, yMid - i, xMid - ts + i,
									yMid - i);
				break;
			case 3:
				for (int i = 0; i <= ts; i++)
					g2d.drawLine(xMid + i, yMid + ts - i, xMid + i, yMid
									- ts + i);
				break;
			}
		} else {
			g2d.setColor(blackPieceColour);
			switch (boardRotation) {
			case 0:
				for (int i = 0; i <= ts; i++)
					g2d.drawLine(xMid + ts - i, yMid - i, xMid - ts + i,
									yMid - i);
				break;
			case 1:
				for (int i = 0; i <= ts; i++)
					g2d.drawLine(xMid + i, yMid + ts - i, xMid + i, yMid
									- ts + i);
				break;
			case 2:
				for (int i = 0; i <= ts; i++)
					g2d.drawLine(xMid + ts - i, yMid + i, xMid - ts + i,
									yMid + i);
				break;
			case 3:
				for (int i = 0; i <= ts; i++)
					g2d.drawLine(xMid - i, yMid + ts - i, xMid - i, yMid
									- ts + i);
				break;
			}
		}

		g2d.dispose();

		return turnIndicatorImage;
	}

	public static BufferedImage getOptionsImage(boolean[] legalOptions){

		System.out.println("getOptionsImage is run");

		//this could be in QBoardMaker??
		 BufferedImage optionsImage =  new BufferedImage(canvasSize, canvasSize,
                BufferedImage.TRANSLUCENT);

        Graphics g = optionsImage.getGraphics();
        Graphics2D g2d = (Graphics2D) g;

        //make it here:

        g2d.setColor(boardColourLight);


        //we know that legalOptions[].size is 169!!

        //TODO make rings

		//3. add board ornaments (options and goal dots)
		//TODO re write more efficiently ...
		//TODO make getting this not so often!!

		for (int y = 0; y < 13; y++) { //I like y before x; follows the alexian rows
			for (int x = 0; x < 13; x++) {
				boolean doFill = false;
				int loc = location(x,y);
//				legal = quincala.currentState.options[loc];
				//boolean legal = legalOptions[loc];
				if(legalOptions[loc]){
					if (isOnFrame(loc)) {
						//on the ledge
						g2d.setColor(frameColourLight);
					} else {
						g2d.setColor(boardColourLight);
					}
					g2d.fillOval((x + 1)* ss, (y + 1) * ss, ss, ss);//Good!

				}
			}
		}





        g2d.dispose();

		return optionsImage;
	}

	private static void completeOrnLineDef(){

		if (allLineDef[0][0] == 0){ //starts at origo, so calculate!
			allLineDef[0][3] = allLineDef[0][2];
			allLineDef[1][3] = allLineDef[0][2];
			allLineDef[1][4] = 1 - allLineDef[0][4] / 2;
			allLineDef[1][5] = 1 + allLineDef[0][4] / 2;
		} else { //there is no complete first line to calculate ...
			//make the small petal the first line?
			allLineDef[1][3] = 1;
			allLineDef[1][4] = (double) 2/3;
			allLineDef[1][5] = (double) 4/3;
		}

		//first segment second control point must be 45
		allLineDef[2][5] = 6 - allLineDef[2][4];

		//this is giving a lot of control to [3][2] and [3][4]
		//postulating the identity of segments 3, 6 & 7
		double verticalParam = allLineDef[3][2] - 1;
		double horizontParam = 2 -allLineDef[3][4];
		allLineDef[3][3] = 5 - verticalParam;//1.4 -> 4.6
		allLineDef[3][5] = 5;

		allLineDef[6][2] = 3 + verticalParam;
		allLineDef[6][3] = 5 + verticalParam;
		allLineDef[6][4] = 4 - horizontParam;
		allLineDef[6][5] = 5;
		allLineDef[6][6] = 4;
		allLineDef[6][7] = 5;

		allLineDef[7][2] = 4 + horizontParam;
		allLineDef[7][3] = 5;
		allLineDef[7][4] = 5 - verticalParam;
		allLineDef[7][5] = 5 + verticalParam;

		//this assumes that the wave tip is 90�, and the means
		//to that is horizontal control point 2 for wave left
		//and vertical for wave right
		allLineDef[4][5] = allLineDef[4][7];

		allLineDef[5][0] = allLineDef[4][6];
		allLineDef[5][1] = allLineDef[4][7];
		allLineDef[5][2] = allLineDef[4][6];
		allLineDef[5][5] = allLineDef[5][4] + 2;

		//this puts the makes point 8,1 equal both sides ...
		allLineDef[4][2] = 2 + horizontParam;
	}


	private static void expandBoardLineDef(){
		//firstly put let the lines follow input on 0,2 and 0,4:



		//good to print the values ...
//		System.out.println("These are the final values defining the lines:");
//		for (int k = 0; k < 8; k++){
//			for (int i = 0; i < 8; i++){
//				System.out.print(lineDef[k][i] + " ");
//			}
//			System.out.println();
//		}
//		System.out.println();


		xpandLn = new double[lineCount * 8][8];
		ln = new double[lineCount * 8][8];

//		filling the ornamental lines

		System.out.println("lineCount is " + lineCount);
		//lineCount * 8
		//0. load the original lineCount defining lines into xpandLn
		for (int k = 0; k < lineCount; k++){
			for (int i = 0; i < 8; i++){
				xpandLn[k][i] = boardLineDef[k][i];
			}
		}

		//1. set x = -x to make 16
		for (int k = 0; k < lineCount; k++){
			for (int i = 0; i < 8; i++){
				if (i % 2 == 0){ //x-coordinate
					xpandLn[k + lineCount][i] = - xpandLn[k][i];
				} else {
					xpandLn[k + lineCount][i] = xpandLn[k][i];
				}
			}
		}
		//1. set y = -y to make 32
		for (int k = 0; k < (lineCount * 2); k++){
			for (int i = 0; i < 8; i++){
				if (i % 2 == 0){ //x-coordinate
					xpandLn[k + lineCount * 2][i] = xpandLn[k][i];
				} else {
					xpandLn[k + lineCount * 2][i] = - xpandLn[k][i];
				}
			}
		}

		//3. mirror x to y to make 64
		for (int k = 0; k < (lineCount * 4); k++){
			for (int i = 0; i < 8; i++){
				if (i % 2 == 0){ //x-coordinate
					xpandLn[k + lineCount * 4][i] = xpandLn[k][i + 1];
				} else { //y-coordinate
					xpandLn[k + lineCount * 4][i] = xpandLn[k][i - 1];
				}
			}

		}


		//4. put into middle
		for (int k = 0; k < lineCount * 8; k++){
			for (int i = 0; i < 8; i++){
				xpandLn[k][i] = xpandLn[k][i] + 6.5;
			}
		}


	}





//	these interpret the array boardElements
	public static boolean isOnFrame(int loc){
		boolean result = false;
		if (boardElements[loc] == 0)
			result = true;
		return result;
	}

	public static boolean hasDiamond(int loc){
		boolean result = false;
		if (boardElements[loc] > 1)
			result = true;
		return result;
	}

	public static boolean hasBlackDiamond(int loc){
		boolean result = false;
		if (boardElements[loc] > 2)
			result = true;
		return result;
	}

	public static boolean hasWhiteDiamond(int loc){
		boolean result = false;
		if (boardElements[loc] == 2)
			result = true;
		return result;
	}

	public static boolean hasStandardBlackDiamond(int loc){
		boolean result = false;
		if (boardElements[loc] == 3)
			result = true;
		return result;
	}

	public static boolean hasTurnedBlackDiamond(int loc){
		boolean result = false;
		if (boardElements[loc] == 4)
			result = true;
		return result;
	}

	public static void setNumberOfSizes(int noSizes){
		numberOfSizes = noSizes;
	}



	public static void setWhiteGoalDot(int whiteGoalDot) {
		QuiGraphics.whiteGoalDot = whiteGoalDot;
	}



	public static void setBlackGoalDot(int blackGoalDot) {
		QuiGraphics.blackGoalDot = blackGoalDot;
	}

	public static void setMiniBoard(boolean isMiniBoard) {
		//is "overriding" a bit?
		boolean doRedefine = false;
		if (QGraphics.isMiniBoard != isMiniBoard){
			doRedefine = true;
			setReDrawBoardFlag();
		}


		QGraphics.isMiniBoard = isMiniBoard;
		System.out.println("QuiGraphics.isMiniBoard is set " + isMiniBoard);
		if (doRedefine)
			redefineBoard();
	}



//	public static void setUnit(int unit) {
//		QuiGraphics.unit = unit;
//	}

//	public static int gridX(int boardRotation, int loc){
//		int X = 0;
//		switch (boardRotation){
//			case 0:
//				X = loc % 13;
//				break;
//			case 1:
//				X = 12 - (loc / 13);
//				break;
//			case 2:
//				X = 12 - (loc % 13);
//				break;
//			case 3:
//				X = loc / 13;
//				break;
//		}
//		return X;
//	}
//
//	public static int gridY(int boardRotation, int loc){
//		int Y = 0;
//		switch (boardRotation){
//			case 0:
//				Y = loc / 13;
//				break;
//			case 1:
//				Y = loc % 13;
//				break;
//			case 2:
//				Y = 12 - (loc / 13);
//				break;
//			case 3:
//				Y = 12 - (loc % 13);
//				break;
//		}
//		return Y;
//	}
//
//	//not overriding since different parameters!
//	public static int location(int boardRotation, int x, int y) { //returns the index to use in QuGameState objects
//		int a = 0;
//		switch(boardRotation){
//		case 0:
//			a = x + y * 13;
//			break;
//		case 1:
//			a = (12 - x) * 13 + y;
//			break;
//
//		case 2:
//			a = 12 - x + (12 - y) * 13;
//			break;
//		case 3:
//			a = x * 13 + 12 -y;
//			break;
//		}
//		return a;
//	}






}
