/*
**********************************************************************
*                        License Notice
*
* QuiGameStatus.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

import com.quincala.core.*;

public class QuiGameStatus extends QGameStatus {

	/*
	 * the game specific status report objects are
	 * very small extensions on the following principle
	 * Maybe even put the quincala version naming as default??
	 */

//in QGameStatus as default!
//	public String[] playerName = {"White", "Black"};
//	public String[] colourName = {"white", "black"};

	//allowBooleans - are they general?

	public boolean mayMove = false;
	public boolean isMoving = false;
	public boolean mayPlaceLedge = false;
	public boolean mayPlaceHome = false;
	public boolean mayRelease = false;//use releasing destination > 0!
	public boolean mayBounce = false;
	public boolean hasBeenRewound = false;
	//public boolean failedControlTest = false;

	//TODO implement these status values:
//	public boolean isWin = false;
//	public boolean isWinAhead = false;

	public int releaseDestIndex = 0;//
	public int releasedPieceColour = 0;



	public String gameName = "Quincala";


	public String getFullGameName(){
		String fullName = gameName + " ";

		switch(GameVersion){

		case 0:
			fullName += "Position Editor with " + GameVariant + " sizes";
			break;

		case 7:
			fullName += "Football";
			break;
		case 2:
			fullName += "Displacing with " + GameVariant + " sizes";
			break;

		case 3:
			fullName += "Standard with " + GameVariant + " sizes";
			break;

		case 4:
			fullName += "Bouncing";
			break;

		case 5:
			fullName += "Unlimited";
			break;

		case 1:
			fullName += "Mixing with " + GameVariant + " sizes";
			break;

		default:
			fullName += "Undefined variant";
			break;
		}


//		fullName = gameName + " " + GameVersion + "." + GameVariant;
		return fullName;
	}

	public String getStatusBarText(){
		String sBText = "";

		//first filter out the posEdit:
		if (GameVersion < 1){
			sBText = "Position Editor - any piece with red selection will be moved anywhere you click";
			return sBText;
		}
//		about result of the match
		String resultText = "";
		if(isWinAhead && !isWin)
			resultText = playerName[winColour] + " will win!";

		if(isEndOfLine){
			if(isWin)
				resultText = playerName[winColour] + " has won!";
			if (resignInt == 0)
				resultText += " (White has resigned)";
			if (resignInt == 1)
				resultText += " (Black has resigned)";
			if (resignInt == 2)
				resultText += "Draw is agreed.";
			if (resignInt == 3)
				resultText += "Draw by consecutive Passes.";

		} else {
			if (mayMove)
				sBText = " to move";
			if (mayPlaceHome){
				if (sBText.length() == 0){
					sBText += " to place";
				} else {
					sBText += " or place";
				}
			}
			if (mayPass){
				if (sBText.length() == 0){
					sBText += " to pass";
				} else {
					sBText += " or pass";
				}
			}

			if (isMoving)
				sBText = " is moving";

			if (mayPlaceLedge)
				sBText = " to place from the ledge";

			if (mayRelease){
				if (zeroPlyDestIndex == 0)
					sBText = " to release";
				if (zeroPlyDestIndex == 1)
					sBText = " to capture";
				if (zeroPlyDestIndex > 1)
					sBText = " to release to the ledge";
			}

			if (sBText.length() > 0)
				sBText = playerName[playerInt] + sBText + ".";

			//end of second part; beginning third

			if(mayBounce)
				sBText += " (may bounce)";


			if (hasBeenRewound)
				sBText += " (The entire turn has been 're-wound' to enable re-play!)";
		}

		//leave this out!!
		if (passFlag > -1 && resignInt != 3){
			sBText += " (" + playerName[passFlag] + " has passed)";
		}



		if (sBText.length() == 0){
			sBText = resultText;
		} else if (resultText.length() > 0){
			sBText += " " + resultText;
		}


		//finally add the turn number info, or just the comma
		sBText = "; " + sBText;
//		sBText = "Turn " + currentTurnNo + ", " + sBText;

//		System.out.println("sBText is " + sBText);
		return sBText;
	}

	public int opponentInt(){
		return (playerInt + 1) % 2;
	}


	public void setMoving(boolean isMoving) {
		this.isMoving = isMoving;
	}


	public void setMayMove(boolean mayMove) {
		this.mayMove = mayMove;
	}





	public void setMayPlaceHome(boolean mayPlaceHome) {
		this.mayPlaceHome = mayPlaceHome;
	}


	public void setMayPlaceLedge(boolean mayPlaceLedge) {
		this.mayPlaceLedge = mayPlaceLedge;
	}


	public void setMayRelease(boolean mayRelease) {
		this.mayRelease = mayRelease;
	}

	public void setMayBounce(boolean mayBounce) {
		this.mayBounce = mayBounce;
	}

	public void setReleaseDestIndex(int releaseDestIndex) {
		this.releaseDestIndex = releaseDestIndex;
	}

	public void setReleasedPieceColour(int releasedPieceColour) {
		this.releasedPieceColour = releasedPieceColour;
	}

//	public void setFailedControlTest(boolean failedControlTest) {
//		this.failedControlTest = failedControlTest;
//	}

	public void setHasBeenRewound(boolean hasBeenRewound) {
		this.hasBeenRewound = hasBeenRewound;
	}






}
