/*
**********************************************************************
*                        License Notice
*
* QuiGameState.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

//import com.quincala.core.*;

import java.util.*;
import com.quincala.core.*;

import java.util.ArrayList;

//public class QuiGameState extends QuCalc {

public class QuiGameState extends QGameState implements Cloneable {

	// keep cloneable but probably don't use

	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	// public Object clone() { //hmmr
	// Object o = null;
	// try {
	// o = super.clone();
	// } catch (CloneNotSupportedException e) {}
	// return o;
	// }

	/**
	 * this class holds all information about the Game state it takes input of
	 * location integer or (will take) qustrings for plys and positions. It can
	 * output strings, simple arrays corresponding to layers of information or
	 * more comprehensive objects.
	 */

	// engineer's switches :-)
	private boolean disObeyOptions = false;

	public boolean doConstruction = false;



	// Layers of information - "simple arrays"
	// easy to reset a layer by creating a new instance ...
	public boolean[] options = new boolean[169];// initiates all false?
	public byte[] stacks = new byte[169];// sizes information
	public byte[] blackPieces = new byte[169];// colour information
	public byte[] pieceSelections = new byte[169];
	public byte[] releasedPieces = new byte[169];
	public byte[] immortalPieces = new byte[169];
//	transitional until graphics paint from pieceArray ...

	public byte[] noKnockPiecesToBe = new byte[169];//experimental knocking rule
	public byte[] noKnockPieces = new byte[169];//gradually


	// replace with ordrdReleaseHandlesArray?

	public int activeLocation = 169; // instead of squareSelections:

	// 169 is "no selection" - use -1!

	private ArrayList ReleaseHandles = new ArrayList();
	private ArrayList ordrdReleaseHandles = new ArrayList();
	public QDuplet[] ordrdReleaseHandlesArray = new QDuplet[0];
	// needs initialising; new test

	public boolean doReleasing = false;// do I need both of these?



	// about bouncing
	public int bouncingDirectionUnit = 0;
	public int bouncingOrigin = 0;

	/*
	 * life cycle of bouncingDirectionUnit: set in perform Duplet list reset in
	 * receiveEntry/if endleg click
	 */
	// this is temporary: for graphics only:
	public int[] bouncingLineLocs = new int[2];

	QDuplet active = new QDuplet(); // make the first active duplet object:

	public ArrayList activeList = new ArrayList();

	// if codebase > 5.0 add <QDuplet> as params?

	// ALLOWBOOLEANS FOR STATUSBAR TEXT:
	// use resetAllowBooleans() to reset ...
	public boolean mayMove = false;
	public boolean isMoving = false;
	public boolean mayPlaceLedge = false;
	public boolean mayPlaceHome = false;
	public boolean mayPass = false;

	// mayBounce is (bouncingDirectionUnit != 0)

	public int passFlag = -1; // true when a player has just passed!
	private boolean justPassedFlag = false;//to enable consecutive pass

	public boolean failedControlTest = false;
	public int controlPassInt = 0;

	// 0 if pass, + 1 is IR fail, +2 is FR fail
	public boolean hasBeenRewound = false;
	public boolean initialRetrace = false;// quick fix?
	public boolean buildLocString = false;
	public int confirmedPlyCount = 0;
	public int confirmedLocPos = 0;

	private boolean doCrop = false;

	public boolean hasIllegalPlies = false;

	// RULE PARAMETERS:

	// QuRules currentRules = new QuRules();

	//do presets as for PosEdit!
//	private final int presentRuleVersion = 0;
//	private final int numSizes = 5; // default is 5
//	private final int numPieces = 40;
//	private final boolean goalDotWin = false;
//	private final int whiteGoalDot = -1; // these are only set & accessed for game 1
//	private final int blackGoalDot = -1;
//
//	//used for creating a starting position without sending rules
//	private final boolean homePlacingRule = false; // placing from home dot
//	private final boolean releasingRule = false; //
//	private final boolean fullReleasingRule = false; // Implement!??
//	private final boolean bouncingRule = false;
//	private final boolean leglimitRule = false;
//	// limiting legs to the number of pieces moving
//	private final boolean immunityRule = false;
//	private final boolean irreversibilityRule = false;
//
//	// initialise these???
//	public int[][] knockingPaths;
//	public int[][] releasingPaths;
//	public int[][] ledges;
//	public int[][] placingAreas;

	// about duplet type: - USE 0, or is 0 just init?
	public int presentDupletType = 0;
	public int lastPlyValue = 0;
	//this will be read to determine previous marker ...

	/*
	 * presentDupletType will slowly morph into turnPhase ... currently they are
	 * the same; make distinctions in performDupletList()
	 */
	public int turnPhase = 0;
	private final int EMPTY = 0;
	private final int L_PLACING = 1;
	private final int H_PLACING = 2;
	private final int LEG = 3;
	private final int KNOCKING = 4;
	private final int END_LEG = 5;
	private final int RELEASING = 6;

	// about selection types:
	private final int LARGEST_PIECE = 0;
	private final int ALL_OWN_PIECES = 1;
	private final int SOWERS = 2;

	QuiStack[] stackArray = new QuiStack[169];

	/*
	 * This is a comprehensive cross cut of layers It is made to order
	 * (getStackArray) and doesn't interfere with rerunning long strings. (only
	 * send the stack Ojects that have changed to the GUI!)
	 */

	public Set changedLocs = new HashSet();

	// irreversibility history!
	public ArrayList whiteIRHistory = new ArrayList();
	public ArrayList blackIRHistory = new ArrayList();

	// does this belong to QuGameState? NO, obsolete!! is in QuGameLine
	public String matchString = "qui"; // current match in string format
	public String matchHexString = "qui"; // current match in string format
	public String lineStringHead = "qui";
	public String plyString = "";

	// using hex chars only

	public String locString = "";

	// used to build it before importing to GameLine
	// private String zeroPlyString = "";
	// used for 0ply locs; get from "fetcher"

	// do pastString and futureString too?? IN QuGameSpace?

	public int turnNumber = 1; // start on 1 as in reality
	//public int turnLocCount =0;//in Qgamestate ...
	public int plyCount = 0; // keeps track how many clicks received
	public int player = 0; // replace this slowly by:??
	private int homedot = ownHomeDot(player);// from QuCalc ...
	public boolean whitesTurn = true;
	public int firstPlayer = 0; // in case Black starts ...; or:??
	public boolean whiteStarted = true;
//	public byte towerByte = 0;

	public boolean isWin = false;
	public boolean isWinAhead = false;
	public boolean isEndOfLine = false;
	public int resignInt = -1;//0=white resign, 1=black resign, 2=agreed draw
	public int winColour = -1;
	// corresponding to the winner ... 0 for White, 1 for Black
	public int winLocation = 169;//set -1??
	public int winLocationAhead = 169;

	// use when zeroPly operations can complete win
	public String matchPhaseString = "";// or keep empty? - 0-length == no win
										// ..

	// NOTE keep resetGameState() happy? until migration complete ...
	public String statusBarText = "";

	public String controlStatusText = "";



	// use with isWinAhead when zeroPly operations can complete win
	// 169 is "no selection"
	public int goldenRuleFlag = -1;// part of mechanics

	public boolean goldenRuleHolds = false;

	// keep for future statistics engines
	public String goldenRuleInfo = "";

	// NOTE keep resetGameState() happy? until migration complete ...

	// new generation: Testing button!

	public void setStack(byte stackByte, int loc) {

		// initialising the array
		for (int i = 0; i < 169; i++) {
			stackArray[i] = new QuiStack();
		}

		// System.out.println("stackByte & loc are " + stackByte + " & " + loc);
		stackArray[loc].setSizes(stackByte);
		// System.out.println("stackArray[loc].sizes is " +
		// stackArray[loc].sizes);
		if (stackArray[loc].isPresent(2)) {
			// System.out.println("size 2 isPresent at " + loc);
		}
	}

	public QuiPiece[] getPieceArray(int boardRotation, int xTop, int yTop,
			int ss) {
		// maybe need pwide, pthick, pdiff too?
		// this is creating an array to order ...
		// not involved in long ply string calculations or tree explorations ...
		QuiPiece[] pieceArray = new QuiPiece[QuiRules.numPieces];// smaller for less sizes!
		int paIndex = 0;
		int size = 0;
		for (byte mask = 1; mask < QuiRules.towerByte; mask *= 2) {//
			size++;
			for (int colour = 0; colour < 2; colour++) {
				for (int loc = 0; loc < 169; loc++) {
					// search the simple arrays
					if (pieceIsAtLocation(mask, colour, loc)) {
						QuiPiece quiPiece= new QuiPiece();
						quiPiece.setLoc(loc);
						quiPiece.setType(size);
						quiPiece.setColour(colour);
						quiPiece.setStackSize(countBits(stacks[loc]));
						quiPiece.setOrderInStack(orderInStack(size,	stacks[loc]));
						quiPiece.setReleased(isPresent(mask,
								releasedPieces[loc]));
						quiPiece.setFree(isPlain(stacks[loc], blackPieces[loc])
									&& isBlackDot(loc));

						quiPiece.setInMixedStack(isMixed(
								stacks[loc], blackPieces[loc]));//obsolete
						// etc
						//finally put the piece into the pieceArray:
						pieceArray[paIndex] = quiPiece;

						paIndex++;
					}

				}

			}
		}

		//just to avoid immortality being marked in posEdit
		//and other variant not using the freedom rule:
		if (!QuiRules.freedomRule || isEndOfLine)
			return pieceArray;

//		 here investigate immortal piece:
		immortalPieces = new byte[169];//empty old ones!
		int index = 0;
		for (byte mask = 1; mask < QuiRules.towerByte; mask *= 2){
			for (int colour = 0; colour < 2; colour++){
				int freeCount = 0;
				for (int i = 0; i < 4; i++){//8 times masks ...
					if(pieceArray[index].isFree){
						freeCount++;
					}
					index++;
				}
				if (freeCount < 2){//less than 1 out of 4 is free
					index -= 4;//go over these four again!
					for (int i = 0; i < 4; i++){
						if(pieceArray[index].isFree){
							//= the piece at index is immortal and on pieceArray[index].loc and
							//set mask (=size byte) as immortal at loc
							immortalPieces[pieceArray[index].loc] += mask;
							//+= since can be more than one immortal piece on a diamond!
							pieceArray[index].setImmortal(true);//not yet used


						}
						index++;
					}

				}

			}

		}



		return pieceArray;
	}

	public QuiGameStatus getGameStatus() {
		QuiGameStatus currentGameStatus = new QuiGameStatus();

		/*
		 * NOTE game status displays current turnNumber whether a duplet is
		 * performed or not:
		 */

		currentGameStatus.setCurrentTurnNo(turnNumber);

		currentGameStatus.setPlayerInt(player);
		endOfLineTest();// really turnPhaseTest ...
		currentGameStatus.setMatchPhaseString(matchPhaseString);
		// or rather:
		currentGameStatus.setStatusBarText(statusBarText);
		// currentGameStatus.setGameName(gameName);//for now not changed ...
		currentGameStatus.setGameVersion(QuiRules.ruleVersion);
		currentGameStatus.setGameVariant(QuiRules.numSizes);

		// allowbooleans:
		currentGameStatus.setMayMove(mayMove);
		// TODO Bug mayPass doesn't allow for releasing and wins!!
		// currentGameStatus.setMayPass(mayPass && irreversibilityTest() &&
		// freedomTest());
		currentGameStatus.setMayPass(mayPass);// needs to be double checked!
		currentGameStatus.setMayPlaceHome(mayPlaceHome);
		currentGameStatus.setMayPlaceLedge(mayPlaceLedge);
		currentGameStatus.setMayRelease(zeroPlyDestination > 0);
		currentGameStatus.setZeroPlyDestIndex(zeroPlyDestIndex);
		currentGameStatus.setMoving(isMoving);
		currentGameStatus.setMayBounce(bouncingDirectionUnit != 0);

		currentGameStatus.setPassFlag(passFlag);
		currentGameStatus.setHasBeenRewound(hasBeenRewound);
		// currentGameStatus.setFailedControlTest(failedControlTest);
		// nope; make a flag that it has been retraced!

		currentGameStatus.setWin(isWin);
		currentGameStatus.setWinAhead(isWinAhead);
		currentGameStatus.setWinColour(winColour);
		currentGameStatus.setResignInt(resignInt);
		currentGameStatus.setEndOfLine(isEndOfLine);

		// System.out.println("currentGameStatus.currentTurnNo is " +
		// currentGameStatus.currentTurnNo);

		return currentGameStatus;
	}

	public QWholeLineData getWholeLineData() {
		// should always be at the end of line when calling this method
		QWholeLineData currentStateEndData = new QWholeLineData();

		// add to this list whenever needed!
		/*
		 * TODO Add float gameSpaceCount? after migration and pruning ...
		 */
		currentStateEndData.setGameVersion(QuiRules.ruleVersion);
		currentStateEndData.setGameVariant(QuiRules.numSizes);

		currentStateEndData.setLocString(locString);

		/*
		 * NOTE only turns with at least one completed duplet (= leg or placing)
		 * are entered into the line turncount To count a turn already from leg
		 * start, the engine needs to have migrated to GameState! Should a ledge
		 * placing start be counted in??
		 */

		currentStateEndData.setTurnsOpened(turnNumber);

		int turnCount = turnNumber;
		if ((turnPhase == 0) && (resignInt == -1))
			turnCount -= 1;
		currentStateEndData.setTurnsInLine(turnCount);
		//doesn't count turns without a ply in it
		//resignation or draw is a ply but doesn't change turnphase!

//		String turnCountString = "Turns in line: " + turnCount + ".";
//		currentStateEndData.setTurnCountString(turnCountString);
		currentStateEndData.setTurnPhase(turnPhase);
		currentStateEndData.setPlayer(player);


		currentStateEndData.setWinnerInt(winColour);
//		currentStateEndData.setSealed(isSealed);//nope must come from Line!!
		currentStateEndData.setResignInt(resignInt);
		currentStateEndData.setEndOfLine(isEndOfLine);

		//replace by creating the string in QuiWholeLineData!!
		endOfLineTest();// is this too complicated??
		//currentStateEndData.setTurnPhaseString(matchPhaseString);
//		currentStateEndData.setGoldenRuleHolds(goldenRuleHolds);//obsolete
//
//		// keep for futurestatistics engines: test again ...
//		currentStateEndData.setGoldenRuleInfo(goldenRuleInfo);//obsolete

		currentStateEndData.setGoldenRuleFlag(goldenRuleFlag);

		// public int winLocation = 169;
		// // 169 is "no selection"

		return currentStateEndData;
	}

	public String getLineString() {
		return lineStringHead + plyString;
	}

	public int getLocPos() {
		return locString.length();
	}

	public String getLocStringToLocPos(int locPos) {
		String extract = locString.substring(0, locPos);
		return extract;
	}

	public int getPlyPos() {
		// System.out.println("plyString.length() is " + plyString.length());
		return plyString.length();
	}

	public boolean[] getOptions() {
		return options;
	}

	public int[] getLocArray() {
		int length = locString.length();
		int[] locArray = new int[length / 2]; // since each loc has two coords
		for (int i = 0; i < length / 2; i++) {
			char hexChar1 = locString.charAt(i * 2);
			char hexChar2 = locString.charAt(i * 2 + 1);
			// here make alexian out of hexChars
			locArray[i] = QSFUtils.hexCharsToLoc(hexChar1, hexChar2);
		}
		return locArray;
	}

	public void cropFourChars() {
		// called from doCrop/restart?
		plyString = plyString.substring(0, getPlyPos() - 4);
		locString = locString.substring(0, getLocPos() - 4);
	}

	public void setDoCropTrue() {
		// called from restarting condition in receive Entry
		doCrop = true;// for userEntry() to fetch
	}

	public boolean fetchDoCrop() {
		boolean value = doCrop;
		doCrop = false;
		return value;
	}

	// end new generation

	public void setGoldeRuleFlag(int colour) {
		if (goldenRuleFlag < 0)
			goldenRuleFlag = colour;
	}

	public void newTurn() { // used by Games > 0 to toggle players etc
		switchPlayer();
		turnNumber++;
		turnLocCount = 0; //reset
		noKnockPieces = new byte[169];
		noKnockPieces = (byte[]) noKnockPiecesToBe.clone();//blimey - clone needed??
		noKnockPiecesToBe = new byte[169];//reset immunePieces & also feed proper immunePieces!

	}

	public void switchPlayer() { // used by positionEditor to toggle players
		player = ((player + 1) % 2);
		// System.out.println("activePlayer is " + activePlayer);
		whitesTurn = !whitesTurn;
		// System.out.println("whitesTurn is " + whitesTurn);
		// turnState = 0;
		turnPhase = 0;
		// System.out.println("turnPhase is " + turnPhase);
		activeLocation = 169;
		presentDupletType = 0;
	}

	// is this useful??
	// TODO test this one! NEW turnNumber starts on 1! change formulas?
	// public void setPlayer() { //used in matches with turnNumbers
	// activePlayer = (turnNumber + firstPlayer) % 2;
	//
	// if ((turnNumber % 2) == 0){
	// whitesTurn = whiteStarted;
	// } else {
	// whitesTurn = !whiteStarted;
	// }
	// }

	// used to load starting positions:
	public void setStacks(byte[] startStacks) {
		resetGameState();
		stacks = (byte[]) startStacks.clone();
	}

	public void setBlackPieces(byte[] startBlackPieces) {
		// System.out.println("!!Loaded by clones");
		blackPieces = (byte[]) startBlackPieces.clone();

	}

	// setTowerByte();
	public void setTowerByte(int numSizes) {//obsolete but IRhistory!!
//		towerByte = calcTowerByte(numSizes);
		// System.out.println("towerByte is " + towerByte);
		// now this is a temporary place for this:
		whiteIRHistory.add(0, getIRPositionString(0));
		blackIRHistory.add(0, getIRPositionString(1));
		// System.out.println("whiteIRHistory0 is " + whiteIRHistory.get(0));
		// System.out.println("blackIRHistory0 is " + blackIRHistory.get(0));

	}

	public void setPresentDupletType(int dType) {
		presentDupletType = dType;
		// System.out.println("presentDupletType is " + presentDupletType);
	}

	public void selectUserSquare(int loc) {
		// squareSelections[loc] = 64; //or maybe 96, then make green just
		// removes all 64s
		activeLocation = loc;
	}

	public void selectAllPieces(int loc) {
		// byte selectionStack = stacks[loc];
		pieceSelections[loc] = stacks[loc];
	}

	public void selectSomePieces(int loc, byte pieceSelection) {
		// should this delete prevoius selections?
		pieceSelections[loc] = pieceSelection;
	}

	public void addReleasedPiece(int loc, byte releasedPiece) {
		/*
		 * this adds selections of pieces without removing previous selections
		 */
		releasedPieces[loc] = joinGroups(releasedPieces[loc], releasedPiece);
	}

	public void updateReleasedPieces() {
		for (int i = 0; i < 169; i++) {
			releasedPieces[i] = (byte) (releasedPieces[i] & stacks[i]);
		}
	}

	public void clearReleasedPieces() {
		releasedPieces = new byte[169];
	}

	// public void deSelectSquares(int stack){ //Can't get this one to work ...
	// for (int i = 0; i < 169; i++){
	// squareSelections[i] = (byte) (squareSelections[i] ^ stack);
	// }
	// }

	public void noActiveLocation() {
		// squareSelections = new byte[169];
		activeLocation = 169;
	}

	public void deSelectAllPieces() {
		pieceSelections = new byte[169];
	}

	// obsolete?
	public void updatePosition(int atLoc, byte newStack, byte newBlacks) {
		stacks[atLoc] = newStack;
		blackPieces[atLoc] = newBlacks;
	}

	// this class can know about itself ...
	// the following could now use the superclass QuCalc ...
	public boolean hasPieces(int loc) {
		boolean result = false;
		if (stacks[loc] > 0)
			result = true;
		return result;
	}

	public boolean hasCompleteTower(int loc) {
		boolean result = false;
		if (stacks[loc] == QuiRules.towerByte)
			result = true;
		return result;
	}

	public boolean hasMixedGroup(int loc) {
		/*
		 * formula says: there are black pieces, and there are sizes which are
		 * not black.
		 */
		return ((blackPieces[loc] > 0) && (stacks[loc] != blackPieces[loc]));
	}

	public boolean hasPlainGroup(int loc) { // optimise?
		return (hasPlainWhite(loc) || hasPlainBlack(loc));
	}

	public boolean hasPlainWhite(int loc) {
		return ((stacks[loc] > 0) && (blackPieces[loc] == 0));
	}

	public boolean hasWhitePiece(int loc) { // used for game1 winTest()
		return (stacks[loc] > blackPieces[loc]);
	}

	public boolean hasBlackPiece(int loc) { // used for game1 winTest(){
		return (blackPieces[loc] > 0);
	}

	public boolean hasPlainBlack(int loc) {
		return ((stacks[loc] > 0) && (stacks[loc] == blackPieces[loc]));
	}

	public boolean pieceIsAtLocation(int sizeMask, int colour, int loc) {
		boolean result = false;
		byte stack = stacks[loc];
		byte blacks = blackPieces[loc];
		if (((sizeMask & stack) != 0)
				& ((sizeMask & blacks) == (sizeMask * colour)))
			result = true;
		return result;
	}

	public boolean pieceIsInReleasedPieces(int sizeMask, int colour, int loc) {
		boolean result = false;
		byte stack = releasedPieces[loc];
		byte blacks = blackPieces[loc];
		if (((sizeMask & stack) != 0)
				& ((sizeMask & blacks) == (sizeMask * colour)))
			result = true;
		return result;
	}

	public void performUeberList(ArrayList listOfListsOfDupletLists) {
		/*
		 * Maybe Queue instead of ArrayList? this would be a list comprising
		 * lists for several linear matches if ever called, the first one only
		 * is performed! alternatively, use Russian Dolls: dupletlist inside
		 * turnphaselist inside turnlist?? TODO only compile tested!
		 */
		ArrayList ueberlist = (ArrayList) listOfListsOfDupletLists.get(0);
		performMetaList(ueberlist);
	}

	public void performMetaList(ArrayList listOfDupletLists) {
		/*
		 * Maybe Queue instead of ArrayList? this would be a list comprising
		 * duplets for an entire turnphase, turn or match; used for stepping,
		 * arrow display and notation TODO only compile tested!
		 */
		int s = listOfDupletLists.size();
		for (int i = 0; i < s; i++) {
			ArrayList dupletlist = (ArrayList) listOfDupletLists.get(i);
			performDupletList(dupletlist);
		}
	}

	public void performDupletList(ArrayList dupletList) {
		// maybe Stack instead of ArrayList
		changedLocs = new HashSet();// what is a hashSet?
		int size = dupletList.size();
		int dType = 0;
		int from = 0;// outside loop to enable bouncing calcs on last duplet
		int to = 0;
		// TEST
		// System.out.println("list is of size " + dupletList.size());
		// System.out.println("zeroPlyString is " + zeroPlyString);

		for (int i = 0; i < size; i++) {

			// first extract a new QuDuplet Object out of activeList
			QDuplet perform = (QDuplet) dupletList.get(i);
			from = perform.origLoc;
			to = perform.destLoc;
			byte movedPieces = perform.activeSizes;
			lastPlyValue = perform.plyValue;
			dType = perform.dupletType;
			// add to changed locations list (set?)
			changedLocs.add(new Integer(from));
			changedLocs.add(new Integer(to));
			// System.out.println(from + " " + to + " " + movedPieces);

			byte movedBlacks = (byte) (movedPieces & blackPieces[from]);
			// use QuCalc for this one?

			stacks[from] = removeFromByte(movedPieces, stacks[from]);
			blackPieces[from] = removeFromByte(movedBlacks, blackPieces[from]);

			stacks[to] = joinGroups(movedPieces, stacks[to]);
			blackPieces[to] = joinGroups(movedBlacks, blackPieces[to]);
			plyCount += lastPlyValue;

			if(QuiRules.immunity){//not necessary but optimising ...
				//knocking sizes are immune on knocking location ...

//				if(dType == KNOCKING){
//					//Maybe move this back to recieveEntry, since don't know colour of knocker her ...
//					immunePieces[from] = (byte )(immunePieces[from] | movedPieces);//graphics
//					immunePiecesToBe[from] = (byte )(immunePieces[from] | movedPieces);//for next turn ...
//					//start with this ... both colours still!
//					//TODO use xor to filter out knocking opposite colour? ... xor is ^?
//					//System.out.println("immunePieces[" + loc + "] is " + immunePieces[loc]);
//
//				}
				if(dType == LEG){
					//END_LEG is always on same tower or turn-indicator
					//move the immunity property with the movers
					 int immuneMovers = movedPieces & noKnockPieces[from];
					 noKnockPieces[to] = (byte )(noKnockPieces[to] | immuneMovers);
					 noKnockPiecesToBe[to] = (byte )(noKnockPiecesToBe[to] | immuneMovers);
					 //remove the immunity from old locations: Necessary???
					 noKnockPieces[from] = (byte )(noKnockPieces[from] ^ immuneMovers);
					 noKnockPiecesToBe[from] = (byte )(noKnockPiecesToBe[from] ^ immuneMovers);
				}
				if(dType == RELEASING){
					//IS this necessary? No knocking can happen after releasing ...
					//when releasing an immune piece, remove its immunity:
					int immuneMovers = movedPieces & noKnockPieces[from];
					noKnockPieces[from] = (byte )(noKnockPieces[from] ^ immuneMovers);
					noKnockPiecesToBe[from] = (byte )(noKnockPiecesToBe[from] ^ immuneMovers);
				}

			}

		}
		// public int bouncingDirectionUnit = 0;
		// public int[] bouncingLineLocs = new int[2];
		if (QuiRules.bouncing && (dType == LEG)) {
			bouncingDirectionUnit = bouncingDirection(from, to);// 0 for no
																// bouncing
			bouncingOrigin = to;
			bouncingLineLocs[0] = to;
			bouncingLineLocs[1] = to + bouncingDirectionUnit;
//			System.out.println("bouncingDirectionUnit is "
	//				+ bouncingDirectionUnit);
//			System.out.println("bouncingLineLocs[0] is " + bouncingLineLocs[0]);
//			System.out.println("bouncingLineLocs[1] is " + bouncingLineLocs[1]);
		}

		presentDupletType = dType;
		turnPhase = dType;// for now; make better distinctions!!
		// System.out.println("turnPhase is " + turnPhase);
		// test the set:
		// Iterating over the elements in the set
		// System.out.print("locations are: ");
		Iterator it = changedLocs.iterator();
		while (it.hasNext()) {
			// Get element
			Object element = it.next();
			// System.out.print(element + " ");
		}

	}

	// THIS IS INCLUDED IN ABOVE!!
	public void performDuplet(QDuplet perform) {
		// int from = perform.origLoc;
		// int to = perform.destLoc;
		// byte movedPieces = perform.activeSizes;
		// int plyValue = perform.plyValue;
		// //System.out.println(from + " " + to + " " + movedPieces);
		//
		// byte movedBlacks = (byte) (movedPieces & blackPieces[from]);//use
		// QuCalc for this one??
		//
		// stacks[from] = removeFromByte(movedPieces, stacks[from]);
		// blackPieces[from] = removeFromByte(movedBlacks, blackPieces[from]);
		//
		// stacks[to] = joinGroups(movedPieces, stacks[to]);
		// blackPieces[to] = joinGroups(movedBlacks, blackPieces[to]);
		//
		// //TODO should winTest go here????
		// winTest();
		//
		// plyCount += plyValue;
	}

	public void initMatchString(int ruleVersion, int numSizes) {
		matchString += (char) (ruleVersion + 48);
		matchString += (char) (numSizes + 48);
		matchHexString += (char) (ruleVersion + 48);
		matchHexString += (char) (numSizes + 48);// obsolete
		lineStringHead += (char) (ruleVersion + 48);
		lineStringHead += (char) (numSizes + 48);
		// System.out.println("matchString is " + matchString);
		// System.out.println("turnNumber is " + turnNumber);
	}

	public void addToHistory(char quChar) {// obsolete
		matchString += quChar;// obsolete
		// lineStringHead += quChar;
		// System.out.println();
		// System.out.println("the unpruned matchString is:");
		// System.out.println(matchString);

	}

	public void addToPlyString(String quHexChars) {
		matchHexString += quHexChars;// obsolete
		plyString += quHexChars;
		// System.out.println();
		// System.out.println("the unpruned matchHexString is:");
		// System.out.println(matchHexString);//obsolete
		// System.out.println(getLineString());

	}

	public boolean mixingGameWinTest(){
		/*
		 * this is a temporary solution to code the Mixing game
		 */


		int whiteTower = 0;
		int blackTower = 0;


		for (int loc = 6; loc < 163; loc++) {
			//TODO loop over a int[] blackDiamonds!
			if(isBlackDot(loc) && isMixed(stacks[loc],blackPieces[loc])){
				blackTower = blackTower | blackPieces[loc];
				int whitePieces = stacks[loc] ^ blackPieces[loc];
				whiteTower = whiteTower | whitePieces;

			}
		}


		if((whiteTower == QuiRules.towerByte) && (blackTower == QuiRules.towerByte)){
			//both players have simultaneous winning position
			isWin = true;
			isEndOfLine = true;
			winColour = (player + 1) % 2;//the other player
		} else {
			if((whiteTower == QuiRules.towerByte)){
				isWin = true;
				isEndOfLine = true;
				winColour = 0;//white win
			}
			if ((blackTower == QuiRules.towerByte)){
				isWin = true;
				isEndOfLine = true;
				winColour = 1;//black win

			}
		}



		return isEndOfLine;

	}

	public boolean endOfLineTest() {

		/*
		 * this is run at the beginning of each loaded postion
		 * and at the end of each leg;
		 */

		/*
		 * wish list for actions: only run once release win: stop immediately
		 * knocking win: fulfill move, but only run once note that fulfilling a
		 * knocking move will not change result: knocking only affects other
		 * player's home dot and his ledge! reach goal dot: stop immediately
		 */

		//TODO move matchPhaseString creation to QWholeLineData!
		// in any case let's update the matchPhaseString now!
		// rename method to getMatchPhase? 4 = win ...
//		System.out.println("endoflinetest is Run");

		if(isEndOfLine){
			if (resignInt > -1 && resignInt < 2){
				isWin = true;
				winColour = (resignInt + 1) % 2;
				goldenRuleTest();
			}
			return true;
		}

//		if (turnPhase == 0) {
//			if (player == 0) {
//				matchPhaseString = "White to play.";
//			} else {
//				matchPhaseString = "Black to play.";
//			}
//		} else {
//			if (player == 0) {
//				matchPhaseString = "White's turn.";
//			} else {
//				matchPhaseString = "Black's turn.";
//			}
//		}

		if(QuiRules.winByKnockAllSizes){
			/*
			 * this incorporates winByKnockLast too
			 * but doesn't cover the combination
			 * winByMixing and winByKnockLast!!
			 */


			//TO BE COMPLETED NEXT!!

//			int blackWinLoc = QuiRules.knockingPaths[0][0];//30
//			int whiteWinLoc = QuiRules.knockingPaths[1][0];//138
//			System.out.println("blackWinLoc is " + blackWinLoc);
//			System.out.println("whiteWinLoc is " + whiteWinLoc);

			for (int i = 0; i < 2; i++) {
				int ledgeNumber = (player + i) % 2;
				//test opponent's ledge first
				// a win on own ledge (his win!) is overriding
				int knockLoc = QuiRules.knockingPaths[ledgeNumber][0];
				boolean knockTowerWin = hasCompleteTower(knockLoc);
				int lastLoc = QuiRules.knockingPaths[ledgeNumber][3];
				boolean lastPieceWin = hasPieces(lastLoc);
				if (knockTowerWin){
					isWin = true;
					isEndOfLine = true;
					winLocation = knockLoc;
					winColour = (ledgeNumber + 1) % 2;
				}
				if (QuiRules.winByKnockingLast && lastPieceWin){
					isWin = true;
					isEndOfLine = true;
					winLocation = lastLoc;
					winColour = (ledgeNumber + 1) % 2;
				}
			}

			return isEndOfLine;



//			if (player == 0){ //in white's turn
//				//check for black win first:
//				if(hasCompleteTower(blackWinLoc)){//black has knocked all white sizes
//					//black win!
//					isWin = true;
//					isEndOfLine = true;
//					winLocation = blackWinLoc;
//					winColour = 1;
//
//				} else if(hasCompleteTower(whiteWinLoc)){//white has knocked all white sizes
//					//must use else if, otherwise white win will override!
//					//white win!
//					isWin = true;
//					isEndOfLine = true;
//					winLocation = whiteWinLoc;
//					winColour = 0;
//				}
//
//			} else {// in blacks turn
//				if(hasCompleteTower(whiteWinLoc)){//white has knocked all white sizes
//					//white win!
//					isWin = true;
//					isEndOfLine = true;
//					winLocation = whiteWinLoc;
//					winColour = 0;
//
//				} else if(hasCompleteTower(blackWinLoc)){//black has knocked all white sizes
//					//black win!
//					isWin = true;
//					isEndOfLine = true;
//					winLocation = blackWinLoc;
//					winColour = 1;
//				}
//
//
//			}



			//return?
		}


		if (QuiRules.ruleVersion > 1 && QuiRules.ruleVersion != 7) {
			/*
			 * TODO add winAhead loop! add a released piece a the time and
			 * retest! black to BQD and white piece to WQD
			 */




			for (int i = 0; i < 4; i++) {
				if (hasCompleteTower(QuiRules.whiteDiamonds[i])) {
					isWin = true;
					isEndOfLine = true;
					winLocation = QuiRules.whiteDiamonds[i];
					if (i < 2) {
						matchPhaseString = "White Win.";
						winColour = 0;// used for goldenRuleTest
					} else {
						matchPhaseString = "Black Win.";
						winColour = 1;
					}
					goldenRuleTest();
				}
			}
			// here look ahead for zeroPly winPosition:
			//this should maybe be done in space??
			byte whiteQuincalaDiamondSizes = stacks[85];
			byte blackQuincalaDiamondSizes = stacks[83];
			int releaseHandlesCount = ordrdReleaseHandlesArray.length;
			// only if length > 0!
			// System.out.println("releaseHandlesCount is " +
			// releaseHandlesCount);
			for (int k = 0; k < releaseHandlesCount; k++) {

				int nextColourToBeReleased = ordrdReleaseHandlesArray[k].colour;
				byte nextSizeToBeReleased = ordrdReleaseHandlesArray[k].activeSizes;
				// join it to appropriate tower!
				if (nextColourToBeReleased == 0) {// white
					whiteQuincalaDiamondSizes = joinGroups(
							whiteQuincalaDiamondSizes, nextSizeToBeReleased);
				} else {// black
					blackQuincalaDiamondSizes = joinGroups(
							blackQuincalaDiamondSizes, nextSizeToBeReleased);
					// System.out.println("blackQuincalaDiamondSizes is " +
					// blackQuincalaDiamondSizes);
				}

				if (whiteQuincalaDiamondSizes == QuiRules.towerByte) {
					isWinAhead = true;
					winLocationAhead = 85;//or simple winLocation??
					matchPhaseString = "White Win.";
					winColour = 0;// used for goldenRuleTest
//					System.out.println("isWinAhead is " + isWinAhead + " "
//							+ matchPhaseString);

					goldenRuleTest();
				} else if (blackQuincalaDiamondSizes == QuiRules.towerByte) {
					isWinAhead = true;
					winLocationAhead = 83;
					matchPhaseString = "Black Win.";
					winColour = 1;

//					System.out.println("isWinAhead is " + isWinAhead + "; "
//							+ matchPhaseString);

					goldenRuleTest();
				}

			}

		} else if (QuiRules.ruleVersion == 7) {
//			System.out.println("version 7 is reached");
			if (hasWhitePiece(QuiRules.whiteGoalDot)) {
				isWin = true;
				isEndOfLine = true;
				winLocation = QuiRules.whiteGoalDot;
				matchPhaseString = "White Win";
				winColour = 0;
			}

			if (hasBlackPiece(QuiRules.blackGoalDot)) {
				isWin = true;
				isEndOfLine = true;
				winLocation = QuiRules.blackGoalDot;
				matchPhaseString = "Black Win";
				winColour = 1;
			}
		}

		//TODO status bar text creation remove from state
		statusBarText = "Turn: " + turnNumber + ", " + matchPhaseString;
		// add releasing, placing, moving! Probably duplet type too late!
		// set from receiveEntry()!
		if (!isWin) {
			if (presentDupletType == L_PLACING) {
				statusBarText += " " + "Placing from ledge.";
			}
			if (presentDupletType == H_PLACING) {
				statusBarText += " " + "Placing from own home dot.";
			}
			if (presentDupletType == LEG) {
				statusBarText += " " + "Moving.";
			}
			if (presentDupletType == RELEASING) {
				statusBarText += " " + "Releasing.";
			}
		}

		if (passFlag == 0) {
			statusBarText += " (White passed)";
		}
		if (passFlag == 1) {
			statusBarText += " (Black passed)";
		}

		statusBarText = statusBarText + controlStatusText;
		// starts with space...

		// System.out.println("statusBarText is " + statusBarText);
		// for reference
		// private final int L_PLACING = 1;
		// private final int H_PLACING = 2;
		// private final int LEG = 3;
		// private final int KNOCKING = 4;
		// private final int END_LEG = 5;
		// private final int RELEASING = 6;

		if (isEndOfLine) {
//			System.out.print("END OF GAME: ");
//			System.out.println(matchPhaseString + "!");
		}

		return isEndOfLine;
	}

	public void goldenRuleTest() {//obsolete? test it in WholeLineData!
		if (goldenRuleFlag > -1) {
			if (goldenRuleFlag == winColour) {
				goldenRuleHolds = false;
				goldenRuleInfo = "Golden Rule failed.";
//				System.out.println("Golden Rule failed");
			} else {
				goldenRuleHolds = true;// obsolete??
				goldenRuleInfo = "Golden Rule holds.";
//				System.out.println("Golden Rule holds");
			}
		} else {
//			System.out.println("goldenRuleFlag is " + goldenRuleFlag);
			// for testing
		}
	}

	public boolean irreversibilityTest() {

		if(!QuiRules.irreversibility)//autopass if no IR!
			return true;

		// otherwise: irr check
		// System.out.println("irr check is reached");
		String iRmessage = "";// or global?
		boolean result = true;

		int offendingTurn = 0;
		String currentPosString = getIRPositionString(player);
//		 System.out.println("iR test! currentPosString is ");
//		 System.out.println(currentPosString);
		// should be getIRString(PLAYER)
		if (player == 0) {// White's turn
			int size = whiteIRHistory.size();
			for (int i = 0; i < size; i++) {
				String testString = (String) whiteIRHistory.get(i);

				// System.out.println(testString);
				if (testString.equals(currentPosString)) {
					result = false;
					controlPassInt++;
					offendingTurn = turnNumber - 2 * (i + 1);
					iRmessage = "end position same as turn " + offendingTurn;
					if (offendingTurn < 1) {
						offendingTurn += 2;
						iRmessage = "end position same as start position (turn "
								+ offendingTurn + ")";
					}
					break;
					//one match is enough - don't want to keep adding to controlPassInt
				}

			}

		} else {// copy over for black!! Hmmr better use of space?
			int size = blackIRHistory.size();
			for (int i = 0; i < size; i++) {
				String testString = (String) blackIRHistory.get(i);// (String)?
				// System.out.println(testString);
				if (testString.equals(currentPosString)) {
					result = false;
					controlPassInt++;
					offendingTurn = turnNumber - 2 * (i + 1);
					iRmessage = "end position same as turn " + offendingTurn;
					if (offendingTurn < 1) {
						offendingTurn += 2;
						iRmessage = "end position same as start position (turn "
								+ offendingTurn + ".)";
					}
				}
				break;
				//one match is enough - don't want to keep adding to controlPassInt

			}
		}

//		System.out.println(iRmessage);

		// mock tests:
		// if (hasPlainBlack(61))
		// result = false;
		// if (hasPlainWhite(150))
		// result = false;

		//if (!result)
//			System.out.print("MESSAGE: Irreversibility Rule is broken! ");

		return result;
	}

	public void addToIRHistory() {
		// this is temporary until migration!
		System.out.println("addToIRHistory is run");
		if (player == 0) {
			whiteIRHistory.add(0, getIRPositionString(0));
		} else {
			blackIRHistory.add(0, getIRPositionString(1));
		}

	}

	// public String getOneColourPositionString(int colourInt){
	// String posString = "";
	//
	// for (int p = 1; p < towerByte; p*=2){
	// for (int i = 0; i < 169; i++){
	// int loc = i;
	// if (pieceIsAtLocation(p, colourInt, loc)){
	// posString += locToHexCharString(loc);
	// }
	// }
	// }
	// System.out.println("posString is:");
	// System.out.println(posString);
	// return posString;
	// }

	public String getIRPositionString(int colourInt) {
		/*
		 * this assumes the ledges are not changed kind of optimised by just
		 * skipping side ledges properly, should test every i for isDiamond
		 * instead of skipping ...
		 */
		String posString = "";
		String ledgePosString = "";
		if (colourInt == 0) {
			ledgePosString = "4c";
		} else {
			ledgePosString = "80";
		}
		int ledgeIndex = (colourInt + 1) % 2;// near Black in Whites turn ...
		int size = QuiRules.ledges[colourInt].length;
		// System.out.println("size is " + size);
		for (int p = 1; p < QuiRules.towerByte; p *= 2) {
			for (int l = 0; l < size; l++) {// l for ledge
				// this searches away from the centre
				// alt use for(int l = size - 1; l>=0;l--)?
				// but should not matter?
				// System.out.println("ledges[ledgeIndex][l] is " +
				// ledges[ledgeIndex][l]);
				if (pieceIsAtLocation(p, colourInt, QuiRules.ledges[ledgeIndex][l])) {
					posString += ledgePosString;
				}
			}
			for (int i = 6; i < 163; i++) {
				// not looking at primary ledge ...
				// ...nor side ledges:
				if (i == 13 || i == 26 || i == 39 || i == 129 || i == 142
						|| i == 155)
					continue;// skips the side ledge dots
				int loc = i;
				if (pieceIsAtLocation(p, colourInt, loc)) {
					posString += QSFUtils.locToHexCharString(loc);
				}
			}
		}
		// System.out.println("posString is:");
		// System.out.println(posString);
		return posString;
	}

	public boolean freedomTest() {
		// freedom check
		// System.out.println("freedom check is reached");
		if(!QuiRules.freedomRule)
			return true;
		//if no freedome rule, then pass every time!

		boolean blackFreedom = false;
		byte blackFreedomByte = 0;
		for (int i = 0; i < 169; i++) {
			if (hasPlainBlack(i) && isBlackDot(i)) {
				blackFreedomByte = joinGroups(blackFreedomByte, stacks[i]);
				if (blackFreedomByte == QuiRules.towerByte) {
					blackFreedom = true;
					// System.out.println("Black freedom achieved on " + i);
					break;
				}
			}
		}
		boolean whiteFreedom = false;
		byte whiteFreedomByte = 0;
		for (int i = 168; i >= 0; i--) {
			if (hasPlainWhite(i) && isBlackDot(i)) {
				whiteFreedomByte = joinGroups(whiteFreedomByte, stacks[i]);
				if (whiteFreedomByte == QuiRules.towerByte) {
					whiteFreedom = true;
					// System.out.println("White freedom achieved on " + i);
					break;
				}
			}
		}

		boolean result = blackFreedom && whiteFreedom; // && whiteFreedom

		if (!result){
//			System.out.println("MESSAGE: Freedom Rule is broken! ");
			controlPassInt += 2;
		}
		return result;
	}

	public String getSimplePositionString() {
		/*
		 * this will create a string that defines the current position
		 */
		String simplePositionString = "";
		// white pieces first - "backwards"

		// for (int p = 1; p < towerByte; p*=2){
		// for (int y = 0; y < 13; y++){
		// for (int x = 0; x < 13; x++){
		// int loc = 168 - y * 13 - x;
		// if (pieceIsAtLocation(p, 0, loc)){
		// simplePositionString += ""
		// + hexMap[x] + hexMap[y];
		// }
		// }
		// }
		// }
		// //then black pieces
		// for (int p = 1; p < towerByte; p*=2){
		// for (int y = 0; y < 13; y++){
		// for (int x = 0; x < 13; x++){
		// int loc = y * 13 + x;
		// if (pieceIsAtLocation(p, 1, loc)){
		// simplePositionString += ""
		// + hexMap[x] + hexMap[y];
		// }
		// }
		// }
		// }

		// TODO this is Buggy!!!

		// white pieces first - "backwards"
		for (int p = 1; p < QuiRules.towerByte; p *= 2) {
			for (int i = 0; i < 169; i++) {
				int loc = 168 - i;
				if (pieceIsAtLocation(p, 0, loc)) {
					simplePositionString += QSFUtils.locToHexCharString(i);
					// lower int is stored in string!
				}
			}
		}
		// then black pieces
		for (int p = 1; p < QuiRules.towerByte; p *= 2) {
			for (int i = 0; i < 169; i++) {
				int loc = i;
				if (pieceIsAtLocation(p, 1, loc)) {
					simplePositionString += QSFUtils.locToHexCharString(loc);
				}

			}
		}

		// System.out.println("simplePositionString is " +
		// simplePositionString);
		return simplePositionString;
	}

	public void setPositionFromString(String quPositionString) {
		/*
		 * this will set the position according to the sent string
		 */

//		System.out.println("!!Loaded by strings");

		resetGameState();

		stacks = new byte[169];
		blackPieces = new byte[169];
		int readIndex = 0;
		int numSizes = quPositionString.length() / 16;
		setTowerByte(numSizes);//obsolete but IRHistory!!
		// write black first, as if white ...
		for (byte p = 1; p < QuiRules.towerByte; p *= 2) {
			for (int n = 0; n < 4; n++) { // four of each size!
				char xChar = quPositionString.charAt(readIndex);
				char yChar = quPositionString.charAt(readIndex + 1);
				int loc = 168 - QSFUtils.hexCharsToLoc(xChar, yChar);
				stacks[loc] += p; // works since no knocking!
				readIndex += 2;
			}
		}
		for (byte p = 1; p < QuiRules.towerByte; p *= 2) {
			for (int n = 0; n < 4; n++) { // four of each size!
				char xChar = quPositionString.charAt(readIndex);
				char yChar = quPositionString.charAt(readIndex + 1);
				int loc = QSFUtils.hexCharsToLoc(xChar, yChar);
				stacks[loc] += p;
				blackPieces[loc] += p;
				readIndex += 2;
			}
		}
	}

	public void resetGameState() {// should be private?
		/*
		 * this to be called whenever a new position string or array is received
		 */
		deSelectAllPieces();// maybe do these ones explicit?
		clearReleasedPieces();
		// zeroPlyString = "";
		locString = "";
		plyString = "";
		activeLocation = 169;
		presentDupletType = 0;
		player = 0;
		firstPlayer = 0;
		isWin = false;
		matchPhaseString = "";
		statusBarText = "";
		goldenRuleFlag = -1;
		goldenRuleInfo = "";
		winLocation = 169;
		// add these when data available!
		// setTowerByte(numSizes);
		// initMatchString(presentRuleVersion, numSizes);
	}

	public void resetAllowBooleans() {
		mayMove = false;
		isMoving = false;
		mayPlaceLedge = false;
		mayPlaceHome = false;
		// mayRelease = false;
		mayPass = false;
	}

	// HERE STARTS NEW GEN METHODS

	public void initGameState() {

		//get starting position from QuiRules:
		setStacks(QuiRules.startStacks);
		setBlackPieces(QuiRules.startBlackPieces);


		// must come after ledges definition:
		initMatchString(QuiRules.ruleVersion, QuiRules.numSizes);
		//TODO initMatchString is not using ascii rule alias
		//not used any longer??

		//also evaluate the starting position:
		evaluatePosition(0);
	}

	public void addToLocString(String addition) {
		// this is transitional; once full engine just add to the
		// string directly in receiveEntry()
		locString += addition;
		controlStatusText = "";
		hasBeenRewound = false;
	}



	// HERE STARTS IMMIGRATION OF ENGINE METHODS

	public void receiveLocString(String locString){


		int length = locString.length();
		int[] plyArray = new int[length/2]; //since each loc has two coords
		for (int i = 0; i < length/2; i++){
			char hexChar1 = locString.charAt(i*2);
			char hexChar2 = locString.charAt(i*2 + 1);
			//here make alexian out of hexChars
			plyArray[i] = QSFUtils.hexCharsToLoc(hexChar1, hexChar2);
			}
		receiveLocArray(plyArray);
	}

	public void receiveLocChars(char xChar, char yChar){
		//not used yet?
		/*
		 * incorporate this in receiveLocString() above?
		 */
		receiveLoc(QSFUtils.hexCharsToLoc(xChar, yChar));
	}

	public void receiveLocArray(int[] p, boolean brake) {
		/*
		 * overloaded; brake is true by default!
		 */
		receiveLocArray(p);
		if (!brake){//no brake means release all
//			System.out.println("completing releasing!!");
			completeZeroPlyMoves();

		}
	}


	public void receiveLocArray(int[] p) {
		int length = p.length;
		for (int i = 0; i < length; i++) {
			receiveLoc(p[i]);
		}
	}

	public void receiveLoc(int loc, boolean brake){
		/*
		 * overloaded; brake is true by default!
		 */
		receiveLoc(loc);
		if (!brake)//no brake means release all
			completeZeroPlyMoves();

	}

	public void completeZeroPlyMoves(){
		while (zeroPlyDestination > 0){
			receiveLoc(zeroPlyDestination);
		}
		//for experiment
//		if (freedomTest() && irreversibilityTest()) { // passed!
//			// space.setConfirmedPlyCount(currentState.plyCount);
//			setFailedControlTest(false);
//		}

	}

	public void receiveLoc(int loc) {

		/*
		 * TODO optimise this by creating a parallel system of receiveLocVIP,
		 * evaluatePositionVIP, receiveLocArrayVIP etc without checking if
		 * entries are legal or bothering about using options until the last loc
		 * in a list ... This involves copying and pasting, so is to be done
		 * after the original methods thoroghly tested for all rules!
		 */

		// first check if entry is legal at this time
		if (!isValidEntry(loc))
			return;

		// here add to locString in GameLine
		addToLocString(QSFUtils.locToHexCharString(loc));
		//also add one to turnLocCount
		turnLocCount++;

		// then if is just a click on the turn indicator
		// (only allowed in version 0) NO: also if zero move allowed!
		if (QRules.isPosEdit && loc == 84) {// not pass: with rules 84 is pass see below
		// //here reset bouncingDirectionUnit
		// bouncingDirectionUnit = 0;
			// NO; only needed if bouncingRule is true in posEdit!

			switchPlayer();
			// player = currentState.player;//migr: delete line
			// empty the duplet of moving content:
			active.fillOrigFields(loc, (byte) 0);
			active.setTypeAndPlyValue(END_LEG, 1);
			setPresentDupletType(END_LEG);
			// also to prune off previous entry??
			// return;
		}

		// then add to proposed history - do leg pruning ...
		// testing to output location in Human:
		// String hum = translator.humanLoc[loc];
		if (presentDupletType != 6 && !QRules.isPosEdit) { // exclude manual releasing
													// clicks ...

//			System.out.println("QFormulas.locToHexCharString(loc) is " + QFormulas.locToHexCharString(loc));
			addToPlyString(QSFUtils.locToHexCharString(loc));
			// System.out.println();
		} else {
			// System.out.println("human notation of entered (release)
			// destination is "
			// + hum);
			// System.out.println();
		}

		//here take resign ones
		if (loc == 972 || loc == 973){
			isEndOfLine = true;
			resignInt = loc - 972;
			evaluatePosition(loc);
			return;
		}

		//here take Draws by agreement
		if (loc == 988){
			isEndOfLine = true;
			resignInt = 2;//make -2!
			evaluatePosition(loc);
			return;
		}


		if (active.origLoc == 0) { // = duplet is empty

			// NOTE: this only works because there will never
			// be a piece on location 0
			// More correct if (active.dupletType == EMPTY)
			//do -1!!

			if (QRules.isPosEdit) { // only if duplet is empty ...
				if (hasPlainBlack(loc) && (player == 0)) {
					switchPlayer();
				}
				if (hasPlainWhite(loc) && (player == 1)) {
					switchPlayer();
				}
			}

			// reset passFlag here?
			passFlag = -1; // unless pass is entered
			if (loc == 84 || loc == 1001) {
				//TODO remove 84; look into legality checks for pass?
				//lpeanty of 84s below!!


				// 84 is pass by turn-indicator click or button
				// 1001 is pass by entering rt
				/*
				 * bit convoluted ... try this and then optimise ... more
				 * elegant would be to start a duplet before if active.origLoc ==
				 * 0; it then slots in as end leg!
				 */
				passFlag = player;

				active.fillOrigFields(84, (byte) 0);
				// empty the duplet - needed?
				active.setTypeAndPlyValue(END_LEG, 1);
				setPresentDupletType(END_LEG);

				noActiveLocation(); // work out these!
				// deselect all pieces
				deSelectAllPieces();
				// fill it with origin info
				active.fillDestField(84);
				// now fill the ListArray activeList - no need for index since
				// it should be empty...
				activeList.add(active);

				performDupletList(activeList);
				active = new QDuplet(); // make a new duplets object! - or
										// inside makeSelections()?
				// finally empty the ArrayList activeList:
				activeList = new ArrayList(); // or always set new in the
												// beginning?

				if (QuiRules.drawByConsecutivePass && justPassedFlag){
					//two consecutive passes!!
					isEndOfLine = true;
					resignInt = 3;//make -3!
				}
				justPassedFlag = true;

				// Now see if there is some extra selections to do:
				evaluatePosition(84);
				return;
			} else {
				justPassedFlag = false;
			}

			if (loc == homedot || isLedge(loc)) {
				// ledge will only reach here in posEdit ...
				// should be white dot or isLedge ... for posEdit!
				startActiveDuplet(loc, LARGEST_PIECE);
				active.setTypeAndPlyValue(H_PLACING, 2); // incl choice
				setPresentDupletType(H_PLACING);
				// in posEdit??
				allowEmptyPlacingDots(player);
				allowOwnHomeDot(player);

			} else {
				startActiveDuplet(loc, ALL_OWN_PIECES);
				active.setTypeAndPlyValue(LEG, 2);// first leg

				setPresentDupletType(LEG);
				allowLegs(loc, active.activeSizes);
				allowSameLoc(loc);
			}

			if (QRules.isPosEdit) {
				allowAllOptions();
			}

		} else {
			/*
			 * this is the filling phase of the duplets
			 */

			// first see if same location has been chosen
			if (active.origLoc == loc) {
				if (active.plyValue == 1) { // =end of move
					// here reset bouncingDirectionUnit
					bouncingDirectionUnit = 0;
					// part of database etc ...
					active.fillOrigFields(loc, (byte) 0); // empty the duplet
					active.setTypeAndPlyValue(END_LEG, 1);
					setPresentDupletType(END_LEG);
				}
				if (active.plyValue == 2) { // = re-start of leg or placing?
					//also if origin is ledge? -
					//no, will not pass validity test for diamond!
					active = new QDuplet(); // delete start values
					// TODO remove last 4 chars in locString and plyString;
					// update posInts
					setDoCropTrue();// hoping ints will be updated accordingly ...
					turnLocCount -= 2; //since second click has added already!
					//maybe back to beginning of turn ...
					//System.out.println("turnLocCount is" + turnLocCount);
					// allow own plain and homedot if homedot placing used
					allowOwnPlain(player);
					if (hasPieces(homedot) && QuiRules.homePlacing)
						allowOwnHomeDot(player);
				}
			}

			if (active.dupletType == L_PLACING)
				passFlag = -1;
			// only case in which first action after
			// a pass move is not creating a new duplet?

			// getting past this means that a placing or a leg has been
			// fulfilled

			noActiveLocation(); // work out these!
			// deselect all pieces
			deSelectAllPieces();
			// fill it with origin info
			active.fillDestField(loc);
			// HERE CHECK IF BOUNCING HAS BEEN FULFILLED
			if (isBouncingLeg(loc))// need bouncingRule check?
				active.setBouncingStackActive();

			// now fill the ListArray activeList - no need for index since it
			// should be empty...
			activeList.add(active);

			// here see if active is a releasing duplet, then delete the handle!
			if (active.dupletType == RELEASING) {
				ordrdReleaseHandles.remove(0); // first element
				// take care of any "double agents",
				// i.e. releasing handles pointing to the same released piece
				// tested for triple agent:
				// qui356061615748486463626161bbaa9988886143436c6b6b3344446b6a6a43252636
				if (ordrdReleaseHandles.size() > 0) {
					// always removed exactly one ... => array is + 1
					int firstLoc = ordrdReleaseHandlesArray[0].destLoc;
					int firstSize = ordrdReleaseHandlesArray[0].activeSizes;
					for (int i = 1; i < ordrdReleaseHandlesArray.length; i++) {
						int nextLoc = ordrdReleaseHandlesArray[i].destLoc;
						int nextSize = ordrdReleaseHandlesArray[i].activeSizes;
						if ((firstLoc == nextLoc) && (firstSize == nextSize))
							ordrdReleaseHandles.remove(0);
					}
				}

				// now update array again
				ordrdReleaseHandlesArray = (QDuplet[]) ordrdReleaseHandles
						.toArray(new QDuplet[ordrdReleaseHandles.size()]);
				// orderedReleaseHandles = ReleaseHandles.toArray( new
				// QDuplet[ReleaseHandles.size()] );//codebase 5.0 +

			}

			// now investigate if knocked pieces ;

			byte knockedPieces = extractKnockedPieces(active.activeSizes,
					stacks[loc]);
			if ((knockedPieces & noKnockPieces[loc]) > 0){
				System.out.println("IMMUNITY RULE BROKEN!");
				failedControlTest = true;
				controlPassInt += 4;
//				if (buildLocString) {// quick fix?? migrate??
//					setInitialRetrace(true);
//					// initialRetrace = true;
//				}
			}
			//System.out.println("knockedPieces is " + knockedPieces);
			if (knockedPieces > 0) {
				byte oldBlacks = blackPieces[loc];
//				if(immunityRule){
				if(QuiRules.immunity){
					//System.out.println("immunity piece loc is " + loc);
					//TODO TEST!!!
					//here filter out knocked pieces knocked by opponent!
					int blackKnockers = knockedPieces & blackPieces[active.origLoc];
					int knockedBlacks = knockedPieces & blackPieces[loc];
					int immuneKnockers = (blackKnockers ^ knockedBlacks);//xor is ^
					noKnockPieces[loc] = (byte )(noKnockPieces[loc] | immuneKnockers);//add
					noKnockPiecesToBe[loc] = (byte )(noKnockPiecesToBe[loc] | immuneKnockers);
					//for next turn ...
					//System.out.println("immunePiecesToBe[" + loc + "] is " + immunePiecesToBe[loc]);
				}



			// System.out.println(countBits(knockedPieces) +
				// " number of pieces are knocked");


				for (byte k = 16; k > 0; k /= 2) {
					// looping thru all potential sizes
					// downwards since FILO
					if (isPresent(k, knockedPieces)) {
						active = new QDuplet();
						int colour = pieceColour(k, oldBlacks);
						// System.out.println("new: the knocked piece is of
						// colour " + colour + " and of size " + k);
						int destination = destinationLocKnocking(k, colour);
						active.fillOrigFields(loc, k);
						active.setTypeAndPlyValue(KNOCKING, 0);
						// don't set present duplet type ...
						active.fillDestField(destination);
						activeList.add(0, active); // FILO
					}
				}
			}
			// perform duplet/s
			// performActionList(listSize);
			performDupletList(activeList);
			active = new QDuplet(); // make a new duplets object! - or inside
									// makeSelections()?
			// finally empty the ArrayList activeList:
			activeList = new ArrayList(); // or always set new in the
											// beginning?
			// Now see if there is some extra selections to do:
			evaluatePosition(loc);
		}
	}

	public void winStop(){
		zeroPlyDestination = 0;//not the culprit!
		ReleaseHandles = new ArrayList();
		ordrdReleaseHandles = new ArrayList();
		ordrdReleaseHandlesArray = new QDuplet[0];
		clearReleasedPieces();
		resetDuplets();
		resetAllowBooleans();
		doReleasing = false;
		pieceSelections = new byte[169];
		options = new boolean[169];// clear options
		noKnockPiecesToBe = new byte[169];//experimental knocking rule
		noKnockPieces = new byte[169];
		immortalPieces = new byte[169];
	}

	public void evaluatePosition(int loc) {// state; build loc string??
		/*
		 * this drives the game forward by auto selecting locations that are no
		 * choice for the player and moves the game on "break" or "return" means "
		 * wait for user entry (or database entry!) it runs at the beginning of
		 * each turn and after fulfilling a duplet(list)
		 */
		// int cLoc = current.activeLocation; //doesn't work!!
		// System.out.println("cLoc is " + cLoc);
		// System.out.println("loc is " + loc);
		/*
		 * trying to find a way to operate this without being sent the loc; to
		 * enable a position being loaded and evaluated directly! TODO re-read
		 * player?
		 */

		// int presentType = presentDupletType; //new, taking over from
		// int tState = current.turnState; //soon obsolete


		// first of all check for Win! At the end too??
		// if (currentState.winTest())
		// return;
		if (endOfLineTest()) {
//			System.out.println("WINSTOP");
			winStop();
			return;
		}

		byte newStack = stacks[loc];
		byte newBlacks = blackPieces[loc];

		// this will be reached only after duplets are performed

		// new switch
		switch (presentDupletType) {// presentDupletType in state!

		case 2: // H_PLACING
			if (hasPieces(homedot)) { // still
				startActiveDuplet(homedot, LARGEST_PIECE);
				active.setTypeAndPlyValue(H_PLACING, 1);
				setPresentDupletType(H_PLACING);
				allowEmptyPlacingDots(player);
			} else { // finished h_placing
				allowOwnPlain(player);
			}
			break;

		case 3: // LEG
			byte sowers = sowingGroup(player, newStack, newBlacks);
			// System.out.println("sowers is " + sowers);
			if (sowers > 0 || (QuiRules.bouncing && (bouncingDirectionUnit != 0))) {
				// leg can continue if bottom piece to leave or if bouncing
				// possible
				// optimise? bouncingDirUnit is always 0 unless bouncingRule!
				startActiveDuplet(loc, SOWERS); // this is used!!
				// ~O send sowers etc instead
				active.setTypeAndPlyValue(LEG, 1);
				if (bouncingDirectionUnit != 0) {// implies bouncingRule!
					byte ownPieces = allOwnPieces(player, newStack, newBlacks);
					active.setBouncingStack(ownPieces);
				}

				setPresentDupletType(LEG);
				allowLegs(loc, active.activeSizes);
				allowSameLoc(loc);
				break;// =not yet end of move!
			}
			// else fall-through
		case 5: // END_LEG - morph into turnPhase 3 with empty duplet!
			if (QRules.isPosEdit) {
				loc = 0;
				break; // loc still has pieces ...
			}
//			HERE test for win in the mixing game
			if (QuiRules.winByMixingAllOwnSizes){
				if (mixingGameWinTest()){
					winStop();
					return;
				}
			}
			// no releasing for posEdit!
			if (QuiRules.releasing)
				findReleased();

			// fall-through
		case 6: // RELEASING
			// System.out.println("doReleasing is " + doReleasing);
			if (doReleasing) {
				releasePieces();
			}


			// HERE starts the controlPoint testing
			if (!doReleasing) { // "else" doesn't work!!
				// need to re test since releasePieces changes doReleasing!!!

//				since each fail must be counted into the controlPassInt!
				//boolean noImmunityBreak = (controlPassInt == 0);
				boolean freePass = freedomTest();
				boolean IRPass = irreversibilityTest();
				if (freePass && IRPass && !failedControlTest) {
					/*
					 * passed all three! - just not to set confirmedPlyString
					 * if knocking an immune piece would have happened before!
					 */



					//System.out.println("EvalPass.controlPassInt is " + controlPassInt);
					// space.setConfirmedPlyCount(currentState.plyCount);
					//setFailedControlTest(false);
					//is there ever a need to reset this one?
					//controlPassInt = 0;//always new state when rewind!
					// keep these in state!!
					setConfirmedPlyCount();
					//setConfirmedLocPos();


					confirmedLocPos = locString.length();
					if(QuiRules.irreversibility)
						addToIRHistory();
					// after migration can do this directly ...

				} else {
					setFailedControlTest(true);//this is already true if immunity break!

					//System.out.println("EvalFail.controlPassInt is " + controlPassInt);


//					if (buildLocString) {// quick fix?? migrate??
//						setInitialRetrace(true);
//						// initialRetrace = true;
//					}
//					System.out.println("The entire turn is retraced! ");


					//hmmr what is this doing???
					boolean restarting = false;
					if (turnNumber < 3)// ??
						restarting = true;

					if (restarting) {
						// presentType = currentState.presentDupletType;
						break;// ie don't switch turns before set
								// presentType...
					}
					break;// actually dont switch turns at all!!

				}
				switchTurns();
				// presentType = currentState.presentDupletType;
			}

			break;

		default: // L_PLACING AND INIT
			break;
		}

		if (QRules.isPosEdit) {
			if (hasPieces(loc)) {
				allowAllOptions();
			} else {
				allowAnyPieceAndPass(loc);
			}

		} else if (presentDupletType < 2) {
			allowOwnPlain(player);
			if (hasPieces(homedot) && QuiRules.homePlacing)
				allowOwnHomeDot(player);
			if (!QRules.isPosEdit && QuiRules.ledgePlacing)
//			if (!posEdit) // unnecessary in this structure
				checkLedge();
		}

	}

	public void switchTurns() {
		/*
		 * migrate to state player and homedot used by space? shouldn't ...
		 */

		if (QRules.isPosEdit) {
			switchPlayer();

		} else {
			newTurn();
			// if (releasing)
			// doFindReleased = true;
			homedot = ownHomeDot(player);// ~O?

		}

//		System.out.println();
//		System.out.println("NEW TURN; number " + turnNumber);
	}

	public void checkLedge() {// state
		/*
		 * this checks for pieces on the ledge; if found it starts the duplets
		 * for them! this was previously at the beginning of autoAction
		 */

		// System.out.println("checkLedge() is run");
		// boolean ledgeIsEmpty = true; //until proven otherwise ...
		// doCheckLedge = false; //until proven otherwise ...
		int sizeMask = 1;
		for (int sizeOrd = 0; sizeOrd < QuiRules.numSizes; sizeOrd++) {
			/*
			 * loop on ordinals to enable free placing order by means of array -
			 * ordinal is index.
			 */
			int colour = 0;
			for (int c = 0; c < 2; c++) {
				colour = (c + player + 1) % 2; // for other player's pieces
												// first
				// colour = (c + player) % 2; //for own pieces first ...
				// System.out.println(sizeOrd + " " + sizeMask + " " + colour);
				for (int i = 6; i >= 0; i--) {
					int ledgeloc = QuiRules.ledges[player][i];
					if (pieceIsAtLocation(sizeMask, colour, ledgeloc)) {
						// System.out.println("loc " + ledgeloc + " has "
						// + sizeMask + " " + colour);
						// doCheckLedge = true; //keep checking!
						startActiveDuplet(ledgeloc, LARGEST_PIECE);
						active.setTypeAndPlyValue(L_PLACING, 1);
						setPresentDupletType(L_PLACING);
						allowEmptyPlacingDots(player);
						return; // breaking all loops - use break; to find all
					}
				}
			}
			sizeMask *= 2;
		}
	}

	public void findReleased() {// state; line...
		/**
		 * this identifies all released pieces on the board; initially only for
		 * simple leg releasing (so not Game 5!)
		 */

		// first reset the releasing counter
		// currentLine.setReleaseCount(0);//obsolete or statistics?
		// how far to look for releasing agent
		int maxPotential = QuiRules.numSizes;

		// local array list to catch the releasing handles
		// will be put into order in orderedReleaseHandles
		ReleaseHandles = new ArrayList();

		// find mixed groups:
		for (int rloc = 0; rloc < 169; rloc++) {
			if (hasMixedGroup(rloc) && isBlackDot(rloc)) {
				// condition of black dot, otherwise release pieces on home dot!
				// System.out.println("mixed group on " + rloc);
				int dirMask = 1;
				byte mixedGroupSizes = stacks[rloc];
				for (int y = -1; y < 2; y++) {
					for (int x = -1; x < 2; x++) {
						if (x == 0 && y == 0)
							x = 1; // to skip the middle square; try skip; ?
						int locDiff = x + y * 13;
						int potential = maxPotential;
						int evalLoc = rloc;
						int stepCount = 0;
						while (potential > 0) {
							if (isBlockedDirection(dirMask, evalLoc))
								break;
							evalLoc += locDiff;
							stepCount++;
							if (hasPieces(evalLoc)) {
								potential = 0;
								if (hasPlainGroup(evalLoc)) {
									byte agent = stacks[evalLoc];
									int agentHeight = countBits(agent);
									if (agentHeight >= stepCount
											|| !QuiRules.leglimit) {
										byte releasedPieces = extractKnockedPieces(
												agent, mixedGroupSizes);
										if (releasedPieces > 0) {
											addReleasedPiece(rloc,
													releasedPieces);
											doReleasing = true; // found
																// released
																// piece!
											// releasing handles:
											int releasedHeight = countBits(releasedPieces);
											for (int i = 0; i < releasedHeight; i++) {
												int releasedPiece = largestSize(releasedPieces);
												releasedPieces = removeFromByte(
														(byte) releasedPiece,
														releasedPieces);
												QDuplet relHandle = new QDuplet();
												relHandle.fillOrigFields(
														evalLoc,
														(byte) releasedPiece);
												// int relColour =
												// currentState.getColour(loc,
												// size)
												if (pieceIsAtLocation(
														releasedPiece, 0, rloc)) {
													relHandle
															.setReleasedPieceColour(0);
												} else {
													relHandle
															.setReleasedPieceColour(1);
												}
												// is all from one agent!
												relHandle.fillDestField(rloc);
												ReleaseHandles.add(relHandle);
											}

											// find destination
											// add allow instead of test above
										}
									}
								}
							} else if (QuiRules.leglimit) {
								potential--;
							}
						}
						dirMask *= 2;
					}
				}
			}
		}
		int releaseHandlesCount = ReleaseHandles.size();
		if (releaseHandlesCount > 0) {
			// test output
			// releasing test
			// qui355544447788882233442626
			// for (int i = 0; i < ReleaseHandles.size(); i++){
			// QDuplet testDuplet = (QDuplet) ReleaseHandles.get(i);
			// System.out.println("origLoc is " + testDuplet.origLoc);
			// System.out.println("destLoc is " + testDuplet.destLoc);
			// System.out.println("activeSizes is " + testDuplet.activeSizes);
			// System.out.println("colour is " + testDuplet.colour);
			// }

			ordrdReleaseHandles = new ArrayList();
			// empty it even if no new release? = move it up

			// QDuplet[] relHArray = (QDuplet[])ReleaseHandles.toArray(new
			// QDuplet[releaseHandlesCount]);
			// with generics: QDuplet[] relHArray = ReleaseHandles.toArray( new
			// QDuplet[releaseHandlesCount] );
			// orderedReleaseHandles = new QDuplet[releaseHandlesCount];

			// sort method:
			// orderedReleaseHandles = new QDuplet[releaseHandlesCount];
			int colour = 0;
			int fillIndex = 0;
			// currentState.setZeroPlyString("");//reset here and everywhere ...
			// obsolete: only one at the time!
			for (int c = 1; c < 3; c++) {
				colour = ((player + c) % 2); // other player's colour first
				for (byte size = 1; size < 17; size *= 2) {// to int in new
															// generation ...
					for (int i = 0; i < releaseHandlesCount; i++) {
						QDuplet testDuplet = (QDuplet) ReleaseHandles.get(i);
						if (testDuplet.activeSizes == size
								&& testDuplet.colour == colour) { // and of
																	// player's
																	// colour!!
							ordrdReleaseHandles.add(fillIndex, ReleaseHandles
									.get(i));
							fillIndex++;
						}
					}
				}
			}
			ordrdReleaseHandlesArray = (QDuplet[]) ordrdReleaseHandles
					.toArray(new QDuplet[releaseHandlesCount]);
			// winTest();//testing!
		}

		// after if releaseHandlescount > 0:

	}

	public void releasePieces() {// state
		/**
		 * this looks for the next released piece according to the order of
		 * releasing and either moves it there or sets up half a duplet,
		 * requiring the destination to be entered by click or CD button step
		 */
		doReleasing = false; // until proven otherwise
		// currentLine.setReleaseDestination(0);//reset! keep until controller
		zeroPlyDestination = 0;
		// currentState.setZeroPlyString("");//probably not necessary since
		// fetcher?
		updateReleasedPieces(); // ~O remove last released piece
		/*
		 * TODO replace the following with just reading off the array with
		 * released pieces ... I think doReleasing is not necessary then??
		 *
		 */

		int colour = 0;
		for (int c = 1; c < 3; c++) {
			colour = ((player + c) % 2); // other player's colour first
			for (byte size = 1; size < 17; size *= 2) { // large pieces first
				for (int rloc = 0; rloc < 169; rloc++) {
					if (pieceIsInReleasedPieces(size, colour, rloc)) {
						active.fillOrigFields(rloc, size);
						active.setTypeAndPlyValue(RELEASING, 0);
						setPresentDupletType(RELEASING);
						int destLoc = destinationLocReleasing(size, colour);
						if (size == 8 && QuiRules.numSizes == 5)// only for 5 sizes!
							setGoldeRuleFlag(colour);
						// maybe golden rule for 4 sizes is size == 4 and for
						// 3:2?
						doReleasing = true;
						selectSomePieces(rloc, size);

						options = new boolean[169];
						options[destLoc] = true;
						// currentLine.setReleaseDestination(destLoc);
						// TODO put release Dest as int in this?
						zeroPlyDestination = destLoc;
						// store release destination as a string to add to the
						// line
						// currentState.setZeroPlyString(locToHexCharString(destLoc));
						// this is obsolete, since only one loc is added at the
						// time ...
						// currentState.addToZeroPlyString(locToHexCharString(destLoc));
						return;

					}
				}
			}
		}
	}

	public void startActiveDuplet(int loc, int selectionType) {// to state
		// int tPhase = current.turnPhase;
		byte newStack = stacks[loc];
		byte newBlacks = blackPieces[loc];

		// select square
		selectUserSquare(loc);
		// select pieces for now depending on turnphase

		deSelectAllPieces();

		switch (selectionType) {
		case 0: // LARGEST_PIECE
			byte largest = (byte) largestSize(newStack);
			selectSomePieces(loc, largest);
			break;
		case 1: // ALL_PIECES
			byte ownPieces = allOwnPieces(player, newStack, newBlacks);
			selectSomePieces(loc, ownPieces);

			// current.selectAllPieces(loc);
			break;
		case 2: // SOWERS
			// byte newBlacks = current.blackPieces[loc];
			byte sowers = sowingGroup(player, newStack, newBlacks);
			selectSomePieces(loc, sowers);
			break;
		}
		// finally fill the duplet with origin info
		active.fillOrigFields(loc, pieceSelections[loc]);
	}

	public boolean isValidEntry(int loc) { // state
		// simple test for now - replace by comparing with options[loc]!
		// not sure to keep this one - incorporate into main methods?

		boolean result = false;

		if (loc > 168){//off the board ply

			//only r0-r1, rg (draw by agreement) rt (pass) allowed so far
			int[] validOffBoardLoc = {972, 973, 988, 1001};

			ArrayList<Integer> vobl = QRules.validOffBoardLocs;


//			//code base < 5.0:
//			int length = validOffBoardLoc.length;
//			for (int i = 0; i < length; i++){
//				if (loc == validOffBoardLoc[i]) {
//					result = true;
//				}
//
//			}

//			//code base 5.0 +
//			//Do test it!! with all off the board plies and invalid
//			//off the board
			for (int validLoc : vobl){
				if (loc == validLoc) result = true;
			}


		} else {//on the board ply or loc
			if (options[loc] || disObeyOptions) {
				// first is rules.options[loc] ...
				result = true;
			} else {
				hasIllegalPlies = true;
				//actually; this needs to be stored in Space after the first run!
				// send error message!
				// TODO the one below is triggered when CD buttons are pressed!
				// System.out.println("MESSAGE: entry is not a legal option!");
			}
		}





		return result;
	}

	public int destinationLocKnocking(int pieceSize, int pieceColour) {// state
		int tryLoc = 0;
		for (int i = 0; i < 7; i++) {
			int pathIndex = pathIndex(player, pieceColour);
			tryLoc = QuiRules.knockingPaths[pathIndex][i];
			byte oldContent = stacks[tryLoc];
			if (!isPresent(pieceSize, oldContent)) {
				break;
			}
		}
		return tryLoc;
	}

	public int destinationLocReleasing(int pieceSize, int pieceColour) {// state
		int tryLoc = 0;
		for (int i = 0; i < 7; i++) {
			int pathIndex = pathIndex(player, pieceColour);
			tryLoc = QuiRules.releasingPaths[pathIndex][i];
			byte oldContent = stacks[tryLoc];
			if (!isPresent(pieceSize, oldContent)) {
				zeroPlyDestIndex = i;
				break;
			}
		}
		return tryLoc;
	}

	public void resetDuplets() {
		active = new QDuplet();
		activeList = new ArrayList();// to clear duplets entered...
	}

	public void allowAllOptions() { // for position editor! obsolete???
		for (int i = 0; i < 169; i++) {
			if (isPosEditLoc(i))
				// space.allowOption(i);
				options[i] = true;
		}
	}

	public void allowSameLoc(int loc) {
		// space.allowOption(loc);
		options[loc] = true;
	}

	public void allowOwnPlain(int activePlayer) {
		// space.clearOptions();
		options = new boolean[169];
		resetAllowBooleans();
		mayMove = true;

		// add allow pass (84); will be removed if breaks IR
		if(QuiRules.allowPass){
			options[84] = true;
			mayPass = true;
		}


		if (activePlayer == 0) {
			for (int i = 0; i < 169; i++) {
				if (isBlackDot(i) && hasPlainWhite(i))
					options[i] = true;
				// space.allowOption(i);

			}
		} else {
			for (int i = 0; i < 169; i++) {
				if (isBlackDot(i) && hasPlainBlack(i))
					options[i] = true;
				// space.allowOption(i);
			}
		}
	}

	public void allowAnyPieceAndPass(int loc) {
		// space.clearOptions();
		options = new boolean[169];
		for (int i = 0; i < 169; i++) {
			if (hasPieces(i))
				options[i] = true;
			// space.allowOption(i);
		}
		// space.allowOption(84);
		if(QuiRules.allowPass)
			options[84] = true;
	}

	public void allowLegs(int loc, byte movingStack) {
		/*
		 * this loops through all 8 directions and pinpoints all valid legs
		 */

		/*
		 * O~ optimise and generalise by reading from int[] directions =
		 * {-14,-13,-12,-1,1,12,13,14} locDiff is this! or int[][] moveMatrix
		 * with [0] maxstep and rows for (chess) pieces ... int enPassantGhost =
		 * if1StepLoc;
		 */
		// space.clearOptions();
		options = new boolean[169];
		if(QRules.isPosEdit){
			/*
			 * TODO make options for posEdit!!
			 * if selected - all
			 * if not selected - all occupied locs
			 */
			return;
		}


		resetAllowBooleans();
		isMoving = true;
		// this is temporary: send sower/all pieces to calc height!
		// byte selectedPieces = current.stacks[current.activeLocation];
		int height = countBits(movingStack);
		int dirMask = 1;
		int legCount = 0;
		for (int y = -1; y < 2; y++) {
			for (int x = -1; x < 2; x++) {
				if (x == 0 && y == 0)
					x = 1; // to skip the middle square
				int locDiff = x + y * 13;// -14,-13 etc
				int potential = height;
				int evalLoc = loc;
				if (QuiRules.bouncing && (locDiff == bouncingDirectionUnit))
					potential += 1;
				while (potential > 0) {
					if (isBlockedDirection(dirMask, evalLoc))
						break;
					evalLoc += locDiff;
					// space.allowOption(evalLoc);
					options[evalLoc] = true;
					legCount++;
					if (hasPieces(evalLoc)) {
						potential = 0;
					} else if (QuiRules.leglimit) {
						potential--;
					}
				}
				dirMask *= 2;
			}
		}
		// System.out.println("legCount is " + legCount);
	}

	public void allowEmptyPlacingDots(int activePlayer) {
		int[] fullPlacingArea = QuiRules.placingAreas[activePlayer];
		int lenght = fullPlacingArea.length;
		// space.clearOptions();
		options = new boolean[169];
		resetAllowBooleans();
		// TODO combine resetAllowBooleans with new options??
		if (QuiRules.boardValues[activeLocation] == 5) {
			mayPlaceHome = true;
		} else {
			mayPlaceLedge = true;
		}
		for (int i = 0; i < lenght; i++) {
			int optionLoc = fullPlacingArea[i];
			if (!hasPieces(optionLoc))
				options[optionLoc] = true;
			// space.allowOption(optionLoc);
		}
	}

	public void allowOwnHomeDot(int activePlayer) {
		// space.allowOption(ownHomeDot(activePlayer));
		options[ownHomeDot(activePlayer)] = true;
		mayPlaceHome = true;
		// 97 for white player, 71 for black
	}

	// public void allowReleasingDots() {
	// //TODO is allowReleasingDots() used?
	// //space.clearOptions();
	// options = new boolean[169];
	//
	// resetAllowBooleans();
	// //mayRelease = true;
	//
	// options[83] = true;
	// options[85] = true;
	// // space.allowOption(83);
	// // space.allowOption(85);
	// }

	// SETTERS:

	public void setFailedControlTest(boolean failedControlTest) {
		this.failedControlTest = failedControlTest;
	}

	public void setConfirmedPlyCount() {
		confirmedPlyCount = getPlyPos();
	}

//	public void setConfirmedLocPos() {
//		confirmedLocPos = getLocPos();
//	}

	public String getConfirmedLocString(){
		return locString.substring(0, confirmedLocPos);
	}

	public void setControlStatusText(String controlStatusText) {
		this.controlStatusText = controlStatusText;
	}

	public void setInitialRetrace(boolean initialRetrace) {
		this.initialRetrace = initialRetrace;
	}

	public void setBuildLocString(boolean buildLocString) {
		this.buildLocString = buildLocString;
	}

	// PASTING OF QUCALC
	/*
	 * Maybe optimise by replacing some or most of these with the bit operations
	 * directly in the methods?
	 */

	// this returns an alexian location number from two hexChars
//	public int hexCharsToLoc(char hexChar1, char hexChar2) {
//
//		int xCoord = QFormulas.hexCharToInt(hexChar1);
//		int yCoord = QFormulas.hexCharToInt(hexChar2);
//
//		int loc = -1;//or other "outside limits" return?
//		//coordinate with hexCharToInt()
//		if (xCoord < 13){//incuding 'c' but not 'd'
////			this is only for on-the board locs:
//			loc = (12 - yCoord) * 13 + xCoord;
//		} else {
//			loc = xCoord * 30 + yCoord;//:-) coordinate with locToHexCharString()!
//		}
//
//		/*
//		 * regarding resign locs
//		 * r0 => 810
//		 * r1 => 811
//		 * r2 => 812
//		 * r9 => 819 (pass as out-of board ply! - coordinate with recieveEntry!)
//		 */
//
//		return loc;
//	}
//



//	public String locToHexCharString(int loc) {
//		//this is specific, but could be made general if 13 is a parameter
//		int hexNum1 = 0;
//		int hexNum2 = 0;
//		if (loc < 169){
//			hexNum1 = loc % 13;
//			hexNum2 = 12 - (loc / 13);
//		} else {
//			//TODO make r0 out of 810!!
//			//opposite of loc = xCoord * 30 + yCoord;
//			hexNum1 = loc / 30;
//			hexNum2 = loc % 30;//try this
//		}
//
//		// int hexNum2 = loc / 13;
//		String hexChars = "" + QFormulas.hexMap[hexNum1] + QFormulas.hexMap[hexNum2];
//		return hexChars;
//	}

	public int pathIndex(int actPlayer, int ColourInt) { // to define what
															// path to use
		int pIndex;
		pIndex = actPlayer * 2 + ColourInt;
		return pIndex;
	}

	public int smallestSizeInPlay(int numSizes) {
		/*
		 * this is returns the value of 2 exp numSizes I use a simple loop
		 * rather than importing the whole math package ...
		 */
		int value = 1;
		for (int k = 1; k < numSizes; k++) {
			value *= 2;
		}
		return value;
	}

	public byte calcTowerByte(int nSizes) {
		// rather than importing maths
		byte tByte = 0;
		int mask = 1;
		for (int i = 0; i < nSizes; i++) {
			tByte += mask;
			mask *= 2;
		}
		return tByte;
	}

	// the following deal with whole groups represented by bytes
	public int countBits(byte B) {
		int bCounter = 0;
		for (int m = 1; m < 17; m *= 2) { // enlarge to 64 in case bigger
											// bytes???
			if ((B & m) != 0) // this means the piece is there
				bCounter++;
		}
		return bCounter;
	}

	public int orderInStack(int size, byte B) {
		// Tests OK for when size is one byte; if not sure test size for
		// oneness!
		// returns highest when piece is not there; only use if sure!
		int ordinalNumber = 0;
		int bCounter = 0;
		for (int m = 1; m < 17; m *= 2) { // enlarge to 64 in case bigger
											// bytes???
			if ((B & m) != 0) {// this means the piece is in the stack
				ordinalNumber++;
				bCounter++;
				if (size == m) // this means it is our special piece
					break;
			}
		}
		return ordinalNumber;
	}

	// the following interprets the byte values stored into types of group
	// consider using the corresp methods in QuGameState: hasMixedGroup() etc
	public boolean isEmpty(byte P) {
		boolean empty = false;
		if (P == 0)
			empty = true;
		return empty;
	}

	public boolean isWhite(byte P, byte C) {
		boolean white = false;
		if (P != 0 && C == 0)
			white = true;
		return white;
	}

	public boolean isBlack(byte P, byte C) {
		boolean black = false;
		if (P != 0 && C == P)
			black = true;
		return black;
	}

	public boolean isMixed(byte P, byte C) {
		boolean mixed = false;
		if (C > 0 && C != P)
			mixed = true;
		return mixed;
	}

	public boolean isPlain(byte P, byte C) {
		boolean plain = false;
		if (P > 0 && (C == 0 || C == P))
			plain = true;
		return plain;
	}

	// these three deal with individual pieces, represented by a mask and a byte
	public boolean isPresent(int mask, byte P) {
		boolean presence = false;
		if ((mask & P) != 0)
			presence = true;
		return presence;
	}

	// too complicated - work round it!
	public boolean pieceIsPresent(int size, int colour, byte stack, byte blacks) {
		// boolean result = false;
		return (isPresent(size, stack) && isPresent(colour * size, blacks));
	}

	public boolean pieceIsWhite(int mask, byte C) {
		boolean white = false;
		if ((mask & C) == 0)
			white = true;
		return white;
	}

	public boolean pieceIsBlack(int mask, byte C) {
		boolean black = false;
		if ((mask & C) != 0)
			black = true;
		return black;
	}

	// ??
	public boolean pieceIsSelected(int mask, byte P) {
		boolean selection = false;
		if ((mask & P) != 0)
			selection = true;
		return selection;
	}

	// this one returns the colour of a piece, 0 is white and 1 is black
	public int pieceColour(byte size, byte blacks) {
		int colour = 0;
		if ((size & blacks) != 0) { // test for black
			colour = 1;
		}
		return colour;
	}

	// the following three deals with moving the pieces on the board
	// they should all be performed on both stacks and blacks, when needed!
	public byte joinGroups(byte GroupA, byte GroupB) { // perform with both
														// stacks and blacks!
		byte resultingGroup = (byte) (GroupA | GroupB);
		return resultingGroup;
	}

	public byte removeFromByte(byte movingPieces, byte originalStack) {// perform
																		// with
																		// both
																		// stacks
																		// and
																		// blacks!
		byte resultingGroup = (byte) (movingPieces ^ originalStack);
		return resultingGroup;
	}

	public byte removeBlacks(byte movingPieces, byte originalBlacks) {
		byte resultingBlacks = (byte) (movingPieces ^ originalBlacks);
		return resultingBlacks;
	}

	public byte extractKnockedPieces(byte knockingPieces, byte oldPieces) {// performa
																			// with
																			// both
																			// stacks
																			// and
																			// blacks!
		byte knockedPieces = (byte) (knockingPieces & oldPieces);
		return knockedPieces;
	}

	public byte sowingGroup(int activePlayer, byte P, byte C) {
		// returns what can move on when bottom piece left

		if(QuiRules.shortMove && isMixed(P,C))
			return 0;

		byte sGroup = 0;
		boolean isBottom = true;
		for (byte k = 1; k < 17; k *= 2) {
			// loop up through the potential tower
			if ((k & P) != 0) { // do isPresent()?
				if ((k & C) == (k * activePlayer)) {
					// this means it is of player's own colour
					if (isBottom) { // hitting largest piece
						isBottom = false;
					} else { // identifying the pieces we are after
						sGroup = joinGroups(k, sGroup);
						// add to sowingGroup
					}
				}
			}
		}
		return sGroup;
	}

	public byte allOwnPieces(int activePlayer, byte P, byte C) {
		/*
		 * not tested yet ~O use better formulas?
		 */

		// returns all pieces of the player's own colour
		byte pGroup = 0;
		for (byte k = 1; k < 17; k *= 2) {
			// loop up through the potential tower
			if ((k & P) != 0) { // use isPresent()?
				if ((k & C) == (k * activePlayer)) {
					// this means it is of player's own colour
					pGroup = joinGroups(k, pGroup); // add to pGroup
				}
			}
		}
		return pGroup;
	}

	public int largestSize(byte B) { // does not depend on player colour!
		int mask = 1;
		for (int k = 0; k < 5; k++) { // this should be k < numPieces ...
			if ((B & mask) != 0) { // this means the piece is there
				break; // try just return mask; instead of break!
			}
			mask *= 2; // here mask is multiplied by 2
		}
		return mask;

	}

	// ths following two are really only for the Graphical side??
	public int yAdjustFactor(int size, byte groupByte) {
		int factor = 0;
		int bCounter = 0;
		int internalOrder = 0;
		for (int m = 1; m < 17; m *= 2) { // enlarge to 64 in case bigger
											// bytes???
			if ((groupByte & m) != 0) // this means the piece is there
				bCounter++;
			if (size == m) {
				internalOrder = bCounter;
			}
		}
		// System.out.println("bCounter is " + bCounter);
		// System.out.println("internalOrder is " + internalOrder);
		factor = bCounter - 2 * internalOrder;
		return factor;
	}

	public int xAdjustFactor(int sizeMask, int numSizes) {
		/*
		 * returns 5 for 1, 4 for 2 etc only really works for five sizes games!!
		 */
		int number = 5;
		if (numSizes == 3) {
			for (int k = 1; k < 5; k *= 2) {
				if (sizeMask == k)
					break;
				number -= 2;
			}

		} else {

			for (int k = 1; k < 17; k *= 2) {
				if (sizeMask == k)
					break;
				number--;
			}
		}

		// System.out.println("number is " + number);
		return number;
	}

	// END PASTING OF QUCALC

	// public class QuBoardFunction {

	/*
	 * This contains the arrays to define the board in terms of freedom to move,
	 * and maybe tangent data for bouncing?
	 */





	// this returns true if a direction is blocked by the lines on the board
	public boolean isBlockedDirection(int dirMask, int loc) {
		int boardValue = QuiRules.boardValues[loc];
		boolean result = false;
		if ((dirMask & boardValue) == 0)
			result = true;
		return result;
	}

	// these interpret the board values in terms of black dots etc:
	// re-write using countBits? Black dots have 3 or more bits ...
	public boolean isFrame(int loc) {
		boolean result = false;
		if (QuiRules.boardValues[loc] < 5 || QuiRules.boardValues[loc] == 64)
			result = true;
		return result;
	}

	public boolean isDot(int loc) {
		boolean result = false;
		if (QuiRules.boardValues[loc] > 4)
			result = true;
		return result;
	}

	public boolean isDotOrLedge(int loc) {
		boolean result = false;
		if ((QuiRules.boardValues[loc] > 2) && (QuiRules.boardValues[loc] != 64))
			result = true;
		return result;
	}

	public boolean isLedge(int loc) {
		boolean result = false;
		if (QuiRules.boardValues[loc] == 3 || QuiRules.boardValues[loc] == 4)
			result = true;
		return result;
	}

	public boolean isPosEditLoc(int loc) {
		boolean result = false;
		if (QuiRules.boardValues[loc] > 0)
			result = true;
		return result;
	}

	/*
	 * ~O could theoretically optimise next two it by rotating the board values,
	 * and reading by y (-1 to 1) x (-1 to 1), but quite a lot of work ...
	 * problem is that engine performs allowLegs before realising it is posEdit
	 * ...
	 */
	public boolean isBlackDot(int loc) {
		boolean result = false;
		if ((QuiRules.boardValues[loc] > 6) && (QuiRules.boardValues[loc] != 64))
			result = true;
		return result;
	}

	public boolean isWhiteDot(int loc) {
		boolean result = false;
		if ((QuiRules.boardValues[loc] == 5 || QuiRules.boardValues[loc] == 6)
				&& (QuiRules.boardValues[loc] != 64))
			result = true;
		return result;
	}

	public boolean isReleasingDot(int loc) {
		boolean result = false;
		if (QuiRules.boardValues[loc] == 6)
			result = true;
		return result;
	}

	public boolean isHomeDot(int loc) {
		boolean result = false;
		if (QuiRules.boardValues[loc] == 5)
			result = true;
		return result;
	}

	// belongs in QuCalc?
	public int ownHomeDot(int activePlayer) {
		return 97 - activePlayer * 26;
	}

	// BOUNCING FORMULAS ETC

	public int directionUnit(int loc0, int loc1) { // returns 0 for no leg
		int sign = 1;
		int unit = 1;// directionUnit of leg

		int leg = loc1 - loc0;
		if (leg == 0)
			return 0;
		if (leg < 0) {
			sign = -1;
			leg = -leg;
		}

		// extract direction; if no hit then unit0 remains 1*sign
		for (int d = 12; d < 15; d++) { // 12,13,14
			if (leg % d == 0)// leg == 0 escapes before
				unit = d;
		}

		return unit * sign;
	}

	public boolean isBouncingLeg(int loc2) {
		// loc2 is the second loc in a candidate bouncing leg;
		// bouncingOrigin and bouncingDirectionUnit are preset!
		if (bouncingDirectionUnit == 0)// =no bouncing leg possible
			return false;
		if (loc2 - bouncingOrigin == 0)// = leg is of 0 length
			return false;

		int unit1 = directionUnit(bouncingOrigin, loc2);
		return unit1 == bouncingDirectionUnit;
		// return unit1 == bouncingDirection(loc0,loc1);
		// or store bouncingDirection? how to reset? fetch?
	}

	public int bouncingDirection(int loc0, int loc1) {
		// loc0 is dot of origin; loc1 is arrival line dot

		int unit0 = directionUnit(loc0, loc1);
		int unit1 = 0;// direction of bouncing leg; 0 is no bouncing available

		// get value from BoardFunctions (in state)
		int lineDotValue = QuiRules.boardValues[loc1];

		switch (lineDotValue) {

		case 22: // 000
		case 151:
			// 12 -12
			// -1 -13
			// 13 1
			if (unit0 == 12)
				unit1 = -12;
			if (unit0 == -1)
				unit1 = -13;
			if (unit0 == 13)
				unit1 = 1;

			break;

		case 7: // 005 3 freedoms
		case 31: // 5 freedoms
		// 13 -13
		// 14 -12
		// 12 -14
			if (unit0 == 13)// S
				unit1 = -13;// N
			if (unit0 == 14)// SE
				unit1 = -12;// NE
			if (unit0 == 12)// SW
				unit1 = -14;// NW

			break; // this times 8?

		case 11: // 010
		case 47:
			// 14 -14
			// 1 -13
			// 13 -1
			if (unit0 == 14)
				unit1 = -14;
			if (unit0 == 1)
				unit1 = -13;
			if (unit0 == 13)
				unit1 = -1;

			break;

		case 41: // 015
		case 107:
			// 1 -1
			// 14 12
			// -12 -14
			if (unit0 == 1)
				unit1 = -1;
			if (unit0 == 14)
				unit1 = 12;
			if (unit0 == -12)
				unit1 = -14;

			break;

		case 104: // 020
		case 233:
			// -12 12
			// 1 13
			// -13 -1
			if (unit0 == -12)
				unit1 = 12;
			if (unit0 == 1)
				unit1 = 13;
			if (unit0 == -13)
				unit1 = -1;

			break;

		case 224: // 025
		case 248:
			// -13 13
			// -14 12
			// -12 14
			if (unit0 == -13)
				unit1 = 13;
			if (unit0 == -14)
				unit1 = 12;
			if (unit0 == -12)
				unit1 = 14;

			break;

		case 208: // 030
		case 244:
			// -14 14
			// -1 13
			// -13 1
			if (unit0 == -14)
				unit1 = 14;
			if (unit0 == -1)
				unit1 = 13;
			if (unit0 == -13)
				unit1 = 1;

			break;

		case 148: // 035
		case 214:
			// -1 1
			// 12 14
			// -14 -12
			if (unit0 == -1)
				unit1 = 1;
			if (unit0 == 12)
				unit1 = 14;
			if (unit0 == -14)
				unit1 = -12;

			break;

		default:
			break;

		}

		return unit1; // no bouncing is 0
	}

	// THESE are for testing only!!
	public void setBouncingDirectionUnit(int bouncingDirectionUnit) {
		this.bouncingDirectionUnit = bouncingDirectionUnit;
	}

	public void setBouncingOrigin(int bouncingOrigin) {
		this.bouncingOrigin = bouncingOrigin;
	}

	public void setHasBeenRewound(boolean hasBeenRewound) {
		this.hasBeenRewound = hasBeenRewound;
	}

}
