/*
**********************************************************************
*                        License Notice
*
* QuiGameSpace.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

import java.util.ArrayList;
import java.lang.String;

import com.quincala.core.*;
//import net.looseswede.QuUtils.*;

public class QuiGameSpace extends QGameSpace {

	//QuRules is held as an object!!

	/**
	 * this class holds all game specific information
	 * and operations
	 */




	//for now, put the Translator here; should be created in Navigator??
	//QuTranslator translator = new QuTranslator();



	//engineer's switch :-)
	public boolean doConstruction = false;




//	QuiRules currentRules = new QuiRules();
	int versionInt = -1;//forcing initRules at first run
	int variantInt = -1;
	/*
	 * the rules belong to specific gamespace (not general)
	 * the integers are used to only run initRules() when
	 * either version or variant has changed.
	 */






	//actually this is performed by sending "qui35",
	//needed to initialise??
	//QuiGameState currentState = new QuiGameState();
	QuiGameState currentState = new QuiGameState();
	//public int player = 0; // or current.activePlayer
	//private int homedot = ownHomeDot(player);
	//QuiGameState confirmed= new QuiGameState();	//use strings instead
	//the last position to pass the control rules


	QuiGameState legalCheckState;//try no initialising here
	QuiGameState stateAhead;

//	QuiGameLine currentLine = new QuiGameLine();
//	QGameLine currentLine = new QGameLine();//in QGameSpace!
	//needs to be initialized for GUI start-up
	//this holds the current line of play




	public static void main(String[] args) {
		//can this be used as a non-gui
		//gateway?
	}


	public void initGameSpace(String args){

		System.out.println();
		System.out.println("INIT GAMESPACE");

		if (args.equals("")){

			receiveSpaceQuString("quiKM");//space still thinks in old ways ...
			receiveSpaceQuString("Quincala;KM");//or default??
			//testing; rather than receiveSetUpString
			//this will initiate gameLine properly


		} else{
			//hmmmr args is String[][] isn't it?
			receiveSpaceQuString(args);
			//this belongs in a static main()!!

		}
//		now pass the whole line data to line:
		currentLine.setWholeLineData(currentState.getWholeLineData());
	}

	public void setDoConstructionTrue(){
		doConstruction = true;
	}

	public synchronized String[] getQuString(String quStringFormat){
		boolean brake = currentState.zeroPlyDestination > 0;
		//TODO change to > - 1 when zeroPlyDestination defaults to -1!
		String[] quStringreturn =  new String[2];
		//no frames until GUI level! - do wrapper on Gui level too!!
		quStringreturn[0] = "";//otherwise "null"!!
		quStringreturn[1] = "A QSF String has been copied to the clipboard.";
		//unless proven otherwise ...
		//TODO in 0.9 just send a message to pop-up
		//rather than a two part string return

		/*
		 * TODO make turnLocCount in state, reset to 0 at turnshifts, -1 at restart, +1 at add loc
		 * 0 <=> turn is open!
		 * make line.getcurrentPlyStringNoFuture(brake) and line.getcurrentPlyStringWithFuture(brake)
		 * @: rethink when a new line is created and use of 'x'
		 *
		 */

		/*
		 * this method should have the shape
		 * if (single string format)
		 * 		return single qustring;
		 * etc
		 * if (composite string format)
		 * 		add to composite
		 * etc
		 * return composite qustring;
		 */



		if (quStringFormat.equals("0.6")){
			quStringreturn[0] = currentState.getLineString();//0.6
			return quStringreturn;
		}

		if (quStringFormat.equals("title")){//single string return
			//rename to title
			quStringreturn[0] = currentLine.getTitle();
			return quStringreturn;
			//TODO make prefix same as Title button text: i18n!
			//no formatting for QuStrings
//			titleOut = false;
//			wrapMode = false;
			//should have sent false, but just in case!
		}

		if (quStringFormat.equals("restart")){//single string return
			quStringreturn[0] = QRules.getGameStringHead();
			return quStringreturn;
			//infoOut = false;//don't want to preserve match info strings!!
		}

		if (quStringFormat.equals("score"))	{//composite string return at end
			quStringreturn[0] = QRules.getGameStringHead();//0.7+
			String markedPlyString = currentLine.purePlyString;//will be marked in the future!!

			quStringreturn[0] += ";" + markedPlyString;


		} else if (quStringFormat.equals("@"))	{

			/*
			 * crop all branch/candidate part off matchInfo!
			 * maybe chosing @ mode in GUI should grey info check box selected?
			 */

			if (currentLine.isLoadEndTurnOpen){
				int turns = currentLine.getWholeLineData().TurnsInLine;
				int loadedTurns = currentLine.loadEndTurnNo;
				if (turns <= loadedTurns){//nope must be more
					//TODO error message!!

				} else if (turns > loadedTurns + 1){
					//then extract exactly one turn more!

					//message for capping!

				}

				//it is good if the mode is set to '@' automatically on loading
				quStringreturn[0] += "&copymode=@";

				//now, the info for '@' should not have any branch data...
//				titleOut = false;
				String titleStringCorrespond = currentLine.getTitle();
				//no formatting for QuStrings
				//TODO @ mode maybe strip branch bits of matchInfo too??

				if (titleStringCorrespond.length() > 0){
					quStringreturn[0] +=  "&title=" + titleStringCorrespond;
				}

				//finally, normally it shouldn't wrap either,
				//potentially really bad for skype etc
				//but think of the
				//system!!! easiest to do
//				wrapMode = false;
				//but maybe not so user friendly?


			} else {
				quStringreturn[1] = "Warning: previously loaded QuString did not end at the beginning of the turn - " +
						"NO QuString has been put to the clipboard!";
			}

		} else if (quStringFormat.equals("posNo")){
			quStringreturn[0] = QRules.getGameStringHead();
			String markedPlyString = currentLine.getPosStringNoFuture(brake);
			quStringreturn[0] += ";" + markedPlyString;
		}


		if (quStringFormat.equals("posYes")){
			quStringreturn[0] = QRules.getGameStringHead();
			String markedPlyString = currentLine.getPosStringWithFuture(brake);
			quStringreturn[0] += ";" + markedPlyString;
		}



		if (quStringFormat.equals("purePos")){//not implemented yet
			//add QRules.getGameStringHead()?
			quStringreturn[0] = currentState.getSimplePositionString();
		}

		//at end of Game Strings add QDV
		quStringreturn[0] += ";" + QuiRules.baseLineToUse
		+ "." + QuiRules.incrementToUse;//should come out as a string?


		//finally add the info string if present etc
		String titleString = currentLine.getTitle();
		if (titleString.length() > 0){
			titleString = QSFUtils.encodeValue(titleString, false);
			//false since titles don't allow Unicode

			//add the info string add end
			quStringreturn[0] += "&title=" + titleString;

		}

		//System.out.println("quStringreturn[0] is " + quStringreturn[0]);
		return quStringreturn;
	}




	protected void receiveEntry(int loc){//stay in space!
		/*
		 * make this (and the overloaded ones?) to return
		 * false if not valid entries??
		 */

		/*
		 * this receives an entry that can be a ply or a loc
		 * it might require cropping (restarting), truncating (IFR break)
		 * or pruning (shaving off redundant legs)
		 * This affects the Line, so must stay in space!
		 */

		/*
		 * it analyses the entry into four actions
		 * 1. adds a ply to the end of current line
		 * 2. follows current line (equal to UP button)
		 * 3. it constitutes a variation, if line is ...
		 * 	a. not sealed: the current line is changed, with x at changing point
		 * 	b. sealed: current line stored, new line created, with x at changing point
		 */

		if (!currentState.isValidEntry(loc))
			return;


		//to save time:
		String locStringlet = QSFUtils.locToHexCharString(loc);
//		System.out.println("locStringlet is " + locStringlet);


//TODO restructure this gateway to look at
		if(!currentLine.forwardStepAvailable()){//Plough
			//at end of line; no steps forward available
			//not releasing??

			/*
			 * since zeroPlyString are pre-loaded (below & CDbuttonReceive),
			 * locs reaching here are always 1 ply!
			 */

			if(currentLine.isSealed){
				// make new tab!!
				makeNewBranch(locStringlet, loc);
			}

//			at least just move forward!
			stepForward(locStringlet, loc);



		} else {//not at end of line

			if (currentLine.getStepLocString(1).equals(locStringlet)){//VIP
//				following the line ...
				receiveCDButtonClick(6);//just as UP button ...

			} else if (currentLine.backStepAvailable() || !currentLine.isSealed){
				//departing from the line - Branch
				makeNewBranch(locStringlet, loc);
				stepForward(locStringlet, loc);//acts on locstring

			} else {
				//is at starting position of a sealed line: no branching, just new line of the same:
				currentLine = new QGameLine();
				reloadCurrentState();
				stepForward(locStringlet, loc);//acts on locstring
			}

		}

//		if(currentState.failedControlTest){
//			//no need to complete releasing to test for immunity ...
//			rewindTurnImmunity();
//		}
		//if(currentState.failedControlTest){
		if(isIFRBreakAhead()){
			rewindTurn();
		}
		if (currentState.isWin && QBuildParameters.sealOnFinish)
			currentLine.setSealedTrue();//comment away if hard coded

		stringReport();//print strings!



		//NOTE the zeroPlyStringletAdditionSystem didn't work!
		//this is for pre-load releasing or other zero ply events:
		//currentLine.addToLocString(currentState.fetchZeroPlyString());
		//don't add to locPos here!
	}

	public void makeNewBranch(String locStringlet, int loc){
		//this makes a new branch, from a sealed line
		//make new branch/line/tab:
		String setUpString = currentLine.setUpString;
		String title = currentLine.getTitle();
		//no formatting since that is only for infopanel

		int BranchNo = currentLine.branchNo;
		boolean newLineIsBranch = false;
		String plyString = "";

		//this is a new branch proper, else is just navigating complete tree!
		if(currentLine.isSealed){//also if press +Y button!
//			BranchNo++;
//			if(BranchNo > 0)
//				MatchInfo += " branch " + BranchNo;

			//maybe better for now:
			newLineIsBranch = true;

			plyString = currentState.plyString;
			if(plyString.length() > 0){
				//only add an x if not at root!
				plyString += "x";
			} else {
				//should not reach here!!
				System.out.println("PROGRAMMING ERROR: space.makenewBranch " +
						"is reached from starting position!");
			}

			//this makes marker at fork only for sealed lines
		} else {
//			System.out.println("fetching marked stem!");
			plyString = currentLine.getMarkedStem();
		}

//		plyString += "x";
		//this puts an 'x' marker at fork for both open and sealed lines


		//stash old currentLine into an ArrayList here
		//maybe also a super session string?
		currentLine = new QGameLine();

		currentLine.setSetUpString(setUpString);//obsolete
		currentLine.addToMarkedPlyString(plyString);
		//not setMarkedPlyStringSealed, since open until sealed


		//or not marked?
		currentLine.setLocString(currentState.locString);
		currentLine.setLocPos(currentState.getLocPos());

		if (title.length() > 0){
			//titel can transfer at root if unsealed line!
			currentLine.setLineTitle(title);
			/*
			 * TODO figure out how to assign branch no properly!!
			 * only after all branches are kept in List!
			 */
			currentLine.setBranchNo(BranchNo);
		}

		//in any case, decide the addBranch after the matchInfo!!!
		currentLine.setAddBranchToMatchInfo(newLineIsBranch);
	}

	private void gotoTurn(int goalTurnInt){
		//this is validated as smaller as current turn, but double check
		int maxTurn = currentLine.lineData.turnsOpened;


		if (goalTurnInt > maxTurn || goalTurnInt < 1)
			return;

		int currentTurn = currentState.turnNumber;

		if (goalTurnInt <= currentTurn){//= in case in middle of turn!
			//need to go back from beginning
			reloadCurrentState();
			currentLine.setLocPos(0);//should be included in the above??
		}

		//then incrementally send upbutton commands until turn reached!
		while (currentState.turnNumber < goalTurnInt){
			receiveCDButtonClick(FORWARD_STEP);//forward one step
//			receiveSpaceQuString("nav=" + FORWARD_STEP);
			//Deadlock danger: this method is called from receiveSpaceQString!
			//but not actual deadlock on testing!
		}
		stringReport();
	}

	public void stepForward(String locStringlet, int loc){
		//"Plough in action"
		//only for open lines!!
		//currentLine.addToLocString(locStringlet);//this is undone below!
		currentLine.addToLocPos(1);//1 step is 2 positions ...

		//only if it is not a white dot!!
//		if(loc != 83 && loc != 85)
//			currentLine.addToMarkedPlyString(locStringlet);

		//rather try this:only add ply if zeroPlyDest = -1!
		if (currentState.zeroPlyDestination <= 0)
			currentLine.addToMarkedPlyString(locStringlet);
		//note: must set default to -1 then ... and change to < 0!

		//currentLine.addToPlyPos(1);
		//this method sends state to X ...
		//getPlyPos from State after performing loc?
		currentState.receiveLoc(loc);//here the input is acted on!
		currentLine.setPlyPos(currentState.getPlyPos());
		currentLine.setLocString(currentState.locString);
		currentLine.setLocPos(currentState.getLocPos());

		//here check for restart of leg or home dot placing!
		cropCheck();

		//here update line info:
		currentLine.setWholeLineData(currentState.getWholeLineData());
		//it's updated from clicking on the board in GUI!
	}

	public void cropCheck(){//space
		if (currentState.fetchDoCrop() && versionInt > 0){//copy to receivePlyArray() ...
			currentLine.cropFourOffMarkedPlyString(currentState.getPlyPos());
			currentState.cropFourChars();
			currentLine.setPlyPos(currentState.getPlyPos());
			currentLine.setLocString(currentState.locString);
			currentLine.setLocPos(currentState.getLocPos());
		}
	}

//	public void rewindTurnImmunity(){//space
//
//
//		String offendingLocString = currentState.locString;
//		String confirmedLocString = currentState.getLocStringToLocPos(currentState.confirmedLocPos);
////		System.out.println("confirmedLocString is " + confirmedLocString);
//
//		/*
//		 * here cap the string - just in case it has plys for
//		 * after the IRF control point
//		 * capping is performed to include the offending ply
//		 * to enable reaching this again
//		 */
//		currentLine.capMarkedPlyString(currentState.getPlyPos());
//		currentLine.lineData.setControlPassInt(currentState.controlPassInt);
//		//this must be before new state!
//		//currentLine.setWholeLineData(stateAhead.getWholeLineData());
//
//		//on loc String: - can be combined into one string??
//		receiveSetUpString(currentLine.setUpString);//incl new GameState
//		//TODO to rewind, just reloadCurrentState()! & remove clear command above!
//		currentState.receiveLocString(confirmedLocString);
//
//		currentLine.setLocPos(currentState.confirmedLocPos);
//		currentLine.setPlyPos(currentState.getPlyPos());
//		//System.out.println("just setting loc string with " + offendingLocString);
//
//		//this is correct but it is set somewhere else afterwards!!
//		currentLine.setLocString(offendingLocString);//minus one?
//
//
//		//here set the IR message to line and state:
//
//		//try
//
//		//bypassing currentLine.setIRMessage(); //obsolete!
//		currentState.setControlStatusText(" The entire turn is back-traced to enable re-play! obsolete?");
//		//obsolete?
//
//		currentState.setHasBeenRewound(true);
//
//
//		stringReport();
//	}

	public void rewindTurn(){//space

		currentLine.setLastPlyIsIllegal(true);

		//note the rewind command has been triggered by stateAhead!
		String offendingLocString = stateAhead.locString;
		//line might not be updated with complete loc string yet ...
		//I choose to get all locStrings from State - is that wrong?
//		System.out.println("offendingLocString is " + offendingLocString);
		//TODO add a method in state to simplify this:
		String confirmedLocString = stateAhead.getConfirmedLocString();
		System.out.println("confirmedLocString is " + confirmedLocString);


		/*
		 * here cap the string - just in case it has plys for
		 * after the IRF control point
		 * capping is performed to include the offending ply
		 * to enable reaching this again
		 */
		currentLine.capMarkedPlyString(stateAhead.getPlyPos());

		currentLine.setWholeLineData(stateAhead.getWholeLineData());
		currentLine.lineData.setControlPassInt(stateAhead.controlPassInt);
		//this must be before new state!


		//on loc String: - can be combined into one string??
		receiveSetUpString(currentLine.setUpString);//incl new GameState!
		//TODO to rewind, just reloadCurrentState()! & remove clear command above!
		currentState.receiveLocString(confirmedLocString);

		currentLine.setLocPos(currentState.confirmedLocPos);
		currentLine.setPlyPos(currentState.getPlyPos());
		//System.out.println("just setting loc string with " + offendingLocString);

		//this is correct but it is set somewhere else afterwards!!
		currentLine.setLocString(offendingLocString);//minus one?


		//here set the IR message to line and state:

		//try

		//bypassing currentLine.setIRMessage(); //obsolete!
		currentState.setControlStatusText(" The entire turn is back-traced to enable re-play!");

		currentState.setHasBeenRewound(true);


		stringReport();
	}

	protected void receiveCDButtonClick(int cdButtonNo){//space
		/*
		 * this receives the clicks from the GUI
		 * numbers are as follows:
		 * rec stop |< < } || > >|
		 *  0   1   2  3 4 5  6 7
		 */

		//first see if a stringHead should be passed on
		//then pass a request to currentLine for a ply array
		switch(cdButtonNo){
		default:
			System.out.println("QSF Error: navigation value " +
					"is not defined: " + cdButtonNo);
			return;//is stronger than break


//		case 0://TODO look over this: is it for recording??
//			currentState.getSimplePositionString();
//			break;
		case PREV_MARK: // PAGEdown button
//			String prevMarkerStrng = currentLine.getPreviousMarkerString();
//			int markerIndex = prevMarkerStrng.length();//
//
//
//			//currentState.clearReleasedPieces();//transitional
//
//			//receiveSetUpString(currentLine.setUpString);
//			reloadCurrentState();
//			receivePurePlyString(prevMarkerStrng, false);
//			//if x marks brake, then it will be set true later
//
//			currentLine.setPlyPos(markerIndex);
//			//always update the locPos after sending plys!:
//			currentLine.setLocPos(currentState.getLocPos());

			boolean lastIsZeroPly = currentState.lastPlyValue == 0;
			QPlyPosition prevPosition = currentLine.getPreviousMarkerPlyPos(lastIsZeroPly);
			int markerIndex = prevPosition.plyPosInt;//combine with below!
			reloadCurrentState();
			receivePlyPosition(prevPosition);
			currentLine.setPlyPos(markerIndex);
			currentLine.setLocPos(currentState.getLocPos());

			break;
		case BACK_STEP: // BACK button

			//currentState.clearReleasedPieces();//transitional

			//on loc String: - can be combined into one string??

			//receiveSetUpString(currentLine.setUpString);
			reloadCurrentState();
			currentState.receiveLocString(currentLine.getStepLocString(-1));
			currentLine.addToLocPos(-1);
			currentLine.setPlyPos(currentState.getPlyPos());



			break;
		case FORWARD_STEP: //UP button
			/*
			 * sending to receivePurePLyString/array instead of directly
			 * to receive Entry: collecting post processing ...
			 */


			if(currentLine.forwardStepAvailable()){//=loc (maybe ply) step;
				/*
				 * note that this is the forwardStepAvailable from currentLine
				 * the forwardStepAvailable that is finally passed on to
				 * the gui.statusBar will take into account if there are
				 * releasing available; same as this structure!
				 */
				currentState.receiveLocString(currentLine.getStepLocString(1));

				currentLine.setPlyPos(currentState.getPlyPos());
				// in case it is a ply step ...

			} else if(currentState.zeroPlyDestination > 0){
				//= releasing step new to the line!
				currentState.receiveLoc(currentState.zeroPlyDestination);
				//plypos remains the same!

				currentLine.setLocString(currentState.locString);
				//since it is new to the line! to enable down button!

			}

			currentLine.setLocPos(currentState.getLocPos());



			break;
		case NEXT_MARK: //PAGEUP button


			if (currentState.zeroPlyDestination == 0){//next step is ply step

//				receivePurePlyString(currentLine.getNextMarkerString(), true);
////				if x marks brake, then it will be set true later

				//this is actually reloading the game from beginning ...
				//maybe make incremental plyPos object?
				QPlyPosition nextPosition = currentLine.getNextMarkerPlyPos();
				int nextMarkerIndex = nextPosition.plyPosInt;//combine with below!
				reloadCurrentState();//not needed if incremental plyPos Object!
				receivePlyPosition(nextPosition);
				currentLine.setPlyPos(nextMarkerIndex);
				currentLine.setLocPos(currentState.getLocPos());
			} else {//releasing steps to be performed!
				receivePurePlyString("", false);
				//TODO completing releasing should override line brake!!
			}

			//don't know where plyPos is now, so:
			currentLine.setPlyPos(currentState.getPlyPos());
			//in case the operation has added to the line:
			if(!currentLine.forwardStepAvailable())
				currentLine.setLocString(currentState.locString);

			//always update the locPos after sending plys!:
			currentLine.setLocPos(currentState.getLocPos());

			//currentLine.addToLocString(currentState.fetchZeroPlyString());
			break;
		}
//		if(currentState.failedControlTest){
//			//no need to complete releasing to test for immunity ...
//			rewindTurnImmunity();
//		}
		//transitional: cdbutton will be string based, so
		//this will be taken care of after string is executed!
		if(isIFRBreakAhead()){
			rewindTurn();
		}

		stringReport();//print strings!


		//TODO receive buttons and user entries into same method;
	}

	public synchronized void receiveSpaceQuString(String quString){//space
		//System.out.println("space.quString has received " + quString);
		//validate quString in QuValidator? or validated
		//before reaching here?

		//maybe double validation??
		//or validation before operating on them??

		//first sift out new type strings
		if (!QSFUtils.is2009QuString(quString)){//= QSF 0.1+
			if(QSFUtils.isKeyValueString(quString)){
				String key = QSFUtils.getKey(quString);
				String value = QSFUtils.getValue(quString);
				if(key.equalsIgnoreCase("loc")){
					int loc = -1;
					try {
						loc = Integer.parseInt(value);
					} catch (NumberFormatException e) {
						System.out.println("Error: space." +
								"receiveString/loc value " +
								"is not an integer!");
					}
					receiveEntry(loc);
					return;
				}
				if(key.equalsIgnoreCase("goto")){
					int turnInt = -1;
						try {
							turnInt = Integer.parseInt(value);
						} catch (NumberFormatException e) {
							System.out.println("Error: space." +
									"receiveString/goto value " +
									"is not an integer!");
						}
					gotoTurn(turnInt);
					return;
				}
				if(key.equalsIgnoreCase("nav")){
					//
					int navActionInt = -1;
					try {
						navActionInt = Integer.parseInt(value);
					} catch (NumberFormatException e) {
						// should have int format!! if validated
						System.out.println("Error: space." +
								"receiveString/nav value " +
								"is not an integer!");
					}
					//here send on to CD button click method
					receiveCDButtonClick(navActionInt);
					return;
				}
				if(key.equalsIgnoreCase("ply")){
					//TODO enlarge ply to more than Stringlets
					int plyLoc = QSFUtils.getAsciiInt(value);
					if (plyLoc > -1){//-1 is error parsing
						receiveEntry(plyLoc);
					}
					return;
				}
			} else if(QSFUtils.isValidGameString(quString)){
				String[] s = quString.split(";");//don't limit to three
				if (s.length > 0){
					if (s[0].equalsIgnoreCase("qui"))
						s[0] = "Quincala";//transitory!!
					QRules.setGameHead(s[0]);

				} else {
					//keep old or set default??

				}
				if (s.length > 1 && QSFUtils.isValidEnvironmentString(s[0],s[1]))
					QRules.setEnvironmentString(s[1]);//to store; for output
				//send to QuiRules to process? via separate QUISpace method?
			}
			//TODO DETECTIVE: compare these brackets for deleting well

		} else {//this it old type!
			//leaving only old space commands,
			//letting game strings go on

			//first sift out ~strings
			char nose = quString.charAt(0);
			if (nose == '~'){
				//repeat code!! do in QuStringUtils!! return String[]
				String tildeHead3 = quString.substring(1, 4);//with 3 chars
				String tildeHead4 = quString.substring(1, 5);//with 4 chars
				String tildeBody3 = quString.substring(4);//with 3 chars head
				String tildeBody4 = quString.substring(5);

				if(tildeHead4.equalsIgnoreCase("goto")){
					tildeBody4 = tildeBody4.trim();
					System.out.println("space.tildeBody is " + tildeBody4);
					int turnInt = Integer.parseInt(tildeBody4);
					gotoTurn(turnInt);
				}
				if(tildeHead3.equalsIgnoreCase("ply")){
					//for now it only works on single stringlets:
					//develop to allow plystrings!
					//one ply at the time to receiveEntry?

					tildeBody3 = tildeBody3.trim();
					//here check validity?
					System.out.println("tildeBody3 is " + tildeBody3);
					int plyLoc = QSFUtils.getAsciiInt(tildeBody3);
					receiveEntry(plyLoc);
					//higher level: add to line!

				}
				return;
			}

			currentState.setInitialRetrace(false);//needed after migration?
			//initialRetrace = false;//reset needed!
			currentLine = new QGameLine();//here rather than later?

			//this is old game strings!
			//first extract the three character "head"
			String quStringHead = quString.substring(0,3);
			//System.out.println("space.quStringHead is " + quStringHead);
			String setUpString = "";
			String markedPlyString = "";
			int quStringLength = quString.length();
			if (quStringHead.equalsIgnoreCase("qui")){
				if (quStringLength > 5){ //develop to game 1 & pos strings! etc!!

					//split string, create line and send on
					setUpString = quString.substring(0,5);
					markedPlyString = quString.substring(5);
//					System.out.println("space.markedPlyString is " + markedPlyString);

//					on which level is the new line created?
					//should the old currentLine be inserted into an array?
//					currentLine = new QuiGameLine();
					currentLine.setSetUpString(setUpString);
					currentLine.setMarkedPlyString(markedPlyString);

					receiveSetUpString(currentLine.setUpString);
//					//UGLY UGLY: make part of setEnvironment!!
//					QuiRules.setRuleVariants();
//					QuiRules.printRuleParams();

					//here send full string to initialize!
//					this is transitional: not needed when markedBrake in place
					//currentState.setBuildLocString(true);
					//TODO remove setBuildLocString() from state!

					//do a pre-run to evaluate the QuString:
					receivePurePlyString(currentLine.getPurePlyString(), false);

//					after rewind??
					//System.out.println("currentState.hasBeenRewound is " + currentState.hasBeenRewound);
					if(!currentState.hasBeenRewound)
						currentLine.setWholeLineData(currentState.getWholeLineData());
					//since if rewound, the data is set already!

					//here set the correspondence game parameters:
					currentLine.setLoadEndPlyPos(currentState.getPlyPos());
					currentLine.setLoadEndTurnNo(currentState.turnNumber);
					currentLine.setLoadEndTurnOpen(currentState.turnLocCount == 0);//Test!!
					//here set locString from state!
					//exception: if there has been a IFR break then locstring is set already!
					//flag is still there?
					//try:
					//System.out.println("initialRetrace is " + initialRetrace);

					//this is for going to starting position instead of turn - 2!
					if(!currentState.hasBeenRewound)//I think initialRetrace is obsolete?
						currentLine.setLocString(currentState.locString);


					//then make locString Pos relate to ply pos
					//then make navigation on locString!

					//before reset the state!
					currentLine.setWholeLineData(currentState.getWholeLineData());

					//buildLocString = false;
					currentState.setBuildLocString(false);//needed?; new state!

					receiveSetUpString(currentLine.setUpString);
					//receivePurePlyString(currentLine.getXPositionString(), false);
					receivePlyPosition(currentLine.xPosition);
					//currentLine.setLocString(currentState.locString);//???
					currentLine.setLocPos(currentState.getLocPos());
				} else {//string is smaller than 6 chars
					//just send head on to currentLine, then retrieve it
					setUpString = quString;
					currentLine = new QGameLine();
					currentLine.setSetUpString(setUpString);
					receiveSetUpString(currentLine.setUpString);
//					//UGLY UGLY: make part of setEnvironment!!
//					QuiRules.setRuleVariants();
//					QuiRules.printRuleParams();
					currentLine.setWholeLineData(currentState.getWholeLineData());
				}

			}
			if (quStringHead.equalsIgnoreCase("loc")){
				//dont think I got this working
				String locString = quString.substring(4).toLowerCase();
				currentState.receiveLocString(locString);//enough??
				//nope get all going!!
				//TODO think trough loc, ply and add heads!
				/*
				 * send locs as entries one by one!
				 */

			}
			if (quStringHead.equalsIgnoreCase("qup")){//simple position string!
				String simplePString = quString.substring(3);
				currentState.setPositionFromString(simplePString);
			}
		}
		stringReport();

	}

	public void reloadCurrentState(){
		//try this as an alternative to recieveSetUpString
		//for simple reloads from the same starting position
		currentState = new QuiGameState();
		currentState.initGameState();

		//can't add this, since CDbuttons need the old loc pos!
//		currentLine.setLocPos(0);//to sync with state
	}

	protected void receiveSetUpString(String quSetUpString){


		int quStringHeadLength = quSetUpString.length();



		/*
		 * For now - demand full length heads (5 chars)
		 * think about changing rules without changing positions
		 * and adding rules to a position string ...
		 */
//		if(quStringHeadLength < 3)
//			return;
		if(quStringHeadLength < 5)
			return;


		int firstNo = 3; //qui defaults to qui35
		int secondNo = 5;
//		secondNo as in number of sizes in play

		if(quStringHeadLength > 3){
			char firstChar = quSetUpString.charAt(3); //"qui" is always first chars!
//			firstNo = (int) (firstChar)  - 48;
			firstNo = QSFUtils.getAsciiInt("" + firstChar);
		}

		if(quStringHeadLength < 5){ //= partial head as in qui3
			//default number of sizes:
			switch(firstNo){
			case 1:
			case 5:
				secondNo = 3;
				break;
			default:
				//secondNo = 5;//default is set above
				break;
			}
		} else { //= full head; length > 4
			char secondChar = quSetUpString.charAt(4);
//			secondNo = (int) (secondChar)  - 48;
			secondNo = QSFUtils.getAsciiInt("" + secondChar);
		}




		if (secondNo < 2){//quiX0 or quiX1 new state???
			//set player; position string to follow
		} else {
			/*
			 * any string reaching here instructs the game engine
			 * to start from the beginning, thus it should
			 * make a new currentState and initialising it!
			 * TODO maybe a new gameState for all new setUpStrings??
			 * then: first thing ...
			 */
			currentState = new QuiGameState();
			//initialising the rule params in State:

			if(firstNo != versionInt || secondNo != variantInt){
				System.out.println("resetting rules!");
				/*
				 * TODO rule setting double
				 * needed to sort error
				 * must be more elegant way!
				 */

				versionInt = firstNo;
				//first too to avoid error!
				QuiRules.setRuleParameters(firstNo);
				variantInt = secondNo;
				QuiRules.setSizeParameters(secondNo);
//				QuiRules.setRuleParameters(firstNo);


			}
			currentState.initGameState();
			QuiGraphics.setNumberOfSizes(QuiRules.numSizes);//inside the above if?
			System.out.println("presentRuleVersion is " + QuiRules.ruleVersion);

		}

	}
	public void receivePlyPosition(QPlyPosition plypos){
		//move to state as soon as receivePlyArray is migrated!
		receivePurePlyString(plypos.purePlyString, plypos.zeroplyBrake);
		//incorporate translation into plypos! and call receivePlyArray directly!
	}
	public void receivePurePlyString(String plyPureString){
		//overloaded
		receivePurePlyString(plyPureString,false);//assuming brake false default
	}

	public void receivePurePlyString(String plyPureString, boolean brake){//state if brake?
		int length = plyPureString.length();
		int[] plyArray = new int[length/2]; //since each ply has two coords
		for (int i = 0; i < length/2; i++){
			char hexChar1 = plyPureString.charAt(i*2);
			char hexChar2 = plyPureString.charAt(i*2 + 1);
			//here make alexian out of hexChars
			plyArray[i] = QSFUtils.hexCharsToLoc(hexChar1, hexChar2);
			}
		receivePlyArray(plyArray, brake);
		//i.e. normally brake is not requested, but if so (upButton)
		//it overrides line.brake!
	}



	//TODO combine these in QPly/LocPosition with start notationX,Y formulas
//	public void receiveLocString(String locString){
//
//		//state?
//		int length = locString.length();
//		int[] plyArray = new int[length/2]; //since each loc has two coords
//		for (int i = 0; i < length/2; i++){
//			char hexChar1 = locString.charAt(i*2);
//			char hexChar2 = locString.charAt(i*2 + 1);
//			//here make alexian out of hexChars
//			plyArray[i] = currentState.hexCharsToLoc(hexChar1, hexChar2);
//			}
//		currentState.receiveLocArray(plyArray);
//	}

	public void receivePlyArray(int[] p){
		//overloaded ...
		receivePlyArray(p, false);//assuming brake false default
	}

	public void receivePlyArray(int[] p, boolean brake){
		//cropcheck is space?
		//move to state, put flag for crop check and do in space
		//alos rewind turn?

//		autoRelease = true;//test taking away
		int length = p.length;
		//always start with clearing all releasing left!
		//TODO test this?
		while (currentState.zeroPlyDestination > 0){
			//System.out.println("releaseDestLoop is running");
			currentState.receiveLoc(currentState.zeroPlyDestination);
		}
		for (int i = 0; i < length; i++){

			currentState.receiveLoc(p[i]);
//			//TODO I don't believe in this ...
//			//nope qui357585888899aaaa is a test string from v0.4
			cropCheck();//in case old qustrings are not cropped properly
			if (i < (length - 1) || !brake || currentState.buildLocString) {
				//any of the above fulfills the releasing!
				while (currentState.zeroPlyDestination > 0)
					currentState.receiveLoc(currentState.zeroPlyDestination);
			}
			//
//			if(currentState.failedControlTest){
//			if(currentState.failedControlTest){
//				//no need to complete releasing to test for immunity ...
//				rewindTurnImmunity();
//				break;
//			}
			if (isIFRBreakAhead()) {
				rewindTurn();
				break;
			}
		}
	}

	public boolean isIFRBreakAhead(){
		/*
		 * this tests state ahead with no brake ...
		 * it returns true if IFR break
		 */
		stateAhead = new QuiGameState();
		stateAhead.initGameState();
		stateAhead.receiveLocArray(currentState.getLocArray(), false);
		//System.out.println("stateAhead.controlPassInt is " + stateAhead.controlPassInt);
		//TODO send something that will release all if necessary
		//before testing for IFR break, win? (=winAhead!), pass?
//		System.out.println("stateAhead.failedControlTest is " + stateAhead.failedControlTest);
		return stateAhead.failedControlTest;
	}


	public void ledgeDishing(int pieceSize, int pieceColour) {//state

	}



	///NEW GENERATION
	public synchronized QGameStatus getGameStatus(){
		/*
		 * here the status report from currentStatus is passing thru
		 * and get filled up with info from GameLine and GameSpace
		 */
		//System.out.println("currentLine.forwardStepAvailable() is " + currentLine.forwardStepAvailable());
		//System.out.println("(releaseDestination > 0) is " + (releaseDestination > 0));
		QuiGameStatus stateStatus = new QuiGameStatus();//needed??
		stateStatus = currentState.getGameStatus();
		stateStatus.setForwardAvailable(currentLine.forwardStepAvailable() || (currentState.zeroPlyDestination > 0));
		stateStatus.setBackwardAvailable(currentLine.backStepAvailable());
		//System.out.println("stateStatus.forwardAvailable is " + stateStatus.forwardAvailable);

		if (QuiRules.irreversibilityUser && stateStatus.mayPass)
			stateStatus.setMayPass(passLegality());



		//these two are very transitional and will break when migrating:
		//when migrating, set version initially in GameState.getGameStatus()
		stateStatus.setGameVersion(QuiRules.ruleVersion);
		stateStatus.setGameVariant(QuiRules.numSizes);

		return stateStatus;
	}

	public synchronized boolean[] getLegalOptions(){
		/*
		 *  passLegality() is built on this method too ...
		 */

		//TODO send plyString to include releasing before test!

//		System.out.println("getLegalOptions() is run");
//		boolean[] legalOptions = currentState.getOptions();	//this assigns it
		//TODO try getLegalOption() if works like cloning?
		boolean[] legalOptions = (boolean[]) currentState.getOptions().clone();

		/*
		 * by cloning, state.options are kept separate:
		 * even though the GUI doesn't show option, state will accept
		 * it and throw an irreversibility message in linedata and statusbar
		 * by not cloning, state will not accept illegal input ...
		 */

		//here insert an if clause that stops the check if
		//no IR and if placing or before first leg, or only one ply?

		if ((!QuiRules.irreversibility &&
				(currentState.mayMove ||
						currentState.mayPlaceHome ||
						currentState.mayPlaceLedge))
				|| currentState.zeroPlyDestination > 0){
			/*
			 * so, don't run legal test on options if a zeroPly situation, or
			 * if no IR & placing or before move.
			 */
//			System.out.println("legal exceptions clause is run");
			return legalOptions;
		}

		//TODO make one boolean or integer to indicate "before move"

		int[] locArray = currentState.getLocArray();
		int legalCount = 0;
		for (int i = 0; i < 169; i++){
			if(legalOptions[i]){
//				System.out.println("space.getlegalOptions() is checking " + i);
				QuiGameState legalCheckState = new QuiGameState();
				legalCheckState.initGameState();
				legalCheckState.receiveLocArray(locArray);
				legalCheckState.receiveLoc(i, false);
				//false instructs state to complete any releasing after
				//having processed the loc
				if(legalCheckState.failedControlTest){
					legalOptions[i] = false;
				} else {
					legalCount++;
				}

			}
		}
		//multiply legal counts to match space?
//		System.out.println("legalCount is " + legalCount);
		if (legalCount == 0) {
			//uh oh! ????

		}
//		System.out.println("getLegalOptions() is ended");
		stringReport();
		return legalOptions;
	}

	public boolean passLegality(){
		//only call this if Old IR rule is active!
		System.out.println("passLegality is run");
		int[] locArray = currentState.getLocArray();
		QuiGameState legalCheckState = new QuiGameState();
		legalCheckState.initGameState();
		legalCheckState.receiveLocArray(locArray);
		legalCheckState.receiveLoc(84, false);//pass is loc=84
		//false asks to complete releasing before testing
		return !legalCheckState.failedControlTest;
	}

	public void modifyRules(boolean[] userRules){
		/*
		 * TODO Bug
		 * must re-evaluate the string if basic rule changes!!
		 *
		 * Note, to switch a position into positionEditor mode,
		 * extract position string then switch!
		 * No use to have a gamestate in posEdit mode full
		 * of history strings ...
		 * TODO should the game line be new too?? in Line ...
		 */

		QuiRules.setUserRules(userRules);

//		if (ruleName.equals("immunityRule")){
//			currentRules.setImmunity(ruleState);
//		}
//		if (ruleName.equals("irreversibilityRule")){
//			currentRules.setIrreversibility(ruleState);
//		}
		//start again:
		currentState = new QuiGameState();
		currentState.initGameState();
		//maybe just send the original string again?
//		String currentQuString = currentLine.setUpString + currentLine.markedPlyString;
//		receiveQuString(currentQuString);
//		currentLine.setLocString(currentState.locString);
//		stringReport();
	}

	//detective work
	public void stringReport(){

//		System.out.println("");
//		System.out.println("currentState.getLocPos() is " + currentState.getLocPos() + " & currentState.locString is:");
//		System.out.println(currentState.locString);
//		System.out.println("currentState.getPlyPos() is " + currentState.getPlyPos() + " & currentState.plyString is:");
//		System.out.println(currentState.plyString);
//
//		System.out.println();
//		System.out.println("currentLine.locPos is " + currentLine.locPos + " & currentLine.locString is:");
//		System.out.println(currentLine.locString);
//		System.out.println("currentLine.plyPos is " + currentLine.plyPos + " & currentLine.getPurePlyString() is:");
//		System.out.println(currentLine.getPurePlyString());
//		System.out.println("currentLine.markedPlyString is ");
//		System.out.println(currentLine.markedPlyString);
//
//		System.out.println();
//		if(currentLine.forwardStepAvailable())
//			System.out.println("currentLine.getStepLocString(1) is " + currentLine.getStepLocString(1));
//		if (currentLine.backStepAvailable())
//			System.out.println("currentLine.getStepLocString(-1) is " + currentLine.getStepLocString(-1));

//		System.out.println("currentLine.isSealed is " + currentLine.isSealed);
//		System.out.println("currentLine.addBranchToMatchInfo is " + currentLine.addBranchToMatchInfo);
//		System.out.println("currentLine.getMatchInfo() is " + currentLine.getMatchInfo());

//		System.out.println("");
//		System.out.println("currentState.immunePieces[60] is " + currentState.immunePieces[60]);
//		System.out.println("currentState.immunePiecesToBe[60] is " + currentState.immunePiecesToBe[60]);
//		System.out.println("currentState.immunePieces[34] is " + currentState.immunePieces[34]);
//		System.out.println("currentState.immunePiecesToBe[34] is " + currentState.immunePiecesToBe[34]);

		// or || currentState.hasIllegalPlies: need to store these after first run!
		if(currentLine.hasRedundantPlies){
			System.out.println("currentLine.markedPlyString has redundant or illegal plies - clean it!! ");
			System.out.println("");
		}


	}
}
