/*
**********************************************************************
*                        License Notice
*
* QuiDrawingPanel.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.*;
import com.quincala.core.*;

public class QuiDrawingPanel extends QuincalaBoardPanel {
	/*
	 * this is obsolete but for the grid lines;
	 * try to get this working properly with the extension
	 * not a priority for 0.6!!
	 */

//	double[][] lineDef = {
//	//{0.00, 0.00, 1.0, 0.00, 0.66666, 2.00, 0.00, 2.00},//change 2 & 4 only
//	{0.622, 1.117, 0.689, 1.60, 0.429, 2.0, 0.0, 2.0},//first approximation
//	{0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.00, 1.00},
//	{0.00, 6.00, 0.47, 6.00, 0.53, 0.00, 1.00, 5.00},
//	{1.00, 5.00, 1.47, 0.00, 1.53, 0.00, 2.00, 5.00},//control 3 segments
//	{2.00, 5.00, 2.30, 5.00, 2.6, 0.0, 2.80, 4.60},//4. wave lft
//	{0.0, 0.0, 0.0, 4.80, 2.9, 4.90, 3.00, 5.00},//5. wave rght
//	{3.00, 5.00, 0.0, 0.0, 0.0, 0.0, 4.00, 5.00},
//	{4.00, 5.00, 0.0, 0.0, 0.0, 0.0, 5.00, 5.00},
//	};
//	double[][] xpandLn = new double[64][8];
//	double[][] ln = new double[64][8];

	//zooming:
//	public int centerSqXCoord = 3; //6 is middle of board
//	public int centerSqYCoord = 1;//as in notation direction!
//	public double radiusSeen = 7;//make int and unit centisquare?
	//normal: radius seen: 6.5 or 7;
	//for centre work: 6,5,1; south gate: 6,1,0.5; wave: 8,1,0.5
	//full centre: 6,6,1.8, full line segment: 8,1,1.7
	//small petal 7,5,-0.1

	public boolean showGrid = true;
	public boolean showDiamonds = true;
	public boolean showBezierPolygons = false;
	public boolean toPrint = false;
	//public boolean calcFirstLine = false;//swap first line above ...

	//set a stroke!

    private BasicStroke ornLineStroke = new BasicStroke(2.0f);
    private BasicStroke whiteDiamStroke = new BasicStroke(2.0f);

	/*
	 * stroke should go up with scale
	 * unit = 0 or 1 -> 1.0f
	 * unit 6 -> 2.0f?
	 * 7.0f is good with unit = 25?
	 * 2.0f is good with unit = 4?
	 */
    //other type of stroke:
	final static float dash1[] = {5.0f};
    final static BasicStroke dashed = new BasicStroke(2.0f,
                                          BasicStroke.CAP_BUTT,
                                          BasicStroke.JOIN_MITER,
                                          10.0f, dash1, 0.0f);

//    final static BasicStroke ornLineStroke = new BasicStroke(3.0f,
//    											 BasicStroke.CAP_BUTT,
//    											 BasicStroke.JOIN_MITER);

//	public int boardPanelSize = 0;//to force initial setDrawSizes
//	public int unit = 4; //this determines the size of everything drawn,
//	//and sets the following in the method setDrawSizes():
//	public int core;//this is the vertical core of a stack, to fit it into a square ...
//	public int margin; // is the margin round a tower to the square
//	public int pdiff; // this is how much the pieces differ in size each side, same as unit for 5 size variants
//	public int xLargestPiece; // the x coordinate for the largest piece in play (half the width of the largest pieces)
//	public int ss; // size of an individual square, is always odd!
//	public int ds; // this is the size of the black diamonds
//	public int tds; //this is the size of the turned black diamond
//	public int ts; // this is the size of the turn indicator
//	public int CDs; // this is the size of the CD buttons
//	public int numberOfSizes;//this is how many sizes are in play - set in quincala.current
//	public int smallestSize; //derived from numberOfSizes
//	public int pthick; // this is how thick the individual pieces are
//
//	public int pwide; // this is half the width of the largest piece
//	public int xTop = 0; // should be more than squaresize!
//	public int yTop = 0;
//
//
//
//	QuiBoardGraphics boardGraphics = new QuiBoardGraphics();

	//public int panelGap;
	public void init(){
//    expandOrnLineDef();//this is init only!
	}


	public void paint(Graphics g){//why paintComponent?

		Graphics2D g2d = (Graphics2D) g;//use for gradients etc?


		int ht = this.getHeight();
		int wd = this.getWidth();
		int sizeCandidate = ht;
		if (wd < ht)
			sizeCandidate = wd;

		if (sizeCandidate != boardPanelSize){
			boardPanelSize = sizeCandidate;
			System.out.println("New boardPanelSize is " + boardPanelSize);
//			update scale if new panel size:
			updateBoardImage();
		}


		if (toPrint){
			g2d.setColor(Color.WHITE);
		} else {
			g2d.setColor(Color.YELLOW);
		}
		g2d.fillRect(0,0,wd,ht);


		//first draw pieceSquares like gloife:

		if (showGrid){
			g2d.setColor(new Color(220,220,220));
			for (int x = 0; x < 13; x++){
				for (int y = 0; y < 13; y++){
					//vertical:
					g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ x * ss, (y * ss) + yTop+ ss-1);
					//horizontal:
		            g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ (x * ss) + ss-1, yTop+ y * ss);
		            //also cross hairs:
		            //up
		            g2d.drawLine(xTop+ x * ss, (y * ss) + yTop+ ss, xTop+ (x * ss) + ss, yTop+ y * ss);
					//down
		            g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ (x * ss) + ss-1, (y * ss) + yTop+ ss-1);


				}
			}
			g2d.drawLine(xTop, yTop + 13*ss, xTop + (13*ss), yTop + 13 * ss);
			g2d.drawLine(xTop + (13*ss), yTop, xTop + (13*ss), yTop + 13 * ss);


		}

		if (showDiamonds){
			g2d.setColor(new Color(180,180,180));
			for (int x = 0; x < 13; x++){
				for (int y = 0; y < 13; y++){

					int loc = boardGraphics.location(x,y);
					int xMid = (int) (xTop + (x + 0.5) * ss) +1; //need casting!
					int yMid = (int) (yTop + (y + 0.5) * ss) + 1;


					//here diamonds are drawn on top
					if (boardGraphics.hasStandardBlackDiamond(loc)) {
						for (int i = 0; i <= ds; i++) {
							g2d.drawLine(xMid + ds - i, yMid + i, xMid - ds + i,
									yMid + i);
							g2d.drawLine(xMid + ds - i, yMid - i, xMid - ds + i,
									yMid - i);
						}
					}

					if (boardGraphics.hasTurnedBlackDiamond(loc)) {
						g2d.fillRect(xMid - tds, yMid - tds, 2 * tds, 2 * tds);
					}

					if (boardGraphics.hasWhiteDiamond(loc)) {
						//use same stroke as ornamental lines?
						g2d.setStroke(whiteDiamStroke);
						g2d.drawLine(xMid - 2 * tds, yMid, xMid, yMid - 2 * tds);//from left /
						g2d.drawLine(xMid - 2 * tds, yMid, xMid, yMid + 2 * tds);//from left \
						//g2d.setStroke(new BasicStroke(3.0f));
						g2d.drawLine(xMid + 2 * tds, yMid, xMid, yMid - 2 * tds);//from right \
						g2d.drawLine(xMid + 2 * tds, yMid, xMid, yMid + 2 * tds);//from right /
						g2d.setStroke(new BasicStroke(1.0f));


					}
				}
			}
		}


		//define stroke

	    g2d.setStroke(ornLineStroke);//as above


		//how to make bezier curve/cubic curve
//		 create new CubicCurve2D.Double
//		CubicCurve2D c = new CubicCurve2D.Double();
////		 draw CubicCurve2D.Double with set coordinates
////		c.setCurve(x1, y1, ctrlx1,
////				  ctrly1, ctrlx2, ctrly2, x2, y2);
//		c.setCurve(400, 400, 450, 400, 435,
//				  335, 500, 300);
//		g2d.draw(c);

		for (int i=0; i < 64; i++){
			//g2d.setColor(Color.black);
			g2d.setColor(new Color(180,180,180));
			CubicCurve2D orn = new CubicCurve2D.Double();
			orn.setCurve(ln[i][0], ln[i][1], ln[i][2], ln[i][3], ln[i][4],
					ln[i][5], ln[i][6], ln[i][7]);
			g2d.draw(orn);
//	        g2d.fill(new Arc2D.Double(x, y, rectWidth, rectHeight, 90,
//          135, Arc2D.OPEN));


		}

		if (showGrid){
			g2d.setColor(new Color(120,120,120));
			for (int x = 0; x < 13; x++){
				for (int y = 0; y < 13; y++){
					//vertical:
					g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ x * ss, (y * ss) + yTop+ ss-1);
					//horizontal:
		            g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ (x * ss) + ss-1, yTop+ y * ss);
		            //also cross hairs:
		            //up
		            g2d.drawLine(xTop+ x * ss, (y * ss) + yTop+ ss, xTop+ (x * ss) + ss, yTop+ y * ss);
					//down
		            g2d.drawLine(xTop+ x * ss, yTop+ y * ss, xTop+ (x * ss) + ss-1, (y * ss) + yTop+ ss-1);


				}
			}
			g2d.drawLine(xTop, yTop + 13*ss, xTop + (13*ss), yTop + 13 * ss);
			g2d.drawLine(xTop + (13*ss), yTop, xTop + (13*ss), yTop + 13 * ss);


		}

		for (int i=0; i < 64; i++){
			if (showBezierPolygons){
				g2d.setColor(Color.blue);
				for (int k = 0; k < 6; k +=2){
					g2d.drawLine((int) ln[i][0 + k], (int) ln[i][1 + k], (int) ln[i][2 + k], (int) ln[i][3 + k]);
				}

			}
		}



	}



//	public void setDrawSizes() { //seriously random!!!
//		// here the sizes of the board are set initially
//		// all relating to squaresizes and numSizes (from Q2DGrid Class)
//
//
//		numberOfSizes = 5;
//		smallestSize = 5;//or 16?
//		core = 3;//1 fits perfectly into square; increase to widen the top piece - always odd!
//		margin = 3;
//
//		//centre board on panel:
//		if (radiusSeen >= 6.5 || radiusSeen <= -0.5){ //normal board
//			unit = (int) (boardPanelSize/13 - margin * 2 - core)/10;
//			ss = margin * 2 + unit * 10 + core;
//			int boardSize = ss * 13;
//			xTop = (boardPanelSize - boardSize) / 2;
//			yTop = xTop;//for now ...
//		} else {
//			unit = (int) (boardPanelSize/(2 * radiusSeen + 1) - margin * 2 - core)/10;
//			ss = margin * 2 + unit * 10 + core;
//			xTop = (int) ((2 * radiusSeen + 1 - centerSqXCoord * 2 - 1) * ss /2);
//			yTop = (int) ((2 * radiusSeen + 1 - (12 - centerSqYCoord) * 2 - 1) * ss /2);
//		}
//		//unit is 1-6 on my screen
//		System.out.println("unit is " + unit);
//		System.out.println("squareSize is " + ss);
//
//		//set strokes here:
////		ornLineStroke = new BasicStroke(2.0f);
////		whiteDiamStroke = new BasicStroke(2.0f);
//
//
//
//
////		expandOrnLineDef();//this is init only!
//		//finally, scale the ornamental lines and relate to x,yTop
//		//this is new size only:
//		for (int k = 0; k < 64; k++){
//			for (int i = 0; i < 8; i++){
//				if (i % 2 == 0){ //x-coordinate
//					ln[k][i] = xpandLn[k][i] * ss + xTop;
//				} else {
//					ln[k][i] = xpandLn[k][i] * ss + yTop;
//				}
//			}
//		}
//
//
//
//		pdiff = unit * 5 / numberOfSizes; // this is how much the pieces differ in size each side
//		pthick = unit*2 + 1; //piece thickness; the + 1 allows for a core of the piece, enabling centering
//		xLargestPiece = pdiff * numberOfSizes + core - 1;
//		ds = unit; // this is the size of the black diamonds, usually 3, but try unit ...
//		tds = ds * 7 / 10 + 1;//round up by + 1
//		//tds = size of turned black diamond & half white diamond: 7/5 is approx SQRT(2)???
//		ts = unit*3; // this is the size of the turn indicator, experiment
//		//CDs = unit*2; // this is the size of the CD buttons, usually square size/5
//
//	}

//	public void expandOrnLineDef(){
//		//firstly put let the lines follow input on 0,2 and 0,4:
//
//		if (lineDef[0][0] == 0){ //starts at origo, so calculate!
//			lineDef[0][3] = lineDef[0][2];
//			lineDef[1][3] = lineDef[0][2];
//			lineDef[1][4] = 1 - lineDef[0][4] / 2;
//			lineDef[1][5] = 1 + lineDef[0][4] / 2;
//		} else { //there is no complete first line to calculate ...
//			//make the small petal the first line?
//			lineDef[1][3] = 1;
//			lineDef[1][4] = (double) 2/3;
//			lineDef[1][5] = (double) 4/3;
//		}
//
//		//first segment second control point must be 45
//		lineDef[2][5] = 6 - lineDef[2][4];
//
//		//this is giving a lot of control to [3][2] and [3][4]
//		//postulating the identity of segments 3, 6 & 7
//		double verticalParam = lineDef[3][2] - 1;
//		double horizontParam = 2 -lineDef[3][4];
//		lineDef[3][3] = 5 - verticalParam;//1.4 -> 4.6
//		lineDef[3][5] = 5;
//
//		lineDef[6][2] = 3 + verticalParam;
//		lineDef[6][3] = 5 + verticalParam;
//		lineDef[6][4] = 4 - horizontParam;
//		lineDef[6][5] = 5;
//		lineDef[6][6] = 4;
//		lineDef[6][7] = 5;
//
//		lineDef[7][2] = 4 + horizontParam;
//		lineDef[7][3] = 5;
//		lineDef[7][4] = 5 - verticalParam;
//		lineDef[7][5] = 5 + verticalParam;
//
//		//this assumes that the wave tip is 90�, and the means
//		//to that is horizontal control point 2 for wave left
//		//and vertical for wave right
//		lineDef[4][5] = lineDef[4][7];
//
//		lineDef[5][0] = lineDef[4][6];
//		lineDef[5][1] = lineDef[4][7];
//		lineDef[5][2] = lineDef[4][6];
//		lineDef[5][5] = lineDef[5][4] + 2;
//
//		//this puts the makes point 8,1 equal both sides ...
//		lineDef[4][2] = 2 + horizontParam;
//
//		//good to print the values ...
//		System.out.println("These are the final values defining the lines:");
//		for (int k = 0; k < 8; k++){
//			for (int i = 0; i < 8; i++){
//				System.out.print(lineDef[k][i] + " ");
//			}
//			System.out.println();
//		}
//		System.out.println();
//
//
//
////		filling the ornamental lines
//		//0. load the original 8 defining lines into xpandLn
//		for (int k = 0; k < 8; k++){
//			for (int i = 0; i < 8; i++){
//				xpandLn[k][i] = lineDef[k][i];
//			}
//		}
//
//		//1. set x = -x to make 16
//		for (int k = 0; k < 8; k++){
//			for (int i = 0; i < 8; i++){
//				if (i % 2 == 0){ //x-coordinate
//					xpandLn[k + 8][i] = - xpandLn[k][i];
//				} else {
//					xpandLn[k + 8][i] = xpandLn[k][i];
//				}
//			}
//		}
//		//1. set y = -y to make 32
//		for (int k = 0; k < 16; k++){
//			for (int i = 0; i < 8; i++){
//				if (i % 2 == 0){ //x-coordinate
//					xpandLn[k + 16][i] = xpandLn[k][i];
//				} else {
//					xpandLn[k + 16][i] = - xpandLn[k][i];
//				}
//			}
//		}
//
//		//3. mirror x to y to make 64
//		for (int k = 0; k < 32; k++){
//			for (int i = 0; i < 8; i++){
//				if (i % 2 == 0){ //x-coordinate
//					xpandLn[k + 32][i] = xpandLn[k][i + 1];
//				} else { //y-coordinate
//					xpandLn[k + 32][i] = xpandLn[k][i - 1];
//				}
//			}
//
//		}
//
//
//		//4. put into middle
//		for (int k = 0; k < 64; k++){
//			for (int i = 0; i < 8; i++){
//				xpandLn[k][i] = xpandLn[k][i] + 6.5;
//			}
//		}
//	}


}
