/*
**********************************************************************
*                        License Notice
*
* QuTranslator.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

//import java.lang.String;
import java.util.HashMap;
//import net.looseswede.QuUtils.QuCalc;


public class QuTranslator extends QuCalc {

	/*
	 * WARNING: the characters in quChar, and all other string/char
	 * related operations will change when the system develops: Use
	 * With Caution.
	 *
	 * this holds the arrays (later hashmaps?) for the diverse
	 * nomenclatures and representations, as well as
	 * formulas for connecting group strings (e.g. EdA) to piece bytes
	 */

	public String[] validHeadFirsts = {"0", "1", "2", "3", "4", "6"};
	public String[] validHeadTwoFirsts = {
		"00", "01",
		"10", "11", "13",
		"20", "21", "23", "24", "25",
		"30", "31", "33", "34", "35",
		"40", "41", "45",
		"40", "61", "63"};


	//private QuCalc calc = new QuCalc();



//	//obsolete
//	public HashMap quCharMap = new HashMap(169);
//	//obsolete
//	public char[] quChar = {
//			'0','1','1','1','1','1','A','0','0','0','0','0','0',
//			'0','B','C','D','E','F','G','H','I','J','K','L','1',
//			'0','M','N','O','P','Q','R','S','T','U','V','W','1',
//			'0','X','Y','Z','a','b','c','d','e','f','g','h','0',
//			'0','i','j','k','l','m','n','o','p','q','r','s','0',
//			'0','t','u','v','w','x','3','y','z','�','�','�','0',
//			'�','�','�','�','�','5','0','6','�','�','�','�','�',
//			'0','�','�','�','�','�','4','�','�','�','�','�','0',
//			'0','�','�','�','�','�','�','�','�','�','�','�','0',
//			'0','�','�','�','�','�','�','�','�','�','�','�','0',
//			'2','�','�','�','�','�','�','�','�','�','�','�','0',
//			'2','�','�','�','�','�','�','�','�','�','�','�','0',
//			'0','0','0','0','0','0','�','2','2','2','2','2','0'
//	};

	//obsolete
	public int[] quCharAsciiNo = {
			48,49,49,49,49,49,65,48,48,48,48,48,48,
			48,66,67,68,69,70,71,72,73,74,75,76,49,
			48,77,78,79,80,81,82,83,84,85,86,87,49,
			48,88,89,90,97,98,99,100,101,102,103,104,48,
			48,105,106,107,108,109,110,111,112,113,114,115,48,
			48,116,117,118,119,120,51,121,122,162,163,164,48,
			165,167,181,192,193,53,48,54,194,195,196,197,198,
			48,199,200,201,202,203,52,204,205,206,207,208,48,
			48,209,210,211,212,213,214,216,217,218,219,220,48,
			48,221,222,223,224,225,226,227,228,229,230,231,48,
			50,232,233,234,235,236,237,238,239,240,241,242,48,
			50,243,244,245,246,248,249,250,251,252,253,254,48,
			48,48,48,48,48,48,255,50,50,50,50,50,48
	};
	//obsolete
	public int[] quCharLocNo = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,5,163,71,97,83,85,0,0,0,0,0,0,0,0,0,
			0,6,14,15,16,17,18,19,20,21,22,23,24,27,28,29,
			30,31,32,33,34,35,36,37,40,41,42,0,0,0,0,0,
			0,43,44,45,46,47,48,49,50,53,54,55,56,57,58,59,
			60,61,62,63,66,67,68,69,70,72,73,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,74,75,76,78,0,79,0,0,0,0,0,0,0,0,
			0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,
			81,82,86,87,88,89,90,92,93,94,95,96,98,99,100,101,
			102,105,106,107,108,109,110,0,111,112,113,114,115,118,119,120,
			121,122,123,124,125,126,127,128,131,132,133,134,135,136,137,138,
			139,140,141,144,145,146,147,0,148,149,150,151,152,153,154,162
	};
	//valid!
	public String[] humanLoc = {
			"F","B05","B04","B03","B02","B01","025","F","F","F","F","F","F",
			"F","030","029","028","027","026","125","024","023","022","021","020","B06",
			"F","031","130","128","127","126","225","124","123","122","120","019","B07",
			"F","032","132","230","227","226","325","224","223","220","118","018","F",
			"F","033","133","233","330","326","425","324","320","217","117","017","F",
			"F","034","134","234","334","430","n","420","316","216","116","016","F",
			"035","135","235","335","435","w","T","o","415","315","215","115","015",
			"F","036","136","236","336","400","s","410","314","214","114","014","F",
			"F","037","137","237","300","304","405","306","310","213","113","013","F",
			"F","038","138","200","203","204","305","206","207","210","112","012","F",
			"W07","039","100","102","103","104","205","106","107","108","110","011","F",
			"W06","000","001","002","003","004","105","006","007","008","009","010","F",
			"F","F","F","F","F","F","005","W01","W02","W03","W04","W05","F"
	};

	public boolean validFirst(String firstChar){
//		boolean result = false;
//		int s = validHeadFirsts.length;
//		for (int i = 0; i < s; i++){
//			if (firstChar.equals(validHeadFirsts[i]))
//				result = true;
//
//		}
		return true;
	}
	//obsolete
//	public void makeQuCharArrays(){
//		for (int i = 0; i < 169; i++){
//			quCharAsciiNo[i] = (int) quChar [i];
//		}
//		for (int k = 0; k < 169; k++){
//			quCharLocNo[quCharAsciiNo[k]] = k;
//			//specify the multiple instances ones:
//			quCharLocNo[48] = 0; //char 0 returns 0
//			quCharLocNo[49] = 5; //char 1 returns 5
//			quCharLocNo[50] = 163; //char 2 returns 5
//		}
//
//		/*
//		 * the print procedures below are used to hardcode arrays
//		 * when the character array quChar is changed ...
//		 */
//
//		System.out.println("printing quCharAsciiNo");
//		for (int y = 0; y < 13; y++){
//			for (int x = 0; x < 13; x++){
//				int i = y * 13 + x;
//				System.out.print(quCharAsciiNo[i] + ",");
//			}
//			System.out.println();
//		}
//		System.out.println();
//
//
//		System.out.println("printing quCharLocNo");
//		for (int y = 0; y < 16; y++){
//			for (int x = 0; x < 16; x++){
//				int i = y * 16 + x;
//				System.out.print(quCharLocNo[i] + ",");
//			}
//			System.out.println();
//		}
//	}

//	public void initQuCharMap(){ //if hashmap used ...
//		//for 169, add as below
////		map.put("a", new Integer(1));
////	    map.put("b", new Integer(2));
////	    map.put("c", new Integer(3));
//
//	}



	public String groupString(byte P, byte C){
		String group = "";
		byte mask = 1;
		for (int k = 0; k < 5; k++) {
			if(isPresent(mask,P)){
				if(isWhite(mask,C)){
					group = group + (char) (69 - k);
				}else{
					group = group + (char) (101 - k);
				}
			}
			mask *=2;
		}
		return group;
	}

	public byte[] stackBytesFromString(String group){
		byte stack = 0;
		byte blacks = 0;
		int g = group.length();
		for (int i = 0; i < g; i++){
			char charAtI  = group.charAt(i);

		}
		System.out.println("make formula!!");
		//TODO make formula! stacks[0] is stack and stack[1] is blacks ...
		//

		byte[] stacks = {stack,blacks};
		return stacks;
	}






}
