/*
**********************************************************************
*                        License Notice
*
* QuStartPositions.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.gamequincala;

//import java.util.Scanner;
//for testing

public class QuStartPositions {

	/*
	 * this class holds all info about the default starting positions
	 * and the method to choose one according to rule variant.
	 * The starting position object is created in QuRules
	 * Try storing the start position as string (or as formula)
	 * then create the array from an instance of non-initiated gameState!
	 * Any starting position could be dealt with like this; always having
	 * the starting position arrays in currentRules!
	 */

	//TODO update these with StringConverter!!
	public String sq03 = "708090a0708090a0708090a0708090a0708090a0708090a0";
	public String sq04 = "708090a0708090a0708090a0708090a0708090a0708090a0708090a0708090a0";
	public String sq05 = "708090a0708090a0708090a0708090a0708090a0708090a0708090a0708090a0708090a0708090a0";
	public String sq33 = "625575266344843633936446625575266344843633936446";
	//public String sq33 = "6a57772669488836399968466a5777266948883639996846";//new
	//test as qp..., convert as i<2??
	public String sq34 = "61557516624484263363933622a2644661557516624484263363933622a26446";
	public String sq35 = "60557506614484166233932622a2633611b1644660557506614484166233932622a2633611b16446";
	public String sq45 = "61448416418114b46233932622a26336319113b361448416418114b46233932622a26336319113b3";
	public String sq53 = "21a112b2418114b45171641621a112b2418114b451716416";
	public String sq65 = "418114b4614484166233932622a26446319113b3418114b4614484166233932622a26446319113b3";


	//All of below arrays will be obsolete

	public byte[] stacksStartPos = new byte[169];
	public byte[] blacksStartPos = new byte[169];

	public byte[] stacksStartPos03 = {
			0,0,0,0,0,0,0,0,7,7,7,7,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,7,7,7,7,0,0,0,0,0,0,0,0

	};
	public byte[] blacksStartPos03 = {
			0,0,0,0,0,0,0,0,7,7,7,7,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};

	public byte[] stacksStartPos04 = {
			0,0,0,0,0,0,0,0,15,15,15,15,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,15,15,15,15,0,0,0,0,0,0,0,0
	};
	public byte[] blacksStartPos04 = {
			0,0,0,0,0,0,0,0,15,15,15,15,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};

	public byte[] stacksStartPos05 = {
			0,0,0,0,0,0,0,0,31,31,31,31,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,31,31,31,31,0,0,0,0,0,0,0,0
	};
	public byte[] blacksStartPos05 = {
			0,0,0,0,0,0,0,0,31,31,31,31,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};


	public byte[] stacksStartPos33 = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,4,0,0,2,0,0,4,0,0,0,
			0,0,0,0,2,0,4,0,2,0,0,0,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			0,0,1,2,4,0,0,0,4,2,1,0,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			0,0,0,0,2,0,4,0,2,0,0,0,0,
			0,0,0,4,0,0,2,0,0,4,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};
	public byte[] blacksStartPos33 = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,4,0,0,2,0,0,4,0,0,0,
			0,0,0,0,2,0,4,0,2,0,0,0,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			0,0,1,2,4,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};

	public byte[] stacksStartPos34 = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,8,0,0,0,2,0,0,0,8,0,0,
			0,0,0,4,0,0,4,0,0,4,0,0,0,
			0,0,0,0,2,0,8,0,2,0,0,0,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			0,1,2,4,8,0,0,0,8,4,2,1,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			0,0,0,0,2,0,8,0,2,0,0,0,0,
			0,0,0,4,0,0,4,0,0,4,0,0,0,
			0,0,8,0,0,0,2,0,0,0,8,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};
	public byte[] blacksStartPos34 = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,0,8,0,0,0,2,0,0,0,8,0,0,
			0,0,0,4,0,0,4,0,0,4,0,0,0,
			0,0,0,0,2,0,8,0,2,0,0,0,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			0,1,2,4,8,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};


	public byte[] stacksStartPos35 = {
			0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,16,0,0,0,0,2,0,0,0,0,16,0,
			0,0,8,0,0,0,4,0,0,0,8,0,0,
			0,0,0,4,0,0,8,0,0,4,0,0,0,
			0,0,0,0,2,0,16,0,2,0,0,0,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			1,2,4,8,16,0,0,0,16,8,4,2,1,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			0,0,0,0,2,0,16,0,2,0,0,0,0,
			0,0,0,4,0,0,8,0,0,4,0,0,0,
			0,0,8,0,0,0,4,0,0,0,8,0,0,
			0,16,0,0,0,0,2,0,0,0,0,16,0,
			0,0,0,0,0,0,1,0,0,0,0,0,0
	};

	public byte[] blacksStartPos35 = {
			0,0,0,0,0,0,1,0,0,0,0,0,0,
			0,16,0,0,0,0,2,0,0,0,0,16,0,
			0,0,8,0,0,0,4,0,0,0,8,0,0,
			0,0,0,4,0,0,8,0,0,4,0,0,0,
			0,0,0,0,2,0,16,0,2,0,0,0,0,
			0,0,0,0,0,1,0,1,0,0,0,0,0,
			1,2,4,8,16,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};


	public byte[] stacksStartPos45 = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,16,2,0,1,0,2,16,0,0,0,
			0,0,8,0,0,0,4,0,0,0,8,0,0,
			0,16,0,4,0,0,8,0,0,4,0,16,0,
			0,2,0,0,1,0,0,0,1,0,0,2,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,1,4,8,0,0,0,0,0,8,4,1,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,2,0,0,1,0,0,0,1,0,0,2,0,
			0,16,0,4,0,0,8,0,0,4,0,16,0,
			0,0,8,0,0,0,4,0,0,0,8,0,0,
			0,0,0,16,2,0,1,0,2,16,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};

	public byte[] blacksStartPos45 = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,16,2,0,1,0,2,16,0,0,0,
			0,0,8,0,0,0,4,0,0,0,8,0,0,
			0,16,0,4,0,0,8,0,0,4,0,16,0,
			0,2,0,0,1,0,0,0,1,0,0,2,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,1,4,8,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};

	public byte[] stacksStartPos53 = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,1,0,2,4,0,4,2,0,1,0,0,
			0,1,0,0,0,0,0,0,0,0,0,1,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,2,0,0,0,0,4,0,0,0,0,2,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,4,0,0,0,0,0,0,0,0,0,4,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,2,0,0,0,0,4,0,0,0,0,2,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,1,0,0,0,0,0,0,0,0,0,1,0,
			0,0,1,0,2,4,0,4,2,0,1,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};
	public byte[] blacksStartPos53 = {
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,1,0,2,4,0,4,2,0,1,0,0,
			0,1,0,0,0,0,0,0,0,0,0,1,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,2,0,0,0,0,4,0,0,0,0,2,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,4,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0
	};

public String getStartPosString(int rVersion, int nSizes){
		String startPosString = "";
		if (nSizes == 5){
			switch(rVersion){
			case 0:
				startPosString = sq05;
				break;
			case 2:
			case 3:
			case 1:
				startPosString = sq35;
				break;
			case 4:
				startPosString = sq45;
				break;
			case 6://actually only
				startPosString = sq65;
				break;
			}
		}
		if (nSizes == 4){
			switch(rVersion){
			case 0:
				startPosString = sq04;
				break;
			case 2:
			case 3:
			case 1:
				startPosString = sq34;
				break;
			}
		}
		if (nSizes == 3){
			switch(rVersion){
			case 0:
				startPosString = sq03;
				break;
			case 22:
			case 20:
			case 1:
			case 2:
			case 3:
			case 7:
				startPosString = sq33;
				break;
			case 5:
				startPosString = sq53;
				break;
			}
		}
		return startPosString;
	}

	public byte[] setStacksStartPos(int rVersion, int nSizes){

		if (nSizes == 5){
			switch(rVersion){
			case 0:
				stacksStartPos = stacksStartPos05;
				break;
			case 2:
			case 3:
			case 1:
				stacksStartPos = stacksStartPos35;
				break;
			case 4:
				stacksStartPos = stacksStartPos45;
				break;
			}
		}
		if (nSizes == 4){
			switch(rVersion){
			case 0:
				stacksStartPos = stacksStartPos04;
				break;
			case 2:
			case 3:
			case 1:
				stacksStartPos = stacksStartPos34;
				break;
			}
		}
		if (nSizes == 3){
			switch(rVersion){
			case 0:
				stacksStartPos = stacksStartPos03;
				break;
			case 22:
			case 20:
			case 1:
			case 2:
			case 3:
			case 7:
				stacksStartPos = stacksStartPos33;
				break;
			case 5:
				stacksStartPos = stacksStartPos53;
				break;
			}
		}
		return stacksStartPos;
	}

	public byte[] setBlacksStartPos(int rVersion, int nSizes){

		if (nSizes == 5){
			switch(rVersion){
			case 0:
				blacksStartPos = blacksStartPos05;
				break;
			case 2:
			case 3:
			case 1:
				//blacksStartPos = (byte[]) blacksStartPos35.clone();
				blacksStartPos = blacksStartPos35;
				break;
			case 4:
				blacksStartPos = blacksStartPos45;
				break;
			}
		}
		if (nSizes == 4){
			switch(rVersion){
			case 0:
				blacksStartPos = blacksStartPos04;
				break;
			case 2:
			case 3:
			case 1:
				blacksStartPos = blacksStartPos34;
				break;
			}
		}
		if (nSizes == 3){
			switch(rVersion){
			case 0:
				blacksStartPos = blacksStartPos03;
				break;
			case 22:
			case 20:
			case 1:
			case 2:
			case 3:
			case 7:
				blacksStartPos = blacksStartPos33;
				break;
			case 5:
				blacksStartPos = blacksStartPos53;
				break;
			}
		}
		return blacksStartPos;
	}

}
