/*
**********************************************************************
*                        License Notice
*
* QXLauncher.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

import java.awt.Desktop;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.io.IOException;

import javax.jnlp.*;

public class QXLauncher {

	/*
	 * This worked quite well until I try to
	 * launch from within a jar!
	 */

//	public static void main(File document) {
//		try{
//			open(document);
//		} catch (IOException e) {
//			System.out.println("Unable to get doc :" +e.getMessage());
//
//		}
//	}

	public static boolean openWS(String urlString){
		URL url = null;
		try {
			url = new URL(urlString);
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}

		if(url == null)
			return false;

		return openWS(url);
	}

	//JNLP open:
	public static boolean openWS(URL url){
		   // Method to show a URL
		try {
			// Lookup the javax.jnlp.BasicService object
			BasicService bs = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
			// Invoke the showDocument method
			return bs.showDocument(url);
		} catch(UnavailableServiceException ue) {
			// Service is not supported
			System.out.println("Error caught: Service is unavailable!");
			return false;
		}

	}

	public static void open(File document) throws IOException {
	    Desktop localSystem = Desktop.getDesktop();
	    localSystem.open(document);
	}

	public static void open(String onlineUrlString){
//		java.net.URL url = null;
//
//		try {
//			url = new URL(onlineUrlString);
//		} catch (MalformedURLException e) {
//			e.printStackTrace();
//		}




		URI uriTest = null;

		try {
//			uriTest = url.toURI();
			uriTest = new URI(onlineUrlString);
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		try {
			open(uriTest);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}


	private static void open(URI onLineDoc) throws IOException {

	    Desktop localSystem = Desktop.getDesktop();
	    if (Desktop.isDesktopSupported()){
	    	localSystem.browse(onLineDoc);
	    }
	}

//	public static void mail() throws IOException {
//	    Desktop localSystem = Desktop.getDesktop();
//	    localSystem.mail();
//	}


	//could test this too??
//	public static void mail(URI mailToURI) throws IOException {
//	    Desktop localSystem = Desktop.getDesktop();
//	    localSystem.mail(mailToURI);
//	}

}
