/*
**********************************************************************
*                        License Notice
*
* QWholeLineData.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;


public class QWholeLineData {

	/**
	 * this holds the general information that relates to the
	 * entire line; it is initiated in GameState, stored in
	 * GameLine and displayed on the InfoPanel in the GUI.
	 * this is in the core class; game specific data is stored
	 * in subclasses (eg golden rule info in QuiWholeLineInfo
	 */

	//start variables that kind of belongs to QuiWholeLineData:
	//private boolean goldenRuleHolds = false;
	private int goldenRuleFlag = -1;//only one needed
	//keep for future statistic engines ...
	//public String goldenRuleInfo = "";//obsolete - all English in this class


	public String gameName = "Quincala";
	public int GameVersion = 0;
	public int GameVariant = 0;

	public int controlPassInt = 0;
	//0 if pass, + 1 is IR fail, +2 is FR fail, +4 is IM fail ...

	//end QuiWholeLineData variables

	public String customString = "";//before the general info ...
	//rather than having to extend ...

	public String locString = "";
	//here store turnNO, win & GR once the brake problem is sorted ...
	public int TurnsInLine = 0;
	public int turnsOpened = 0;
	//public String turnCountString = "";//can't really get rid of this ...
	public int winnerInt = -1;
	public boolean isEndOfLine = false;//true even if not end of match!

	//public String turnPhaseString = "";//needs to initialise!!!
	//replace this with
	public int turnPhase = 0;
	public int player = 0;

	public boolean isSealed = false;//true means changes create new branch
	public int resignInt = -1;

	public String errorMessage = "";

	public String titleString = "";//players, date, event etc - as a heading
	//public int branchNo = 0;//branch pertaining to matchinfo!
	public String titleStringHtml = "";
	//same as above, but in html format; encoded in setTitleString!




//	start methods that kind of belongs to QuiWholeLineData:
public String iRMessage(){//start with space

		String iRInfo = "";
		//System.out.println("Data.controlPassInt is " + controlPassInt);
		int evalControlPassInt = controlPassInt;//since method is get not fetch!
		if(evalControlPassInt > 0){
			if (evalControlPassInt < 4){
				iRInfo = " The end position of the last turn breaks ";
				//maybe only use for evaluating qustrings?
			} else {
				iRInfo = " The last move breaks ";
			}


			if((evalControlPassInt & 4) > 0){
				iRInfo += "the Immunity Rule";
				evalControlPassInt -= 4;
				if(evalControlPassInt > 0)
					iRInfo += " and ";
			}


			if ((evalControlPassInt & 1) > 0){
				iRInfo += "the Irreversibility Rule";
				evalControlPassInt -= 1;
				if(evalControlPassInt > 0)
					iRInfo += " and ";
			}

			if ((evalControlPassInt & 2) > 0){
				iRInfo += "the Freedom Rule";
//				if(controlPassInt - 2 > 0)
//					iRInfo += " and the ";
			}




//			if (controlPassInt == 3)
//				iRInfo += "the Irreversibility Rule and the Freedom Rule";
//			if (controlPassInt == 2)
//				iRInfo += "the Freedom Rule";
//			if (controlPassInt == 1)
//				iRInfo += "the Irreversibility Rule";
//
//			if (controlPassInt == 4)
//				;


			iRInfo += "; therefore the whole " +
			"turn must be retaken and re-played differently in order " +
			"to produce a legal end position!";
		}
		return iRInfo;
	}

public String getFullGameName(){
	String fullName = gameName + " ";

    if(QGraphics.isMiniBoard)
    	fullName = "Mini " + fullName;

	switch(GameVersion){

	case 0:
		fullName += "Position Editor with " + GameVariant + " sizes";
		break;

	case 7:
		fullName += "Football";
		break;

	case 20:
		fullName += "Knocking Game";
		break;
	case 2:
		fullName += "Knocking Game with " + GameVariant + " sizes";
		break;

	case 3:
		fullName += "Standard Game with " + GameVariant + " sizes";
		break;

	case 4:
		fullName += "Bouncing Game";
		break;

	case 5:
		fullName += "Unlimited Game";
		break;
	case 22:
		fullName += "Mixing Game";
		break;
	case 1:
		fullName += "Mixing Game with " + GameVariant + " sizes";
		break;

	default:
		fullName += "Undefined variant";
		break;
	}

	//simple rules are not optional on mini board since placing
	//areas are too small
	if(QRules.withSimpleRules && !QGraphics.isMiniBoard)
		fullName += " with Simple Rules.";


//	fullName = gameName + " " + GameVersion + "." + GameVariant;
	return fullName;
}

//	public void setGoldenRuleInfo(String goldenRuleInfo) {
//		this.goldenRuleInfo = goldenRuleInfo;
//	}
//
//	public void setGoldenRuleHolds(boolean goldenRuleHolds) {
//		this.goldenRuleHolds = goldenRuleHolds;
//	}

	public String getWholeLineDataString(){
		//BUG actually Golden Rule is only for gameversion 3+!
		String infoString = generalWLDataString();

		//add specific strings to the message:

		infoString = infoString + iRMessage();

//		if (goldenRuleInfo.length() > 0)
//			infoString = infoString + " " + goldenRuleInfo;



		if (goldenRuleFlag > -1) {
			if (goldenRuleFlag == winnerInt) {
				infoString = infoString + " Golden Rule failed.";
			} else {
				infoString = infoString + " Golden Rule holds.";
			}
		}




		//finally format to html:
		if(isSealed)
			infoString = "<b>" + infoString + "</b>";

		infoString = "<html>" + infoString + "</html>";

		return infoString;
	}

	public void setControlPassInt(int controlPassInt) {
		this.controlPassInt = controlPassInt;
	}


//	end QuiWholeLineData methods


//	public String getWholeLineDataString(){
////		String infoString = "";
////		if (turnCountString.length() > 0)
////			infoString = infoString + " " + turnCountString;
////		if (matchPhaseString.length() > 0)
////			infoString = infoString + " " + matchPhaseString;
//		return generalWLDataString();
//	}

	public String getTitleString(){
		//O~ just return MatchInfo !
		String infoWithBranch = titleString;
//		if(branchNo > 0)
//			infoWithBranch += " branch " + branchNo;
		return infoWithBranch;
	}

	public String generalWLDataString(){
//		String lineDataString = "";
		String lineDataString = customString;
		String turnPhaseString = "";


		//develop this later:
//		 if (matchInfo.length() > 0){
//			 lineDataString += "Info: " + matchInfo + "\n\n";//two line breaks after info
//		 }
//


		String fullGameName = getFullGameName();


		if (fullGameName.length()> 0){
			lineDataString += fullGameName + "<br>";
		}

		if (titleString.length() > 0){
			//String formattedMatchInfoString = matchInfo;


			lineDataString += titleStringHtml + "<br>";
		}


		//System.out.println("GetGWLString.TurnsInLine is " + TurnsInLine);
		String turnCountString = "Turns in line: " + TurnsInLine + ".";

		//if (turnCountString.length() > 0)
		lineDataString = lineDataString + turnCountString;

		//TODO put matchPhaseString here before isSealed messages?
		if (turnPhase == 0 && winnerInt == -1) {
			if (player == 0) {
				if (TurnsInLine > 0){
					turnPhaseString = "End at White to play.";
				} else {
					turnPhaseString = "White to play.";
				}

			} else {
				turnPhaseString = "End at Black to play.";
			}
		} else {
			if(winnerInt == -1)
				turnPhaseString += "End";
			if(winnerInt == 0)
				turnPhaseString += "White Win";
			if(winnerInt == 1)
				turnPhaseString += "Black Win";

			if (player == 0) {
				turnPhaseString += " in White's turn.";
			} else {
				turnPhaseString += " in Black's turn.";
			}
		}

		//lineDataString += turnPhaseString;

		if (resignInt > -1){

			switch(resignInt){

			case 0://Black has won by White resigning
				lineDataString += " Black win - White resigned.";
				break;

			case 1://white has won by Black resigning
				lineDataString += " White win - Black resigned.";
				break;

			case 2://Draw is agreed
				lineDataString += " Draw is agreed.";
				break;

			case 3://Draw by two consecutive passes
				lineDataString += " Draw by consecutive Passes.";
				break;

			case -1://single s in marked plystring	- no resign or win?
				//this only make sense when tabs are in place: uncomment for 1.0??

//				if(winnerInt < 0) //don't display on winning lines - obvious!
//					lineDataString = lineDataString + " (The line is sealed.)";


			default:
				if (turnPhaseString.length() > 0)
					lineDataString = lineDataString + " " + turnPhaseString;

				break;
			}

			if (errorMessage.length() > 0)
				lineDataString = lineDataString + " " + errorMessage;
		} else {
			if (turnPhaseString.length() > 0)
				lineDataString = lineDataString + " " + turnPhaseString;
		}
//		if(infoString.length() > 0)
//			infoString = "Data for entire line:\n" + infoString;
		return lineDataString;
	}

//	public void setTurnCountString(String turnCountString) {
//		this.turnCountString = turnCountString;
//	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public void setLocString(String locString) {
		this.locString = locString;
	}
	public void setTurnsInLine(int turnsInLine) {
		TurnsInLine = turnsInLine;
		//System.out.println("TurnsInLine is " + TurnsInLine);
	}
	public void setWinnerInt(int winnerInt) {
		this.winnerInt = winnerInt;
		if(winnerInt > -1 && QBuildParameters.sealOnFinish)
			isSealed = true;
	}
//	public void setTurnPhaseString(String matchPhaseString) {
//		this.turnPhaseString = matchPhaseString;
//	}

	public void setSealed(boolean isSealed) {
		//use just setWinnerInt and ssetResignInt or combine?
		this.isSealed = isSealed;
	}

	public void setResignInt(int resignInt) {
		this.resignInt = resignInt;
		if(resignInt > -1 && QBuildParameters.sealOnFinish)
			isSealed = true;
	}

	public void setEndOfLine(boolean isEndOfLine) {
		this.isEndOfLine = isEndOfLine;

	}

	public void setCustomString(String customString) {
		this.customString = customString;
	}

	public void setTitleString(String titleString) {
		//TODO BUG this is called 8 times!!
		this.titleString = titleString;
		titleStringHtml = QSFUtils.xhtmlEncodeValue(titleString, false);
		//false since title values are not Unicode
	}

	public void setTurnPhase(int turnPhase) {
		this.turnPhase = turnPhase;
	}

	public void setPlayer(int player) {
		this.player = player;
	}

	public void setGameVersion(int gameVersion) {
		GameVersion = gameVersion;
	}

	public void setGameVariant(int gameVariant) {
		GameVariant = gameVariant;
	}

	public void setGoldenRuleFlag(int goldenRuleFlag) {
		this.goldenRuleFlag = goldenRuleFlag;
	}

	public void setTurnsOpened(int turnsOpened) {
		this.turnsOpened = turnsOpened;
	}





//	public void setBranchNo(int branchNo) {
//		this.branchNo = branchNo;
//	}


}
