/*
**********************************************************************
*                        License Notice
*
* QSessionManager.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the GPL licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/

package com.quincala.core;

import java.util.Calendar;

public class QSessionManager {

	public static String sessionName = getSessionNameTimeString();



	public static void setSessionName(){
		sessionName = getSessionNameTimeString();
	}

	public static String getSessionNameTimeString(){

		/*
		 * this doesn't put colons in; for session titles?
		 */

		Calendar now = Calendar.getInstance();

		String y = QSFUtils.getYearString(now);
		String m = QSFUtils.getMonthString(now);
		String d = QSFUtils.getDateString(now);

		String h = QSFUtils.getHourString(now);
		String mi = QSFUtils.getMinuteString(now);
		String s = QSFUtils.getSecondString(now);

		String name = "Quincala Session Backup ";
		name += y + "-" + m + "-" + d + " ";
		name += h + "." + mi + "." + s;
		name += ".txt";

//		System.out.println("Session name is " + name);

		return name;
	}

//	private static String getHourString(Calendar now){
//		int hourInt = now.get(Calendar.HOUR_OF_DAY);
//		String hourString = "" + hourInt;
//		if (hourInt < 10)
//			hourString = "0" + hourString;
//		return hourString;
//	}
//
//	private static String getMinuteString(Calendar now){
//		int minuteInt = now.get(Calendar.MINUTE);
//		String minuteString = "" + minuteInt;
//		if (minuteInt < 10)
//			minuteString = "0" + minuteString;
//		return minuteString;
//	}
//
//	private static String getSecondString(Calendar now){
//		int secondInt = now.get(Calendar.SECOND);
//		String secondString = "" + secondInt;
//		if (secondInt < 10)
//			secondString = "0" + secondString;
//		return secondString;
//	}

}
