/*
**********************************************************************
*                        License Notice
*
* QRules.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

//import com.quincala.gamequincala.QuiRules;

import java.util.ArrayList;

public class QRules {

	/*
	 * a good place to keep build parameters:
	 */

	//END BUILD PARAMS!
//	private static final String[] capitalisedGameHeads = {"quincala"};

	public static String gameHead = "Quincala";//will be "Quincala"
	public static String environmentString = "15";
	//mmh need to sync default here until space acts on new type!
	//TODO test qrules.gamehead when shift games!
	public static boolean withSimpleRules = false;

	//USER RULES CAN BE STATIC TOO; IN QUIRULES FOR Quincala!

	public static boolean isPosEdit = false;

	//use these for setting rule params for the current game

	public static QRule[] ruleInfoArray = new QRule[1];
	//alternatively: (how to translate?)
	public static String[] boolsNames = new String[1];
	public static String[] boolsText= new String[1];
	public static boolean[] bools = new boolean[1];
	public static int[] ints = new int[1];


	public static ArrayList<Integer> validOffBoardLocs = new ArrayList<Integer>();



	public static void setGameHead(String gameHead) {

//		for (int i = capitalisedGameHeads.length - 1; i >= 0; i--) {
//			//backwards so need only calc length once
//			if(capitalisedGameHeads[i].equalsIgnoreCase(gameHead)){
//
//				//make first letter upper case
////				gameHead = "" + Character.toUpperCase(gameHead.charAt(0));
////				gameHead = gameHead +
//				String newFirst = "" + Character.toUpperCase(gameHead.charAt(0));
//				StringBuffer b = new StringBuffer(gameHead);
//				b.replace(0, 1, newFirst);
//				gameHead = b.toString();
//			}
//		}


		//Better to just put the stored string as head :-)
		for (int i = QSFUtils.definedGameHeads.length - 1; i >= 0; i--) {
			//backwards so need only calc length once
			if(QSFUtils.definedGameHeads[i].equalsIgnoreCase(gameHead)){
				QRules.gameHead = QSFUtils.definedGameHeads[i];
				System.out.println("QRules.gameHead is set to " + QRules.gameHead);
			}
		}


		//here set all game specific GUI options
		//for instance showShowOptions is false for go ...
	}

	public static String getRuleSheetName(){
		String name = gameHead + "_" + "Rules";
		//list of exclusions ...
		if (environmentString.length() > 0){
			char first = environmentString.charAt(0);
			if(gameHead.equalsIgnoreCase("Quincala") && first > '0' && first < '4'){
				name += "_" + first;
			} else {
				name += "_" + environmentString;
			}
		}
		name += ".pdf";
		System.out.println("getRuleSheetName returns " + name);
		return name;
	}

	public static String getEnvironmentString() {
		return environmentString;
	}

	public static void setEnvironmentString(String environmentString) {
		QRules.environmentString = environmentString;
		System.out.println("QRules.environmentString is set to " + environmentString);
	}

	public static String getGameStringHead() {
		System.out.println("getGameStringHead returns " + gameHead + ";" + environmentString);
		return gameHead + ";" + environmentString;
	}

	public static void setPosEdit(boolean posEdit) {
		QRules.isPosEdit = posEdit;
	}

	public static void setWithSimpleRules(boolean withSimpleRules) {
		QRules.withSimpleRules = withSimpleRules;
	}

	public static void setValidOffBoardLocs(ArrayList<Integer> validOffBoardLocs) {
		QRules.validOffBoardLocs = validOffBoardLocs;
	}


}
