/*
**********************************************************************
*                        License Notice
*
* QPiece.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

public class QPiece {


	public int type = 0; //0 is a non-piece: 1-5 are sizes 1 - 5;
	//(type is more abstract)
	public int colour = 0; // is white and 1 is black - abstract?

	public boolean isSelected = false;//abstract

	public int loc = 0;//default value?
	public int boardRotation = 0;
	public int squareInt = 8;// for chess board


	public int gridX(){//make these general by using squareInt
		//rectangular boards??????
		int X = 0;
		switch (boardRotation){
			case 0:
				X = loc % squareInt;
				break;
			case 1:
				X = squareInt - 1 - (loc / squareInt);
				break;
			case 2:
				X = squareInt - 1 - (loc % squareInt);
				break;
			case 3:
				X = loc / squareInt;
				break;
		}
		return X;
	}

	public int gridY(){
		int Y = 0;
		switch (boardRotation){
			case 0:
				Y = loc / squareInt;
				break;
			case 1:
				Y = loc % squareInt;
				break;
			case 2:
				Y = squareInt - 1 - (loc / squareInt);
				break;
			case 3:
				Y = squareInt - 1 - (loc % squareInt);
				break;
		}
		return Y;
	}

	public void setColour(int colour) {
		this.colour = colour;
	}

	public void setSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}

	public void setType(int type) {
		this.type = type;
	}

	public void setLoc(int loc) {
		this.loc = loc;
	}

}
