/*
**********************************************************************
*                        License Notice
*
* QGraphics.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

import javax.swing.*;

import java.awt.event.*;
import java.awt.*;
import javax.swing.plaf.*;
import javax.swing.event.*;
import java.io.*;


import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
//textures:
import java.awt.TexturePaint;
import java.net.URL;
import javax.imageio.ImageIO;
import java.io.IOException;


import java.awt.BasicStroke;
import java.awt.geom.CubicCurve2D;


import com.quincala.gamequincala.QuiGraphics;
import com.quincala.gamequincala.QuiUtils;

public class QGraphics {
	/*
	 * this defines rotation and coordinate/location relationships
	 * for all types of board
	 * also keeps a record of board panel sizes etc
	 */

	//USER CHOICES EVENTUALLY: make setMethods etc

	/*
	 * make "customise pop-up" with texture choices and
	 * button to colour chooser
	 */
	public static int boardTextureInt = -1;//-1 is no texture
	//typical textures are wood
	public static int canvasTextureInt = 1;
	//typical textures are felt


	//END USER CHOICES

	//TEXTURES:

	/*
	 * Coder pastes texture into folder core/textures
	 * rename to "qtexture" + textureIndex
	 * hard code number of textures as textureCount
	 * (or read files at startup to calculate it)
	 * optionally supply hasGrain is so (default not!)
	 * if has Grain, wooden boards should be painted with
	 * 4 grain directions, not canvas since variable in
	 * proportion!
	 * code loops to load all textures and link them to
	 * TextureInt numbers as chosen by user.
	 */
	public static final int textureCount = 2;
	public static final boolean[] hasGrain = {true,false};
	//maybe initialised as below and filled here as
	//hasGrain[0] = true;
	//is boolean[] initialised with all true or all false?

	//initialise these as Lists with length textureCount:
	public static BufferedImage bimage1 = null;
	public static BufferedImage bimage2 = null;
	public static TexturePaint texture1 = null;
	public static TexturePaint texture2 = null;

	//END TEXTURES

	//public until all graphics migrated to QGraphics class family.
	public static int maxCanvasSize = 2000;//to avoid memory error
	//TODO study about this!!  maybe make canvas with part of board on it?

	//TODO fill out the rest
	public static int boardRotation = 0;//hmmm lots of changes!!

	public static int ht = 0;
	public static int wd = 0;
	public static int boardPanelSize = 0;
	public static boolean isMiniBoard = false;
	private static boolean reDrawBoardFlag = false;

	public static int xTop = 0;//protected??
	public static int yTop = 0;
	//these 2 will replace the above 2 when all drawing is in a Graphics class
	public static int xCanv = 0;//protected??
	public static int yCanv = 0;
	public static int ss = 1; // size of an individual square, is always odd!
	public static int boardSize = 0;
	public static int canvasSize = 400;//just to start with something:
	//updated from QuiGraphics later

	//public static int CDs; // this is the size of the gui navigation buttons
	//not in use since buttons came off the frame!!

	protected static int boardX = 13; //8 for chess//maybe public?
	protected static int boardY = 13; //8 for chess


	public static boolean canZoomByRClick = false;
	public static boolean isZoomedIn = false;
	public static int centerSqLocDefault = 84;
	public static int centerSqLoc = centerSqLocDefault;//new generation


	//these two should be set by the current game:
	public static double radiusSeenDefault = 7.0d;//make protected after migration!
	public static double radiusSeen = radiusSeenDefault;//make int and unit centisquare?
	//normal: radius seen: 6.5 or 7;
	//for centre work: 6,5,1; south gate: 6,1,0.5; wave: 8,1,0.5
	//full centre: 6,6,1.8, full line segment: 8,1,1.7
	//small petal 7,5,-0.1

	public static int iconSize = 0;
	private static double[][] simpleNavArrowDef = {{0.25d, 0.25d, 0.5d, 0},
													{1d, 0.5d, 0.5d, 0d}};
	public static int[][] simpleNavArrowPoints;

	private static double[][] markNavArrowDef = {{0.25d, 0.25d, 0.5d, 0, 0.5d, 0.5d, 0d},
												{1d, 0.61d, 0.61d, 0.14d, 0.14d, 0d, 0d}};
	//these values seems to work for text sizes 10-22 ... don't know why
	public static int[][] markNavArrowPoints;

	//some basic colours and strokes
	public static Color boardColourLight = new Color(225, 160, 0);//options

//	public static Color navArrowcolour = new Color(140, 140, 140);//maybe black?
	public static Color navArrowcolour = Color.black;//maybe black?

	public static BufferedImage[] navArrowBuffered = new BufferedImage[10];//not tested
	public static ImageIcon[] navArrows = new ImageIcon[10];//this is used by ulf's QGL
	//normal * 4, marker * 4, play, pause
//	private static BufferedImage navArrowIm = null;
//	private static BufferedImage rotatedIm = null;//global??
//	private static AffineTransform identityQ = new AffineTransform();//not global


	public static void initQGraphics(int iconSize){

		QGraphics.iconSize = iconSize + ((iconSize + 1) % 2) + 2; //always odd with margin
		System.out.println("iconSize is " + QGraphics.iconSize);

		updateNavArrowIcons();

		loadTextures();
	}

	public static void loadTextures(){

		//no action if no textures wanted!
		if (boardTextureInt == -1 && canvasTextureInt == -1)
			return;

		/*
		 * TODO develop loadTextures:
		 * Coder pastes texture into folder core/textures
		 * rename to "qtexture" + textureIndex
		 * hard code number of textures as textureCount
		 * (or read files at startup to calculate it)
		 * optionally supply hasGrain is so (default not!)
		 * if has Grain, wooden boards should be painted with
		 * 4 grain directions, not canvas since variable in
		 * proportion!
		 * code loops to load all textures and link them to
		 * TextureInt numbers as chosen by user.
		 */

//		 URL url1 = QGraphics.class.getResource("textures/wood113.jpg");
//		 URL url1 = QGraphics.class.getResource("textures/wood013.jpg");
		 URL url1 = QGraphics.class.getResource("textures/wood057.jpg");
//		 URL url1 = QGraphics.class.getResource("textures/Kachel6F.png");
		 //Kachel6F only under GPL!!
		 URL url2 = QGraphics.class.getResource("textures/cloth012.gif");
//		 System.out.println("url1 is " + url1);
	      try {
             bimage1 = ImageIO.read(url1);
             bimage2 = ImageIO.read(url2);

         } catch (IOException ioe) {
             ioe.printStackTrace();
         }
         Rectangle rect1 = new Rectangle(0, 0,
                 bimage1.getWidth(), bimage1.getHeight());
         Rectangle rect2 = new Rectangle(0, 0,
                 bimage2.getWidth(), bimage2.getHeight());

         texture1 = new TexturePaint(bimage1, rect1);
         texture2 = new TexturePaint(bimage2, rect2);

	}

	public static void updateNavArrowIcons(){
		simpleNavArrowPoints = expandNavArrows(simpleNavArrowDef);
		BufferedImage navArrowImage = updateNavArrowImage(simpleNavArrowPoints);
		for (int i = 0; i < 4; i++) {
			//also make an icon out of it:
			navArrows[i] = new ImageIcon(getRotatedImage(navArrowImage, i * 90));
			//here store in buffer image list?
		}
		markNavArrowPoints = expandNavArrows(markNavArrowDef);
		navArrowImage = updateNavArrowImage(markNavArrowPoints);
		for (int i = 4; i < 8; i++) {
			//also make an icon out of it:
			navArrows[i] = new ImageIcon(getRotatedImage(navArrowImage, i * 90));
		}

	}

	public static int[][] expandNavArrows(double[][] arrowDef){
		//expand the navArrowPoints:

		int inputLength = arrowDef[0].length;
//		System.out.println("inputLength is " + inputLength);
		int outputLength = 2 * inputLength - 1;
		double[][] tempNavArrowPoints = new double [2][outputLength];//don't double top point
		int[][] returnNavArrowPoints = new int[2][outputLength];

		//first make symmetrical points round x-axis
		for (int i = 0; i < inputLength; i++) {

			tempNavArrowPoints[0][i] = arrowDef[0][i];
			tempNavArrowPoints[1][i] = arrowDef[1][i];

			if (i < inputLength - 1){
				tempNavArrowPoints[0][outputLength - i - 1] =  - arrowDef[0][i];
				tempNavArrowPoints[1][outputLength - i - 1] = arrowDef[1][i];
			}
//			tempNavArrowPoints[xory][] = inputLenght

		}
//		System.out.println("iconSize is " + iconSize);
		int transformX = iconSize / 2 - 1;//or + 1?//-1 since the canvas is with margin ...
//		System.out.println("transformX is " + transformX);
		for (int i = 0; i < outputLength; i++) {



			returnNavArrowPoints[0][i]  = (int) ((iconSize  - 2) * tempNavArrowPoints[0][i]);
			returnNavArrowPoints[1][i]  = (int) ((iconSize - 2) * tempNavArrowPoints[1][i]);
			//-2 since the canvas is with margin ...



			returnNavArrowPoints[0][i] = returnNavArrowPoints[0][i] + transformX;
//			System.out.println("final point is " + returnNavArrowPoints[0][i] + ", " + returnNavArrowPoints[1][i]);

//			System.out.println("navArrowPoint is " + navArrowPoints[0][i] + ", "
//					+ navArrowPoints[1][i]);

		}



		//expand the board polygon:
//		for(int i = 0; i < 20; i++){
////			boardPolygonXExp[i] = (int) (ss * (boardPolygonX[i] + 1));
////			boardPolygonYExp[i] = (int) (ss * (boardPolygonY[i] + 1));
//		}


		return returnNavArrowPoints;
	}

	public static BufferedImage updateNavArrowImage(int[][] arrowPoints){

		BufferedImage navArrowIm =  new BufferedImage(iconSize, iconSize,
				 BufferedImage.BITMASK);//

	    Graphics g = navArrowIm.getGraphics();
	    Graphics2D g2d = (Graphics2D) g;

		//draw polygon of arrow
//	    System.out.println("navArrowPoints[1][0] is " + navArrowPoints[1][0]);
		g2d.setColor(navArrowcolour);
		int pointCount = arrowPoints[0].length;
		g2d.fillPolygon(arrowPoints[0], arrowPoints[1],pointCount);
		g2d.drawPolygon(arrowPoints[0], arrowPoints[1],pointCount);

		//store in the image array if someone wants to use raw image buffers
		navArrowBuffered[0] = navArrowIm;//hmmr crap code; store elsewhere!!




	    g2d.dispose();

		return navArrowIm;
	}


	/**
	 * @param imageToRotate
	 * @param degreesOfRotation
	 * @return
	 */
	public static BufferedImage getRotatedImage(BufferedImage imageToRotate, double degreesOfRotation){
		/*
		 * try suing this to rotate around centre:
		 *    protected void paintComponent(Graphics g) {
     super.paintComponent(g);
     Graphics2D g2d = (Graphics2D)g;
     AffineTransform origXform = g2d.getTransform();
     AffineTransform newXform = (AffineTransform)(origXform.clone());
     //center of rotation is center of the panel
     int xRot = this.getWidth()/2;
     int yRot = this.getHeight()/2;
     newXform.rotate(Math.toRadians(currentAngle), xRot, yRot);
     g2d.setTransform(newXform);
     //draw image centered in panel
     int x = (getWidth() - image.getWidth(this))/2;
     int y = (getHeight() - image.getHeight(this))/2;
     g2d.drawImage(image, x, y, this);
     g2d.setTransform(origXform);
   }
   */

		//TODO calc transform and new canvas size!! to use with all sorts of images rotated round middle?

//		Dimension size = new Dimension();
		int canvWidth = imageToRotate.getWidth();//
		int canvHeight = imageToRotate.getHeight();

		//TODO here calculate the new size!!! if not right angle rotation!!

		int xTransl = 0;
		int yTransl = 0;//for now

        //center of rotation is center of the panel
        int xRot = imageToRotate.getWidth()/2;//+ 1 looks better for some reason
        int yRot = imageToRotate.getHeight()/2 ;




		BufferedImage rotatedIm =  new BufferedImage(canvWidth, canvHeight,
                BufferedImage.BITMASK);



        Graphics g = rotatedIm.getGraphics();
        Graphics2D g2d = (Graphics2D) g;

        AffineTransform identityQ = new AffineTransform();//WHY????
        AffineTransform trans = new AffineTransform();
        trans.setTransform(identityQ);

        trans.translate(xTransl, yTransl);//this must come before rotation
        trans.rotate( Math.toRadians(degreesOfRotation), xRot, yRot );

        g2d.drawImage((Image) imageToRotate, trans, null);


        g2d.dispose();

		return rotatedIm;
	}

	public static BufferedImage getRotatedImage(BufferedImage imageToRotate, double degreesOfRotation, float transparency){

		//TODO avoid double code!! this is more of a store ...

		/*
		 * try suing this to rotate around centre:
		 *    protected void paintComponent(Graphics g) {
     super.paintComponent(g);
     Graphics2D g2d = (Graphics2D)g;
     AffineTransform origXform = g2d.getTransform();
     AffineTransform newXform = (AffineTransform)(origXform.clone());
     //center of rotation is center of the panel
     int xRot = this.getWidth()/2;
     int yRot = this.getHeight()/2;
     newXform.rotate(Math.toRadians(currentAngle), xRot, yRot);
     g2d.setTransform(newXform);
     //draw image centered in panel
     int x = (getWidth() - image.getWidth(this))/2;
     int y = (getHeight() - image.getHeight(this))/2;
     g2d.drawImage(image, x, y, this);
     g2d.setTransform(origXform);
   }

		 */

//		how to add an image ... & size the buffer accordingly!
//      size = new Dimension();
//      castle = new ImageIcon("slanec.jpg").getImage();

		Dimension size = new Dimension();
		size.width = imageToRotate.getWidth(null);
		size.height = imageToRotate.getHeight(null);

		//TODO here calculate the new size!!!

		BufferedImage rotatedIm =  new BufferedImage(size.width, size.height,
                BufferedImage.TRANSLUCENT);
//		float transparency = 0.4f;
		//keeps the pattern underneath! & allows transparency to be set!


        Graphics g = rotatedIm.getGraphics();
        Graphics2D g2d = (Graphics2D) g;

        AffineTransform identityQ = new AffineTransform();//WHY???
        AffineTransform trans = new AffineTransform();
        trans.setTransform(identityQ);
        //trans.scale(0.2, 1.3);

        trans.translate(0, 0);//this must come before rotation
        trans.rotate( Math.toRadians(degreesOfRotation), 7, 7 );
        g2d.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, transparency));
        //http://www.javalobby.org/articles/ultimate-image/

        g2d.drawImage((Image) imageToRotate, trans, null);




        //g.drawImage(castle, 0, 0, null);//how to add images
//        g2d.setColor(Color.red);
//        g2d.fillRect(0, 0, 150, 100);

        //need to use affine?? ...
        //g2d.rotate(1);//holy grail! radians ..
//        g2d.rotate(45.0 * Math.PI / 180.0);//holy grail!

        g2d.dispose();

		return rotatedIm;
	}

	public static void setDrawSizes(){
		/*
		 * not overriding since static! usable??
		 */

	}



	//not good!
	public int location(int boardX, int boardY, int boardRot, int x, int y) { //returns the index to use in QuGameState objects
		int a = 0;
		switch(boardRot){
		case 0:
			a = x + (boardY - 1 - y) * boardX;
			break;
		case 1:
			a = (12 - x) * 13 + y;
			break;

		case 2:
			a = boardX -1 - x + (boardY -1 - y) * boardX;//??
			break;
		case 3:
			a = x * 13 + 12 -y;
			break;
		}
		return a;
	}

	public static void setZoom(int zoomLoc, int x, int y, double radius){
		//first clear old panel


//		centerSqXCoord = x;
//		centerSqYCoord = y;
		centerSqLoc = zoomLoc;

		radiusSeen = radius;
		if (radiusSeen < 1)
			radiusSeen = 1;
		//setDrawSizes();
		updateZoomedIn();

	}

	public static void setZoom(String xy, double radius){
		//first clear old panel?
		char x = xy.charAt(0);
		char y = xy.charAt(1);
		centerSqLoc = QSFUtils.hexCharsToLoc(x,y);
		radiusSeen = radius;
		if (radiusSeen < 1)
			radiusSeen = 1;
		System.out.println("static radiusSeen is " + radiusSeen);
		updateZoomedIn();

		//setDrawSizes();

	}

	public static void resetZoom(){
		radiusSeen = radiusSeenDefault;
		centerSqLoc = centerSqLocDefault;
	}

	public static void receiveMouseZoom(int x, int y){

		if (x < xTop)
			return;
		x -= xTop; // this is the left margin
		if (y < yTop)
			return;
		y -= yTop; // this is the top margin
		int xSquare = x / ss;
		int ySquare = y / ss;

		centerSqLoc = location(xSquare,ySquare);
		if (radiusSeen < 1){
			radiusSeen = 1;
			return;
		}

		if (isMiniBoard){

			radiusSeen = ((radiusSeen + 3) % 5);
			//5, 3, 1, 5 (goes only down to about 2 currently)
		} else {
			radiusSeen = ((radiusSeen + 5) % 8);
			//7, 5, 2, 7
		}

		if (radiusSeen < 1)
			radiusSeen = 1;//why twice??
		System.out.println("radiusSeen is " + radiusSeen);
		if (radiusSeen >= radiusSeenDefault - 1){
			//resetting with mouse!
			radiusSeen = radiusSeenDefault;
			centerSqLoc = centerSqLocDefault;
		}

		//setDrawSizes();

		updateZoomedIn();
	}


	//until sorted out old code ...
	public static int gridX(int loc){
		return gridX(boardRotation, loc);
	}

	public static int gridX(int boardRotation, int loc){
		//TODO generalise these formulas to boardX, boardY!
		int X = 0;
		switch (boardRotation){
			case 0:
				X = loc % 13;
				break;
			case 1:
				X = 12 - (loc / 13);
				break;
			case 2:
				X = 12 - (loc % 13);
				break;
			case 3:
				X = loc / 13;
				break;
		}
		return X;
	}

	public static int gridY(int loc){
		return gridY(boardRotation, loc);
	}

	public static int gridY(int boardRotation, int loc){
		//TODO generalise these formulas to boardX, boardY!
		int Y = 0;
		switch (boardRotation){
			case 0:
				Y = loc / 13;
				break;
			case 1:
				Y = loc % 13;
				break;
			case 2:
				Y = 12 - (loc / 13);
				break;
			case 3:
				Y = 12 - (loc % 13);
				break;
		}
		return Y;
	}

	public static int mouseToLoc(int x, int y){
		
		
		return 1;
	}
	
	//not overriding since different parameters!
	public static int location(int x, int y) {
		//returns the index to use in QuGameState objects
		//TODO generalise these formulas to boardX, boardY!
		int a = 0;
		switch(boardRotation){
		case 0:
			a = x + y * 13;
			break;
		case 1:
			a = (12 - x) * 13 + y;
			break;

		case 2:
			a = 12 - x + (12 - y) * 13;
			break;
		case 3:
			a = x * 13 + 12 -y;
			break;
		}
		return a;
	}

	public static BufferedImage getOptionsImage(boolean[] legalOptions){

		//this is not tested in its general form, but looks ok
		 BufferedImage optionsImage =  new BufferedImage(canvasSize, canvasSize,
                BufferedImage.TRANSLUCENT);

        Graphics g = optionsImage.getGraphics();
        Graphics2D g2d = (Graphics2D) g;

        //make it here:

        g2d.setColor(boardColourLight);



		for (int y = 0; y < boardY; y++) { //I like y before x; follows the alexian rows
			for (int x = 0; x < boardX; x++) {
				g2d.fillOval((x + 1)* ss, (y + 1) * ss, ss, ss);//Good!
			}
		}





        g2d.dispose();

		return optionsImage;
	}


	public static int getHeight() {
		return ht;
	}

	public static void setHeight(int boardPanelHeight) {
		ht = boardPanelHeight;

	}

	public static int getWidth() {
		return wd;
	}

	public static void setWidth(int boardPanelWidth) {
		wd = boardPanelWidth;
	}

	public static void setHeightAndWidth(int boardPanelHeight, int boardPanelWidth) {
		ht = boardPanelHeight;
		wd = boardPanelWidth;
//		System.out.print("static ht is " + ht);
//		System.out.println(", static wd is " + wd);
	}

	public static void rotateBoard(int quartersClockwise){
		boardRotation = (boardRotation + quartersClockwise) % 4;
		//boardRotation = boardRot;
		System.out.println("boardRotation is " + boardRotation);
	}
	public static void setBoardRotation(int boardRot){
		boardRotation = boardRot;
		//boardRotation = boardRot;
		System.out.println("boardRotation is " + boardRotation);
	}

	public static int getXTop() {
		return xTop;
	}

	public static int getYTop() {
		return yTop;
	}



	public static int getBoardPanelSize() {
		return boardPanelSize;
	}

	public static void setBoardPanelSize(int boardPanelSize) {
		QGraphics.boardPanelSize = boardPanelSize;
		System.out.println("setting boardPanelSize to " + boardPanelSize);
	}

//	public static void setMiniBoard(boolean isMiniBoard) {
//		//this puts a flag if miniBoard status has changed
//		System.out.println("QGraphics.isMiniBoard is set " + isMiniBoard);
//		System.out.println("boardReDefinitionFlag is set " + boardReDefinitionFlag);
//		QGraphics.isMiniBoard = isMiniBoard;
//	}

	public static void setReDrawBoardFlag(){
		reDrawBoardFlag = true;
	}

	public static boolean fetchBoardReDefinitionFlag(){
		//returns a true flag only once!
		System.out.println("boardReDefinitionFlag is fetched");
		boolean flag = reDrawBoardFlag;
		reDrawBoardFlag = false;
		return flag;
	}

	public static void toggleZoomByRClick() {
		canZoomByRClick = !canZoomByRClick;
		System.out.println("canZoomByRClick is " + canZoomByRClick);
	}

	public static void setRadiusSeenDefault(double radiusSeenDefault) {
		QGraphics.radiusSeenDefault = radiusSeenDefault;
		radiusSeen = radiusSeenDefault;//inelegant!!
		System.out.println("QGraphics.setRadius to is " + radiusSeen);
	}

	private static void updateZoomedIn() {
		if (radiusSeen < radiusSeenDefault){
			isZoomedIn = true;
		} else {
			isZoomedIn = false;
		}
	}


}
