/*
**********************************************************************
*                        License Notice
*
* QGameStatus.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

public class QGameStatus {

	/*
	 * this is new generation; to hold info
	 * about turn number, phase, player, win etc
	 * Game variant
	 * it is called from GameState
	 * to be sent to the GUI
	 */

	public boolean forwardAvailable = false;
	public boolean backwardAvailable = false;
	//to start with ...

//	to enable extension initiate these two in method!
	public String[] playerName = {"White", "Black"};
	public String[] colourName = {"white", "black"};

	public int currentTurnNo = 1;
	public int playerInt = 0;
	public String matchPhaseString = "";
	public String statusBarText = "";

	public boolean isWin = false;
	public boolean isWinAhead = false;
	public boolean isEndOfLine = false;
	public int winColour = -1;
	public int resignInt = -1;

	public boolean mayPass = false;
	public int passFlag = -1;//has passed ...

	public int zeroPlyDestIndex = 0;//to get granularity of zeroPlys

	public String gameName = "Generic Game Name";
	public int GameVersion = 0;
	public int GameVariant = 0;

	//this is calculated on demand
	//public String fullGameName = "";

	public String getFullGameName(){
		String fullName = gameName + " " + GameVersion + "." + GameVariant;
		return fullName;
	}

	public String getStatusBarText(){//override!

		return "";
	}

	public void setBackwardAvailable(boolean backwardAvailable) {
		this.backwardAvailable = backwardAvailable;
	}

	public void setCurrentTurnNo(int currentTurnNo) {
		this.currentTurnNo = currentTurnNo;
	}

	public void setForwardAvailable(boolean forwardAvailable) {
		this.forwardAvailable = forwardAvailable;
	}

	public void setGameName(String gameName) {
		this.gameName = gameName;
	}

	public void setGameVariant(int gameVariant) {
		GameVariant = gameVariant;
	}

	public void setGameVersion(int gameVersion) {
		GameVersion = gameVersion;
	}

	public void setPlayerInt(int player) {
		playerInt = player;
	}

	public void setMatchPhaseString(String matchPhaseString) {
		this.matchPhaseString = matchPhaseString;
	}

	public void setStatusBarText(String statusBarText) {
		this.statusBarText = statusBarText;
	}

	public void setPassFlag(int passFlag) {
		this.passFlag = passFlag;
	}

	public void setMayPass(boolean mayPass) {
		this.mayPass = mayPass;
	}

	public void setWin(boolean isWin) {
		this.isWin = isWin;
	}

	public void setWinAhead(boolean isWinAhead) {
		this.isWinAhead = isWinAhead;
	}

	public void setWinColour(int winColour) {
		this.winColour = winColour;
	}

	public void setZeroPlyDestIndex(int zeroPlyDestIndex) {
		this.zeroPlyDestIndex = zeroPlyDestIndex;
//		System.out.println("zeroPlyDestIndex is " + zeroPlyDestIndex);
	}

	public void setEndOfLine(boolean isEndOfLine) {
		this.isEndOfLine = isEndOfLine;
	}

	public void setResignInt(int resignInt) {
		this.resignInt = resignInt;
	}

}
