/*
**********************************************************************
*                        License Notice
*
* QGamePanel.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

import javax.swing.*;

//import com.quincala.gamequincala.QuiWholeLineData;

import java.awt.*;
import java.awt.event.*;

public class QGamePanel extends JPanel {

//	private int mainPanelWidth = 0;
//	private int mainPaneHeight = 0;

	QGameSpace currentSpace;

	public boolean showLegal = false;

	//must be public to inherit:
	public boolean showReleaseHandles = true;

	public boolean doConstruction = false;

    public Color tableClothColour = new Color(230,230,230);

	public void init(String defaultVariant) {

	}

	public void init() {
		init("");
	}

	public void paint(Graphics g) {

	}

	public void stepPlayer(int playerDelay){

	}

	public void receiveBoardQuString(String quString){

	}

	public void setShowOptions(boolean showOptions){
		showLegal = showOptions;
		System.out.println("showLegal is " + showLegal);
//		showLegal = !showLegal;
//		System.out.println("showLegal is " + showLegal);
//		repaint();
	}

	public void setDoConstructionTrue(){
		doConstruction = true;
	}

	public void toggleShowReleasingHandles(){
		showReleaseHandles = !showReleaseHandles;
		repaint();
	}

//	public void updateBoardImage() {
//
//	}
//
//	public void updateOptionsImage(){
//
//	}

	public void updatePanelImage(){

	}

	public void updatePositionImages(){

	}

	//transitional methods:

	public void sendOnButtons(int buttonNo){
//		quincala.receiveCDButtonClick(buttonNo);
//		//repaint();//probably needed ...
	}

	public boolean forwardAvailable(){
		return false;
	}

	public boolean backwardAvailable(){
		return false;
	}

	public int playerNo(){
		return 0;
	}

	public int turnNo(){
		return 1;
//		//internally turn number is from 0
	}


	public String getPurePlyString(){
		return "under construction";
	}

	//end transitional methods

//	new generation testing
	public void testNewG(byte stackByte, int loc){
//		quincala.currentState.setStack(stackByte, loc);
	}

	public QGameStatus getGameStatus(){
		return new QGameStatus();
	}

	public void setZoom(int zoomLoc, int x, int y, double radius){
		//obsolete
	}

	public void setZoom(String xy, double radius){
		//maybe do one with char x, char y ...
	}

	public void resetZoom(){

	}

	//new generation methods:
	public void receiveMouseClick(int x, int y){

	}
	//combine these two??
	public void receiveMouseZoom(int x, int y){

	}

//	public void setMainPaneSize(int mainPanelWd, int mainPaneHt){
//		mainPanelWidth = mainPanelWd;
//		mainPaneHeight = mainPaneHt;
//	}

	public void rotateBoard(int quartersClockwise){
//		boardRotation = (boardRotation + quartersClockwise) % 4;
	}

	public void passThruSpaceQuString(String quiString){
//		quincala.receiveQuString(quiString);

	}
	public void passThroughLineInfo(String matchData){

	}

//	public void passThruRuleModification(String ruleName, boolean ruleState){
//
//	}
	public void passThruRuleModification(boolean[] userRules){

	}

	public QWholeLineData passUpWholeLineData(){
//		QWholeLineInfo infoToPassUP = quincala.currentLine.lineInfo;
		return new QWholeLineData();
	}

	//end new generation

	public String[] getQuString(String quStringFormat, boolean infoOut){
		return new String[2];

	}
}
