/*
**********************************************************************
*                        License Notice
*
* QGameLine.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

import java.lang.String;
import java.lang.StringBuffer;
import java.util.ArrayList;


//import com.quincala.gamequincala.QuiWholeLineData;

public class QGameLine {
	/*
	 * this will hold all data relating to a specific line of play;
	 * its string, it's array, it's position markers
	 * The instance currentLine will enable the buttons on the GUI
	 * This can be used for any rectangular game board - maybe even
	 * even Abalone type games?
	 */

	public boolean doConstruction = false;

	//specific to the game: golden rule Quincala specific??
	public int turnsInLine = 0;
	public boolean lastPlyIsIllegal = false;
	public boolean hasRedundantPlies = false;

	//about line status:
	public boolean isSealed = false;//true means changes create new branch
	public boolean isPosted = false;
	// true means it was fetched from online database or posted in this session,
	//shown in italic

	public int resignInt = -1;//not used??
	public int winnerInt = -1;
//	public int resignInt = -1;
	public String winnerString = "";


	public QWholeLineData lineData = new QWholeLineData();
	protected String titleString = "";
	public int branchNo = 0;

	public QPlyPosition xPosition = new QPlyPosition();
	public QPlyPosition[] markers;
//	public QPlyPosition[] markers = new QPlyPosition[2];
	private int markerCount = 2;//beginning and end are markers by default


	//TODO get rid of this? Are all lines in a specified space having the
	//same gameHead?
	public String setUpString = "";

	public String markedPlyString = "";
	public String purePlyString = "";
	public String locString = "";

	//correspondence game parameters
	public int loadEndPlyPos = 0;//especially if only if string > 5 ...
	public int loadEndTurnNo = 1;
	public boolean isLoadEndTurnOpen = false;


	public StringBuffer markedPlyStringBfr = new StringBuffer("");
	public StringBuffer purePlyStringBfr = new StringBuffer("");


	public int plyPos = 0;
	//keeps track of where in line the match is
	//actually is the index of the next coordinate; so
	//1 choice/click is two plyPos counts!
	//adapt to 3 dimensional games too
	public int locPos = 0;
	public int xPos = -1;//use in getXPos??

	public int markingsOffset = 0;
	public int turnCount = 0; //replace turnNumber in GameState!
	public int lastBranchIndex = 0;//maybe replaced by isBranch?
	public boolean addBranchToMatchInfo = false;

	public int lastTurnIndex = 0;
	public int lastTurnPhaseIndex = 0;

//	public boolean backStepAvailable = false;
//	public boolean forwardStepAvailable = false;

	//TODO rename this zeroPlyBrake? also rename setReleaseBrake()
	//public boolean zeroPlyBrake = false;//set as false when releasing by >
	//this determines if autoRelease is applied to the very end of a string
	//TODO use value from release array in QuiGameSpace
	//public int releaseDestination = 0;//or 0 as default?
	//when clicking through releasing by > button, this holds the dest info
	public int releaseCount = 0;//obsolete when navigate on locString


//	obsolete when navigate on locString
//	public void setReleaseCount(int addOrReset){
//		if (addOrReset == 0){
//			releaseCount = 0;
//		} else
//			releaseCount++;
//	}

//	public void setZeroPlyBrake(boolean brakeValue){
//		zeroPlyBrake = brakeValue;
//		//System.out.println("releaseBrake is " + releaseBrake);
//	}




	public void resetGameLine(){ //private? used???
		/*
		 * this resets all the parameters
		 * to the beginning of the line
		 * maybe include it in setPos???
		 */
		setPlyPos(0);
		markedPlyString = "";

		markingsOffset = 0;//??

		lastBranchIndex = 0;
		lastTurnIndex = 0;
		lastTurnPhaseIndex = 0;
	}

	public void setPlyPos(int currentPos){
		plyPos = currentPos;
		//setStepAvailability();
	}

	//maybe use this one; set markedPlyStrGfr private?
	public String getMarkedPlyString(){
		String markedPString = markedPlyStringBfr.toString();
		return markedPString;
	}

	//maybe not need this one?
	public String getPurePlyString(){
		//TEST does this return trimmed string or do trim()?
		String purePString = purePlyStringBfr.toString();
		return purePString;
	}

	public String getMarkedPlyStringToCurrent(){
		/*
		 * use for inheriting previous x's when
		 * correcting an open line
		 */
		String b = markedPlyStringBfr.substring(0, plyPos);
		System.out.println("MarkedPlyStringToCurrent is " + b);
		return b;
	}

	public String getMarkedStem(){

		if(plyPos == 0){
			System.out.println("PROGRAMMING ERROR: line.getMarkedStem " +
			"is reached from starting position!");
			return "";
		}
		/*
		 * Otherwise, the loop puts one character in before
		 * breaking!! Major corruption cause!
		 */
//		System.out.println("markedPlyStringBfr is " + markedPlyStringBfr.toString());

//		int dimensions = 2;//get from Rules & incorporate? need?
		int markedBufferLength = markedPlyStringBfr.length();
		StringBuffer stem = new StringBuffer(0);

		char ch;
		int coordCount = 0;
//		int i = 0;
		int breakIndex = 0;
		//maybe there is a more clever way to set up the loop?
		//but use breakInt for now for when at end of lines.

		for (int i = 0; i < markedBufferLength; i++) {
			ch = markedPlyStringBfr.charAt(i);
			if (ch == 'r'){
				//is metagame ply: always 2 coords
				coordCount ++;
				stem.append(ch);
				i ++;
				if(i < markedBufferLength){
					//=was not the last char in markedPlystringBfr!
					coordCount ++;
					stem.append(markedPlyStringBfr.charAt(i));//after i++!
//					i ++;
					//= don't look at the second char!
				} else {
//					breakInt = 1;
					break;
				}
			} else if (ch > 'r'){
				//ci is a mark; only single marks ok for now!
//				i++;
				stem.append(ch);
				//so, no coordinate count!
			} else {
				//ci is a coordinate
				coordCount++;
				stem.append(ch);
				//BUG SOLVED: if plyPos==0, append happen before break!
			}
//			System.out.println("stem is " + stem.toString());

			if (coordCount >= plyPos){
				breakIndex = i;
				break;
			}


		}

		/*
		 * All the markings following the end of the
		 * stem do belong to the stem too,
		 * since they annotate the position
		 * created by the last ply
		 */
		for (int i = breakIndex + 1; i < markedBufferLength; i++) {
			ch = markedPlyStringBfr.charAt(i);
			if (ch > 'r'){
				stem.append(ch);
				System.out.println("stem is " + stem.toString());
				/*
				 * TODO marks with one character only
				 * are covered; expand this when marks that
				 * take arguments are properly defined, e.g.
				 * z00 and w1
				 */
			} else
				break;
		}

		return stem.toString();
	}


	//this is the "gateway" to this object
	public void addToMarkedPlyString(String plyStringToAdd){
		//try insert(length,"string") <=> append ("string")
		//maybe create a markedPlyString buffer temporary in order to insert?
		//markedPlyStringBfr = new StringBuffer(markedPlyString);//dynamic!
		markedPlyStringBfr.append(plyStringToAdd);
		analyzeBuffers();
	}

	public void setMarkedPlyString(String markedPlyString){
		markedPlyStringBfr = new StringBuffer(markedPlyString);
		isSealed = true;
		analyzeBuffers();
	}

	public void cropFourOffMarkedPlyString(int cropPlyPos){
		//this might include a mark!! assume not first ...
		System.out.println("CROPPING!");

		int cropCount = 0;
		int i= getMarkedPlyPos(cropPlyPos) - 1;
		// i was length, not last index ...
		while (cropCount < 4){
			//this deletes all char > 'r' + four ply chars! at end.
			if (markedPlyStringBfr.charAt(i) < 's'){
				markedPlyStringBfr.deleteCharAt(i);
				cropCount++;
			}
			i--;
		}
		analyzeBuffers();
	}

	public void capMarkedPlyString(int capPlyPos){
		int newLength = getMarkedPlyPos(capPlyPos);
		//System.out.println("newLength is " + newLength);
		markedPlyStringBfr.setLength(newLength);
		analyzeBuffers();
	}

	private int getMarkedPlyPos(int currentPlyPos){
		int markedLength = markedPlyStringBfr.length();
		//int markedPlyPos = 0;
		int ppP = 0;//temporary purePLyPos

		int i = 0;
		while (i < markedLength){
			/*
			 * this counts up through the markedPlyStringBuffer
			 * until a position that corresponds to the current
			 * plyPos in the purePlyString/Bfr
			 */
			if (ppP == currentPlyPos)
				break;
			if (markedPlyStringBfr.charAt(i) < 's'){//used to be 'x'
				ppP++;
			}
			i++;
		}

//		System.out.println("markedLength is " + markedLength);
//		System.out.println("markedPlyPos is " + i);//???!
//		System.out.println("plyPos is " + plyPos);
//		System.out.println("ppP is " + ppP);
		return i;
	}

	public void setSetUpString(String setUpStringToSet){
		setUpString = setUpStringToSet;
		//System.out.println("setUpString is " + setUpString);
	}


	public void analyzeBuffers(){
		//first remove any white spaces from the markedPlyString:
		int mrkdPlStrngLength = markedPlyStringBfr.length();
		for (int i = mrkdPlStrngLength - 1; i >= 0 ; i--){
			char testChar = markedPlyStringBfr.charAt(i);
			if (testChar == 32 || testChar == 160){
				int textCharInt = markedPlyStringBfr.charAt(i);
				markedPlyStringBfr.deleteCharAt(i);

				System.out.println("removed " + textCharInt + " char at " + i);
			}
		}


		markedPlyString = markedPlyStringBfr.toString();
		//new demarking:
		purePlyStringBfr = new StringBuffer();//initialises empty?
		int markedLength = markedPlyStringBfr.length();
		for (int i = 0; i < markedLength; i++) {
			char ci = markedPlyStringBfr.charAt(i);
			if (ci == 'r'){
				//let through and jump one if there:
				purePlyStringBfr.append(ci);
				if (i < markedLength - 1){
					purePlyStringBfr.append(markedPlyStringBfr.charAt(i + 1));
					i++;
				}
				continue;
			}
			if (ci == 'x'){
				//maybe set x positions? or elsewhere?
				continue;
			}
			//add for all above 'r'?
			/*
			 * TODO marks with one character only
			 * are covered so far; expand this when marks that
			 * take arguments are properly defined, e.g.
			 * z00 and w1
			 */

			if (ci > 'r'){
				//sweeps up all that is not picked up earlier:
				continue;
			}
			//only arrives here if not picked up earlier, i.e. ci < 'r':
			//add validation of coordinates?
			purePlyStringBfr.append(ci);
		}


		//end new demarking
//		purePlyStringBfr = new StringBuffer(markedPlyString);//to be
//		int pureBfrLength = purePlyStringBfr.length();
//		//System.out.println("pureBfrLenght is " + pureBfrLenght);
//		int yzCount = 0;//count them??
//		for (int i = pureBfrLength - 1; i >= 0 ; i--){
//			//remove all 'v', 'w', 'x', 'y' and 'z'
//			//backwards since length goes down as chars are deleted ...
//			char testChar = purePlyStringBfr.charAt(i);
//
//			//first look at off-board plies:
//			if (testChar == 'r'){//a resigning
//				if (i < pureBfrLength - 1){//there is a char after the 'r'
//					int resignCandidate = QSFUtils.getAsciiInt("" + purePlyStringBfr.charAt(i + 1));
//					if (resignCandidate >= 0 && resignCandidate < 10)
//						resignInt = resignCandidate;
////					System.out.println("Line.resignInt is " + resignInt);
////					if (resignInt >= 0 && resignInt < 3)//agreed draw or resigning
////						setSealedTrue();//uncomment if seal on finishing position!
//				}
//				//let through as ply!
//				//TODO only let through analyzeBuffers if valid ply!!not r5!
//			}
//
//			//then at markers in general
//			if (testChar > 'r'){//'r' is resign ply, 's' is sealing marker ...
//				//TODO check that the the same char is used in cropFour ...()!!
//
//				char preChar = '0';
//				if (i > 0)
//					preChar = purePlyStringBfr.charAt(i - 1);
//
//				if (preChar >= 'r')
//					continue;//don't delete or consider in any other way yet
//
//				//these are not navigation markers
//				if (testChar == 's'){//indicates the line is sealed
//					setSealedTrue();//still able to seal by adding an s ... depleted?
//					//should the line be cropped here?
////					if (i < pureBfrLength - 1){//there is a char after the 'w'
////						sealInt = (int) (purePlyStringBfr.charAt(i + 1))  - 48;
////						System.out.println("Line.sealInt is " + sealInt);
////					}
//				}
//
//				if (testChar == 'w'){//indicates the line is a calculated must-win
//
//				}
//				//these are for navigational markers other than 'x':
//				if (testChar == 'z'){ //start here
//					yzCount++;//only count the first x if not at beginning; delete all others!
//				}
//				//TODO incorporate 'y', 'v' and 'z' in navigational marker count!!
//
//				//finally for all char>'r'
//				purePlyStringBfr.deleteCharAt(i);
//			}
//		}


		purePlyString = purePlyStringBfr.toString();
		if (!isValidPurePlyString()){
			//check is in isGameString;
			//however, titles get loaded after invalid ones!!
			//BUG!
			//was bad idea to return here for invalid ones!
		}


		//the above guarantees that there is an even number of chars in
		//purePlyStringBfr

		//the following removes redundant char 56 and 76
		//and swaps 66 for r9
		//It should only be run for Quincala!!
		//TODO test ply adjustments for other games!!
		int plyStringLength = purePlyStringBfr.length();
		hasRedundantPlies = false; //until proven otherwise
		for (int i = plyStringLength - 2; i >=0; i -=2){
			if (!QRules.gameHead.equalsIgnoreCase("Quincala"))
				break;
			//these replacements afe only for Quincala!!

			String stringLet = purePlyStringBfr.substring(i,i + 2);
			//System.out.println("stringLet is " + stringLet);
			if(stringLet.equals("56") || stringLet.equals("76")){
				//System.out.println("stringLet is " + stringLet);
				hasRedundantPlies = true;
				purePlyStringBfr.delete(i, i + 2);
			}
			if (stringLet.equals("66") || stringLet.equals("r9")){
				/*
				 * standardise pass ply to r9 to enable other Quincala GUIs
				 * to not use the centre as pass entry/indicator
				 */
				purePlyStringBfr.replace(i, i + 2, "rt");
			}

			if (stringLet.equals("r3")){
				System.out.println("r3 is found!! and converted");
				/*
				 * standardise pass ply to r9 to enable other Quincala GUIs
				 * to not use the centre as pass entry/indicator
				 */
				purePlyStringBfr.replace(i, i + 2, "rg");
			}

		}
		purePlyString = purePlyStringBfr.toString();
		//or make purePlyString protected?

		//System.out.println("purePlyStringBfr is " + purePlyStringBfr.toString());
//		if(hasRedundantPlies){
//			System.out.println("IMPORTED QUSTRING HAS REDUNDANT PLIES!");
//		}


		/*
		 * currently copes with one x, in the right place ...
		 * this sets the pos initially to the x place
		 */


		int plyPosCount = 0;
		int markedBrfLngth = markedPlyStringBfr.length();
		for (int i = 0; i < markedBrfLngth; i++){
			char testChar = markedPlyStringBfr.charAt(i);
			if (testChar < 's'){// a ply char
				plyPosCount++;
			} else { //a marker char
				if ((testChar == 'x' || testChar == 'v') && xPos < 0){
					//only set xPos once; if xPos == 0, then default suffices!
					setPlyPos(plyPosCount);//initial plypos set to xPos!
					xPos = plyPosCount;

					//reference:
//					if (xPos > -1){
//						xPosStr = purePlyString.substring(0,xPos);
//					} else {
//						xPosStr = purePlyString;
//					}

					//System.out.println("Line.analyzeBuffers().xPos is " + xPos);
//					if (xPos % 2 == 1) {//xPos is odd
//						System.out.println("Line.analyzeBuffers().xPos is odd!");
//						xPos++;//add one to xPos always valid??
//						zeroPlyBrake = true;
//						xPosition.setZeroplyBrake(true);//only if default is false!!!!
//						//System.out.println("Line.analyzeBuffers().xPos is " + xPos);
//					}

					if (xPos % 2 == 0) {//xPos is odd
						//zeroPlyBrake = false;//obsolete
						xPosition.setZeroplyBrake(false);//default is true
						//System.out.println("Line.analyzeBuffers().xPos is " + xPos);
					} else { //xPos is odd
//						System.out.println("Line.analyzeBuffers().xPos is odd!");
						//zeroPlyBrake = true;//obsolete
						xPos++;//add one to xPos always valid??
					}
					xPosition.setPurePlyString(purePlyString.substring(0,xPos));//x string!!
					//xPosition.setPlyPosInt(xPos);//automatically in setPurePLyString()!

					//TODO update getPreviousMarkerString() to use xPositions etc!!
				}


			}
		}

		QPlyPosition endPosition = new  QPlyPosition();
		endPosition.setPurePlyString(purePlyString);
		//endPosition.setPlyPosInt(purePlyString.length());//automatically in setPurePLyString()!

		//finally, make the markers array to navigate the PageUp and PageDown buttons

	/*
	 * current system is a bit silly, but it works for now ...
	 * TODO make markers array via ListArray:
	 * 1. start and end pos as 0 & 1
	 * 2. if xPos at 0 or end: overwrite
	 * 3. else xPos at 1!
	 * 4. finally convert to array
	 */

//		System.out.println("HEJ HEJ!");
		ArrayList markerList = new ArrayList(2);
		markerList.add(0, new QPlyPosition());
		markerList.add(1, endPosition);

		if (xPos == 0){
			markerList.remove(0);
			markerList.add(0, xPosition);
		} else if (xPos == purePlyString.length() - 1){
			markerList.remove(1);
			markerList.add(1, xPosition);
		} else {
			markerList.add(1, xPosition);
			//without removing; thus creating a list of 3 items
		}

		markers = (QPlyPosition[]) markerList.toArray(new QPlyPosition[markerList.size()]);


//		markers[1] = xPosition;
//		markers[2] = endPosition;

//		if (xPos > 0 && (xPos < purePlyString.length() - 1)){
//			markerCount++;
//		}
//		markers = new QPlyPosition[markerCount];
//
//
//		if (xPos == 0){
//			markers[0] = xPosition;
//		} else {
//			markers[0] = new QPlyPosition();
//		}
//
//		switch(markerCount){
//		case 2:
//
//			if (xPos == purePlyString.length()){//at very end
//				markers[1] = endPosition;
//
//			} else {// just before very end
//				markers[1] = xPosition;
//			}
//			break;
//
//		case 3:
//
//			markers[1] = xPosition;
//			markers[2] = endPosition;
//			break;
//
//		default:
//			break;
//		}
		//for testing:
		for (int i = 0; i < markers.length; i++){
//			System.out.println("markers[" + i + "].string is " + markers[i].purePlyString);
		}



	}


	public boolean forwardStepAvailable(){//testing on locString ...
		return locPos < locString.length();
	}



	public boolean backStepAvailable(){
		return locPos > 0;
	}

	public String getStepLocString(int stepValue){
		String extract = "";
		if (stepValue == 1){
			extract += locString.substring(locPos,locPos + 2);

		}
		if (stepValue == 0){
			extract += locString.substring(0,locPos);

		}
		if (stepValue == -1){
			extract += locString.substring(0,locPos - 2);

		}
		//TODO make for larger stepValues with validity? ...

		return extract;
	}


	public void addToLocPos(int locPosAddition){
		locPos += 2 * locPosAddition;
		//System.out.println("@locPos is " + locPos);
	}

	public String getLocStringToLocPos(int locPos){
		String extract = locString.substring(0,locPos);
		return extract;
	}

	public String getPosStringWithFuture(boolean brake){
		//or insert into purePlyStringBfr etc ...

		//TODO rewrite this one from bfr, using brake & wrap!!!
//		System.out.println("purePlyStringBfr is " + purePlyStringBfr.toString());
		StringBuffer sb = new  StringBuffer(purePlyStringBfr.toString());

		/*
		 * StringBuffer sb = purePlyStringBfr;
		 * is not enough; x's are still inserted
		 * below. And one can't clone a buffer directly!
		 */
		//make new one before inserting 'x's!!

//		System.out.println("purePlyStringBfr is " + purePlyStringBfr.toString());

		if(brake){
			if(plyPos > 0)
				sb = sb.insert(plyPos - 1,"x");
		} else {
			if(plyPos > 0)
				sb = sb.insert(plyPos,"x");
		}
		//i.e. if plyPos = 0, then a pure "score" string is returned; no x!

		//returnString += purePlyString.substring(0,plyPos) + 'x' + purePlyString.substring(plyPos);
		return sb.toString();
	}

	public String getPosStringNoFuture(boolean brake){

		System.out.println("purePlyStringBfr is " + purePlyStringBfr.toString());

//		if(brake){
//			if(plyPos > 0)
//				sb = sb.insert(plyPos - 1,"x");
//		} else {
//			sb = sb.insert(plyPos,"x");
//		}
		String result = getPosStringWithFuture(brake);
		if (result.length() > plyPos)
			result = result.substring(0,plyPos + 1);


		return result;
	}




	public String getStepString(int stepValue){
		/*
		 * this returns a string for forward step or
		 * string from 0 to backwards step
		 */

		String extract = "";

		/*
		 * TODO multiply if step is more than 1 ply! chess is �2 ply!
		 * check that the stepValue is in range! otherwise shrink it.
		 */

		if (stepValue > 0){
			extract += purePlyString.substring(plyPos,plyPos + 2);
			//setPlyPos(plyPos + 2);//pos can be set directly now stepavailability is dynamic?
			//TODO yep!
		}
		if (stepValue == 0){
			extract = purePlyString.substring(0,plyPos);
			//pos = pos;
		}


		if (stepValue < 0){
			extract = purePlyString.substring(0,(plyPos - 2));
			//setPlyPos(plyPos - 2);
		}
		return extract;
	}

	public void addToPlyPos(int plyPosAddition){
		plyPos += 2 * plyPosAddition;
		//System.out.println("@plyPos is " + plyPos);
	}

//	public String getNextMarkerString(){
//		//seems to work ... don't quite know why.
//		//System.out.println("plyPos is " + plyPos);
//		//System.out.println("purePlyString.length( is " + purePlyString.length());
//		String toNextMarkerString = purePlyString.substring(plyPos);
//		//int xPos = markedPlyString.indexOf('x');
//		if (xPos > 0 && xPos > plyPos) //xIndex = -1 means no 'x'
//			toNextMarkerString = purePlyString.substring(plyPos,xPos); //or pos-1?
//
//		setPlyPos(plyPos + toNextMarkerString.length());
//		return toNextMarkerString;
//	}

	public QPlyPosition getNextMarkerPlyPos(){

//		QPlyPosition nextPos = new QPlyPosition();//needed?
//		nextPos = markers[markerCount - 1];
		System.out.println("markers.length is " + markers.length);
		int markerIndex = markers.length - 1;
		//although GUI shouldn't pass on nextmarker requests if at endposition ...
		for (int i = 0; i < markers.length; i++){
			if(markers[i].plyPosInt > plyPos){
				markerIndex = i;
				//System.out.println("markerNumber is " + i);
				break;
			}
		}
		QPlyPosition nextPos = markers[markerIndex];
		//think thru this:
		//nextPos.makeIncremental(plyPos);

		return nextPos;
	}

	public QPlyPosition getPreviousMarkerPlyPos(boolean lastIsZeroPly){

		//returns to x (or z or y later) previuosly, or ""
		//QPlyPosition prevPosition = new QPlyPosition();//needed?
		//~O by store result as index and return markers[index] ...
		//prevPosition = markers[0];//in case markers[0] has brake false
		int markerIndex = 0;
		for(int i = markerCount - 1; i >=0 ; i--){
			//backwards for previous marker
			if(markers[i].plyPosInt < plyPos){
				//a strict less than is standard case
				markerIndex = i;
//				System.out.println("markerNumber is " + i);
				break;
			} else if(markers[i].plyPosInt == plyPos && (lastIsZeroPly && markers[i].zeroplyBrake)){
				//but return to same plyPos if brake true and releasing has happened
				markerIndex = i;
//				System.out.println("break markerNumber is " + i);
				break;
			}


		}

		return markers[markerIndex];
	}

//	public String getPreviousMarkerString(){
//		//returns to x (or z or y later) previuosly, or ""
//		String toPrevMarkerString = "";//default to beginning
//		//int xPos = markedPlyString.indexOf('x');
//		if (xPos > 0 && xPos < plyPos)
//			toPrevMarkerString = purePlyString.substring(0,xPos);
//		return toPrevMarkerString;
//	}

//	public String getXPositionString(){
//		String xPosStr = "";
//		//consider strings without 'x' as if having 'x' at end
//		//xPos has just been set in analyzeBuffers()
//		if (xPos > -1){
//			xPosStr = purePlyString.substring(0,xPos);
//		} else {
//			xPosStr = purePlyString;
//		}
//
//		return xPosStr;
//	}

	private boolean isValidPurePlyString(){
		boolean validity = true;

		//test no 1: even number of chars in pure ply string
		int stringLength = purePlyString.length();
		if (stringLength % 2 == 1){
			validity = false;
			//System.out.println("The entered string has not a full set of coordinates!");
		}


		return validity;
	}

	public void setWholeLineData(QWholeLineData info){
		//lineData = new QWholeLineData();
		lineData = info;
		//this covers for all manners of setting seal:
		//from loading a QuString to reaching a finishing pos
		//to resign or draw
		if(lineData.isSealed)
			isSealed = true;
		lineData.setSealed(isSealed);
		//needed for illegal QuString to load sealed

		turnsInLine = info.TurnsInLine;
		winnerInt = info.winnerInt;
		//setGeneralWLData(info);
	}

	/*
	 * Now(non-Javadoc) this need to be duplicated into children!
	 * Maybe do an "implement"?
	 */

//	public void setGeneralWLData(QWholeLineData info){
//
////		seems necessary to include these in all child classes:
//		lineData.setSealed(isSealed);
//		//lineData.setResignInt(resignInt);//from state!
//
//		//locString = lineInfo.locString;//or addto?
////		addToLocString(info.locString);
////		addToLocPos(info.locString.length());
//		//NOTE since general lineInfo is updated every time a loc is added
//		//don't add again!
//		//TODO no need for this information in the info object!
//
//		//winnerString = info.turnPhaseString;
//	}

//	public void setGeneralWLInfo(){
//		//locString = lineInfo.locString;//or addto?
//		addToLocString(lineInfo.locString);
//		turnsInLine = lineInfo.TurnsInLine;
//		winnerInt = lineInfo.winnerInt;
//		winnerString = lineInfo.matchPhaseString;
//	}

	public void addToLocString(String addition){
		/*
		 * this is not used for initial build, but
		 * to import built loc string, and
		 * to add when extending line by mouse
		 */
		locString += addition;
		//locPos += addition.length();
		//System.out.println("addition is " + addition);
		//System.out.println("locString is " + locString);
		//System.out.println("locPos is " + locPos);
		//testing: NOTE this is not an error if there are releasing to be done
		if (locPos != locString.length()){
			//lineData.setErrorMessage("locPos is not at end of locString!");

			//System.out.println("locPos is not at end of locString! triggered 1");
		}
	}

	public void setLocString(String locString){
		this.locString = locString;
//		System.out.println("this.locString is " + this.locString);
	}


	public void setLocPos(int locPos) {
		this.locPos = locPos;
		//System.out.println("this.locPos is " + this.locPos);
		//testing:
		if (this.locPos != locString.length()){
			//TODO this is triggered by resign ply: r1
			//lineData.setErrorMessage("locPos is not at end of locString!");
			//System.out.println("locPos is not at end of locString!  triggered 2");
		}
	}

	public void setSealedTrue(){
		//once a line is sealed, it can not be opened:
		//that would make any annotations on the line disappear!
		isSealed = true;
		System.out.println("QGameLine.isSealed is " + isSealed);
	}

	public boolean isIllegalPly(){
		return lastPlyIsIllegal && (plyPos == purePlyStringBfr.length());
	}

	public void setDoConstructionTrue(){
		//not called yet!!
		doConstruction = true;
	}

	public void setLoadEndTurnOpen(boolean isLoadEndTurnOpen) {
		this.isLoadEndTurnOpen = isLoadEndTurnOpen;
	}

	public void setLoadEndPlyPos(int loadEndPlyPos) {
		this.loadEndPlyPos = loadEndPlyPos;
	}

	public void setLoadEndTurnNo(int loadEndTurnNo) {
		this.loadEndTurnNo = loadEndTurnNo;
	}

//	public void setMatchInfo(String matchInfo) {
//		lineData.setMatchInfo(matchInfo);
//	}

	public void setLineTitle(String lineTitle) {
		this.titleString = lineTitle;
		System.out.println("lineTitle is set as " + lineTitle);

		addBranchToMatchInfo = false;
		//this is set at the very end of space.makeNewBranch
		//it is used in getMatchInfo() to add auto suffixes

		/*
		 * user edited matchInfo overrides the automatic
		 * addition of the "branch" suffix in
		 * getMatchInfo()
		 */


		//either find a branch no in matchInfo or set it 0:
		branchNo = 0;//branch No pertains to a specific match!


		//This is not in use:
		String[] splitMatchInfo = lineTitle.split("branch");
		if (splitMatchInfo.length > 1){//"branch" exists in info
			//System.out.println("branch exists!");
			String branchIndicatorString = splitMatchInfo[1].trim();
			if (branchIndicatorString.length() > 0){
				//after trimming!
				char branchIndicator = branchIndicatorString.charAt(0);
				//only bother about the first digit or the first branch at the moment
				if (Character.isDigit(branchIndicator)){
					branchNo = Character.getNumericValue(branchIndicator);
					System.out.println("branchNo is " + branchNo);
				}
			}
		} else {
			//System.out.println("branch doesn't exist!");
		}


		//System.out.println("matchInfoNew is " + matchInfoNew);
	}

	public String getTitle(){
		if (titleString.length() == 0)
			return "";


		String title = titleString;
		//System.out.println("matchInfo.split('branch').length is " + matchInfo.split("branch").length);
//		if(isBranch && matchInfo.split("branch").length == 1){
		if(addBranchToMatchInfo){
			/*
			 * see doc in setMatchInfo()
			 */
//			if(forwardStepAvailable()){
			String[] splitMatchInfo = titleString.split("branch");
			if (splitMatchInfo.length > 1){
				//"branch" exists in info
				title += ".?";
			} else {
				//is a branch but no "branch" entered by user
				title += " branch ?";
			}







//			}
//			else {
//				fullInfo += " candidate";
//			}

			/*
			 * to use "candidate", think through exact scenarios
			 * then probably decide it from space.makeNewBranch
			 * and do parallel to branch indicator!
			 */





//			if(branchNo > 0)
//			fullInfo += " branch " + branchNo;
		}


		return title;
	}

	public QWholeLineData getWholeLineData(){
		//feed the matchInfoString:
		//System.out.println("matchInfoNew is fed to linedata as " + matchInfoNew);
		lineData.setTitleString(getTitle());
		//lineData.setBranchNo(branchNo);//branch info is now included in matchInfo!
		return lineData;
	}

	public void setLastPlyIsIllegal(boolean lastPlyIsIllegal) {
		this.lastPlyIsIllegal = lastPlyIsIllegal;
	}

	public void setBranchNo(int branchNo) {
		this.branchNo = branchNo;
	}

	public void setPosted(boolean isPosted) {
		this.isPosted = isPosted;
	}

	public void setAddBranchToMatchInfo(boolean isBranch) {
		this.addBranchToMatchInfo = isBranch;
	}

}
