/*
**********************************************************************
*                        License Notice
*
* QDuplet.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

public class QDuplet {

	/*
	 * this handles the individual duplets, each corresponding to a
	 * single arrow,
	 * necessary to execute a move by manipulating the Alexians ...
	 * This replaced the class QuDuplets (in plural), using an ArrayList
	 * in QuGame to handle them.
	 */

	//these are the main "active" fields, required for moving the pieces about
	public int origLoc;
	public byte activeSizes; //ActiveBlacks is calculated from an QuGameState object
	public byte bouncingStack = 0;//used for bouncing - is this quincala specific?

	public int destLoc;

	public int dupletType = 0;
	public int plyValue = 0;


	public int turnPhase = 0; //this helps define depth of display
	public int turnNo = 0; //helps translating to human game file

	//these are extra fields that define arrows and connectors
	public char arrowType; //m|ove, p|lacing, r|eleasing, c|onnector etc
	public byte destinationContent;
	//head, butt ...?
	public int colour = 0;//this is the colour of a released piece

	public void setTypeAndPlyValue(int dType, int pValue){
		dupletType = dType;
//		System.out.println("dupletType is " + dupletType);
		plyValue = pValue;
//		System.out.println("pValue is " + pValue);
	}

	public void fillOrigFields(int loc0, byte movers) {
		origLoc = loc0;
		activeSizes = movers;
	}

	public void fillDestField(int loc1){
		destLoc = loc1;
	}

	public void setReleasedPieceColour(int colourInt){
		colour = colourInt;
	}


	public void FillAllFields(){
		//TODO make same as fillActiveFields() but with all fields!
	}

	public void setBouncingStack(byte bouncingStack) {
		this.bouncingStack = bouncingStack;
	}

	public void setBouncingStackActive(){
		activeSizes = bouncingStack;
	}

}
