/*
**********************************************************************
*                        License Notice
*
* QClipBoardBridge.java is part of the Quincala Software Project, which is
* aimed at playing, viewing, studying, communicating and publishing
* games; primarily the Quincala games, but in time any game that fits.
*
* (C) Copyright 2010 Ulf Aberg (Åberg) and AB Games Ltd. All Rights
* Reserved.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* Here is also a copy of the gpl licence version 3 in html format,
* called "gpl-3.0-standalone.html" in the com.quincala.core/docs folder.
*
* This licence does not provide any license or right to use any
* trademark owned by Ulf Aberg (Åberg) or AB Games Ltd in any form or
* media. QUINCALA is a registered trademark owned by Ulf Aberg (Åberg).
*
* The design of the (classic) Quincala board is a Registered Design,
* also owned by Ulf Aberg (Åberg).
*
* Contact Ulf on ulf@quincala.com
*
**********************************************************************
*/


package com.quincala.core;

import java.awt.Toolkit;
import java.awt.datatransfer.*;

import java.io.*;
import javax.jnlp.*;
//import javax.jws.*;

/*
 * TODO import javax.jnlp.*; ???
 * ?need to download jnlp.jar
 *
 *
 */






public class QClipBoardBridge {


	public static void copyWS(String stringToCopy){

		//copy is commented out

		   ClipboardService cs;
		   StringSelection ss;
//		   String s = "";

		    try {
		        cs = (ClipboardService)ServiceManager.lookup
		                 ("javax.jnlp.ClipboardService");
		    } catch (UnavailableServiceException e) {
		        cs = null;
		        System.out.println("caught: cs is null");
		    }

		    if (cs != null) {
		        // set the system clipboard contents to a string selection
//		        ss = new StringSelection("Java Web Start!");
		    	ss = new StringSelection(stringToCopy);
		        cs.setContents(ss);
		    }
	}

	public String pasteWS(){

		//copy is commented out

		   ClipboardService cs;
//		   StringSelection ss;
		   String s = "";

		    try {
		        cs = (ClipboardService)ServiceManager.lookup
		                 ("javax.jnlp.ClipboardService");
		    } catch (UnavailableServiceException e) {
		        cs = null;
		        System.out.println("caught: cs is null");
		    }

		    if (cs != null) {
		        // set the system clipboard contents to a string selection
//		        ss = new StringSelection("Java Web Start!");
//		        cs.setContents(ss);


		        // get the contents of the system clipboard and print them
		        Transferable tr = cs.getContents();
		        if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
		           try {
		                s = (String)tr.getTransferData(DataFlavor.stringFlavor);
		                System.out.println("Clipboard contents: " + s);
		            } catch (Exception e) {
		                e.printStackTrace();
		            }
		        }
		    }
		    return s;
	}



	//public Toolkit myToolkit;//no these methods are static!

	public static void putStringOnClipboard(String stringToCopy){

		//is it OK to make this static?

		StringSelection s = new StringSelection(stringToCopy);
	    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
	    clipboard.setContents(s, s);//owner is s???
	    //or should owner be "this" class?
	    //compare http://www.javapractices.com/topic/TopicAction.do?Id=82
	}

	public String getStringOnClipBoard()  {
		  //can't use "this" in a static context ...

	    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
	    Transferable data = clipboard.getContents(this);
	    String stringFromClipBoard = "";
	    try {
	      stringFromClipBoard = (String) (data.getTransferData(DataFlavor.stringFlavor));
	      System.out.println("clipboard has string: " + stringFromClipBoard);
	    }
	    catch (Exception ex) {
	      System.out.println("error message: " + data.toString());
	    }


	    //experiment to paste text file:
	    DataFlavor[] flavourList = data.getTransferDataFlavors();
	    System.out.println("flavourList.length is " + flavourList.length);
	    if(flavourList.length > 0){
	    	System.out.println("flavourList[0].getHumanPresentableName() is " + flavourList[0].getHumanPresentableName());
	    	System.out.println("flavourList[0].getMimeType() is " + flavourList[0].getMimeType());
	    }
	    //1 returns: "application/x-java-file-list" when pasting a text file (unicode or ansi)
	    //mime type: application/x-java-file-list; class=java.util.List


	    //TODO figure out how to deal with textfiles on the clipboard!
	    //try unicode encoded text file and something from below:
	    //experiment with Drag-and-Drop!

	    return stringFromClipBoard;
	}
}
